/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterable;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectSortedSets;
import it.unimi.dsi.fastutil.shorts.AbstractShort2DoubleMap;
import it.unimi.dsi.fastutil.shorts.Short2DoubleMap;
import it.unimi.dsi.fastutil.shorts.Short2DoubleMaps;
import it.unimi.dsi.fastutil.shorts.Short2DoubleSortedMap;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import it.unimi.dsi.fastutil.shorts.ShortSortedSet;
import it.unimi.dsi.fastutil.shorts.ShortSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public final class Short2DoubleSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Short2DoubleSortedMaps() {
    }

    public static Comparator<? super Map.Entry<Short, ?>> entryComparator(ShortComparator comparator) {
        return (x, y) -> comparator.compare((short)((Short)x.getKey()), (short)((Short)y.getKey()));
    }

    public static ObjectBidirectionalIterator<Short2DoubleMap.Entry> fastIterator(Short2DoubleSortedMap map23) {
        ObjectSet entries = map23.short2DoubleEntrySet();
        return entries instanceof Short2DoubleSortedMap.FastSortedEntrySet ? ((Short2DoubleSortedMap.FastSortedEntrySet)entries).fastIterator() : entries.iterator();
    }

    public static ObjectBidirectionalIterable<Short2DoubleMap.Entry> fastIterable(Short2DoubleSortedMap map23) {
        ObjectSet entries = map23.short2DoubleEntrySet();
        return entries instanceof Short2DoubleSortedMap.FastSortedEntrySet ? ((Short2DoubleSortedMap.FastSortedEntrySet)entries)::fastIterator : entries;
    }

    public static Short2DoubleSortedMap singleton(Short key, Double value2) {
        return new Singleton(key, value2);
    }

    public static Short2DoubleSortedMap singleton(Short key, Double value2, ShortComparator comparator) {
        return new Singleton(key, value2, comparator);
    }

    public static Short2DoubleSortedMap singleton(short key, double value2) {
        return new Singleton(key, value2);
    }

    public static Short2DoubleSortedMap singleton(short key, double value2, ShortComparator comparator) {
        return new Singleton(key, value2, comparator);
    }

    public static Short2DoubleSortedMap synchronize(Short2DoubleSortedMap m3) {
        return new SynchronizedSortedMap(m3);
    }

    public static Short2DoubleSortedMap synchronize(Short2DoubleSortedMap m3, Object sync) {
        return new SynchronizedSortedMap(m3, sync);
    }

    public static Short2DoubleSortedMap unmodifiable(Short2DoubleSortedMap m3) {
        return new UnmodifiableSortedMap(m3);
    }

    public static class UnmodifiableSortedMap
    extends Short2DoubleMaps.UnmodifiableMap
    implements Short2DoubleSortedMap,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Short2DoubleSortedMap sortedMap;

        protected UnmodifiableSortedMap(Short2DoubleSortedMap m3) {
            super(m3);
            this.sortedMap = m3;
        }

        @Override
        public ShortComparator comparator() {
            return this.sortedMap.comparator();
        }

        @Override
        public ObjectSortedSet<Short2DoubleMap.Entry> short2DoubleEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.unmodifiable(this.sortedMap.short2DoubleEntrySet());
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<Short, Double>> entrySet() {
            return this.short2DoubleEntrySet();
        }

        @Override
        public ShortSortedSet keySet() {
            if (this.keys == null) {
                this.keys = ShortSortedSets.unmodifiable(this.sortedMap.keySet());
            }
            return (ShortSortedSet)this.keys;
        }

        @Override
        public Short2DoubleSortedMap subMap(short from2, short to2) {
            return new UnmodifiableSortedMap(this.sortedMap.subMap(from2, to2));
        }

        @Override
        public Short2DoubleSortedMap headMap(short to2) {
            return new UnmodifiableSortedMap(this.sortedMap.headMap(to2));
        }

        @Override
        public Short2DoubleSortedMap tailMap(short from2) {
            return new UnmodifiableSortedMap(this.sortedMap.tailMap(from2));
        }

        @Override
        public short firstShortKey() {
            return this.sortedMap.firstShortKey();
        }

        @Override
        public short lastShortKey() {
            return this.sortedMap.lastShortKey();
        }

        @Override
        @Deprecated
        public Short firstKey() {
            return this.sortedMap.firstKey();
        }

        @Override
        @Deprecated
        public Short lastKey() {
            return this.sortedMap.lastKey();
        }

        @Override
        @Deprecated
        public Short2DoubleSortedMap subMap(Short from2, Short to2) {
            return new UnmodifiableSortedMap(this.sortedMap.subMap(from2, to2));
        }

        @Override
        @Deprecated
        public Short2DoubleSortedMap headMap(Short to2) {
            return new UnmodifiableSortedMap(this.sortedMap.headMap(to2));
        }

        @Override
        @Deprecated
        public Short2DoubleSortedMap tailMap(Short from2) {
            return new UnmodifiableSortedMap(this.sortedMap.tailMap(from2));
        }
    }

    public static class SynchronizedSortedMap
    extends Short2DoubleMaps.SynchronizedMap
    implements Short2DoubleSortedMap,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final Short2DoubleSortedMap sortedMap;

        protected SynchronizedSortedMap(Short2DoubleSortedMap m3, Object sync) {
            super(m3, sync);
            this.sortedMap = m3;
        }

        protected SynchronizedSortedMap(Short2DoubleSortedMap m3) {
            super(m3);
            this.sortedMap = m3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ShortComparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        @Override
        public ObjectSortedSet<Short2DoubleMap.Entry> short2DoubleEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.synchronize(this.sortedMap.short2DoubleEntrySet(), this.sync);
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<Short, Double>> entrySet() {
            return this.short2DoubleEntrySet();
        }

        @Override
        public ShortSortedSet keySet() {
            if (this.keys == null) {
                this.keys = ShortSortedSets.synchronize(this.sortedMap.keySet(), this.sync);
            }
            return (ShortSortedSet)this.keys;
        }

        @Override
        public Short2DoubleSortedMap subMap(short from2, short to2) {
            return new SynchronizedSortedMap(this.sortedMap.subMap(from2, to2), this.sync);
        }

        @Override
        public Short2DoubleSortedMap headMap(short to2) {
            return new SynchronizedSortedMap(this.sortedMap.headMap(to2), this.sync);
        }

        @Override
        public Short2DoubleSortedMap tailMap(short from2) {
            return new SynchronizedSortedMap(this.sortedMap.tailMap(from2), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public short firstShortKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstShortKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public short lastShortKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastShortKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Short firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Deprecated
        public Short lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }

        @Override
        @Deprecated
        public Short2DoubleSortedMap subMap(Short from2, Short to2) {
            return new SynchronizedSortedMap(this.sortedMap.subMap(from2, to2), this.sync);
        }

        @Override
        @Deprecated
        public Short2DoubleSortedMap headMap(Short to2) {
            return new SynchronizedSortedMap(this.sortedMap.headMap(to2), this.sync);
        }

        @Override
        @Deprecated
        public Short2DoubleSortedMap tailMap(Short from2) {
            return new SynchronizedSortedMap(this.sortedMap.tailMap(from2), this.sync);
        }
    }

    public static class Singleton
    extends Short2DoubleMaps.Singleton
    implements Short2DoubleSortedMap,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;
        protected final ShortComparator comparator;

        protected Singleton(short key, double value2, ShortComparator comparator) {
            super(key, value2);
            this.comparator = comparator;
        }

        protected Singleton(short key, double value2) {
            this(key, value2, null);
        }

        final int compare(short k1, short k2) {
            return this.comparator == null ? Short.compare(k1, k2) : this.comparator.compare(k1, k2);
        }

        @Override
        public ShortComparator comparator() {
            return this.comparator;
        }

        @Override
        public ObjectSortedSet<Short2DoubleMap.Entry> short2DoubleEntrySet() {
            if (this.entries == null) {
                this.entries = ObjectSortedSets.singleton(new AbstractShort2DoubleMap.BasicEntry(this.key, this.value), Short2DoubleSortedMaps.entryComparator(this.comparator));
            }
            return (ObjectSortedSet)this.entries;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<Short, Double>> entrySet() {
            return this.short2DoubleEntrySet();
        }

        @Override
        public ShortSortedSet keySet() {
            if (this.keys == null) {
                this.keys = ShortSortedSets.singleton(this.key, this.comparator);
            }
            return (ShortSortedSet)this.keys;
        }

        @Override
        public Short2DoubleSortedMap subMap(short from2, short to2) {
            if (this.compare(from2, this.key) <= 0 && this.compare(this.key, to2) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public Short2DoubleSortedMap headMap(short to2) {
            if (this.compare(this.key, to2) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public Short2DoubleSortedMap tailMap(short from2) {
            if (this.compare(from2, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        @Override
        public short firstShortKey() {
            return this.key;
        }

        @Override
        public short lastShortKey() {
            return this.key;
        }

        @Override
        @Deprecated
        public Short2DoubleSortedMap headMap(Short oto) {
            return this.headMap((short)oto);
        }

        @Override
        @Deprecated
        public Short2DoubleSortedMap tailMap(Short ofrom) {
            return this.tailMap((short)ofrom);
        }

        @Override
        @Deprecated
        public Short2DoubleSortedMap subMap(Short ofrom, Short oto) {
            return this.subMap((short)ofrom, (short)oto);
        }

        @Override
        @Deprecated
        public Short firstKey() {
            return this.firstShortKey();
        }

        @Override
        @Deprecated
        public Short lastKey() {
            return this.lastShortKey();
        }
    }

    public static class EmptySortedMap
    extends Short2DoubleMaps.EmptyMap
    implements Short2DoubleSortedMap,
    Serializable,
    Cloneable {
        private static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        @Override
        public ShortComparator comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Short2DoubleMap.Entry> short2DoubleEntrySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        @Deprecated
        public ObjectSortedSet<Map.Entry<Short, Double>> entrySet() {
            return ObjectSortedSets.EMPTY_SET;
        }

        @Override
        public ShortSortedSet keySet() {
            return ShortSortedSets.EMPTY_SET;
        }

        @Override
        public Short2DoubleSortedMap subMap(short from2, short to2) {
            return EMPTY_MAP;
        }

        @Override
        public Short2DoubleSortedMap headMap(short to2) {
            return EMPTY_MAP;
        }

        @Override
        public Short2DoubleSortedMap tailMap(short from2) {
            return EMPTY_MAP;
        }

        @Override
        public short firstShortKey() {
            throw new NoSuchElementException();
        }

        @Override
        public short lastShortKey() {
            throw new NoSuchElementException();
        }

        @Override
        @Deprecated
        public Short2DoubleSortedMap headMap(Short oto) {
            return this.headMap((short)oto);
        }

        @Override
        @Deprecated
        public Short2DoubleSortedMap tailMap(Short ofrom) {
            return this.tailMap((short)ofrom);
        }

        @Override
        @Deprecated
        public Short2DoubleSortedMap subMap(Short ofrom, Short oto) {
            return this.subMap((short)ofrom, (short)oto);
        }

        @Override
        @Deprecated
        public Short firstKey() {
            return this.firstShortKey();
        }

        @Override
        @Deprecated
        public Short lastKey() {
            return this.lastShortKey();
        }
    }
}

