/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;

@InterfaceStability.Evolving
public class ElectPreferredLeadersResult {
    private final KafkaFutureImpl<Map<TopicPartition, ApiError>> electionFuture;
    private final Set<TopicPartition> partitions;

    ElectPreferredLeadersResult(KafkaFutureImpl<Map<TopicPartition, ApiError>> electionFuture, Set<TopicPartition> partitions) {
        this.electionFuture = electionFuture;
        this.partitions = partitions;
    }

    public KafkaFuture<Void> partitionResult(final TopicPartition partition) {
        final KafkaFutureImpl<Void> result2 = new KafkaFutureImpl<Void>();
        this.electionFuture.whenComplete(new KafkaFuture.BiConsumer<Map<TopicPartition, ApiError>, Throwable>(){

            @Override
            public void accept(Map<TopicPartition, ApiError> topicPartitions, Throwable throwable) {
                if (throwable != null) {
                    result2.completeExceptionally(throwable);
                } else if (!topicPartitions.containsKey(partition)) {
                    result2.completeExceptionally(new UnknownTopicOrPartitionException("Preferred leader election for partition \"" + partition + "\" was not attempted"));
                } else {
                    ApiException exception;
                    if (ElectPreferredLeadersResult.this.partitions == null && topicPartitions.isEmpty()) {
                        result2.completeExceptionally(Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
                    }
                    if ((exception = topicPartitions.get(partition).exception()) == null) {
                        result2.complete(null);
                    } else {
                        result2.completeExceptionally(exception);
                    }
                }
            }
        });
        return result2;
    }

    public KafkaFuture<Set<TopicPartition>> partitions() {
        if (this.partitions != null) {
            return KafkaFutureImpl.completedFuture(this.partitions);
        }
        final KafkaFutureImpl<Set<TopicPartition>> result2 = new KafkaFutureImpl<Set<TopicPartition>>();
        this.electionFuture.whenComplete(new KafkaFuture.BiConsumer<Map<TopicPartition, ApiError>, Throwable>(){

            @Override
            public void accept(Map<TopicPartition, ApiError> topicPartitions, Throwable throwable) {
                if (throwable != null) {
                    result2.completeExceptionally(throwable);
                } else if (topicPartitions.isEmpty()) {
                    result2.completeExceptionally(Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
                } else {
                    for (ApiError apiError : topicPartitions.values()) {
                        if (!apiError.isFailure()) continue;
                        result2.completeExceptionally(apiError.exception());
                    }
                    result2.complete(topicPartitions.keySet());
                }
            }
        });
        return result2;
    }

    public KafkaFuture<Void> all() {
        final KafkaFutureImpl<Void> result2 = new KafkaFutureImpl<Void>();
        this.electionFuture.thenApply(new KafkaFuture.Function<Map<TopicPartition, ApiError>, Void>(){

            @Override
            public Void apply(Map<TopicPartition, ApiError> topicPartitions) {
                for (ApiError apiError : topicPartitions.values()) {
                    if (!apiError.isFailure()) continue;
                    result2.completeExceptionally(apiError.exception());
                    return null;
                }
                result2.complete(null);
                return null;
            }
        });
        return result2;
    }
}

