/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class ControlledShutdownRequestData
implements ApiMessage {
    private int brokerId;
    private long brokerEpoch;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public ControlledShutdownRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public ControlledShutdownRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public ControlledShutdownRequestData() {
        this.brokerId = 0;
        this.brokerEpoch = -1L;
    }

    @Override
    public short apiKey() {
        return 7;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable readable, short version) {
        this.brokerId = readable.readInt();
        this.brokerEpoch = version >= 2 ? readable.readLong() : -1L;
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeInt(this.brokerId);
        if (version >= 2) {
            writable.writeLong(this.brokerEpoch);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.brokerId = struct.getInt("broker_id");
        this.brokerEpoch = version >= 2 ? struct.getLong("broker_epoch") : -1L;
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("broker_id", (Object)this.brokerId);
        if (version >= 2) {
            struct.set("broker_epoch", (Object)this.brokerEpoch);
        }
        return struct;
    }

    @Override
    public int size(short version) {
        int size2 = 0;
        size2 += 4;
        if (version >= 2) {
            size2 += 8;
        }
        return size2;
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof ControlledShutdownRequestData)) {
            return false;
        }
        ControlledShutdownRequestData other = (ControlledShutdownRequestData)obj2;
        if (this.brokerId != other.brokerId) {
            return false;
        }
        return this.brokerEpoch == other.brokerEpoch;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.brokerId;
        hashCode = 31 * hashCode + ((int)(this.brokerEpoch >> 32) ^ (int)this.brokerEpoch);
        return hashCode;
    }

    public String toString() {
        return "ControlledShutdownRequestData(brokerId=" + this.brokerId + ", brokerEpoch=" + this.brokerEpoch + ")";
    }

    public int brokerId() {
        return this.brokerId;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    public ControlledShutdownRequestData setBrokerId(int v) {
        this.brokerId = v;
        return this;
    }

    public ControlledShutdownRequestData setBrokerEpoch(long v) {
        this.brokerEpoch = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The id of the broker for which controlled shutdown has been requested."));
        SCHEMA_2 = new Schema(new Field("broker_id", Type.INT32, "The id of the broker for which controlled shutdown has been requested."), new Field("broker_epoch", Type.INT64, "The broker epoch."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }
}

