/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FindCoordinatorResponse;

public class FindCoordinatorRequest
extends AbstractRequest {
    private static final String COORDINATOR_KEY_KEY_NAME = "coordinator_key";
    private static final String COORDINATOR_TYPE_KEY_NAME = "coordinator_type";
    private static final Schema FIND_COORDINATOR_REQUEST_V0 = new Schema(CommonFields.GROUP_ID);
    private static final Schema FIND_COORDINATOR_REQUEST_V1;
    private static final Schema FIND_COORDINATOR_REQUEST_V2;
    private final String coordinatorKey;
    private final CoordinatorType coordinatorType;

    public static Schema[] schemaVersions() {
        return new Schema[]{FIND_COORDINATOR_REQUEST_V0, FIND_COORDINATOR_REQUEST_V1, FIND_COORDINATOR_REQUEST_V2};
    }

    private FindCoordinatorRequest(CoordinatorType coordinatorType, String coordinatorKey, short version) {
        super(ApiKeys.FIND_COORDINATOR, version);
        this.coordinatorType = coordinatorType;
        this.coordinatorKey = coordinatorKey;
    }

    public FindCoordinatorRequest(Struct struct, short version) {
        super(ApiKeys.FIND_COORDINATOR, version);
        this.coordinatorType = struct.hasField(COORDINATOR_TYPE_KEY_NAME) ? CoordinatorType.forId(struct.getByte(COORDINATOR_TYPE_KEY_NAME)) : CoordinatorType.GROUP;
        this.coordinatorKey = struct.hasField(CommonFields.GROUP_ID) ? struct.get(CommonFields.GROUP_ID) : struct.getString(COORDINATOR_KEY_KEY_NAME);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return new FindCoordinatorResponse(Errors.forException(e), Node.noNode());
            }
            case 1: 
            case 2: {
                return new FindCoordinatorResponse(throttleTimeMs, Errors.forException(e), Node.noNode());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.FIND_COORDINATOR.latestVersion()));
    }

    public String coordinatorKey() {
        return this.coordinatorKey;
    }

    public CoordinatorType coordinatorType() {
        return this.coordinatorType;
    }

    public static FindCoordinatorRequest parse(ByteBuffer buffer, short version) {
        return new FindCoordinatorRequest(ApiKeys.FIND_COORDINATOR.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.FIND_COORDINATOR.requestSchema(this.version()));
        if (struct.hasField(CommonFields.GROUP_ID)) {
            struct.set(CommonFields.GROUP_ID, this.coordinatorKey);
        } else {
            struct.set(COORDINATOR_KEY_KEY_NAME, (Object)this.coordinatorKey);
        }
        if (struct.hasField(COORDINATOR_TYPE_KEY_NAME)) {
            struct.set(COORDINATOR_TYPE_KEY_NAME, (Object)this.coordinatorType.id);
        }
        return struct;
    }

    static {
        FIND_COORDINATOR_REQUEST_V2 = FIND_COORDINATOR_REQUEST_V1 = new Schema(new Field(COORDINATOR_KEY_KEY_NAME, Type.STRING, "Id to use for finding the coordinator (for groups, this is the groupId, for transactional producers, this is the transactional id)"), new Field(COORDINATOR_TYPE_KEY_NAME, Type.INT8, "The type of coordinator to find (0 = group, 1 = transaction)"));
    }

    public static enum CoordinatorType {
        GROUP(0),
        TRANSACTION(1);

        final byte id;

        private CoordinatorType(byte id2) {
            this.id = id2;
        }

        public static CoordinatorType forId(byte id2) {
            switch (id2) {
                case 0: {
                    return GROUP;
                }
                case 1: {
                    return TRANSACTION;
                }
            }
            throw new IllegalArgumentException("Unknown coordinator type received: " + id2);
        }
    }

    public static class Builder
    extends AbstractRequest.Builder<FindCoordinatorRequest> {
        private final String coordinatorKey;
        private final CoordinatorType coordinatorType;
        private final short minVersion;

        public Builder(CoordinatorType coordinatorType, String coordinatorKey) {
            super(ApiKeys.FIND_COORDINATOR);
            this.coordinatorType = coordinatorType;
            this.coordinatorKey = coordinatorKey;
            this.minVersion = coordinatorType == CoordinatorType.TRANSACTION ? (short)1 : 0;
        }

        @Override
        public FindCoordinatorRequest build(short version) {
            if (version < this.minVersion) {
                throw new UnsupportedVersionException("Cannot create a v" + version + " FindCoordinator request because we require features supported only in " + this.minVersion + " or later.");
            }
            return new FindCoordinatorRequest(this.coordinatorType, this.coordinatorKey, version);
        }

        public String coordinatorKey() {
            return this.coordinatorKey;
        }

        public CoordinatorType coordinatorType() {
            return this.coordinatorType;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=FindCoordinatorRequest, coordinatorKey=");
            bld.append(this.coordinatorKey);
            bld.append(", coordinatorType=");
            bld.append((Object)this.coordinatorType);
            bld.append(")");
            return bld.toString();
        }
    }
}

