/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import org.hsqldb.Database;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserCommand;
import org.hsqldb.Row;
import org.hsqldb.Scanner;
import org.hsqldb.SessionContext;
import org.hsqldb.SessionData;
import org.hsqldb.SessionInterface;
import org.hsqldb.Statement;
import org.hsqldb.StatementManager;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSession;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCDriver;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.CountUpDownLatch;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.User;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;
import org.hsqldb.types.TypedComparator;

public class Session
implements SessionInterface {
    private volatile boolean isClosed;
    public Database database;
    private final User sessionUser;
    private User user;
    private Grantee role;
    public boolean isReadOnlyDefault;
    int isolationLevelDefault = 2;
    int isolationLevel = 2;
    boolean isReadOnlyIsolation;
    int actionIndex;
    long actionStartTimestamp;
    long actionTimestamp;
    long transactionTimestamp;
    long transactionEndTimestamp;
    final boolean txConflictRollback;
    final boolean txInterruptRollback;
    boolean isPreTransaction;
    boolean isTransaction;
    boolean isBatch;
    volatile boolean abortAction;
    volatile boolean abortTransaction;
    volatile boolean redoAction;
    HsqlArrayList rowActionList;
    volatile boolean tempUnlocked;
    public OrderedHashSet waitedSessions;
    public OrderedHashSet waitingSessions;
    OrderedHashSet tempSet;
    OrderedHashSet actionSet;
    public CountUpDownLatch latch = new CountUpDownLatch();
    TimeoutManager timeoutManager;
    final String zoneString;
    final int sessionTimeZoneSeconds;
    int timeZoneSeconds;
    boolean isNetwork;
    private int sessionMaxRows;
    int sessionOptimization = 8;
    private final long sessionId;
    int sessionTxId = -1;
    private boolean ignoreCase;
    private long sessionStartTimestamp;
    private JDBCConnection intConnection;
    private JDBCConnection extConnection;
    public HsqlNameManager.HsqlName currentSchema;
    public HsqlNameManager.HsqlName loggedSchema;
    ParserCommand parser;
    boolean isProcessingScript;
    boolean isProcessingLog;
    public SessionContext sessionContext;
    int resultMaxMemoryRows;
    public SessionData sessionData;
    public StatementManager statementManager;
    public Object special;
    private final long connectTime = System.currentTimeMillis();
    long currentDateSCN;
    long currentTimestampSCN;
    long currentMillis;
    private TimestampData currentDate;
    private TimestampData currentTimestamp;
    private TimestampData localTimestamp;
    private TimestampData transactionSystemTimestamp = this.getSystemTimestamp(false);
    boolean systemTimestampSet = false;
    private TimeData currentTime;
    private TimeData localTime;
    HsqlDeque sqlWarnings;
    private Calendar calendar;
    private Calendar calendarGMT;
    TypedComparator typedComparator = new TypedComparator(this);
    Scanner secondaryScanner;
    SimpleDateFormat simpleDateFormat;
    SimpleDateFormat simpleDateFormatGMT;
    Random randomGenerator = new Random();
    long seed = -1L;
    public final int randomId = this.randomGenerator.nextInt(Integer.MAX_VALUE);
    HsqlProperties clientProperties;

    Session(Database database, User user, boolean bl, boolean bl2, long l, String string2, int n) {
        this.sessionId = l;
        this.database = database;
        this.user = user;
        this.sessionUser = user;
        this.zoneString = string2;
        this.sessionTimeZoneSeconds = n;
        this.timeZoneSeconds = n;
        this.rowActionList = new HsqlArrayList(32, true);
        this.waitedSessions = new OrderedHashSet();
        this.waitingSessions = new OrderedHashSet();
        this.tempSet = new OrderedHashSet();
        this.actionSet = new OrderedHashSet();
        this.isolationLevelDefault = this.database.defaultIsolationLevel;
        this.ignoreCase = this.database.sqlIgnoreCase;
        this.isolationLevel = this.isolationLevelDefault;
        this.txConflictRollback = this.database.txConflictRollback;
        this.txInterruptRollback = this.database.txInterruptRollback;
        this.isReadOnlyDefault = bl2;
        this.isReadOnlyIsolation = this.isolationLevel == 1;
        this.sessionContext = new SessionContext(this);
        this.sessionContext.isAutoCommit = bl ? Boolean.TRUE : Boolean.FALSE;
        this.sessionContext.isReadOnly = this.isReadOnlyDefault ? Boolean.TRUE : Boolean.FALSE;
        this.parser = new ParserCommand(this, new Scanner());
        this.setResultMemoryRowCount(this.database.getResultMaxMemoryRows());
        this.resetSchema();
        this.sessionData = new SessionData(this.database, this);
        this.statementManager = new StatementManager(this.database);
        this.timeoutManager = new TimeoutManager();
        this.sessionStartTimestamp = System.currentTimeMillis();
    }

    void resetSchema() {
        this.loggedSchema = null;
        this.currentSchema = this.user.getInitialOrDefaultSchema();
    }

    @Override
    public long getId() {
        return this.sessionId;
    }

    @Override
    public int getRandomId() {
        return this.randomId;
    }

    @Override
    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.rollback(false);
        try {
            this.database.logger.writeOtherStatement(this, "DISCONNECT");
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
        this.sessionData.closeAllNavigators();
        this.sessionData.persistentStoreCollection.release();
        this.statementManager.reset();
        this.rowActionList.clear();
        this.isClosed = true;
        this.user = null;
        this.sessionContext.savepoints = null;
        this.sessionContext.lastIdentity = null;
        this.intConnection = null;
        this.database.sessionManager.removeSession(this);
        this.database.closeIfLast();
        this.database = null;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public synchronized void setIsolationDefault(int n) {
        if (n == 1) {
            n = 2;
        }
        if (n == this.isolationLevelDefault) {
            return;
        }
        this.isolationLevelDefault = n;
        if (!this.isInMidTransaction()) {
            this.isolationLevel = this.isolationLevelDefault;
            this.isReadOnlyIsolation = n == 1;
        }
    }

    public void setIsolation(int n) {
        if (this.isInMidTransaction()) {
            throw Error.error(3701);
        }
        if (n == 1) {
            n = 2;
        }
        if (this.isolationLevel != n) {
            this.isolationLevel = n;
            this.isReadOnlyIsolation = n == 1;
        }
    }

    @Override
    public synchronized int getIsolation() {
        return this.isolationLevel;
    }

    void setLastIdentity(Number number2) {
        this.sessionContext.lastIdentity = number2;
    }

    public Number getLastIdentity() {
        return this.sessionContext.lastIdentity;
    }

    public Database getDatabase() {
        return this.database;
    }

    public String getUsername() {
        return this.user.getName().getNameString();
    }

    public User getUser() {
        return this.user;
    }

    public Grantee getGrantee() {
        return this.user;
    }

    public Grantee getRole() {
        return this.role;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setRole(Grantee grantee) {
        this.role = grantee;
    }

    int getMaxRows() {
        return this.sessionContext.currentMaxRows;
    }

    void setSQLMaxRows(int n) {
        this.sessionMaxRows = n;
    }

    void setFeature(String string2, boolean bl) {
        int n = 8;
        this.sessionOptimization = bl ? (this.sessionOptimization |= n) : (this.sessionOptimization &= ~n);
    }

    void checkAdmin() {
        this.user.checkAdmin();
    }

    void checkReadWrite() {
        if (this.sessionContext.isReadOnly.booleanValue() || this.isReadOnlyIsolation) {
            throw Error.error(3706);
        }
    }

    void checkDDLWrite() {
        if (this.isProcessingScript || this.isProcessingLog) {
            return;
        }
        this.checkReadWrite();
    }

    public long getActionTimestamp() {
        return this.actionTimestamp;
    }

    public void addDeleteAction(Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        if (this.abortTransaction) {
            throw Error.error(4861);
        }
        if (this.abortAction) {
            throw Error.error(4872);
        }
        this.getTransactionSystemTimestamp();
        this.database.txManager.addDeleteAction(this, table, persistentStore, row, nArray);
    }

    void addInsertAction(Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        this.getTransactionSystemTimestamp();
        this.database.txManager.addInsertAction(this, table, persistentStore, row, nArray);
        if (this.abortTransaction) {
            throw Error.error(4861);
        }
        if (this.abortAction) {
            throw Error.error(4872);
        }
    }

    public HsqlArrayList getRowActionList() {
        return this.rowActionList;
    }

    @Override
    public synchronized void setAutoCommit(boolean bl) {
        if (this.isClosed) {
            return;
        }
        if (this.sessionContext.depth > 0) {
            return;
        }
        if (this.sessionContext.isAutoCommit != bl) {
            this.commit(false);
            this.sessionContext.isAutoCommit = bl ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public void beginAction(Statement statement) {
        this.actionIndex = this.rowActionList.size();
        this.database.txManager.beginAction(this, statement);
        this.database.txManager.beginActionResume(this);
    }

    public void endAction(Result result2) {
        this.abortAction = false;
        this.timeoutManager.endTimeout();
        this.sessionData.persistentStoreCollection.clearStatementTables();
        if (result2.mode == 2) {
            this.sessionData.persistentStoreCollection.clearResultTables(this.actionTimestamp);
            this.database.txManager.rollbackAction(this);
        } else {
            this.sessionContext.diagnosticsVariables[2] = result2.mode == 1 ? Integer.valueOf(result2.getUpdateCount()) : ValuePool.INTEGER_0;
            this.database.txManager.completeActions(this);
        }
    }

    public void startTransaction() {
        this.database.txManager.beginTransaction(this);
    }

    @Override
    public synchronized void startPhasedTransaction() {
    }

    @Override
    public synchronized void prepareCommit() {
        if (this.isClosed) {
            throw Error.error(1303);
        }
        if (!this.database.txManager.prepareCommitActions(this)) {
            this.rollbackNoCheck(false);
            throw Error.error(4861);
        }
    }

    @Override
    public synchronized void commit(boolean bl) {
        if (this.isClosed) {
            return;
        }
        if (this.sessionContext.depth > 0) {
            return;
        }
        if (this.isTransaction) {
            if (!this.database.txManager.commitTransaction(this)) {
                this.rollbackNoCheck(bl);
                throw Error.error(4861);
            }
        } else {
            this.logSequences();
        }
        this.endTransaction(true, bl);
        if (this.database != null && !this.sessionUser.isSystem() && this.database.logger.needsCheckpointReset()) {
            this.database.checkpointRunner.start();
        }
    }

    @Override
    public synchronized void rollback(boolean bl) {
        if (this.sessionContext.depth > 0) {
            return;
        }
        this.rollbackNoCheck(bl);
    }

    synchronized void rollbackNoCheck(boolean bl) {
        if (this.isClosed) {
            return;
        }
        if (this.isTransaction) {
            this.database.txManager.rollback(this);
        }
        this.endTransaction(false, bl);
    }

    private void endTransaction(boolean bl, boolean bl2) {
        this.abortAction = false;
        this.abortTransaction = false;
        this.systemTimestampSet = false;
        this.sessionContext.resetStack();
        this.sessionContext.savepoints.clear();
        this.sessionContext.savepointTimestamps.clear();
        this.rowActionList.clear();
        this.sessionData.persistentStoreCollection.clearTransactionTables();
        this.sessionData.closeAllTransactionNavigators();
        this.sessionData.clearLobOps();
        if (!bl2) {
            this.sessionContext.isReadOnly = this.isReadOnlyDefault ? Boolean.TRUE : Boolean.FALSE;
            this.setIsolation(this.isolationLevelDefault);
        }
        if (this.database.logger.getSqlEventLogLevel() > 0) {
            StatementSession statementSession = bl ? StatementSession.commitNoChainStatement : StatementSession.rollbackNoChainStatement;
            this.database.logger.logStatementEvent(this, statementSession, null, Result.updateZeroResult, 1);
        }
    }

    @Override
    public synchronized void resetSession() {
        if (this.isClosed) {
            return;
        }
        this.rollbackNoCheck(false);
        this.sessionData.closeAllNavigators();
        this.sessionData.persistentStoreCollection.clearAllTables();
        this.sessionData.clearLobOps();
        this.statementManager.reset();
        this.sessionContext.lastIdentity = ValuePool.INTEGER_0;
        this.sessionContext.isAutoCommit = Boolean.TRUE;
        this.setResultMemoryRowCount(this.database.getResultMaxMemoryRows());
        this.user = this.sessionUser;
        this.resetSchema();
        this.setZoneSeconds(this.sessionTimeZoneSeconds);
        this.sessionMaxRows = 0;
        this.ignoreCase = this.database.sqlIgnoreCase;
        this.setIsolation(this.isolationLevelDefault);
    }

    @Override
    public synchronized void savepoint(String string2) {
        int n = this.sessionContext.savepoints.getIndex(string2);
        if (n != -1) {
            this.sessionContext.savepoints.remove(string2);
            this.sessionContext.savepointTimestamps.remove(n);
        }
        this.actionTimestamp = this.database.txManager.getNextGlobalChangeTimestamp();
        this.sessionContext.savepoints.add(string2, ValuePool.getInt(this.rowActionList.size()));
        this.sessionContext.savepointTimestamps.addLast(this.actionTimestamp);
    }

    @Override
    public synchronized void rollbackToSavepoint(String string2) {
        if (this.isClosed) {
            return;
        }
        int n = this.sessionContext.savepoints.getIndex(string2);
        if (n < 0) {
            throw Error.error(4821, string2);
        }
        this.database.txManager.rollbackSavepoint(this, n);
    }

    public synchronized void rollbackToSavepoint() {
        if (this.isClosed) {
            return;
        }
        this.database.txManager.rollbackSavepoint(this, 0);
    }

    public synchronized void rollbackAction(int n, long l) {
        if (this.isClosed) {
            return;
        }
        this.database.txManager.rollbackPartial(this, n, l);
    }

    @Override
    public synchronized void releaseSavepoint(String string2) {
        int n = this.sessionContext.savepoints.getIndex(string2);
        if (n < 0) {
            throw Error.error(4821, string2);
        }
        while (this.sessionContext.savepoints.size() > n) {
            this.sessionContext.savepoints.remove(this.sessionContext.savepoints.size() - 1);
            this.sessionContext.savepointTimestamps.removeLast();
        }
    }

    public boolean isInMidTransaction() {
        return this.isTransaction;
    }

    public void setNoSQL() {
        this.sessionContext.noSQL = Boolean.TRUE;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public boolean isIgnorecase() {
        return this.ignoreCase;
    }

    public void setReadOnly(boolean bl) {
        if (!bl && this.database.databaseReadOnly) {
            throw Error.error(455);
        }
        if (this.isInMidTransaction()) {
            throw Error.error(3701);
        }
        this.sessionContext.isReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public synchronized void setReadOnlyDefault(boolean bl) {
        if (!bl && this.database.databaseReadOnly) {
            throw Error.error(455);
        }
        this.isReadOnlyDefault = bl;
        if (!this.isInMidTransaction()) {
            this.sessionContext.isReadOnly = this.isReadOnlyDefault ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    public boolean isReadOnly() {
        return this.sessionContext.isReadOnly != false || this.isReadOnlyIsolation;
    }

    @Override
    public synchronized boolean isReadOnlyDefault() {
        return this.isReadOnlyDefault;
    }

    @Override
    public synchronized boolean isAutoCommit() {
        return this.sessionContext.isAutoCommit;
    }

    @Override
    public synchronized int getStreamBlockSize() {
        return 524288;
    }

    JDBCConnection getInternalConnection() {
        if (this.intConnection == null) {
            this.intConnection = new JDBCConnection(this);
        }
        JDBCDriver.driverInstance.threadConnection.set(this.intConnection);
        return this.intConnection;
    }

    void releaseInternalConnection() {
        if (this.sessionContext.depth == 0) {
            JDBCDriver.driverInstance.threadConnection.set(null);
        }
    }

    @Override
    public JDBCConnection getJDBCConnection() {
        return this.extConnection;
    }

    @Override
    public void setJDBCConnection(JDBCConnection jDBCConnection) {
        this.extConnection = jDBCConnection;
    }

    @Override
    public String getDatabaseUniqueName() {
        return this.database.getNameString();
    }

    public boolean isAdmin() {
        return this.user.isAdmin();
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public int getTransactionSize() {
        return this.rowActionList.size();
    }

    public long getTransactionTimestamp() {
        return this.transactionTimestamp;
    }

    public Statement compileStatement(String string2, int n) {
        this.parser.reset(this, string2);
        Statement statement = this.parser.compileStatement(n);
        return statement;
    }

    public Statement compileStatement(String string2) {
        this.parser.reset(this, string2);
        Statement statement = this.parser.compileStatement(0);
        statement.setCompileTimestamp(Long.MAX_VALUE);
        return statement;
    }

    @Override
    public synchronized Result execute(Result result2) {
        if (this.isClosed) {
            return Result.newErrorResult(Error.error(1353));
        }
        this.sessionContext.currentMaxRows = 0;
        this.isBatch = false;
        switch (result2.mode) {
            case 18: {
                return this.performLOBOperation((ResultLob)result2);
            }
            case 35: {
                int n = result2.getUpdateCount();
                this.sessionContext.currentMaxRows = n == -1 ? 0 : n;
                Statement statement = result2.statement;
                if (statement == null || statement.compileTimestamp < this.database.schemaManager.schemaChangeTimestamp) {
                    long l = result2.getStatementID();
                    statement = this.statementManager.getStatement(this, l);
                    result2.setStatement(statement);
                    if (statement == null) {
                        return Result.newErrorResult(Error.error(1252));
                    }
                }
                Object[] objectArray = (Object[])result2.valueData;
                Result result3 = this.executeCompiledStatement(statement, objectArray, result2.queryTimeout);
                result3 = this.performPostExecute(result2, result3);
                return result3;
            }
            case 9: {
                this.isBatch = true;
                Result result4 = this.executeCompiledBatchStatement(result2);
                result4 = this.performPostExecute(result2, result4);
                return result4;
            }
            case 34: {
                Result result5 = this.executeDirectStatement(result2);
                result5 = this.performPostExecute(result2, result5);
                return result5;
            }
            case 8: {
                this.isBatch = true;
                Result result6 = this.executeDirectBatchStatement(result2);
                result6 = this.performPostExecute(result2, result6);
                return result6;
            }
            case 37: {
                Statement statement;
                try {
                    statement = this.statementManager.compile(this, result2);
                }
                catch (Throwable throwable) {
                    String string2 = result2.getMainString();
                    return Result.newErrorResult(throwable, string2);
                }
                Result result7 = Result.newPrepareResponse(statement);
                if (statement.getType() == 44 || statement.getType() == 10) {
                    this.sessionData.setResultSetProperties(result2, result7);
                }
                result7 = this.performPostExecute(result2, result7);
                return result7;
            }
            case 40: {
                this.closeNavigator(result2.getResultId());
                return Result.updateZeroResult;
            }
            case 41: {
                Result result8 = this.executeResultUpdate(result2);
                result8 = this.performPostExecute(result2, result8);
                return result8;
            }
            case 36: {
                this.statementManager.freeStatement(result2.getStatementID());
                return Result.updateZeroResult;
            }
            case 7: {
                int n = result2.getStatementType();
                return this.getAttributesResult(n);
            }
            case 6: {
                return this.setAttributes(result2);
            }
            case 33: {
                switch (result2.getActionType()) {
                    case 0: {
                        try {
                            this.commit(false);
                            break;
                        }
                        catch (Throwable throwable) {
                            return Result.newErrorResult(throwable);
                        }
                    }
                    case 6: {
                        try {
                            this.commit(true);
                            break;
                        }
                        catch (Throwable throwable) {
                            return Result.newErrorResult(throwable);
                        }
                    }
                    case 1: {
                        this.rollback(false);
                        break;
                    }
                    case 7: {
                        this.rollback(true);
                        break;
                    }
                    case 4: {
                        try {
                            String string3 = result2.getMainString();
                            this.releaseSavepoint(string3);
                            break;
                        }
                        catch (Throwable throwable) {
                            return Result.newErrorResult(throwable);
                        }
                    }
                    case 2: {
                        try {
                            this.rollbackToSavepoint(result2.getMainString());
                            break;
                        }
                        catch (Throwable throwable) {
                            return Result.newErrorResult(throwable);
                        }
                    }
                    case 12: {
                        try {
                            this.prepareCommit();
                            break;
                        }
                        catch (Throwable throwable) {
                            return Result.newErrorResult(throwable);
                        }
                    }
                }
                return Result.updateZeroResult;
            }
            case 38: {
                switch (result2.getConnectionAttrType()) {
                    case 10027: {
                        try {
                            this.savepoint(result2.getMainString());
                            break;
                        }
                        catch (Throwable throwable) {
                            return Result.newErrorResult(throwable);
                        }
                    }
                }
                return Result.updateZeroResult;
            }
            case 13: {
                return this.sessionData.getDataResultSlice(result2.getResultId(), result2.getUpdateCount(), result2.getFetchSize());
            }
            case 32: {
                this.close();
                return Result.updateZeroResult;
            }
        }
        return Result.newErrorResult(Error.runtimeError(201, "Session"));
    }

    private Result performPostExecute(Result result2, Result result3) {
        if (result3.mode == 3) {
            result3 = this.sessionData.getDataResultHead(result2, result3, this.isNetwork);
        }
        if (this.sqlWarnings != null && this.sqlWarnings.size() > 0) {
            if (result3.mode == 1) {
                result3 = new Result(1, result3.getUpdateCount());
            }
            HsqlException[] hsqlExceptionArray = this.getAndClearWarnings();
            result3.addWarnings(hsqlExceptionArray);
        }
        return result3;
    }

    @Override
    public RowSetNavigatorClient getRows(long l, int n, int n2) {
        return this.sessionData.getRowSetSlice(l, n, n2);
    }

    @Override
    public synchronized void closeNavigator(long l) {
        this.sessionData.closeNavigator(l);
    }

    public Result executeDirectStatement(Result result2) {
        HsqlArrayList hsqlArrayList;
        String string2 = result2.getMainString();
        int n = result2.getUpdateCount();
        if (n == -1) {
            this.sessionContext.currentMaxRows = 0;
        } else if (this.sessionMaxRows == 0) {
            this.sessionContext.currentMaxRows = n;
        } else {
            this.sessionContext.currentMaxRows = this.sessionMaxRows;
            this.sessionMaxRows = 0;
        }
        try {
            hsqlArrayList = this.parser.compileStatements(string2, result2);
        }
        catch (Throwable throwable) {
            return Result.newErrorResult(throwable);
        }
        Result result3 = null;
        boolean bl = false;
        HsqlNameManager.HsqlName hsqlName = this.getCurrentSchemaHsqlName();
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            Statement statement = (Statement)hsqlArrayList.get(i);
            if (i > 0) {
                if (statement.getCompileTimestamp() > this.database.txManager.getGlobalChangeTimestamp()) {
                    bl = true;
                }
                if (statement.getSchemaName() != null && statement.getSchemaName() != hsqlName) {
                    bl = true;
                }
            }
            if (bl) {
                statement = this.compileStatement(statement.getSQL(), result2.getExecuteProperties());
            }
            statement.setGeneratedColumnInfo(result2.getGeneratedResultType(), result2.getGeneratedResultMetaData());
            result3 = this.executeCompiledStatement(statement, ValuePool.emptyObjectArray, result2.queryTimeout);
            if (result3.mode == 2) break;
        }
        return result3;
    }

    public Result executeDirectStatement(String string2) {
        try {
            Statement statement = this.compileStatement(string2);
            Result result2 = this.executeCompiledStatement(statement, ValuePool.emptyObjectArray, 0);
            return result2;
        }
        catch (HsqlException hsqlException) {
            return Result.newErrorResult(hsqlException);
        }
    }

    public Result executeCompiledStatement(Statement statement, Object[] objectArray, int n) {
        Result result2;
        if (this.abortTransaction) {
            return this.handleAbortTransaction();
        }
        if (this.sessionContext.depth > 0 && (this.sessionContext.noSQL.booleanValue() || statement.isAutoCommitStatement())) {
            return Result.newErrorResult(Error.error(6000));
        }
        if (statement.isAutoCommitStatement()) {
            if (this.isReadOnly()) {
                return Result.newErrorResult(Error.error(3706));
            }
            try {
                this.commit(false);
            }
            catch (HsqlException hsqlException) {
                this.database.logger.logInfoEvent("Exception at commit");
            }
        }
        this.sessionContext.currentStatement = statement;
        boolean bl = statement.isTransactionStatement();
        if (!bl) {
            this.actionTimestamp = this.database.txManager.getNextGlobalChangeTimestamp();
            this.sessionContext.setDynamicArguments(objectArray);
            if (this.database.logger.getSqlEventLogLevel() >= 2) {
                this.database.logger.logStatementEvent(this, statement, objectArray, Result.updateZeroResult, 2);
            }
            Result result3 = statement.execute(this);
            this.sessionContext.currentStatement = null;
            this.abortAction = false;
            this.sessionData.persistentStoreCollection.clearStatementTables();
            return result3;
        }
        this.timeoutManager.startTimeout(n);
        block8: while (true) {
            this.actionIndex = this.rowActionList.size();
            this.database.txManager.beginAction(this, statement);
            if (this.redoAction) {
                this.redoAction = false;
                continue;
            }
            statement = this.sessionContext.currentStatement;
            if (statement == null) {
                return Result.newErrorResult(Error.error(1252));
            }
            if (this.abortTransaction) {
                return this.handleAbortTransaction();
            }
            boolean bl2 = false;
            while (true) {
                try {
                    this.latch.await();
                }
                catch (InterruptedException interruptedException) {
                    bl2 = this.txInterruptRollback;
                    Thread.interrupted();
                    continue;
                }
                break;
            }
            if (this.abortAction) {
                result2 = Result.newErrorResult(Error.error(4872));
                this.endAction(result2);
                break;
            }
            if (this.abortTransaction || bl2) {
                Result result4 = this.handleAbortTransaction();
                if (bl2) {
                    Thread.currentThread().interrupt();
                }
                return result4;
            }
            this.database.txManager.beginActionResume(this);
            this.sessionContext.setDynamicArguments(objectArray);
            result2 = statement.execute(this);
            if (this.database.logger.getSqlEventLogLevel() >= 2) {
                this.database.logger.logStatementEvent(this, statement, objectArray, result2, 2);
            }
            this.endAction(result2);
            if (this.abortTransaction || !this.redoAction) break;
            this.redoAction = false;
            while (true) {
                try {
                    this.latch.await();
                    continue block8;
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                    continue;
                }
                break;
            }
        }
        if (this.abortTransaction) {
            return this.handleAbortTransaction();
        }
        if (this.sessionContext.depth == 0 && (this.sessionContext.isAutoCommit.booleanValue() || statement.isAutoCommitStatement())) {
            try {
                if (result2.mode == 2) {
                    this.rollbackNoCheck(false);
                } else {
                    this.commit(false);
                }
            }
            catch (Exception exception) {
                this.sessionContext.currentStatement = null;
                return Result.newErrorResult(Error.error(4861, exception));
            }
        }
        this.sessionContext.currentStatement = null;
        return result2;
    }

    private Result handleAbortTransaction() {
        this.rollbackNoCheck(false);
        this.sessionContext.currentStatement = null;
        return Result.newErrorResult(Error.error(4861));
    }

    private Result executeCompiledBatchStatement(Result result2) {
        long l;
        Statement statement = result2.statement;
        if ((statement == null || statement.compileTimestamp < this.database.schemaManager.schemaChangeTimestamp) && (statement = this.statementManager.getStatement(this, l = result2.getStatementID())) == null) {
            return Result.newErrorResult(Error.error(1252));
        }
        int n = 0;
        RowSetNavigator rowSetNavigator = result2.initialiseNavigator();
        int[] nArray = new int[rowSetNavigator.getSize()];
        Result result3 = null;
        if (statement.hasGeneratedColumns()) {
            result3 = Result.newGeneratedDataResult(statement.generatedResultMetaData());
        }
        Result result4 = null;
        while (rowSetNavigator.next()) {
            Object[] objectArray = rowSetNavigator.getCurrent();
            Result result5 = this.executeCompiledStatement(statement, objectArray, result2.queryTimeout);
            if (result5.isUpdateCount()) {
                if (statement.hasGeneratedColumns()) {
                    RowSetNavigator rowSetNavigator2 = result5.getChainedResult().getNavigator();
                    while (rowSetNavigator2.next()) {
                        Object[] objectArray2 = rowSetNavigator2.getCurrent();
                        result3.getNavigator().add(objectArray2);
                    }
                }
                nArray[n++] = result5.getUpdateCount();
                continue;
            }
            if (result5.isData()) {
                nArray[n++] = -2;
                continue;
            }
            if (result5.mode == 43) {
                nArray[n++] = -2;
                continue;
            }
            if (result5.mode == 2) {
                nArray = ArrayUtil.arraySlice(nArray, 0, n);
                result4 = result5;
                break;
            }
            throw Error.runtimeError(201, "Session");
        }
        return Result.newBatchedExecuteResponse(nArray, result3, result4);
    }

    private Result executeDirectBatchStatement(Result result2) {
        int n = 0;
        RowSetNavigator rowSetNavigator = result2.initialiseNavigator();
        int[] nArray = new int[rowSetNavigator.getSize()];
        Result result3 = null;
        while (rowSetNavigator.next()) {
            Result result4;
            Object[] objectArray = rowSetNavigator.getCurrent();
            String string2 = (String)objectArray[0];
            try {
                Statement statement = this.compileStatement(string2);
                result4 = this.executeCompiledStatement(statement, ValuePool.emptyObjectArray, result2.queryTimeout);
            }
            catch (Throwable throwable) {
                result4 = Result.newErrorResult(throwable);
            }
            if (result4.isUpdateCount()) {
                nArray[n++] = result4.getUpdateCount();
                continue;
            }
            if (result4.isData()) {
                nArray[n++] = -2;
                continue;
            }
            if (result4.mode == 43) {
                nArray[n++] = -2;
                continue;
            }
            if (result4.mode == 2) {
                nArray = ArrayUtil.arraySlice(nArray, 0, n);
                result3 = result4;
                break;
            }
            throw Error.runtimeError(201, "Session");
        }
        return Result.newBatchedExecuteResponse(nArray, null, result3);
    }

    private Result executeResultUpdate(Result result2) {
        long l = result2.getResultId();
        int n = result2.getActionType();
        Result result3 = this.sessionData.getDataResult(l);
        if (result3 == null) {
            return Result.newErrorResult(Error.error(3601));
        }
        Object[] objectArray = (Object[])result2.valueData;
        Type[] typeArray = result2.metaData.columnTypes;
        StatementQuery statementQuery = (StatementQuery)result3.getStatement();
        this.sessionContext.rowUpdateStatement.setRowActionProperties(result3, n, statementQuery, typeArray);
        Result result4 = this.executeCompiledStatement(this.sessionContext.rowUpdateStatement, objectArray, result2.queryTimeout);
        return result4;
    }

    @Override
    public synchronized TimestampData getCurrentDate() {
        this.resetCurrentTimestamp();
        if (this.currentDate == null) {
            this.currentDate = (TimestampData)Type.SQL_DATE.getValue(this, this.currentMillis / 1000L, 0, this.getZoneSeconds());
        }
        return this.currentDate;
    }

    synchronized TimeData getCurrentTime(boolean bl) {
        this.resetCurrentTimestamp();
        if (bl) {
            if (this.currentTime == null) {
                int n = (int)HsqlDateTime.getNormalisedTime(this.getCalendarGMT(), this.currentMillis) / 1000;
                int n2 = (int)(this.currentMillis % 1000L) * 1000000;
                this.currentTime = new TimeData(n, n2, this.getZoneSeconds());
            }
            return this.currentTime;
        }
        if (this.localTime == null) {
            int n = (int)HsqlDateTime.getNormalisedTime(this.getCalendarGMT(), this.currentMillis + (long)this.getZoneSeconds() * 1000L) / 1000;
            int n3 = (int)(this.currentMillis % 1000L) * 1000000;
            this.localTime = new TimeData(n, n3, 0);
        }
        return this.localTime;
    }

    synchronized TimestampData getCurrentTimestamp(boolean bl) {
        this.resetCurrentTimestamp();
        if (bl) {
            if (this.currentTimestamp == null) {
                int n = (int)(this.currentMillis % 1000L) * 1000000;
                this.currentTimestamp = new TimestampData(this.currentMillis / 1000L, n, this.getZoneSeconds());
            }
            return this.currentTimestamp;
        }
        if (this.localTimestamp == null) {
            int n = (int)(this.currentMillis % 1000L) * 1000000;
            this.localTimestamp = new TimestampData(this.currentMillis / 1000L + (long)this.getZoneSeconds(), n, 0);
        }
        return this.localTimestamp;
    }

    synchronized TimestampData getSystemTimestamp(boolean bl) {
        long l = System.currentTimeMillis();
        long l2 = l / 1000L;
        int n = (int)(l % 1000L) * 1000000;
        int n2 = 0;
        if (!bl) {
            TimeZone timeZone = TimeZone.getDefault();
            n2 = timeZone.getOffset(l) / 1000;
            l2 += (long)n2;
            n2 = 0;
        }
        return new TimestampData(l2, n, n2);
    }

    TimestampData getTransactionSystemTimestamp() {
        if (!this.systemTimestampSet) {
            this.transactionSystemTimestamp = this.getSystemTimestamp(false);
            this.systemTimestampSet = true;
        }
        return this.transactionSystemTimestamp;
    }

    private void resetCurrentTimestamp() {
        if (this.currentTimestampSCN != this.actionTimestamp) {
            this.currentTimestampSCN = this.actionTimestamp;
            this.currentMillis = System.currentTimeMillis();
            this.currentDate = null;
            this.currentTimestamp = null;
            this.localTimestamp = null;
            this.currentTime = null;
            this.localTime = null;
        }
    }

    private Result getAttributesResult(int n) {
        Result result2 = Result.newSessionAttributesResult();
        Object[] objectArray = result2.getSingleRowData();
        objectArray[0] = ValuePool.getInt(n);
        switch (n) {
            case 0: {
                objectArray[1] = ValuePool.getInt(this.isolationLevel);
                break;
            }
            case 1: {
                objectArray[2] = this.sessionContext.isAutoCommit;
                break;
            }
            case 2: {
                objectArray[2] = this.sessionContext.isReadOnly;
                break;
            }
            case 3: {
                objectArray[3] = this.database.getCatalogName().name;
            }
        }
        return result2;
    }

    private Result setAttributes(Result result2) {
        Object[] objectArray = result2.getSessionAttributes();
        int n = (Integer)objectArray[0];
        try {
            switch (n) {
                case 1: {
                    boolean bl = (Boolean)objectArray[2];
                    this.setAutoCommit(bl);
                    break;
                }
                case 2: {
                    boolean bl = (Boolean)objectArray[2];
                    this.setReadOnlyDefault(bl);
                    break;
                }
                case 0: {
                    int n2 = (Integer)objectArray[1];
                    this.setIsolationDefault(n2);
                    break;
                }
                case 3: {
                    String string2 = (String)objectArray[3];
                    this.setCatalog(string2);
                }
            }
        }
        catch (HsqlException hsqlException) {
            return Result.newErrorResult(hsqlException);
        }
        return Result.updateZeroResult;
    }

    @Override
    public synchronized Object getAttribute(int n) {
        switch (n) {
            case 0: {
                return ValuePool.getInt(this.isolationLevel);
            }
            case 1: {
                return this.sessionContext.isAutoCommit;
            }
            case 2: {
                return this.isReadOnlyDefault ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.database.getCatalogName().name;
            }
        }
        return null;
    }

    @Override
    public synchronized void setAttribute(int n, Object object) {
        switch (n) {
            case 1: {
                boolean bl = (Boolean)object;
                this.setAutoCommit(bl);
                break;
            }
            case 2: {
                boolean bl = (Boolean)object;
                this.setReadOnlyDefault(bl);
                break;
            }
            case 0: {
                int n2 = (Integer)object;
                this.setIsolationDefault(n2);
                break;
            }
            case 3: {
                String string2 = (String)object;
                this.setCatalog(string2);
            }
        }
    }

    @Override
    public BlobDataID createBlob(long l) {
        long l2 = this.database.lobManager.createBlob(this, l);
        if (l2 == 0L) {
            throw Error.error(1852);
        }
        this.sessionData.registerNewLob(l2);
        return new BlobDataID(l2);
    }

    @Override
    public ClobDataID createClob(long l) {
        long l2 = this.database.lobManager.createClob(this, l);
        if (l2 == 0L) {
            throw Error.error(1852);
        }
        this.sessionData.registerNewLob(l2);
        return new ClobDataID(l2);
    }

    public void registerResultLobs(Result result2) {
        this.sessionData.registerLobForResult(result2);
    }

    @Override
    public void allocateResultLob(ResultLob resultLob, InputStream inputStream) {
        this.sessionData.allocateLobForResult(resultLob, inputStream);
    }

    Result performLOBOperation(ResultLob resultLob) {
        long l = resultLob.getLobID();
        int n = resultLob.getSubType();
        switch (n) {
            case 11: {
                return this.database.lobManager.getLob(l, resultLob.getOffset(), resultLob.getBlockLength());
            }
            case 10: {
                return this.database.lobManager.getLength(l);
            }
            case 1: {
                return this.database.lobManager.getBytes(l, resultLob.getOffset(), (int)resultLob.getBlockLength());
            }
            case 2: {
                return this.database.lobManager.setBytes(l, resultLob.getOffset(), resultLob.getByteArray(), (int)resultLob.getBlockLength());
            }
            case 3: {
                return this.database.lobManager.getChars(l, resultLob.getOffset(), (int)resultLob.getBlockLength());
            }
            case 4: {
                return this.database.lobManager.setChars(l, resultLob.getOffset(), resultLob.getCharArray(), (int)resultLob.getBlockLength());
            }
            case 9: {
                return this.database.lobManager.truncate(l, resultLob.getOffset());
            }
            case 12: {
                return this.database.lobManager.createDuplicateLob(l);
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                throw Error.error(1551);
            }
        }
        throw Error.runtimeError(201, "Session");
    }

    @Override
    public String getInternalConnectionURL() {
        return "jdbc:hsqldb:" + this.database.getURI();
    }

    @Override
    public Result cancel(Result result2) {
        if (result2.getType() == 5 && result2.getSessionRandomID() == this.randomId) {
            this.database.txManager.resetSession(null, this, 5);
        }
        return Result.updateZeroResult;
    }

    public boolean isProcessingScript() {
        return this.isProcessingScript;
    }

    public boolean isProcessingLog() {
        return this.isProcessingLog;
    }

    public void setSchema(String string2) {
        this.currentSchema = this.database.schemaManager.getSchemaHsqlName(string2);
    }

    public void setCatalog(String string2) {
        if (this.database.getCatalogName().name.equals(string2)) {
            return;
        }
        throw Error.error(4840);
    }

    HsqlNameManager.HsqlName getSchemaHsqlName(String string2) {
        return string2 == null ? this.currentSchema : this.database.schemaManager.getSchemaHsqlName(string2);
    }

    public String getSchemaName(String string2) {
        return string2 == null ? this.currentSchema.name : this.database.schemaManager.getSchemaName(string2);
    }

    public void setCurrentSchemaHsqlName(HsqlNameManager.HsqlName hsqlName) {
        this.currentSchema = hsqlName;
    }

    public HsqlNameManager.HsqlName getCurrentSchemaHsqlName() {
        return this.currentSchema;
    }

    public int getResultMemoryRowCount() {
        return this.resultMaxMemoryRows;
    }

    public void setResultMemoryRowCount(int n) {
        if (this.database.logger.getTempDirectoryPath() != null) {
            if (n < 0) {
                n = 0;
            }
            this.resultMaxMemoryRows = n;
        }
    }

    @Override
    public void addWarning(HsqlException hsqlException) {
        int n;
        if (this.sqlWarnings == null) {
            this.sqlWarnings = new HsqlDeque();
        }
        if (this.sqlWarnings.size() > 9) {
            this.sqlWarnings.removeFirst();
        }
        if ((n = this.sqlWarnings.indexOf(hsqlException)) >= 0) {
            this.sqlWarnings.remove(n);
        }
        this.sqlWarnings.add(hsqlException);
    }

    public HsqlException[] getAndClearWarnings() {
        if (this.sqlWarnings == null) {
            return HsqlException.emptyArray;
        }
        Object[] objectArray = new HsqlException[this.sqlWarnings.size()];
        this.sqlWarnings.toArray(objectArray);
        this.sqlWarnings.clear();
        return objectArray;
    }

    public HsqlException getLastWarning() {
        if (this.sqlWarnings == null || this.sqlWarnings.size() == 0) {
            return null;
        }
        return (HsqlException)this.sqlWarnings.getLast();
    }

    public void clearWarnings() {
        if (this.sqlWarnings != null) {
            this.sqlWarnings.clear();
        }
    }

    @Override
    public int getZoneSeconds() {
        return this.timeZoneSeconds;
    }

    public void setZoneSeconds(int n) {
        this.timeZoneSeconds = n;
    }

    @Override
    public Calendar getCalendar() {
        if (this.calendar == null) {
            if (this.zoneString == null) {
                this.calendar = new GregorianCalendar();
            } else {
                TimeZone timeZone = TimeZone.getTimeZone(this.zoneString);
                this.calendar = new GregorianCalendar(timeZone);
            }
        }
        return this.calendar;
    }

    @Override
    public Calendar getCalendarGMT() {
        if (this.calendarGMT == null) {
            this.calendarGMT = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        }
        return this.calendarGMT;
    }

    @Override
    public SimpleDateFormat getSimpleDateFormatGMT() {
        if (this.simpleDateFormatGMT == null) {
            this.simpleDateFormatGMT = new SimpleDateFormat("MMMM", Locale.ENGLISH);
            this.simpleDateFormatGMT.setCalendar(this.getCalendarGMT());
        }
        return this.simpleDateFormatGMT;
    }

    public TypedComparator getComparator() {
        return this.typedComparator;
    }

    public double random(long l) {
        if (this.seed != l) {
            this.randomGenerator.setSeed(l);
            this.seed = l;
        }
        return this.randomGenerator.nextDouble();
    }

    public double random() {
        return this.randomGenerator.nextDouble();
    }

    @Override
    public Scanner getScanner() {
        if (this.secondaryScanner == null) {
            this.secondaryScanner = new Scanner();
        }
        return this.secondaryScanner;
    }

    @Override
    public HsqlProperties getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new HsqlProperties();
            this.clientProperties.setProperty("jdbc.translate_tti_types", this.database.sqlTranslateTTI);
            this.clientProperties.setProperty("sql.live_object", this.database.sqlLiveObject);
        }
        return this.clientProperties;
    }

    void logSequences() {
        HashMap hashMap = this.sessionData.sequenceUpdateMap;
        if (hashMap == null || hashMap.isEmpty()) {
            return;
        }
        Iterator iterator = hashMap.keySet().iterator();
        int n = hashMap.size();
        for (int i = 0; i < n; ++i) {
            NumberSequence numberSequence = (NumberSequence)iterator.next();
            this.database.logger.writeSequenceStatement(this, numberSequence);
        }
        this.sessionData.sequenceUpdateMap.clear();
    }

    String getStartTransactionSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("START").append(' ').append("TRANSACTION");
        if (this.isolationLevel != this.isolationLevelDefault) {
            stringBuilder.append(' ');
            Session.appendIsolationSQL(stringBuilder, this.isolationLevel);
        }
        return stringBuilder.toString();
    }

    String getTransactionIsolationSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SET").append(' ').append("TRANSACTION");
        stringBuilder.append(' ');
        Session.appendIsolationSQL(stringBuilder, this.isolationLevel);
        return stringBuilder.toString();
    }

    String getSessionIsolationSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SET").append(' ').append("SESSION");
        stringBuilder.append(' ').append("CHARACTERISTICS").append(' ');
        stringBuilder.append("AS").append(' ').append("TRANSACTION").append(' ');
        Session.appendIsolationSQL(stringBuilder, this.isolationLevelDefault);
        return stringBuilder.toString();
    }

    static void appendIsolationSQL(StringBuilder stringBuilder, int n) {
        stringBuilder.append("ISOLATION").append(' ');
        stringBuilder.append("LEVEL").append(' ');
        stringBuilder.append(Session.getIsolationString(n));
    }

    static String getIsolationString(int n) {
        switch (n) {
            case 1: 
            case 2: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("READ").append(' ');
                stringBuilder.append("COMMITTED");
                return stringBuilder.toString();
            }
        }
        return "SERIALIZABLE";
    }

    String getSetSchemaStatement() {
        return "SET SCHEMA " + this.currentSchema.statementName;
    }

    class TimeoutManager {
        AtomicInteger currentTimeout = new AtomicInteger();

        TimeoutManager() {
        }

        void startTimeout(int n) {
            this.currentTimeout.set(n);
            if (n == 0) {
                return;
            }
            Session.this.database.timeoutRunner.addSession(Session.this);
        }

        boolean endTimeout() {
            this.currentTimeout.set(0);
            return true;
        }

        public boolean checkTimeout() {
            if (this.currentTimeout.get() == 0) {
                return true;
            }
            int n = this.currentTimeout.decrementAndGet();
            if (n <= 0) {
                this.currentTimeout.set(0);
                Session.this.database.txManager.resetSession(null, Session.this, 5);
                return true;
            }
            return false;
        }
    }
}

