/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.auth;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Set;
import org.hsqldb.auth.AuthFunctionBean;
import org.hsqldb.auth.AuthUtils;
import org.hsqldb.auth.DenyException;
import org.hsqldb.lib.FrameworkLogger;

public class HsqldbSlaveAuthBean
implements AuthFunctionBean {
    private static FrameworkLogger logger = FrameworkLogger.getLog(HsqldbSlaveAuthBean.class);
    private String masterJdbcUrl;
    private String validationUser;
    private String validationPassword;
    private boolean delegateRolesSchema = true;
    protected boolean initialized;

    public void setValidationUser(String string2) {
        this.validationUser = string2;
    }

    public void setValidationPassword(String string2) {
        this.validationPassword = string2;
    }

    public void setMasterJdbcUrl(String string2) {
        this.masterJdbcUrl = string2;
    }

    public void setDelegateRolesSchema(boolean bl) {
        this.delegateRolesSchema = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws SQLException {
        if (this.masterJdbcUrl == null) {
            throw new IllegalStateException("Required property 'masterJdbcUrl' not set");
        }
        if (this.validationUser != null || this.validationPassword != null) {
            if (this.validationUser == null || this.validationPassword == null) {
                throw new IllegalStateException("If you set one property of 'validationUser' or 'validationPassword', then you must set both.");
            }
            Connection connection = null;
            SQLException sQLException = null;
            try {
                connection = DriverManager.getConnection(this.masterJdbcUrl, this.validationUser, this.validationPassword);
            }
            catch (SQLException sQLException2) {
                logger.error("Master/slave Connection validation failure", sQLException2);
                sQLException = sQLException2;
            }
            finally {
                block16: {
                    if (connection != null) {
                        try {
                            connection.close();
                            connection = null;
                        }
                        catch (SQLException sQLException3) {
                            logger.error("Failed to close test master/slave Connection", sQLException3);
                            if (sQLException != null) break block16;
                            throw sQLException3;
                        }
                    }
                }
            }
        }
        this.initialized = true;
    }

    @Override
    public String[] authenticate(String string2, String string3) throws DenyException {
        if (!this.initialized) {
            throw new IllegalStateException("You must invoke the 'init' method to initialize the " + HsqldbSlaveAuthBean.class.getName() + " instance.");
        }
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(this.masterJdbcUrl, string2, string3);
            if (this.delegateRolesSchema) {
                Set<String> set2 = AuthUtils.getEnabledRoles(connection);
                String string4 = AuthUtils.getInitialSchema(connection);
                if (string4 != null) {
                    set2.add(string4);
                }
                logger.finer("Slave delegating schema+roles: " + set2);
                String[] stringArray = set2.toArray(new String[0]);
                return stringArray;
            }
            String[] stringArray = null;
            return stringArray;
        }
        catch (SQLException sQLException) {
            throw new DenyException();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                    connection = null;
                }
                catch (SQLException sQLException) {
                    logger.severe("Failed to close master/slave Connection", sQLException);
                }
            }
        }
    }
}

