/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.SQLException;
import java.sql.Savepoint;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCUtil;

public class JDBCSavepoint
implements Savepoint {
    int id;
    String name;
    JDBCConnection connection;

    JDBCSavepoint(String string2, JDBCConnection jDBCConnection) throws SQLException {
        if (string2 == null) {
            throw JDBCUtil.nullArgument("name");
        }
        if (jDBCConnection == null) {
            throw JDBCUtil.nullArgument("conn");
        }
        this.name = string2;
        this.id = -1;
        this.connection = jDBCConnection;
    }

    JDBCSavepoint(JDBCConnection jDBCConnection) throws SQLException {
        if (jDBCConnection == null) {
            throw JDBCUtil.nullArgument("conn");
        }
        this.id = jDBCConnection.getSavepointID();
        this.name = "SYSTEM_SAVEPOINT_" + this.id;
        this.connection = jDBCConnection;
    }

    @Override
    public int getSavepointId() throws SQLException {
        if (this.id != -1) {
            return this.id;
        }
        throw JDBCUtil.notSupported();
    }

    @Override
    public String getSavepointName() throws SQLException {
        if (this.id == -1) {
            return this.name;
        }
        throw JDBCUtil.notSupported();
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + "]";
    }
}

