/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class RCData {
    public static final String DEFAULT_JDBC_DRIVER = "org.hsqldb.jdbc.JDBCDriver";
    private String defaultJdbcDriverName = "org.hsqldb.jdbc.JDBCDriver";
    public String id;
    public String url;
    public String username;
    public String password;
    public String ti;
    public String driver;
    public String charset;
    public String truststore;
    public String libpath;

    public void setDefaultJdbcDriver(String string2) {
        this.defaultJdbcDriverName = string2;
    }

    public String getDefaultJdbcDriverName() {
        return this.defaultJdbcDriverName;
    }

    public String toString() {
        return "id: " + RCData.angleBracketNull(this.id) + ", url: " + RCData.angleBracketNull(this.url) + ", username: " + RCData.angleBracketNull(this.username) + ", password: <" + (this.password == null ? "NULL" : "PRESENT") + ">, ti: " + RCData.angleBracketNull(this.ti) + ", driver: " + RCData.angleBracketNull(this.driver) + ", truststore: " + RCData.angleBracketNull(this.truststore) + ", libpath: " + RCData.angleBracketNull(this.libpath);
    }

    private static String angleBracketNull(String string2) {
        return string2 == null ? "<NULL>" : string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RCData(File file, String string2) throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        if (file == null) {
            throw new IllegalArgumentException("RC file name not specified");
        }
        if (!file.canRead()) {
            throw new IOException("Please set up authentication file '" + file + "'");
        }
        StringTokenizer stringTokenizer = null;
        boolean bl = false;
        int n = 0;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            String string3;
            while ((string3 = bufferedReader.readLine()) != null) {
                String string4;
                String string5;
                ++n;
                if ((string3 = string3.trim()).length() == 0 || string3.charAt(0) == '#') continue;
                stringTokenizer = new StringTokenizer(string3);
                if (stringTokenizer.countTokens() == 1) {
                    string5 = stringTokenizer.nextToken();
                    string4 = "";
                } else if (stringTokenizer.countTokens() > 1) {
                    string5 = stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken("").trim();
                } else {
                    throw new Exception("Corrupt line " + n + " in '" + file + "':  " + string3);
                }
                if (string5.equals("urlid")) {
                    String[] stringArray = string4.split("\\s*,\\s*", -1);
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (hashSet.contains(stringArray[i])) {
                            throw new Exception("ID Pattern '" + stringArray[i] + "' repeated at line " + n + " in '" + file + "'");
                        }
                        hashSet.add(stringArray[i]);
                        if (string2 == null) {
                            System.out.println(stringArray[i]);
                            continue;
                        }
                        bl = Pattern.compile(stringArray[i]).matcher(string2).matches();
                        if (this.id != null || !bl) continue;
                        this.id = string2;
                    }
                    continue;
                }
                if (string2 == null || !bl) continue;
                if (string5.equals("url")) {
                    this.url = string4;
                    continue;
                }
                if (string5.equals("username")) {
                    this.username = string4;
                    continue;
                }
                if (string5.equals("driver")) {
                    this.driver = string4;
                    continue;
                }
                if (string5.equals("charset")) {
                    this.charset = string4;
                    continue;
                }
                if (string5.equals("truststore")) {
                    this.truststore = string4;
                    continue;
                }
                if (string5.equals("password")) {
                    this.password = string4;
                    continue;
                }
                if (string5.equals("transiso")) {
                    this.ti = string4;
                    continue;
                }
                if (string5.equals("libpath")) {
                    this.libpath = string4;
                    continue;
                }
                throw new Exception("Bad line " + n + " in '" + file + "':  " + string3);
            }
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            bufferedReader = null;
        }
        if (string2 == null) {
            return;
        }
        if (this.libpath != null) {
            throw new IllegalArgumentException("Sorry, 'libpath' not supported yet");
        }
        if (this.id == null) {
            throw new IllegalArgumentException("No match for '" + string2 + "' in file '" + file + "'");
        }
    }

    public RCData(String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws Exception {
        this(string2, string3, string4, string5, string6, string7, string8, null);
    }

    public RCData(String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws Exception {
        this(string2, string3, string4, string5, string6, string7, string8, string9, null);
    }

    public RCData(String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws Exception {
        this.id = string2;
        this.url = string3;
        this.username = string4;
        this.password = string5;
        this.ti = string10;
        this.driver = string6;
        this.charset = string7;
        this.truststore = string8;
        this.libpath = string9;
        if (string9 != null) {
            throw new IllegalArgumentException("Sorry, 'libpath' not supported yet");
        }
        if (string2 == null) {
            throw new Exception("id was not set");
        }
    }

    public Connection getConnection() throws ClassNotFoundException, SQLException, MalformedURLException {
        return this.getConnection(null, null);
    }

    public Connection getConnection(String string2, String string3) throws ClassNotFoundException, MalformedURLException, SQLException {
        Connection connection;
        String string4 = null;
        String string5 = null;
        Properties properties2 = System.getProperties();
        string4 = string2 == null ? (this.driver == null ? DEFAULT_JDBC_DRIVER : this.driver) : RCData.expandSysPropVars(string2);
        if (string3 == null) {
            if (this.truststore != null) {
                string5 = RCData.expandSysPropVars(this.truststore);
            }
        } else {
            string5 = RCData.expandSysPropVars(string3);
        }
        if (string5 == null) {
            properties2.remove("javax.net.ssl.trustStore");
        } else {
            properties2.put("javax.net.ssl.trustStore", string5);
        }
        String string6 = null;
        if (this.url == null) {
            throw new MalformedURLException("url string is required to establish a connection, but is null");
        }
        try {
            string6 = RCData.expandSysPropVars(this.url);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MalformedURLException(illegalArgumentException.toString() + " for URL '" + this.url + "'");
        }
        String string7 = null;
        if (this.username != null) {
            try {
                string7 = RCData.expandSysPropVars(this.username);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new MalformedURLException(illegalArgumentException.toString() + " for user name '" + this.username + "'");
            }
        }
        String string8 = null;
        if (this.password != null) {
            try {
                string8 = RCData.expandSysPropVars(this.password);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new MalformedURLException(illegalArgumentException.toString() + " for password");
            }
        }
        Class.forName(string4);
        Connection connection2 = connection = string7 == null ? DriverManager.getConnection(string6) : DriverManager.getConnection(string6, string7, string8);
        if (this.ti != null) {
            RCData.setTI(connection, this.ti);
        }
        return connection;
    }

    public static String expandSysPropVars(String string2) {
        int n;
        int n2;
        String string3 = string2;
        while ((n2 = string3.indexOf("${")) >= 0 && (n = string3.indexOf(125, n2 + 2)) >= 0) {
            String string4 = string3.substring(n2 + 2, n);
            if (string4.length() < 1) {
                throw new IllegalArgumentException("Bad variable setting");
            }
            String string5 = System.getProperty(string4);
            if (string5 == null) {
                throw new IllegalArgumentException("No Java system property with name '" + string4 + "'");
            }
            string3 = string3.substring(0, n2) + string5 + string3.substring(n + 1);
        }
        return string3;
    }

    public static void setTI(Connection connection, String string2) throws SQLException {
        int n = -1;
        if (string2.equals("TRANSACTION_READ_UNCOMMITTED")) {
            n = 1;
        }
        if (string2.equals("TRANSACTION_READ_COMMITTED")) {
            n = 2;
        }
        if (string2.equals("TRANSACTION_REPEATABLE_READ")) {
            n = 4;
        }
        if (string2.equals("TRANSACTION_SERIALIZABLE")) {
            n = 8;
        }
        if (string2.equals("TRANSACTION_NONE")) {
            n = 0;
        }
        if (n < 0) {
            throw new SQLException("Trans. isol. value not supported by " + RCData.class.getName() + ": " + string2);
        }
        connection.setTransactionIsolation(n);
    }

    public static String tiToString(int n) {
        switch (n) {
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
            case 0: {
                return "TRANSACTION_NONE";
            }
        }
        return "Custom Transaction Isolation numerical value: " + n;
    }
}

