/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.resources;

import java.lang.reflect.Method;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;

public final class ResourceBundleHandler {
    private static final Object mutex = new Object();
    private static Locale locale = Locale.getDefault();
    private static HashMap bundleHandleMap = new HashMap();
    private static HsqlArrayList bundleList = new HsqlArrayList();
    private static final String prefix = "org.hsqldb.resources.";
    private static final Method newGetBundleMethod = ResourceBundleHandler.getNewGetBundleMethod();

    private ResourceBundleHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locale getLocale() {
        Object object = mutex;
        synchronized (object) {
            return locale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLocale(Locale locale) throws IllegalArgumentException {
        Object object = mutex;
        synchronized (object) {
            if (locale == null) {
                throw new IllegalArgumentException("null locale");
            }
            ResourceBundleHandler.locale = locale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getBundleHandle(String string2, ClassLoader classLoader) {
        Integer n;
        String string3 = prefix + string2;
        Object object = mutex;
        synchronized (object) {
            String string4 = locale.toString() + string3;
            n = (Integer)bundleHandleMap.get(string4);
            if (n == null) {
                ResourceBundle resourceBundle = ResourceBundleHandler.getBundle(string3, locale, classLoader);
                bundleList.add(resourceBundle);
                n = bundleList.size() - 1;
                bundleHandleMap.put(string4, n);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(int n, String string2) {
        String string3;
        ResourceBundle resourceBundle;
        Object object = mutex;
        synchronized (object) {
            resourceBundle = n < 0 || n >= bundleList.size() || string2 == null ? null : (ResourceBundle)bundleList.get(n);
        }
        if (resourceBundle == null) {
            string3 = null;
        } else {
            try {
                string3 = resourceBundle.getString(string2);
            }
            catch (Exception exception) {
                string3 = null;
            }
        }
        return string3;
    }

    private static Method getNewGetBundleMethod() {
        Class<ResourceBundle> clazz = ResourceBundle.class;
        Class[] classArray = new Class[]{String.class, Locale.class, ClassLoader.class};
        try {
            return clazz.getMethod("getBundle", classArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static ResourceBundle getBundle(String string2, Locale locale, ClassLoader classLoader) throws NullPointerException, MissingResourceException {
        if (classLoader == null) {
            return ResourceBundle.getBundle(string2, locale);
        }
        if (newGetBundleMethod == null) {
            return ResourceBundle.getBundle(string2, locale);
        }
        try {
            return (ResourceBundle)newGetBundleMethod.invoke(null, string2, locale, classLoader);
        }
        catch (Exception exception) {
            return ResourceBundle.getBundle(string2, locale);
        }
    }
}

