/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.sql.SQLException;
import java.util.Map;
import org.hsqldb.Session;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.server.OdbcPreparedStatement;
import org.hsqldb.server.PgType;
import org.hsqldb.server.RecoverableOdbcFailure;
import org.hsqldb.types.Type;

class StatementPortal {
    public Object[] parameters;
    public Result bindResult;
    public Result ackResult;
    public String lcQuery;
    public String handle;
    private Map containingMap;
    private Session session;

    public StatementPortal(String string2, OdbcPreparedStatement odbcPreparedStatement, Map map23) throws RecoverableOdbcFailure {
        this(string2, odbcPreparedStatement, new Object[0], map23);
    }

    public StatementPortal(String string2, OdbcPreparedStatement odbcPreparedStatement, Object[] objectArray, Map map23) throws RecoverableOdbcFailure {
        this.handle = string2;
        this.lcQuery = odbcPreparedStatement.query.toLowerCase();
        this.ackResult = odbcPreparedStatement.ackResult;
        this.session = odbcPreparedStatement.session;
        this.containingMap = map23;
        Type[] typeArray = Type.emptyArray;
        switch (this.ackResult.getType()) {
            case 4: {
                break;
            }
            case 2: {
                throw new RecoverableOdbcFailure(this.ackResult);
            }
            default: {
                throw new RecoverableOdbcFailure("Output Result from secondary Statement prep is of unexpected type: " + this.ackResult.getType());
            }
        }
        if (objectArray.length < 1) {
            this.parameters = new Object[0];
        } else {
            ResultMetaData resultMetaData = odbcPreparedStatement.ackResult.parameterMetaData;
            if (resultMetaData == null) {
                throw new RecoverableOdbcFailure("No metadata for Result ack");
            }
            typeArray = resultMetaData.getParameterTypes();
            if (typeArray.length != objectArray.length) {
                throw new RecoverableOdbcFailure(null, "Client didn't specify all " + typeArray.length + " parameters (" + objectArray.length + ')', "08P01");
            }
            this.parameters = new Object[objectArray.length];
            try {
                for (int i = 0; i < this.parameters.length; ++i) {
                    this.parameters[i] = objectArray[i] instanceof String ? PgType.getPgType(typeArray[i], true).getParameter((String)objectArray[i], this.session) : objectArray[i];
                }
            }
            catch (SQLException sQLException) {
                throw new RecoverableOdbcFailure("Typing failure: " + sQLException);
            }
        }
        this.bindResult = Result.newPreparedExecuteRequest(typeArray, odbcPreparedStatement.ackResult.getStatementID());
        map23.put(string2, this);
    }

    public void close() {
        this.containingMap.remove(this.handle);
    }
}

