/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.hsqldb.lib.RCData;
import org.hsqldb.util.CommonSwing;
import org.hsqldb.util.ConnectionDialogCommon;
import org.hsqldb.util.ConnectionDialogSwing;
import org.hsqldb.util.ConnectionSetting;
import org.hsqldb.util.DatabaseManagerCommon;
import org.hsqldb.util.FontDialogSwing;
import org.hsqldb.util.GridSwing;
import org.hsqldb.util.TableSorter;
import org.hsqldb.util.Transfer;

public class DatabaseManagerSwing
extends JFrame
implements ActionListener,
WindowListener,
KeyListener,
MouseListener {
    private static String homedir = null;
    private boolean isOracle = false;
    ArrayList<JMenuItem> localActionList = new ArrayList();
    private JFrame jframe = null;
    private static final String DEFAULT_RCFILE;
    private static boolean TT_AVAILABLE;
    private static final String HELP_TEXT;
    private static final String ABOUT_TEXT;
    static final String NL;
    static final String NULL_STR = "[null]";
    static int iMaxRecent;
    Connection cConn;
    Connection rowConn;
    DatabaseMetaData dMeta;
    Statement sStatement;
    JMenu mRecent;
    String[] sRecent;
    int iRecent;
    JTextArea txtCommand;
    JScrollPane txtCommandScroll;
    JButton butExecute;
    JTree tTree;
    JScrollPane tScrollPane;
    DefaultTreeModel treeModel;
    TableModel tableModel;
    DefaultMutableTreeNode rootNode;
    JPanel pResult;
    long lTime;
    GridSwing gResult;
    JTable gResultTable;
    JScrollPane gScrollPane;
    JTextArea txtResult;
    JScrollPane txtResultScroll;
    JSplitPane nsSplitPane;
    JSplitPane ewSplitPane;
    boolean bHelp;
    RootPaneContainer fMain;
    static boolean bMustExit;
    String sqlScriptBuffer = null;
    JToolBar jtoolbar;
    private boolean showSchemas = true;
    private boolean showTooltips = true;
    private boolean autoRefresh = true;
    private boolean gridFormat = true;
    static DatabaseManagerSwing refForFontDialogSwing;
    boolean displayRowCounts = false;
    boolean showSys = false;
    boolean showIndexDetails = true;
    String currentLAF = null;
    JPanel pStatus;
    static JButton iReadyStatus;
    JRadioButtonMenuItem rbAllSchemas = new JRadioButtonMenuItem("*");
    JMenuItem mitemAbout = new JMenuItem("About", 65);
    JMenuItem mitemHelp = new JMenuItem("Help", 72);
    JMenuItem mitemUpdateSchemas = new JMenuItem("Update Schemas");
    JCheckBoxMenuItem boxAutoCommit = new JCheckBoxMenuItem("Autocommit mode");
    JCheckBoxMenuItem boxLogging = new JCheckBoxMenuItem("Logging mode");
    JCheckBoxMenuItem boxShowSchemas = new JCheckBoxMenuItem("Show schemas");
    JCheckBoxMenuItem boxAutoRefresh = new JCheckBoxMenuItem("Auto-refresh tree");
    JCheckBoxMenuItem boxTooltips = new JCheckBoxMenuItem("Show Tooltips");
    JCheckBoxMenuItem boxRowCounts = new JCheckBoxMenuItem("Show row counts");
    JCheckBoxMenuItem boxShowGrid = new JCheckBoxMenuItem("Show results in Grid (a.o.t. Text)");
    JCheckBoxMenuItem boxShowSys = new JCheckBoxMenuItem("Show system tables");
    JRadioButtonMenuItem rbNativeLF = new JRadioButtonMenuItem("Native Look & Feel");
    JRadioButtonMenuItem rbJavaLF = new JRadioButtonMenuItem("Java Look & Feel");
    JRadioButtonMenuItem rbMotifLF = new JRadioButtonMenuItem("Motif Look & Feel");
    JLabel jStatusLine;
    static String READY_STATUS;
    private static final String AUTOCOMMIT_BOX_TEXT = "Autocommit mode";
    private static final String LOGGING_BOX_TEXT = "Logging mode";
    private static final String SHOWSCHEMAS_BOX_TEXT = "Show schemas";
    private static final String AUTOREFRESH_BOX_TEXT = "Auto-refresh tree";
    private static final String SHOWTIPS_BOX_TEXT = "Show Tooltips";
    private static final String ROWCOUNTS_BOX_TEXT = "Show row counts";
    private static final String SHOWSYS_BOX_TEXT = "Show system tables";
    private static final String GRID_BOX_TEXT = "Show results in Grid (a.o.t. Text)";
    Cursor fMainCursor;
    Cursor txtCommandCursor;
    Cursor txtResultCursor;
    HashMap<AbstractButton, String> tipMap = new HashMap();
    private JMenu mnuSchemas = new JMenu("Schemas");
    private final Cursor waitCursor = new Cursor(3);
    static String defDriver;
    static String defURL;
    static String defUser;
    static String defPassword;
    static String defScript;
    static String defDirectory;
    private String schemaFilter = null;
    private DBMPrefs prefs = null;
    Thread dummyThread = new Thread("dummy");
    private String busyText = null;
    private Runnable enableButtonRunnable = new Runnable(){

        @Override
        public void run() {
            DatabaseManagerSwing.this.jbuttonClear.setEnabled(true);
            DatabaseManagerSwing.this.jbuttonExecute.setEnabled(true);
        }
    };
    private Runnable disableButtonRunnable = new Runnable(){

        @Override
        public void run() {
            DatabaseManagerSwing.this.jbuttonClear.setEnabled(false);
            DatabaseManagerSwing.this.jbuttonExecute.setEnabled(false);
        }
    };
    private Thread buttonUpdaterThread = null;
    private static final int BUTTON_CHECK_PERIOD = 500;
    private Runnable buttonUpdater = new Runnable(){

        @Override
        public void run() {
            while (true) {
                boolean bl;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (DatabaseManagerSwing.this.buttonUpdaterThread == null) {
                    return;
                }
                boolean bl2 = bl = DatabaseManagerSwing.this.txtCommand.getText().length() > 0;
                if (DatabaseManagerSwing.this.jbuttonClear.isEnabled() == bl) continue;
                SwingUtilities.invokeLater(bl ? DatabaseManagerSwing.this.enableButtonRunnable : DatabaseManagerSwing.this.disableButtonRunnable);
            }
        }
    };
    private JButton jbuttonClear;
    private JButton jbuttonExecute;
    private Runnable treeRefreshRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                DatabaseManagerSwing.this.directRefreshTree();
            }
            catch (RuntimeException runtimeException) {
                CommonSwing.errorMessage(runtimeException);
                throw runtimeException;
            }
            finally {
                DatabaseManagerSwing.this.setWaiting(null);
            }
        }
    };
    private MouseEvent alreadyHandled = null;
    private static final String[] usertables;
    private static final String[] nonSystables;
    private static final HashSet<String> oracleSysUsers;
    private static final String[] oracleSysSchemas;
    ActionListener schemaListListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DatabaseManagerSwing.this.schemaFilter = actionEvent.getActionCommand();
            if (DatabaseManagerSwing.this.schemaFilter.equals("*")) {
                DatabaseManagerSwing.this.schemaFilter = null;
            }
            DatabaseManagerSwing.this.refreshTree();
        }
    };
    private static final String tString;
    private static final String fString;

    public DatabaseManagerSwing() {
        this.jframe = new JFrame("HSQLDB DatabaseManager");
        this.fMain = this.jframe;
    }

    public DatabaseManagerSwing(JFrame jFrame) {
        this.jframe = jFrame;
        this.fMain = this.jframe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.fMain = this;
        this.main();
        for (int i = 0; i < this.localActionList.size(); ++i) {
            AbstractButton abstractButton = this.localActionList.get(i);
            abstractButton.setEnabled(false);
        }
        Connection connection = null;
        boolean bl = false;
        try {
            this.setWaiting("Initializing");
            connection = bl ? ConnectionDialogSwing.createConnection(defDriver, defURL, defUser, defPassword) : ConnectionDialogSwing.createConnection(this.jframe, "Connect");
        }
        catch (Exception exception) {
            CommonSwing.errorMessage(exception);
        }
        finally {
            this.setWaiting(null);
        }
        if (connection != null) {
            this.connect(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        DatabaseManagerSwing databaseManagerSwing;
        System.getProperties().put("sun.java2d.noddraw", "true");
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        bMustExit = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            String string5 = stringArray[i].toLowerCase();
            if (string5.startsWith("--")) {
                string5 = string5.substring(1);
            }
            if (!string5.equals("-noexit") && !string5.equals("-help") && i == stringArray.length - 1) {
                throw new IllegalArgumentException("No value for argument " + string4);
            }
            ++i;
            if (string5.equals("-driver")) {
                defDriver = stringArray[i];
                bl = true;
                continue;
            }
            if (string5.equals("-url")) {
                defURL = stringArray[i];
                bl = true;
                continue;
            }
            if (string5.equals("-user")) {
                defUser = stringArray[i];
                bl = true;
                continue;
            }
            if (string5.equals("-password")) {
                defPassword = stringArray[i];
                bl = true;
                continue;
            }
            if (string5.equals("-urlid")) {
                string2 = stringArray[i];
                bl2 = true;
                continue;
            }
            if (string5.equals("-rcfile")) {
                string3 = stringArray[i];
                bl2 = true;
                continue;
            }
            if (string5.equals("-dir")) {
                defDirectory = stringArray[i];
                continue;
            }
            if (string5.equals("-script")) {
                defScript = stringArray[i];
                continue;
            }
            if (string5.equals("-noexit")) {
                bMustExit = false;
                --i;
                continue;
            }
            if (string5.equals("-help")) {
                DatabaseManagerSwing.showUsage();
                return;
            }
            throw new IllegalArgumentException("invalid argrument " + string4 + " try:  java... " + DatabaseManagerSwing.class.getName() + " --help");
        }
        refForFontDialogSwing = databaseManagerSwing = new DatabaseManagerSwing(new JFrame("HSQL Database Manager"));
        databaseManagerSwing.main();
        Connection connection = null;
        databaseManagerSwing.setWaiting("Initializing");
        try {
            if (bl && bl2) {
                throw new IllegalArgumentException("You may not specify both (urlid) AND (url/user/password).");
            }
            if (bl) {
                connection = ConnectionDialogSwing.createConnection(defDriver, defURL, defUser, defPassword);
            } else if (bl2) {
                if (string2 == null) {
                    throw new IllegalArgumentException("You must specify an 'urlid' to use an RC file");
                }
                bl = true;
                String string6 = string3 == null ? DEFAULT_RCFILE : string3;
                RCData rCData = new RCData(new File(string6), string2);
                connection = rCData.getConnection(null, System.getProperty("javax.net.ssl.trustStore"));
            } else {
                connection = ConnectionDialogSwing.createConnection(databaseManagerSwing.jframe, "Connect");
            }
        }
        catch (Exception exception) {
            CommonSwing.errorMessage(exception);
        }
        finally {
            databaseManagerSwing.setWaiting(null);
        }
        if (connection != null) {
            databaseManagerSwing.connect(connection);
        }
        FontDialogSwing.creatFontDialog(refForFontDialogSwing);
        databaseManagerSwing.start();
    }

    public void connect(Connection connection) {
        this.schemaFilter = null;
        if (connection == null) {
            return;
        }
        if (this.cConn != null) {
            try {
                this.cConn.close();
            }
            catch (SQLException sQLException) {
                CommonSwing.errorMessage(sQLException);
            }
        }
        this.cConn = connection;
        this.rowConn = connection;
        try {
            this.dMeta = this.cConn.getMetaData();
            this.isOracle = this.dMeta.getDatabaseProductName().indexOf("Oracle") >= 0;
            this.sStatement = this.cConn.createStatement();
            this.updateAutoCommitBox();
            this.showIndexDetails = !this.isOracle;
            Driver driver = DriverManager.getDriver(this.dMeta.getURL());
            ConnectionSetting connectionSetting = new ConnectionSetting(this.dMeta.getDatabaseProductName(), driver.getClass().getName(), this.dMeta.getURL(), this.dMeta.getUserName().replaceAll("@localhost", ""), "");
            Hashtable hashtable = ConnectionDialogCommon.loadRecentConnectionSettings();
            ConnectionDialogCommon.addToRecentConnectionSettings(hashtable, connectionSetting);
            ConnectionDialogSwing.setConnectionSetting(connectionSetting);
            this.refreshTree();
            this.clearResultPanel();
        }
        catch (SQLException sQLException) {
            CommonSwing.errorMessage(sQLException);
        }
        catch (IOException iOException) {
            CommonSwing.errorMessage(iOException);
        }
        catch (Exception exception) {
            CommonSwing.errorMessage(exception);
        }
    }

    private static void showUsage() {
        System.out.println("Usage: java DatabaseManagerSwing [--options]\nwhere options include:\n    --help                show this message\n    --driver <classname>  jdbc driver class\n    --url <name>          jdbc url\n    --user <name>         username used for connection\n    --password <password> password for this user\n    --urlid <urlid>       use url/user/password/driver in rc file\n    --rcfile <file>       (defaults to 'dbmanager.rc' in home dir)\n    --dir <path>          default directory\n    --script <file>       reads from script file\n    --noexit              do not call system.exit()");
    }

    private void insertTestData() {
        try {
            DatabaseManagerCommon.createTestTables(this.sStatement);
            this.txtCommand.setText(DatabaseManagerCommon.createTestData(this.sStatement));
            for (int i = 0; i < DatabaseManagerCommon.testDataSql.length; ++i) {
                this.addToRecent(DatabaseManagerCommon.testDataSql[i]);
            }
            this.executeCurrentSQL();
        }
        catch (SQLException sQLException) {
            CommonSwing.errorMessage(sQLException);
        }
    }

    public void setMustExit(boolean bl) {
        bMustExit = bl;
    }

    public void main() {
        JMenuItem jMenuItem;
        try {
            this.prefs = new DBMPrefs(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.prefs == null) {
            this.setLF(CommonSwing.Native);
        } else {
            this.autoRefresh = this.prefs.autoRefresh;
            this.displayRowCounts = this.prefs.showRowCounts;
            this.showSys = this.prefs.showSysTables;
            this.showSchemas = this.prefs.showSchemas;
            this.gridFormat = this.prefs.resultGrid;
            this.showTooltips = this.prefs.showTooltips;
            this.setLF(this.prefs.laf);
        }
        this.fMain.getContentPane().add((Component)this.createToolBar(), "North");
        if (this.fMain instanceof Frame) {
            ((Frame)((Object)this.fMain)).setIconImage(CommonSwing.getIcon("Frame"));
        }
        if (this.fMain instanceof Window) {
            ((Window)((Object)this.fMain)).addWindowListener(this);
        }
        JMenuBar jMenuBar = new JMenuBar();
        Object[] objectArray = new String[]{"-Connect...", "--", "OOpen Script...", "-Save Script...", "-Save Result...", "--", "-Exit"};
        JMenu jMenu = this.addMenu(jMenuBar, "File", objectArray);
        for (int i = 2; i < jMenu.getItemCount(); ++i) {
            jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null) continue;
            this.localActionList.add(jMenuItem);
        }
        Object[] objectArray2 = new Object[]{"RRefresh Tree", this.boxAutoRefresh, "--", this.boxRowCounts, this.boxShowSys, this.boxShowSchemas, this.boxShowGrid};
        this.addMenu(jMenuBar, "View", objectArray2);
        Object[] objectArray3 = new String[]{"SSELECT", "IINSERT", "UUPDATE", "DDELETE", "EEXECUTE", "---", "-CREATE TABLE", "-DROP TABLE", "-CREATE INDEX", "-DROP INDEX", "--", "CCOMMIT*", "LROLLBACK*", "-CHECKPOINT*", "-SCRIPT", "-SET", "-SHUTDOWN", "--", "-Test Script"};
        this.addMenu(jMenuBar, "Command", objectArray3);
        this.mRecent = new JMenu("Recent");
        this.mRecent.setMnemonic(82);
        jMenuBar.add(this.mRecent);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbNativeLF);
        buttonGroup.add(this.rbJavaLF);
        buttonGroup.add(this.rbMotifLF);
        this.boxShowSchemas.setSelected(this.showSchemas);
        this.boxShowGrid.setSelected(this.gridFormat);
        this.boxTooltips.setSelected(this.showTooltips);
        this.boxShowGrid.setAccelerator(KeyStroke.getKeyStroke(71, 128));
        this.boxAutoRefresh.setSelected(this.autoRefresh);
        this.boxRowCounts.setSelected(this.displayRowCounts);
        this.boxShowSys.setSelected(this.showSys);
        this.rbNativeLF.setActionCommand("LFMODE:" + CommonSwing.Native);
        this.rbJavaLF.setActionCommand("LFMODE:" + CommonSwing.Java);
        this.rbMotifLF.setActionCommand("LFMODE:" + CommonSwing.Motif);
        this.tipMap.put(this.mitemUpdateSchemas, "Refresh the schema list in this menu");
        this.tipMap.put(this.rbAllSchemas, "Display items in all schemas");
        this.tipMap.put(this.mitemAbout, "Display product information");
        this.tipMap.put(this.mitemHelp, "Display advice for obtaining help");
        this.tipMap.put(this.boxAutoRefresh, "Refresh tree (and schema list) automaticallywhen YOU modify database objects");
        this.tipMap.put(this.boxShowSchemas, "Display object names in tree-like schemaname.basename");
        this.tipMap.put(this.rbNativeLF, "Set Look and Feel to Native for your platform");
        this.tipMap.put(this.rbJavaLF, "Set Look and Feel to Java");
        this.tipMap.put(this.rbMotifLF, "Set Look and Feel to Motif");
        this.boxTooltips.setToolTipText("Display tooltips (hover text), like this");
        this.tipMap.put(this.boxAutoCommit, "Shows current Auto-commit mode.  Click to change");
        this.tipMap.put(this.boxLogging, "Shows current JDBC DriverManager logging mode.  Click to change");
        this.tipMap.put(this.boxShowSys, "Show system tables in table tree to the left");
        this.tipMap.put(this.boxShowGrid, "Show query results in grid (in text if off)");
        this.tipMap.put(this.boxRowCounts, "Show row counts with table names in tree");
        this.boxAutoRefresh.setMnemonic(67);
        this.boxShowSchemas.setMnemonic(89);
        this.boxAutoCommit.setMnemonic(65);
        this.boxShowSys.setMnemonic(89);
        this.boxShowGrid.setMnemonic(71);
        this.boxRowCounts.setMnemonic(67);
        this.boxLogging.setMnemonic(76);
        this.rbAllSchemas.setMnemonic(151);
        this.rbNativeLF.setMnemonic(78);
        this.rbJavaLF.setMnemonic(74);
        this.rbMotifLF.setMnemonic(77);
        this.mitemUpdateSchemas.setMnemonic(85);
        Object[] objectArray4 = new Object[]{this.rbNativeLF, this.rbJavaLF, this.rbMotifLF, "--", "-Set Fonts", "--", this.boxAutoCommit, "--", "-Disable MaxRows", "-Set MaxRows to 100", "--", this.boxLogging, "--", "-Insert test data"};
        this.addMenu(jMenuBar, "Options", objectArray4);
        Object[] objectArray5 = new String[]{"-Dump", "-Restore", "-Transfer"};
        jMenu = this.addMenu(jMenuBar, "Tools", objectArray5);
        jMenu.setEnabled(TT_AVAILABLE);
        this.localActionList.add(jMenu);
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null) continue;
            this.localActionList.add(jMenuItem);
        }
        this.mnuSchemas.setMnemonic(83);
        jMenuBar.add(this.mnuSchemas);
        JMenu jMenu2 = new JMenu("Help");
        jMenu2.setMnemonic(72);
        jMenu2.add(this.mitemAbout);
        jMenu2.add(this.mitemHelp);
        jMenu2.add(this.boxTooltips);
        this.rbAllSchemas.addActionListener(this.schemaListListener);
        this.mitemUpdateSchemas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseManagerSwing.this.updateSchemaList();
            }
        });
        this.mitemHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(DatabaseManagerSwing.this.fMain.getContentPane(), HELP_TEXT, "HELP", 1);
            }
        });
        this.mitemAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(DatabaseManagerSwing.this.fMain.getContentPane(), ABOUT_TEXT, "About", 1);
            }
        });
        this.boxTooltips.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseManagerSwing.this.showTooltips = DatabaseManagerSwing.this.boxTooltips.isSelected();
                DatabaseManagerSwing.this.resetTooltips();
            }
        });
        jMenuBar.add(jMenu2);
        if (this.fMain instanceof JFrame) {
            ((JFrame)this.fMain).setJMenuBar(jMenuBar);
        }
        this.initGUI();
        this.sRecent = new String[iMaxRecent];
        CommonSwing.setFramePositon((JFrame)this.fMain);
        ((Component)((Object)this.fMain)).setVisible(true);
        if (defScript != null) {
            if (defDirectory != null) {
                defScript = defDirectory + File.separator + defScript;
            }
            this.sqlScriptBuffer = DatabaseManagerCommon.readFile(defScript);
            if (4096 <= this.sqlScriptBuffer.length()) {
                int n = this.sqlScriptBuffer.indexOf(10);
                if (n > 0) {
                    n = this.sqlScriptBuffer.indexOf(10, n + 1);
                }
                if (n > 0) {
                    n = this.sqlScriptBuffer.indexOf(10, n + 1);
                }
                if (n < 1) {
                    n = 100;
                }
                this.txtCommand.setText("............... Script File loaded: " + defScript + " ..................... \n............... Click Execute or Clear ...................\n" + this.sqlScriptBuffer.substring(0, n + 1) + ".........................................................................\n.........................................................................\n");
                this.txtCommand.setEnabled(false);
            } else {
                this.txtCommand.setText(this.sqlScriptBuffer);
                this.sqlScriptBuffer = null;
                this.txtCommand.setEnabled(true);
            }
        }
        this.resetTooltips();
        this.txtCommand.requestFocus();
    }

    private JMenu addMenu(JMenuBar jMenuBar, String string2, Object[] objectArray) {
        JMenu jMenu = new JMenu(string2);
        jMenu.setMnemonic(string2.charAt(0));
        this.addMenuItems(jMenu, objectArray);
        jMenuBar.add(jMenu);
        return jMenu;
    }

    private void addMenuItems(JMenu jMenu, Object[] objectArray) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        for (int i = 0; i < objectArray.length; ++i) {
            JMenuItem jMenuItem;
            if (objectArray[i].equals("--")) {
                jMenu.addSeparator();
                continue;
            }
            if (objectArray[i].equals("---")) {
                if (dimension.width >= 640) {
                    jMenu.addSeparator();
                    continue;
                }
                return;
            }
            if (objectArray[i] instanceof JMenuItem) {
                jMenuItem = (JMenuItem)objectArray[i];
            } else if (objectArray[i] instanceof String) {
                jMenuItem = new JMenuItem(((String)objectArray[i]).substring(1));
                char c = ((String)objectArray[i]).charAt(0);
                if (c != '-') {
                    KeyStroke keyStroke = KeyStroke.getKeyStroke((int)c, 128);
                    jMenuItem.setAccelerator(keyStroke);
                }
            } else {
                throw new RuntimeException("Unexpected element for menu item creation: " + objectArray[i].getClass().getName());
            }
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n' && keyEvent.isControlDown()) {
            keyEvent.consume();
            this.executeCurrentSQL();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string2 = actionEvent.getActionCommand();
        if (string2 == null && actionEvent.getSource() instanceof JMenuItem) {
            string2 = ((JMenuItem)actionEvent.getSource()).getText();
        }
        if (string2 != null) {
            if (string2.equals("Exit")) {
                this.windowClosing(null);
            } else if (string2.equals("Transfer")) {
                Transfer.work(null);
            } else if (string2.equals("Dump")) {
                Transfer.work((String[])new String[]{"-d"});
            } else if (string2.equals("Restore")) {
                JOptionPane.showMessageDialog(this.fMain.getContentPane(), "Use Ctrl-R or the View menu to\nupdate nav. tree after Restoration", "Suggestion", 1);
                Transfer.work((String[])new String[]{"-r"});
            } else if (string2.equals(LOGGING_BOX_TEXT)) {
                DatabaseManagerSwing.setLogToSystem(this.boxLogging.isSelected());
            } else if (string2.equals(AUTOREFRESH_BOX_TEXT)) {
                this.autoRefresh = this.boxAutoRefresh.isSelected();
                this.refreshTree();
            } else if (string2.equals("Refresh Tree")) {
                this.refreshTree();
            } else if (string2.startsWith("#")) {
                int n = Integer.parseInt(string2.substring(1));
                this.txtCommand.setText(this.sRecent[n]);
            } else if (string2.equals("Connect...")) {
                Connection connection = null;
                try {
                    this.setWaiting("Connecting");
                    connection = ConnectionDialogSwing.createConnection(this.jframe, "Connect");
                }
                finally {
                    this.setWaiting(null);
                }
                this.connect(connection);
            } else if (string2.equals(GRID_BOX_TEXT)) {
                this.gridFormat = this.boxShowGrid.isSelected();
                this.displayResults();
            } else if (string2.equals("Open Script...")) {
                File file;
                int n;
                JFileChooser jFileChooser = new JFileChooser(".");
                jFileChooser.setDialogTitle("Open Script...");
                if (defDirectory != null) {
                    jFileChooser.setCurrentDirectory(new File(defDirectory));
                }
                if ((n = jFileChooser.showOpenDialog((Component)((Object)this.fMain))) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    this.sqlScriptBuffer = DatabaseManagerCommon.readFile(file.getAbsolutePath());
                    if (4096 <= this.sqlScriptBuffer.length()) {
                        int n2 = this.sqlScriptBuffer.indexOf(10);
                        if (n2 > 0) {
                            n2 = this.sqlScriptBuffer.indexOf(10, n2 + 1);
                        }
                        if (n2 > 0) {
                            n2 = this.sqlScriptBuffer.indexOf(10, n2 + 1);
                        }
                        if (n2 < 1) {
                            n2 = 100;
                        }
                        this.txtCommand.setText("............... Script File loaded: " + file + " ..................... \n............... Click Execute or Clear ...................\n" + this.sqlScriptBuffer.substring(0, n2 + 1) + ".........................................................................\n.........................................................................\n");
                        this.txtCommand.setEnabled(false);
                    } else {
                        this.txtCommand.setText(this.sqlScriptBuffer);
                        this.sqlScriptBuffer = null;
                        this.txtCommand.setEnabled(true);
                    }
                }
            } else if (string2.equals("Save Script...")) {
                File file;
                int n;
                JFileChooser jFileChooser = new JFileChooser(".");
                jFileChooser.setDialogTitle("Save Script");
                if (defDirectory != null) {
                    jFileChooser.setCurrentDirectory(new File(defDirectory));
                }
                if ((n = jFileChooser.showSaveDialog((Component)((Object)this.fMain))) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    DatabaseManagerCommon.writeFile(file.getAbsolutePath(), this.txtCommand.getText());
                }
            } else if (string2.equals("Save Result...")) {
                File file;
                int n;
                JFileChooser jFileChooser = new JFileChooser(".");
                jFileChooser.setDialogTitle("Save Result...");
                if (defDirectory != null) {
                    jFileChooser.setCurrentDirectory(new File(defDirectory));
                }
                if ((n = jFileChooser.showSaveDialog((Component)((Object)this.fMain))) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    this.showResultInText();
                    DatabaseManagerCommon.writeFile(file.getAbsolutePath(), this.txtResult.getText());
                }
            } else if (string2.equals(SHOWSYS_BOX_TEXT)) {
                this.showSys = this.boxShowSys.isSelected();
                this.refreshTree();
            } else if (string2.equals(ROWCOUNTS_BOX_TEXT)) {
                this.displayRowCounts = this.boxRowCounts.isSelected();
                this.refreshTree();
            } else if (string2.startsWith("LFMODE:")) {
                this.setLF(string2.substring("LFMODE:".length()));
            } else if (string2.equals("Set Fonts")) {
                FontDialogSwing.creatFontDialog(refForFontDialogSwing);
            } else if (string2.equals(AUTOCOMMIT_BOX_TEXT)) {
                try {
                    this.cConn.setAutoCommit(this.boxAutoCommit.isSelected());
                }
                catch (SQLException sQLException) {
                    this.boxAutoCommit.setSelected(!this.boxAutoCommit.isSelected());
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string2.equals("COMMIT*")) {
                try {
                    this.cConn.commit();
                    this.showHelp(new String[]{"", "COMMIT executed"});
                }
                catch (SQLException sQLException) {
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string2.equals("Insert test data")) {
                this.insertTestData();
                this.refreshTree();
            } else if (string2.equals("ROLLBACK*")) {
                try {
                    this.cConn.rollback();
                    this.showHelp(new String[]{"", "ROLLBACK executed"});
                }
                catch (SQLException sQLException) {
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string2.equals("Disable MaxRows")) {
                try {
                    this.sStatement.setMaxRows(0);
                }
                catch (SQLException sQLException) {
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string2.equals("Set MaxRows to 100")) {
                try {
                    this.sStatement.setMaxRows(100);
                }
                catch (SQLException sQLException) {
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string2.equals("SELECT")) {
                this.showHelp(DatabaseManagerCommon.selectHelp);
            } else if (string2.equals("INSERT")) {
                this.showHelp(DatabaseManagerCommon.insertHelp);
            } else if (string2.equals("UPDATE")) {
                this.showHelp(DatabaseManagerCommon.updateHelp);
            } else if (string2.equals("DELETE")) {
                this.showHelp(DatabaseManagerCommon.deleteHelp);
            } else if (string2.equals("EXECUTE")) {
                this.executeCurrentSQL();
            } else if (string2.equals("CREATE TABLE")) {
                this.showHelp(DatabaseManagerCommon.createTableHelp);
            } else if (string2.equals("DROP TABLE")) {
                this.showHelp(DatabaseManagerCommon.dropTableHelp);
            } else if (string2.equals("CREATE INDEX")) {
                this.showHelp(DatabaseManagerCommon.createIndexHelp);
            } else if (string2.equals("DROP INDEX")) {
                this.showHelp(DatabaseManagerCommon.dropIndexHelp);
            } else if (string2.equals("CHECKPOINT*")) {
                try {
                    this.cConn.createStatement().executeUpdate("CHECKPOINT");
                    this.showHelp(new String[]{"", "CHECKPOINT executed"});
                }
                catch (SQLException sQLException) {
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string2.equals("SCRIPT")) {
                this.showHelp(DatabaseManagerCommon.scriptHelp);
            } else if (string2.equals("SHUTDOWN")) {
                this.showHelp(DatabaseManagerCommon.shutdownHelp);
            } else if (string2.equals("SET")) {
                this.showHelp(DatabaseManagerCommon.setHelp);
            } else if (string2.equals("Test Script")) {
                this.showHelp(DatabaseManagerCommon.testHelp);
            } else if (string2.equals(SHOWSCHEMAS_BOX_TEXT)) {
                this.showSchemas = this.boxShowSchemas.isSelected();
                this.refreshTree();
            } else {
                throw new RuntimeException("Unexpected action triggered: " + string2);
            }
        }
    }

    private void displayResults() {
        if (this.gridFormat) {
            this.setResultsInGrid();
        } else {
            this.setResultsInText();
        }
    }

    private void setResultsInGrid() {
        this.pResult.removeAll();
        this.pResult.add((Component)this.gScrollPane, "Center");
        this.pResult.doLayout();
        this.gResult.fireTableChanged(null);
        this.pResult.repaint();
    }

    private void setResultsInText() {
        this.pResult.removeAll();
        this.pResult.add((Component)this.txtResultScroll, "Center");
        this.pResult.doLayout();
        this.showResultInText();
        this.pResult.repaint();
    }

    private void showHelp(String[] stringArray) {
        this.txtCommand.setText(stringArray[0]);
        this.bHelp = true;
        this.pResult.removeAll();
        this.pResult.add((Component)this.txtResultScroll, "Center");
        this.pResult.doLayout();
        this.txtResult.setText(stringArray[1]);
        this.pResult.repaint();
        this.txtCommand.requestFocus();
        this.txtCommand.setCaretPosition(stringArray[0].length());
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.stop();
        try {
            if (this.cConn != null) {
                this.cConn.close();
            }
            if (this.prefs != null) {
                this.prefs.autoRefresh = this.autoRefresh;
                this.prefs.showRowCounts = this.displayRowCounts;
                this.prefs.showSysTables = this.showSys;
                this.prefs.showSchemas = this.showSchemas;
                this.prefs.resultGrid = this.gridFormat;
                this.prefs.showTooltips = this.showTooltips;
                this.prefs.laf = this.currentLAF;
                this.prefs.store();
            }
        }
        catch (Exception exception) {
            CommonSwing.errorMessage(exception);
        }
        if (this.fMain instanceof Window) {
            ((Window)((Object)this.fMain)).dispose();
        }
        if (bMustExit) {
            System.exit(0);
        }
    }

    private void clear() {
        this.sqlScriptBuffer = null;
        this.txtCommand.setText("");
        this.txtCommand.setEnabled(true);
    }

    private void backgroundIt(Runnable runnable, String string2) {
        if (this.busyText != null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.setWaiting(string2);
        SwingUtilities.invokeLater(runnable);
    }

    private void clearResultPanel() {
        this.gResult.setHead(new Object[0]);
        this.gResult.clear();
        if (this.gridFormat) {
            this.gResult.fireTableChanged(null);
        } else {
            this.showResultInText();
        }
    }

    public void setWaiting(String string2) {
        this.busyText = string2;
        if (this.busyText == null) {
            if (this.fMain instanceof Frame) {
                ((Frame)((Object)this.fMain)).setCursor(this.fMainCursor);
            } else {
                ((Component)((Object)this.fMain)).setCursor(this.fMainCursor);
            }
            this.txtCommand.setCursor(this.txtCommandCursor);
            this.txtResult.setCursor(this.txtResultCursor);
        } else {
            if (this.fMainCursor == null) {
                this.fMainCursor = this.fMain instanceof Frame ? ((Frame)((Object)this.fMain)).getCursor() : ((Component)((Object)this.fMain)).getCursor();
                this.txtCommandCursor = this.txtCommand.getCursor();
                this.txtResultCursor = this.txtResult.getCursor();
            }
            if (this.fMain instanceof Frame) {
                ((Frame)((Object)this.fMain)).setCursor(this.waitCursor);
            } else {
                ((Component)((Object)this.fMain)).setCursor(this.waitCursor);
            }
            this.txtCommand.setCursor(this.waitCursor);
            this.txtResult.setCursor(this.waitCursor);
        }
        this.setStatusLine(this.busyText, this.busyText == null ? this.gResult.getRowCount() : 0);
    }

    public void start() {
        if (this.buttonUpdaterThread == null) {
            this.buttonUpdaterThread = new Thread(this.buttonUpdater);
        }
        this.buttonUpdaterThread.start();
    }

    public void stop() {
        System.err.println("Stopping");
        Thread thread = this.buttonUpdaterThread;
        if (thread != null) {
            thread.setContextClassLoader(null);
        }
        this.buttonUpdaterThread = null;
    }

    protected void executeCurrentSQL() {
        if (this.txtCommand.getText().length() < 1) {
            CommonSwing.errorMessage("No SQL to execute");
            return;
        }
        this.backgroundIt(new StatementExecRunnable(), "Executing SQL");
    }

    private void executeSQL() {
        Object[] objectArray = new String[1];
        String string2 = null;
        try {
            this.lTime = System.nanoTime();
            String string3 = string2 = this.sqlScriptBuffer == null ? this.txtCommand.getText() : this.sqlScriptBuffer;
            if (this.sStatement == null) {
                objectArray[0] = "no connection";
                this.gResult.setHead(objectArray);
                return;
            }
            this.sStatement.execute(string2);
            this.lTime = System.nanoTime() - this.lTime;
            int n = this.sStatement.getUpdateCount();
            if (n == -1) {
                ResultSet resultSet = this.sStatement.getResultSet();
                try {
                    this.formatResultSet(resultSet);
                }
                catch (Throwable throwable) {
                    objectArray[0] = "Error displaying the ResultSet";
                    this.gResult.setHead(objectArray);
                    String string4 = throwable.getMessage();
                    objectArray[0] = string4;
                    this.gResult.addRow(objectArray);
                }
            } else {
                objectArray[0] = "update count";
                this.gResult.setHead(objectArray);
                objectArray[0] = "" + n;
                this.gResult.addRow(objectArray);
            }
            if (this.sqlScriptBuffer == null) {
                this.addToRecent(string2);
                this.txtCommand.setEnabled(true);
            } else {
                this.clear();
            }
        }
        catch (SQLException sQLException) {
            this.lTime = System.nanoTime() - this.lTime;
            objectArray[0] = "SQL Error";
            this.gResult.setHead(objectArray);
            String string5 = sQLException.getMessage();
            string5 = string5 + " / Error Code: " + sQLException.getErrorCode();
            string5 = string5 + " / State: " + sQLException.getSQLState();
            objectArray[0] = string5;
            this.gResult.addRow(objectArray);
            return;
        }
        if (this.autoRefresh) {
            this.setStatusLine("Refreshing object tree", 0);
            String string6 = string2.toUpperCase(Locale.ENGLISH);
            if (string6.indexOf("ALTER") > -1 || string6.indexOf("DROP") > -1 || string6.indexOf("CREATE") > -1) {
                this.directRefreshTree();
            }
        }
    }

    private void updateResult() {
        if (this.gridFormat) {
            if (this.bHelp) {
                this.pResult.removeAll();
                this.pResult.add((Component)this.gScrollPane, "Center");
                this.pResult.doLayout();
                this.gResult.fireTableChanged(null);
                this.pResult.repaint();
                this.bHelp = false;
            }
        } else {
            this.showResultInText();
        }
        this.txtCommand.selectAll();
        this.txtCommand.requestFocus();
    }

    private void formatResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            Object[] objectArray = new String[]{"Result"};
            this.gResult.setHead(objectArray);
            objectArray[0] = "(empty)";
            this.gResult.addRow(objectArray);
            return;
        }
        try {
            int n;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            Object[] objectArray = new Object[n2];
            boolean[] blArray = new boolean[n2];
            for (n = 1; n <= n2; ++n) {
                objectArray[n - 1] = resultSetMetaData.getColumnLabel(n);
                blArray[n - 1] = resultSetMetaData.getColumnType(n) == 12;
            }
            this.gResult.setHead(objectArray);
            while (resultSet.next()) {
                for (n = 1; n <= n2; ++n) {
                    try {
                        objectArray[n - 1] = resultSet.getObject(n);
                        if (!resultSet.wasNull()) continue;
                        objectArray[n - 1] = blArray[n - 1] ? NULL_STR : null;
                        continue;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.gResult.addRow(objectArray);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            CommonSwing.errorMessage(sQLException);
        }
    }

    private void testPerformance() {
        int n;
        String string2 = this.txtCommand.getText();
        StringBuilder stringBuilder = new StringBuilder();
        long l = 0L;
        this.lTime = 0L;
        for (int i = 0; i < string2.length(); ++i) {
            n = string2.charAt(i);
            if (n == 10) continue;
            stringBuilder.append((char)n);
        }
        string2 = stringBuilder.toString();
        Object[] objectArray = new String[]{"ms", "count", "sql", "error"};
        this.gResult.setHead(objectArray);
        n = 1;
        this.lTime = System.nanoTime() - this.lTime;
        while (!string2.equals("")) {
            String string3;
            int n2 = string2.indexOf(59);
            if (n2 != -1) {
                string3 = string2.substring(0, n2);
                string2 = string2.substring(n2 + 1);
            } else {
                string3 = string2;
                string2 = "";
            }
            if (string3.startsWith("--#")) {
                n = Integer.parseInt(string3.substring(3));
                continue;
            }
            if (string3.startsWith("--")) continue;
            objectArray[2] = string3;
            long l2 = 0L;
            try {
                l2 = DatabaseManagerCommon.testStatement(this.sStatement, string3, n);
                l += l2;
                objectArray[0] = "" + l2;
                objectArray[1] = "" + n;
                objectArray[3] = "";
            }
            catch (SQLException sQLException) {
                objectArray[1] = "n/a";
                objectArray[0] = "n/a";
                objectArray[3] = sQLException.toString();
                CommonSwing.errorMessage(sQLException);
            }
            this.gResult.addRow(objectArray);
            System.out.println(l2 + " ms : " + string3);
        }
        objectArray[0] = "" + l;
        objectArray[1] = "total";
        objectArray[2] = "";
        this.gResult.addRow(objectArray);
        this.lTime = System.nanoTime() - this.lTime;
    }

    private void showResultInText() {
        int n;
        Object[] objectArray;
        int n2;
        Object[] objectArray2 = this.gResult.getHead();
        int n3 = objectArray2.length;
        int[] nArray = new int[n3];
        ArrayList<Object[]> arrayList = this.gResult.getData();
        int n4 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = objectArray2[n2].toString().length();
        }
        for (n2 = 0; n2 < n4; ++n2) {
            objectArray = arrayList.get(n2);
            for (n = 0; n < n3; ++n) {
                String string2 = objectArray[n] == null ? "" : objectArray[n].toString();
                int n5 = string2.length();
                if (n5 <= nArray[n]) continue;
                nArray[n] = n5;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < n3; ++n) {
            stringBuilder.append(objectArray2[n]);
            for (int i = objectArray2[n].toString().length(); i <= nArray[n]; ++i) {
                stringBuilder.append(' ');
            }
        }
        stringBuilder.append(NL);
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < nArray[n]; ++i) {
                stringBuilder.append('-');
            }
            stringBuilder.append(' ');
        }
        stringBuilder.append(NL);
        for (n = 0; n < n4; ++n) {
            objectArray = arrayList.get(n);
            for (int i = 0; i < n3; ++i) {
                String string3 = objectArray[i] == null ? "" : objectArray[i].toString();
                stringBuilder.append(string3);
                for (int j = string3.length(); j <= nArray[i]; ++j) {
                    stringBuilder.append(' ');
                }
            }
            stringBuilder.append(NL);
        }
        this.txtResult.setText(stringBuilder.toString());
    }

    private void addToRecent(String string2) {
        for (int i = 0; i < iMaxRecent; ++i) {
            if (!string2.equals(this.sRecent[i])) continue;
            return;
        }
        if (this.sRecent[this.iRecent] != null) {
            this.mRecent.remove(this.iRecent);
        }
        this.sRecent[this.iRecent] = string2;
        if (string2.length() > 43) {
            string2 = string2.substring(0, 40) + "...";
        }
        JMenuItem jMenuItem = new JMenuItem(string2);
        jMenuItem.setActionCommand("#" + this.iRecent);
        jMenuItem.addActionListener(this);
        this.mRecent.insert(jMenuItem, this.iRecent);
        this.iRecent = (this.iRecent + 1) % iMaxRecent;
    }

    @Override
    public final void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public final void mousePressed(MouseEvent mouseEvent) {
        if (this.alreadyHandled == mouseEvent) {
            return;
        }
        this.handlePopup(mouseEvent);
        this.alreadyHandled = mouseEvent;
    }

    @Override
    public final void mouseReleased(MouseEvent mouseEvent) {
        if (this.alreadyHandled == mouseEvent) {
            return;
        }
        this.handlePopup(mouseEvent);
        this.alreadyHandled = mouseEvent;
    }

    public final void handlePopup(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        Object object = mouseEvent.getSource();
        if (!(object instanceof JTree)) {
            return;
        }
        JTree jTree = (JTree)object;
        TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        String[] stringArray = new String[]{"Select", "Delete", "Update", "Insert"};
        for (int i = 0; i < stringArray.length; ++i) {
            PopupListener popupListener = new PopupListener(stringArray[i], treePath);
            String string2 = popupListener.toString();
            if (string2 == null) {
                return;
            }
            if (string2.length() > 40) {
                string2 = string2.substring(0, 40) + "...";
            }
            JMenuItem jMenuItem = new JMenuItem(string2);
            jMenuItem.addActionListener(popupListener);
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private String quoteTableName(String string2) {
        int n = string2.indexOf(".");
        if (n < 0) {
            int n2 = string2.indexOf(" (");
            if (n2 >= 0) {
                string2 = string2.substring(0, n2);
            }
            return this.quoteObjectName(string2);
        }
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1);
        int n3 = string4.indexOf(" (");
        if (n3 >= 0) {
            string4 = string4.substring(0, n3);
        }
        return this.quoteObjectName(string3) + '.' + this.quoteObjectName(string4);
    }

    private String quoteObjectName(String string2) {
        return "\"" + string2 + "\"";
    }

    private void initGUI() {
        JPanel jPanel = new JPanel();
        this.pResult = new JPanel();
        this.nsSplitPane = new JSplitPane(0, jPanel, this.pResult);
        this.nsSplitPane.setOneTouchExpandable(true);
        jPanel.setLayout(new BorderLayout());
        this.pResult.setLayout(new BorderLayout());
        Font font = new Font("Dialog", 0, 12);
        this.txtCommand = new JTextArea(7, 40);
        this.txtCommand.setMargin(new Insets(5, 5, 5, 5));
        this.txtCommand.addKeyListener(this);
        this.txtCommandScroll = new JScrollPane(this.txtCommand);
        this.txtResult = new JTextArea(25, 40);
        this.txtResult.setMargin(new Insets(5, 5, 5, 5));
        this.txtResultScroll = new JScrollPane(this.txtResult);
        this.txtCommand.setFont(font);
        this.txtResult.setFont(new Font("Courier", 0, 12));
        jPanel.add((Component)this.txtCommandScroll, "Center");
        this.gResult = new GridSwing();
        TableSorter tableSorter = new TableSorter(this.gResult);
        this.tableModel = tableSorter;
        this.gResultTable = new JTable(tableSorter);
        tableSorter.setTableHeader(this.gResultTable.getTableHeader());
        this.gScrollPane = new JScrollPane(this.gResultTable);
        this.gResultTable.setAutoResizeMode(0);
        this.gResult.setJTable(this.gResultTable);
        this.pResult.add((Component)this.gScrollPane, "Center");
        this.rootNode = new DefaultMutableTreeNode("Connection");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tTree = new JTree(this.treeModel);
        this.tScrollPane = new JScrollPane(this.tTree);
        this.tTree.addMouseListener(this);
        this.tScrollPane.setPreferredSize(new Dimension(200, 400));
        this.tScrollPane.setMinimumSize(new Dimension(70, 100));
        this.txtCommandScroll.setPreferredSize(new Dimension(560, 100));
        this.txtCommandScroll.setMinimumSize(new Dimension(180, 100));
        this.gScrollPane.setPreferredSize(new Dimension(460, 300));
        this.ewSplitPane = new JSplitPane(1, this.tScrollPane, this.nsSplitPane);
        this.ewSplitPane.setOneTouchExpandable(true);
        this.fMain.getContentPane().add((Component)this.ewSplitPane, "Center");
        this.jStatusLine = new JLabel();
        iReadyStatus = new JButton(new ImageIcon(CommonSwing.getIcon("StatusReady")));
        iReadyStatus.setSelectedIcon(new ImageIcon(CommonSwing.getIcon("StatusRunning")));
        this.pStatus = new JPanel();
        this.pStatus.setLayout(new BorderLayout());
        this.pStatus.add((Component)iReadyStatus, "West");
        this.pStatus.add((Component)this.jStatusLine, "Center");
        this.fMain.getContentPane().add((Component)this.pStatus, "South");
        this.doLayout();
        if (this.fMain instanceof Window) {
            ((Window)((Object)this.fMain)).pack();
        } else {
            ((Container)((Object)this.fMain)).validate();
        }
    }

    private DefaultMutableTreeNode makeNode(Object object, MutableTreeNode mutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(object);
        if (mutableTreeNode != null) {
            this.treeModel.insertNodeInto(defaultMutableTreeNode, mutableTreeNode, mutableTreeNode.getChildCount());
        }
        return defaultMutableTreeNode;
    }

    protected void refreshTree() {
        this.backgroundIt(this.treeRefreshRunnable, "Refreshing object tree");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void directRefreshTree() {
        Object object;
        DecimalFormat decimalFormat = new DecimalFormat(" ( ####,###,####,##0 )");
        while (this.treeModel.getChildCount(this.rootNode) > 0) {
            object = (DefaultMutableTreeNode)this.treeModel.getChild(this.rootNode, 0);
            this.treeModel.removeNodeFromParent((MutableTreeNode)object);
            ((DefaultMutableTreeNode)object).removeAllChildren();
            ((DefaultMutableTreeNode)object).removeFromParent();
        }
        this.treeModel.nodeStructureChanged(this.rootNode);
        this.treeModel.reload();
        this.tScrollPane.repaint();
        object = null;
        try {
            String string2;
            this.rootNode.setUserObject(this.dMeta.getURL());
            object = this.dMeta.getTables(null, null, null, this.showSys ? usertables : nonSystables);
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            while (object.next()) {
                string2 = object.getString(2);
                if (!this.showSys && this.isOracle && oracleSysUsers.contains(string2) || this.schemaFilter != null && !string2.equals(this.schemaFilter)) continue;
                arrayList2.add(string2);
                arrayList.add(object.getString(3));
                arrayList3.add(object.getString(5));
            }
            object.close();
            object = null;
            int[] nArray = new int[arrayList.size()];
            try {
                nArray = this.getRowCounts(arrayList, arrayList2);
            }
            catch (Exception exception) {
                CommonSwing.errorMessage(exception);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object2;
                Object object3;
                DefaultMutableTreeNode defaultMutableTreeNode;
                Object object4;
                Object object5;
                Object object6;
                String string3;
                ResultSet resultSet = null;
                try {
                    string3 = (String)arrayList.get(i);
                    if (this.isOracle && string3.startsWith("BIN$")) continue;
                    string2 = (String)arrayList2.get(i);
                    object6 = "";
                    if (string2 != null && this.showSchemas) {
                        object6 = string2 + '.';
                    }
                    object5 = this.displayRowCounts ? decimalFormat.format(nArray[i]) : "";
                    object4 = (String)object6 + string3 + (String)object5;
                    defaultMutableTreeNode = this.makeNode(object4, this.rootNode);
                    resultSet = this.dMeta.getColumns(null, string2, string3, null);
                    if (string2 != null && !string2.trim().equals("")) {
                        this.makeNode(string2, defaultMutableTreeNode);
                    }
                    if ((object3 = (String)arrayList3.get(i)) != null && !((String)object3).trim().equals("")) {
                        this.makeNode(object3, defaultMutableTreeNode);
                    }
                    while (resultSet.next()) {
                        String string4 = resultSet.getString(4);
                        object2 = this.makeNode(string4, defaultMutableTreeNode);
                        String string5 = resultSet.getString(6);
                        this.makeNode("Type: " + string5, (MutableTreeNode)object2);
                        boolean bl = resultSet.getInt(11) != 0;
                        this.makeNode("Nullable: " + bl, (MutableTreeNode)object2);
                    }
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                object6 = this.makeNode("Indices", defaultMutableTreeNode);
                if (!this.showIndexDetails) continue;
                object5 = null;
                try {
                    object5 = this.dMeta.getIndexInfo(null, string2, string3, false, false);
                    object4 = null;
                    object3 = null;
                    while (object5.next()) {
                        boolean bl = object5.getBoolean(4);
                        object2 = object5.getString(6);
                        if (object4 == null || !((String)object4).equals(object2)) {
                            object3 = this.makeNode(object2, (MutableTreeNode)object6);
                            this.makeNode("Unique: " + !bl, (MutableTreeNode)object3);
                            object4 = object2;
                        }
                        this.makeNode(object5.getString(9), (MutableTreeNode)object3);
                    }
                    continue;
                }
                catch (SQLException sQLException) {
                    if (sQLException.getMessage() != null && (sQLException.getMessage().startsWith("ORA-25191:") || sQLException.getMessage().startsWith("ORA-01702:") || sQLException.getMessage().startsWith("ORA-01031:"))) continue;
                    throw sQLException;
                }
                finally {
                    if (object5 != null) {
                        object5.close();
                        object5 = null;
                    }
                }
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.makeNode("Properties", this.rootNode);
            this.makeNode("User: " + this.dMeta.getUserName(), defaultMutableTreeNode);
            this.makeNode("ReadOnly: " + this.cConn.isReadOnly(), defaultMutableTreeNode);
            this.makeNode("AutoCommit: " + this.cConn.getAutoCommit(), defaultMutableTreeNode);
            this.makeNode("Driver: " + this.dMeta.getDriverName(), defaultMutableTreeNode);
            this.makeNode("Product: " + this.dMeta.getDatabaseProductName(), defaultMutableTreeNode);
            this.makeNode("Version: " + this.dMeta.getDatabaseProductVersion(), defaultMutableTreeNode);
        }
        catch (SQLException sQLException) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.makeNode("Error getting metadata:", this.rootNode);
            this.makeNode(sQLException.getMessage(), defaultMutableTreeNode);
            this.makeNode(sQLException.getSQLState(), defaultMutableTreeNode);
            CommonSwing.errorMessage(sQLException);
        }
        finally {
            if (object != null) {
                try {
                    object.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        this.treeModel.nodeStructureChanged(this.rootNode);
        this.treeModel.reload();
        this.tScrollPane.repaint();
        this.updateSchemaList();
    }

    void setStatusLine(String string2, int n) {
        iReadyStatus.setSelected(string2 != null);
        if (string2 == null) {
            String string3 = "";
            if (this.schemaFilter != null) {
                string3 = " /  Tree showing objects in schema '" + this.schemaFilter + "'";
            }
            if (n >= 1) {
                long l = this.lTime / 1000000L;
                long l2 = this.lTime % 1000000L / 100000L;
                string3 = string3 + " / " + n + " rows retrieved in " + l + '.' + l2 + " ms";
            }
            this.jStatusLine.setText("  " + READY_STATUS + string3);
        } else {
            this.jStatusLine.setText("  " + string2 + "...");
        }
    }

    protected int[] getRowCounts(ArrayList arrayList, ArrayList arrayList2) throws Exception {
        if (!this.displayRowCounts) {
            return null;
        }
        String string2 = "SELECT COUNT(*) FROM ";
        int[] nArray = new int[arrayList.size()];
        try {
            Statement statement = this.rowConn.createStatement();
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    String string3 = (String)arrayList2.get(i);
                    string3 = string3 == null ? "" : "\"" + string3 + "\".\"";
                    String string4 = string3 + arrayList.get(i) + "\"";
                    ResultSet resultSet = statement.executeQuery(string2 + string4);
                    while (resultSet.next()) {
                        nArray[i] = resultSet.getInt(1);
                    }
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("Unable to get row count for table " + arrayList2.get(i) + '.' + arrayList.get(i) + ".  Using value '0': " + exception);
                }
            }
        }
        catch (Exception exception) {
            CommonSwing.errorMessage(exception);
        }
        return nArray;
    }

    protected JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.jbuttonClear = new JButton("Clear SQL", new ImageIcon(CommonSwing.getIcon("Clear")));
        this.jbuttonClear.putClientProperty("is3DEnabled", Boolean.TRUE);
        this.tipMap.put(this.jbuttonClear, "Clear SQL");
        this.jbuttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DatabaseManagerSwing.this.sqlScriptBuffer == null && DatabaseManagerSwing.this.txtCommand.getText().length() < 1) {
                    CommonSwing.errorMessage("No SQL to clear");
                    return;
                }
                DatabaseManagerSwing.this.clear();
            }
        });
        this.jbuttonExecute = new JButton("Execute SQL", new ImageIcon(CommonSwing.getIcon("Execute")));
        this.tipMap.put(this.jbuttonExecute, "Execute SQL");
        this.jbuttonExecute.putClientProperty("is3DEnabled", Boolean.TRUE);
        this.jbuttonExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseManagerSwing.this.executeCurrentSQL();
            }
        });
        jToolBar.addSeparator();
        jToolBar.add(this.jbuttonClear);
        jToolBar.addSeparator();
        jToolBar.add(this.jbuttonExecute);
        jToolBar.addSeparator();
        this.jbuttonClear.setAlignmentY(0.5f);
        this.jbuttonClear.setAlignmentX(0.5f);
        this.jbuttonExecute.setAlignmentY(0.5f);
        this.jbuttonExecute.setAlignmentX(0.5f);
        return jToolBar;
    }

    void updateAutoCommitBox() {
        try {
            if (this.cConn != null) {
                this.boxAutoCommit.setSelected(this.cConn.getAutoCommit());
            }
        }
        catch (SQLException sQLException) {
            CommonSwing.errorMessage(sQLException);
        }
    }

    private void setLF(String string2) {
        if (this.currentLAF != null && this.currentLAF == string2) {
            return;
        }
        if (this.pResult != null && this.gridFormat) {
            this.pResult.removeAll();
        }
        CommonSwing.setSwingLAF((Component)((Object)this.fMain), string2);
        if (this.pResult != null && this.gridFormat) {
            this.setResultsInGrid();
        }
        this.currentLAF = string2;
        if (this.currentLAF.equals(CommonSwing.Native)) {
            this.rbNativeLF.setSelected(true);
        } else if (this.currentLAF.equals(CommonSwing.Java)) {
            this.rbJavaLF.setSelected(true);
        } else if (this.currentLAF.equals(CommonSwing.Motif)) {
            this.rbMotifLF.setSelected(true);
        }
    }

    void resetTooltips() {
        for (JComponent jComponent : this.tipMap.keySet()) {
            jComponent.setToolTipText(this.showTooltips ? this.tipMap.get(jComponent) : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSchemaList() {
        ButtonGroup buttonGroup = new ButtonGroup();
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSet resultSet = null;
        try {
            resultSet = this.dMeta.getSchemas();
            if (resultSet == null) {
                throw new SQLException("Failed to get metadata from database");
            }
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
        }
        catch (SQLException sQLException) {
            CommonSwing.errorMessage(sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        this.mnuSchemas.removeAll();
        this.rbAllSchemas.setSelected(this.schemaFilter == null);
        buttonGroup.add(this.rbAllSchemas);
        this.mnuSchemas.add(this.rbAllSchemas);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string2);
            buttonGroup.add(jRadioButtonMenuItem);
            this.mnuSchemas.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.setSelected(this.schemaFilter != null && this.schemaFilter.equals(string2));
            jRadioButtonMenuItem.addActionListener(this.schemaListListener);
            jRadioButtonMenuItem.setEnabled(arrayList.size() > 1);
        }
        this.mnuSchemas.addSeparator();
        this.mnuSchemas.add(this.mitemUpdateSchemas);
    }

    private static void setLogToSystem(boolean bl) {
        try {
            PrintWriter printWriter = bl ? new PrintWriter(System.out) : null;
            DriverManager.setLogWriter(printWriter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        homedir = System.getProperty("user.home");
        DEFAULT_RCFILE = homedir + "/dbmanager.rc";
        TT_AVAILABLE = false;
        try {
            Class.forName(DatabaseManagerSwing.class.getPackage().getName() + ".Transfer");
            TT_AVAILABLE = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        HELP_TEXT = "See the HSQLDB Utilities Guide, forums and mailing lists \nat http://hsqldb.org.\n\nPlease paste the following version identifier with any\nproblem reports or help requests:  $Revision: 5987 $" + (TT_AVAILABLE ? "" : "\n\nTransferTool classes are not in CLASSPATH.\nTo enable the Tools menu, add 'transfer.jar' to your class path.");
        ABOUT_TEXT = "$Revision: 5987 $ of DatabaseManagerSwing\n\nCopyright (c) 2001-2019, The HSQL Development Group.\nhttp://hsqldb.org  (Utilities Guide available at this site).\n\n\nYou may use and redistribute according to the HSQLDB\nlicense documented in the source code and at the web\nsite above." + (TT_AVAILABLE ? "\n\nTransferTool options are available." : "");
        NL = System.getProperty("line.separator");
        iMaxRecent = 24;
        READY_STATUS = "Ready";
        defDriver = "org.hsqldb.jdbcDriver";
        defURL = "jdbc:hsqldb:mem:.";
        defUser = "SA";
        defPassword = "";
        usertables = new String[]{"TABLE", "GLOBAL TEMPORARY", "VIEW", "SYSTEM TABLE"};
        nonSystables = new String[]{"TABLE", "GLOBAL TEMPORARY", "VIEW"};
        oracleSysUsers = new HashSet();
        oracleSysSchemas = new String[]{"SYS", "SYSTEM", "OUTLN", "DBSNMP", "OUTLN", "MDSYS", "ORDSYS", "ORDPLUGINS", "CTXSYS", "DSSYS", "PERFSTAT", "WKPROXY", "WKSYS", "WMSYS", "XDB", "ANONYMOUS", "ODM", "ODM_MTR", "OLAPSYS", "TRACESVR", "REPADMIN"};
        for (int i = 0; i < oracleSysSchemas.length; ++i) {
            oracleSysUsers.add(oracleSysSchemas[i]);
        }
        tString = Boolean.TRUE.toString();
        fString = Boolean.FALSE.toString();
    }

    public class DBMPrefs {
        public File prefsFile = null;
        boolean autoRefresh = true;
        boolean showRowCounts = false;
        boolean showSysTables = false;
        boolean showSchemas = true;
        boolean resultGrid = true;
        String laf = CommonSwing.Native;
        boolean showTooltips = true;

        public DBMPrefs(boolean bl) throws IOException {
            if (!bl) {
                if (homedir == null) {
                    throw new IOException("Skipping preferences since do not know home dir");
                }
                this.prefsFile = new File(homedir, "dbmprefs.properties");
            }
            this.load();
        }

        public void load() throws IOException {
            if (this.prefsFile != null) {
                if (!this.prefsFile.exists()) {
                    throw new IOException("No such file: " + this.prefsFile);
                }
                Properties properties2 = new Properties();
                try {
                    FileInputStream fileInputStream = new FileInputStream(this.prefsFile);
                    properties2.load(fileInputStream);
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    throw new IOException("Failed to read preferences file '" + this.prefsFile + "':  " + iOException.getMessage());
                }
                String string2 = properties2.getProperty("autoRefresh");
                if (string2 != null) {
                    this.autoRefresh = Boolean.valueOf(string2);
                }
                if ((string2 = properties2.getProperty("showRowCounts")) != null) {
                    this.showRowCounts = Boolean.valueOf(string2);
                }
                if ((string2 = properties2.getProperty("showSysTables")) != null) {
                    this.showSysTables = Boolean.valueOf(string2);
                }
                if ((string2 = properties2.getProperty("showSchemas")) != null) {
                    this.showSchemas = Boolean.valueOf(string2);
                }
                if ((string2 = properties2.getProperty("resultGrid")) != null) {
                    this.resultGrid = Boolean.valueOf(string2);
                }
                this.laf = (string2 = properties2.getProperty("laf")) == null ? CommonSwing.Native : string2;
                string2 = properties2.getProperty("showTooltips");
                if (string2 != null) {
                    this.showTooltips = Boolean.valueOf(string2);
                }
            }
        }

        public void store() {
            if (this.prefsFile == null) {
                return;
            }
            Properties properties2 = new Properties();
            properties2.setProperty("autoRefresh", this.autoRefresh ? tString : fString);
            properties2.setProperty("showRowCounts", this.showRowCounts ? tString : fString);
            properties2.setProperty("showSysTables", this.showSysTables ? tString : fString);
            properties2.setProperty("showSchemas", this.showSchemas ? tString : fString);
            properties2.setProperty("resultGrid", this.resultGrid ? tString : fString);
            properties2.setProperty("laf", this.laf);
            properties2.setProperty("showTooltips", this.showTooltips ? tString : fString);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.prefsFile);
                properties2.store(fileOutputStream, "DatabaseManagerSwing user preferences");
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to prepare preferences file '" + this.prefsFile + "':  " + iOException.getMessage());
            }
        }
    }

    private class PopupListener
    implements ActionListener {
        public static final int DEPTH_URL = 1;
        public static final int DEPTH_TABLE = 2;
        public static final int DEPTH_COLUMN = 3;
        String command;
        TreePath treePath;
        TreePath tablePath;
        TreePath columnPath;
        String table = null;
        String column = null;

        PopupListener(String string2, TreePath treePath) {
            this.command = string2;
            this.treePath = treePath;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DatabaseManagerSwing.this.txtCommand.setText(this.getCommandString());
        }

        public String toString() {
            return this.getCommandString();
        }

        public String getCommandString() {
            int n = this.treePath.getPathCount();
            if (n == 1) {
                return "";
            }
            if (n == 2) {
                this.tablePath = this.treePath;
                this.table = this.treePath.getPathComponent(1).toString();
            }
            if (n == 3) {
                this.tablePath = this.treePath.getParentPath();
                this.table = this.treePath.getPathComponent(1).toString();
                this.columnPath = this.treePath;
                this.column = this.treePath.getPathComponent(2).toString();
            }
            if (this.command.toUpperCase().equals("SELECT")) {
                String string2 = "SELECT * FROM " + DatabaseManagerSwing.this.quoteTableName(this.table);
                if (this.column != null) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treePath.getLastPathComponent();
                    String string3 = null;
                    if (defaultMutableTreeNode.getChildCount() > 0) {
                        string3 = defaultMutableTreeNode.getFirstChild().toString();
                        boolean bl = string3.indexOf("CHAR") >= 0;
                        string2 = string2 + " WHERE " + DatabaseManagerSwing.this.quoteObjectName(this.column);
                        string2 = bl ? string2 + " LIKE '%%'" : string2 + " = ";
                    }
                }
                return string2;
            }
            if (this.command.toUpperCase().equals("UPDATE")) {
                String string4 = "UPDATE " + DatabaseManagerSwing.this.quoteTableName(this.table) + " SET ";
                if (this.column != null) {
                    string4 = string4 + DatabaseManagerSwing.this.quoteObjectName(this.column) + " = ";
                }
                return string4;
            }
            if (this.command.toUpperCase().equals("DELETE")) {
                String string5 = "DELETE FROM " + DatabaseManagerSwing.this.quoteTableName(this.table);
                if (this.column != null) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.treePath.getLastPathComponent();
                    String string6 = null;
                    if (defaultMutableTreeNode.getChildCount() > 0) {
                        string6 = defaultMutableTreeNode.getFirstChild().toString();
                        boolean bl = string6.indexOf("CHAR") >= 0;
                        string5 = string5 + " WHERE " + DatabaseManagerSwing.this.quoteObjectName(this.column);
                        string5 = bl ? string5 + " LIKE '%%'" : string5 + " = ";
                    }
                }
                return string5;
            }
            if (this.command.toUpperCase().equals("INSERT")) {
                String string7 = "";
                String string8 = " ";
                String string9 = "";
                String string10 = "";
                if (this.tablePath == null) {
                    return null;
                }
                TreeNode treeNode = (TreeNode)this.tablePath.getLastPathComponent();
                Enumeration<? extends TreeNode> enumeration = treeNode.children();
                while (enumeration.hasMoreElements()) {
                    TreeNode treeNode2 = enumeration.nextElement();
                    if (treeNode2.toString().equals("Indices")) continue;
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode2;
                    String string11 = null;
                    if (defaultMutableTreeNode.getChildCount() == 0) continue;
                    string11 = defaultMutableTreeNode.getFirstChild().toString();
                    string10 = string11.indexOf("CHAR") >= 0 ? "''" : "";
                    string7 = string7 + string9 + DatabaseManagerSwing.this.quoteObjectName(treeNode2.toString());
                    string8 = string8 + string9 + string10;
                    string9 = ", ";
                }
                return "INSERT INTO " + DatabaseManagerSwing.this.quoteTableName(this.table) + "\n( " + string7 + " )\nVALUES (" + string8 + ")";
            }
            return "Got here in error " + this.command + ".  Should never happen";
        }
    }

    protected class StatementExecRunnable
    implements Runnable {
        protected StatementExecRunnable() {
        }

        @Override
        public void run() {
            DatabaseManagerSwing.this.gResult.clear();
            try {
                if (DatabaseManagerSwing.this.txtCommand.getText().startsWith("-->>>TEST<<<--")) {
                    DatabaseManagerSwing.this.testPerformance();
                } else {
                    DatabaseManagerSwing.this.executeSQL();
                }
                DatabaseManagerSwing.this.updateResult();
                DatabaseManagerSwing.this.displayResults();
                DatabaseManagerSwing.this.updateAutoCommitBox();
            }
            catch (RuntimeException runtimeException) {
                CommonSwing.errorMessage(runtimeException);
                throw runtimeException;
            }
            finally {
                DatabaseManagerSwing.this.setWaiting(null);
            }
        }
    }
}

