/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import org.springframework.core.env.Profiles;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class ProfilesParser {
    private ProfilesParser() {
    }

    static Profiles parse(String ... expressions) {
        Assert.notEmpty((Object[])expressions, "Must specify at least one profile");
        Profiles[] parsed = new Profiles[expressions.length];
        for (int i = 0; i < expressions.length; ++i) {
            parsed[i] = ProfilesParser.parseExpression(expressions[i]);
        }
        return new ParsedProfiles(expressions, parsed);
    }

    private static Profiles parseExpression(String expression2) {
        Assert.hasText(expression2, () -> "Invalid profile expression [" + expression2 + "]: must contain text");
        StringTokenizer tokens = new StringTokenizer(expression2, "()&|!", true);
        return ProfilesParser.parseTokens(expression2, tokens);
    }

    private static Profiles parseTokens(String expression2, StringTokenizer tokens) {
        return ProfilesParser.parseTokens(expression2, tokens, Context.NONE);
    }

    private static Profiles parseTokens(String expression2, StringTokenizer tokens, Context context) {
        ArrayList<Profiles> elements = new ArrayList<Profiles>();
        Operator operator = null;
        block14: while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.isEmpty()) continue;
            switch (token) {
                case "(": {
                    Profiles contents = ProfilesParser.parseTokens(expression2, tokens, Context.BRACKET);
                    if (context == Context.INVERT) {
                        return contents;
                    }
                    elements.add(contents);
                    continue block14;
                }
                case "&": {
                    ProfilesParser.assertWellFormed(expression2, operator == null || operator == Operator.AND);
                    operator = Operator.AND;
                    continue block14;
                }
                case "|": {
                    ProfilesParser.assertWellFormed(expression2, operator == null || operator == Operator.OR);
                    operator = Operator.OR;
                    continue block14;
                }
                case "!": {
                    elements.add(ProfilesParser.not(ProfilesParser.parseTokens(expression2, tokens, Context.INVERT)));
                    continue block14;
                }
                case ")": {
                    Profiles merged = ProfilesParser.merge(expression2, elements, operator);
                    if (context == Context.BRACKET) {
                        return merged;
                    }
                    elements.clear();
                    elements.add(merged);
                    operator = null;
                    continue block14;
                }
            }
            Profiles value2 = ProfilesParser.equals(token);
            if (context == Context.INVERT) {
                return value2;
            }
            elements.add(value2);
        }
        return ProfilesParser.merge(expression2, elements, operator);
    }

    private static Profiles merge(String expression2, List<Profiles> elements, @Nullable Operator operator) {
        ProfilesParser.assertWellFormed(expression2, !elements.isEmpty());
        if (elements.size() == 1) {
            return elements.get(0);
        }
        Profiles[] profiles = elements.toArray(new Profiles[0]);
        return operator == Operator.AND ? ProfilesParser.and(profiles) : ProfilesParser.or(profiles);
    }

    private static void assertWellFormed(String expression2, boolean wellFormed) {
        Assert.isTrue(wellFormed, () -> "Malformed profile expression [" + expression2 + "]");
    }

    private static Profiles or(Profiles ... profiles) {
        return activeProfile -> Arrays.stream(profiles).anyMatch(ProfilesParser.isMatch(activeProfile));
    }

    private static Profiles and(Profiles ... profiles) {
        return activeProfile -> Arrays.stream(profiles).allMatch(ProfilesParser.isMatch(activeProfile));
    }

    private static Profiles not(Profiles profiles) {
        return activeProfile -> !profiles.matches(activeProfile);
    }

    private static Profiles equals(String profile) {
        return activeProfile -> activeProfile.test(profile);
    }

    private static Predicate<Profiles> isMatch(Predicate<String> activeProfile) {
        return profiles -> profiles.matches(activeProfile);
    }

    private static class ParsedProfiles
    implements Profiles {
        private final String[] expressions;
        private final Profiles[] parsed;

        ParsedProfiles(String[] expressions, Profiles[] parsed) {
            this.expressions = expressions;
            this.parsed = parsed;
        }

        @Override
        public boolean matches(Predicate<String> activeProfiles) {
            for (Profiles candidate : this.parsed) {
                if (!candidate.matches(activeProfiles)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return StringUtils.arrayToDelimitedString(this.expressions, " or ");
        }
    }

    private static enum Context {
        NONE,
        INVERT,
        BRACKET;

    }

    private static enum Operator {
        AND,
        OR;

    }
}

