/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class ObjectUtils {
    private static final int INITIAL_HASH = 7;
    private static final int MULTIPLIER = 31;
    private static final String EMPTY_STRING = "";
    private static final String NULL_STRING = "null";
    private static final String ARRAY_START = "{";
    private static final String ARRAY_END = "}";
    private static final String EMPTY_ARRAY = "{}";
    private static final String ARRAY_ELEMENT_SEPARATOR = ", ";

    public static boolean isCheckedException(Throwable ex) {
        return !(ex instanceof RuntimeException) && !(ex instanceof Error);
    }

    public static boolean isCompatibleWithThrowsClause(Throwable ex, Class<?> ... declaredExceptions) {
        if (!ObjectUtils.isCheckedException(ex)) {
            return true;
        }
        if (declaredExceptions != null) {
            for (Class<?> declaredException : declaredExceptions) {
                if (!declaredException.isInstance(ex)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isArray(@Nullable Object obj2) {
        return obj2 != null && obj2.getClass().isArray();
    }

    public static boolean isEmpty(@Nullable Object[] array2) {
        return array2 == null || array2.length == 0;
    }

    public static boolean isEmpty(@Nullable Object obj2) {
        if (obj2 == null) {
            return true;
        }
        if (obj2 instanceof Optional) {
            return !((Optional)obj2).isPresent();
        }
        if (obj2 instanceof CharSequence) {
            return ((CharSequence)obj2).length() == 0;
        }
        if (obj2.getClass().isArray()) {
            return Array.getLength(obj2) == 0;
        }
        if (obj2 instanceof Collection) {
            return ((Collection)obj2).isEmpty();
        }
        if (obj2 instanceof Map) {
            return ((Map)obj2).isEmpty();
        }
        return false;
    }

    @Nullable
    public static Object unwrapOptional(@Nullable Object obj2) {
        if (obj2 instanceof Optional) {
            Optional optional2 = (Optional)obj2;
            if (!optional2.isPresent()) {
                return null;
            }
            Object result2 = optional2.get();
            Assert.isTrue(!(result2 instanceof Optional), "Multi-level Optional usage not supported");
            return result2;
        }
        return obj2;
    }

    public static boolean containsElement(@Nullable Object[] array2, Object element) {
        if (array2 == null) {
            return false;
        }
        for (Object arrayEle : array2) {
            if (!ObjectUtils.nullSafeEquals(arrayEle, element)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsConstant(Enum<?>[] enumValues, String constant) {
        return ObjectUtils.containsConstant(enumValues, constant, false);
    }

    public static boolean containsConstant(Enum<?>[] enumValues, String constant, boolean caseSensitive) {
        for (Enum<?> candidate : enumValues) {
            if (!(caseSensitive ? candidate.toString().equals(constant) : candidate.toString().equalsIgnoreCase(constant))) continue;
            return true;
        }
        return false;
    }

    public static <E extends Enum<?>> E caseInsensitiveValueOf(E[] enumValues, String constant) {
        for (E candidate : enumValues) {
            if (!((Enum)candidate).toString().equalsIgnoreCase(constant)) continue;
            return candidate;
        }
        throw new IllegalArgumentException("Constant [" + constant + "] does not exist in enum type " + enumValues.getClass().getComponentType().getName());
    }

    public static <A, O extends A> A[] addObjectToArray(@Nullable A[] array2, @Nullable O obj2) {
        Class compType = Object.class;
        if (array2 != null) {
            compType = array2.getClass().getComponentType();
        } else if (obj2 != null) {
            compType = obj2.getClass();
        }
        int newArrLength = array2 != null ? array2.length + 1 : 1;
        Object[] newArr = (Object[])Array.newInstance(compType, newArrLength);
        if (array2 != null) {
            System.arraycopy(array2, 0, newArr, 0, array2.length);
        }
        newArr[newArr.length - 1] = obj2;
        return newArr;
    }

    public static Object[] toObjectArray(@Nullable Object source2) {
        if (source2 instanceof Object[]) {
            return (Object[])source2;
        }
        if (source2 == null) {
            return new Object[0];
        }
        if (!source2.getClass().isArray()) {
            throw new IllegalArgumentException("Source is not an array: " + source2);
        }
        int length = Array.getLength(source2);
        if (length == 0) {
            return new Object[0];
        }
        Class<?> wrapperType = Array.get(source2, 0).getClass();
        Object[] newArray = (Object[])Array.newInstance(wrapperType, length);
        for (int i = 0; i < length; ++i) {
            newArray[i] = Array.get(source2, i);
        }
        return newArray;
    }

    public static boolean nullSafeEquals(@Nullable Object o1, @Nullable Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            return ObjectUtils.arrayEquals(o1, o2);
        }
        return false;
    }

    private static boolean arrayEquals(Object o1, Object o2) {
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
        if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
            return Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof char[] && o2 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        if (o1 instanceof double[] && o2 instanceof double[]) {
            return Arrays.equals((double[])o1, (double[])o2);
        }
        if (o1 instanceof float[] && o2 instanceof float[]) {
            return Arrays.equals((float[])o1, (float[])o2);
        }
        if (o1 instanceof int[] && o2 instanceof int[]) {
            return Arrays.equals((int[])o1, (int[])o2);
        }
        if (o1 instanceof long[] && o2 instanceof long[]) {
            return Arrays.equals((long[])o1, (long[])o2);
        }
        if (o1 instanceof short[] && o2 instanceof short[]) {
            return Arrays.equals((short[])o1, (short[])o2);
        }
        return false;
    }

    public static int nullSafeHashCode(@Nullable Object obj2) {
        if (obj2 == null) {
            return 0;
        }
        if (obj2.getClass().isArray()) {
            if (obj2 instanceof Object[]) {
                return ObjectUtils.nullSafeHashCode((Object[])obj2);
            }
            if (obj2 instanceof boolean[]) {
                return ObjectUtils.nullSafeHashCode((boolean[])obj2);
            }
            if (obj2 instanceof byte[]) {
                return ObjectUtils.nullSafeHashCode((byte[])obj2);
            }
            if (obj2 instanceof char[]) {
                return ObjectUtils.nullSafeHashCode((char[])obj2);
            }
            if (obj2 instanceof double[]) {
                return ObjectUtils.nullSafeHashCode((double[])obj2);
            }
            if (obj2 instanceof float[]) {
                return ObjectUtils.nullSafeHashCode((float[])obj2);
            }
            if (obj2 instanceof int[]) {
                return ObjectUtils.nullSafeHashCode((int[])obj2);
            }
            if (obj2 instanceof long[]) {
                return ObjectUtils.nullSafeHashCode((long[])obj2);
            }
            if (obj2 instanceof short[]) {
                return ObjectUtils.nullSafeHashCode((short[])obj2);
            }
        }
        return obj2.hashCode();
    }

    public static int nullSafeHashCode(@Nullable Object[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hash2 = 7;
        for (Object element : array2) {
            hash2 = 31 * hash2 + ObjectUtils.nullSafeHashCode(element);
        }
        return hash2;
    }

    public static int nullSafeHashCode(@Nullable boolean[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hash2 = 7;
        for (boolean element : array2) {
            hash2 = 31 * hash2 + Boolean.hashCode(element);
        }
        return hash2;
    }

    public static int nullSafeHashCode(@Nullable byte[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hash2 = 7;
        for (byte element : array2) {
            hash2 = 31 * hash2 + element;
        }
        return hash2;
    }

    public static int nullSafeHashCode(@Nullable char[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hash2 = 7;
        for (char element : array2) {
            hash2 = 31 * hash2 + element;
        }
        return hash2;
    }

    public static int nullSafeHashCode(@Nullable double[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hash2 = 7;
        for (double element : array2) {
            hash2 = 31 * hash2 + Double.hashCode(element);
        }
        return hash2;
    }

    public static int nullSafeHashCode(@Nullable float[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hash2 = 7;
        for (float element : array2) {
            hash2 = 31 * hash2 + Float.hashCode(element);
        }
        return hash2;
    }

    public static int nullSafeHashCode(@Nullable int[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hash2 = 7;
        for (int element : array2) {
            hash2 = 31 * hash2 + element;
        }
        return hash2;
    }

    public static int nullSafeHashCode(@Nullable long[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hash2 = 7;
        for (long element : array2) {
            hash2 = 31 * hash2 + Long.hashCode(element);
        }
        return hash2;
    }

    public static int nullSafeHashCode(@Nullable short[] array2) {
        if (array2 == null) {
            return 0;
        }
        int hash2 = 7;
        for (short element : array2) {
            hash2 = 31 * hash2 + element;
        }
        return hash2;
    }

    @Deprecated
    public static int hashCode(boolean bool2) {
        return Boolean.hashCode(bool2);
    }

    @Deprecated
    public static int hashCode(double dbl) {
        return Double.hashCode(dbl);
    }

    @Deprecated
    public static int hashCode(float flt) {
        return Float.hashCode(flt);
    }

    @Deprecated
    public static int hashCode(long lng) {
        return Long.hashCode(lng);
    }

    public static String identityToString(@Nullable Object obj2) {
        if (obj2 == null) {
            return EMPTY_STRING;
        }
        return obj2.getClass().getName() + "@" + ObjectUtils.getIdentityHexString(obj2);
    }

    public static String getIdentityHexString(Object obj2) {
        return Integer.toHexString(System.identityHashCode(obj2));
    }

    public static String getDisplayString(@Nullable Object obj2) {
        if (obj2 == null) {
            return EMPTY_STRING;
        }
        return ObjectUtils.nullSafeToString(obj2);
    }

    public static String nullSafeClassName(@Nullable Object obj2) {
        return obj2 != null ? obj2.getClass().getName() : NULL_STRING;
    }

    public static String nullSafeToString(@Nullable Object obj2) {
        if (obj2 == null) {
            return NULL_STRING;
        }
        if (obj2 instanceof String) {
            return (String)obj2;
        }
        if (obj2 instanceof Object[]) {
            return ObjectUtils.nullSafeToString((Object[])obj2);
        }
        if (obj2 instanceof boolean[]) {
            return ObjectUtils.nullSafeToString((boolean[])obj2);
        }
        if (obj2 instanceof byte[]) {
            return ObjectUtils.nullSafeToString((byte[])obj2);
        }
        if (obj2 instanceof char[]) {
            return ObjectUtils.nullSafeToString((char[])obj2);
        }
        if (obj2 instanceof double[]) {
            return ObjectUtils.nullSafeToString((double[])obj2);
        }
        if (obj2 instanceof float[]) {
            return ObjectUtils.nullSafeToString((float[])obj2);
        }
        if (obj2 instanceof int[]) {
            return ObjectUtils.nullSafeToString((int[])obj2);
        }
        if (obj2 instanceof long[]) {
            return ObjectUtils.nullSafeToString((long[])obj2);
        }
        if (obj2 instanceof short[]) {
            return ObjectUtils.nullSafeToString((short[])obj2);
        }
        String str = obj2.toString();
        return str != null ? str : EMPTY_STRING;
    }

    public static String nullSafeToString(@Nullable Object[] array2) {
        if (array2 == null) {
            return NULL_STRING;
        }
        int length = array2.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(String.valueOf(array2[i]));
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(@Nullable boolean[] array2) {
        if (array2 == null) {
            return NULL_STRING;
        }
        int length = array2.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array2[i]);
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(@Nullable byte[] array2) {
        if (array2 == null) {
            return NULL_STRING;
        }
        int length = array2.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array2[i]);
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(@Nullable char[] array2) {
        if (array2 == null) {
            return NULL_STRING;
        }
        int length = array2.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append("'").append(array2[i]).append("'");
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(@Nullable double[] array2) {
        if (array2 == null) {
            return NULL_STRING;
        }
        int length = array2.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array2[i]);
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(@Nullable float[] array2) {
        if (array2 == null) {
            return NULL_STRING;
        }
        int length = array2.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array2[i]);
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(@Nullable int[] array2) {
        if (array2 == null) {
            return NULL_STRING;
        }
        int length = array2.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array2[i]);
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(@Nullable long[] array2) {
        if (array2 == null) {
            return NULL_STRING;
        }
        int length = array2.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array2[i]);
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }

    public static String nullSafeToString(@Nullable short[] array2) {
        if (array2 == null) {
            return NULL_STRING;
        }
        int length = array2.length;
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sb.append(ARRAY_START);
            } else {
                sb.append(ARRAY_ELEMENT_SEPARATOR);
            }
            sb.append(array2[i]);
        }
        sb.append(ARRAY_END);
        return sb.toString();
    }
}

