/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.UUID;
import org.xerial.snappy.BitShuffleNative;
import org.xerial.snappy.OSInfo;
import org.xerial.snappy.SnappyError;
import org.xerial.snappy.SnappyErrorCode;
import org.xerial.snappy.SnappyNative;

public class SnappyLoader {
    public static final String SNAPPY_SYSTEM_PROPERTIES_FILE = "org-xerial-snappy.properties";
    public static final String KEY_SNAPPY_LIB_PATH = "org.xerial.snappy.lib.path";
    public static final String KEY_SNAPPY_LIB_NAME = "org.xerial.snappy.lib.name";
    public static final String KEY_SNAPPY_TEMPDIR = "org.xerial.snappy.tempdir";
    public static final String KEY_SNAPPY_USE_SYSTEMLIB = "org.xerial.snappy.use.systemlib";
    public static final String KEY_SNAPPY_DISABLE_BUNDLED_LIBS = "org.xerial.snappy.disable.bundled.libs";
    private static boolean isLoaded = false;
    private static volatile SnappyNative snappyApi = null;
    private static volatile BitShuffleNative bitshuffleApi = null;
    private static File nativeLibFile = null;

    static void cleanUpExtractedNativeLib() {
        if (nativeLibFile != null && nativeLibFile.exists()) {
            boolean bl = nativeLibFile.delete();
            if (!bl) {
                // empty if block
            }
            snappyApi = null;
            bitshuffleApi = null;
        }
    }

    static synchronized void setSnappyApi(SnappyNative snappyNative) {
        snappyApi = snappyNative;
    }

    private static void loadSnappySystemProperties() {
        try {
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(SNAPPY_SYSTEM_PROPERTIES_FILE);
            if (inputStream == null) {
                return;
            }
            Properties properties2 = new Properties();
            properties2.load(inputStream);
            inputStream.close();
            Enumeration<?> enumeration = properties2.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.startsWith("org.xerial.snappy.") || System.getProperty(string2) != null) continue;
                System.setProperty(string2, properties2.getProperty(string2));
            }
        }
        catch (Throwable throwable) {
            System.err.println("Could not load 'org-xerial-snappy.properties' from classpath: " + throwable.toString());
        }
    }

    static synchronized SnappyNative loadSnappyApi() {
        if (snappyApi != null) {
            return snappyApi;
        }
        SnappyLoader.loadNativeLibrary();
        SnappyLoader.setSnappyApi(new SnappyNative());
        return snappyApi;
    }

    static synchronized BitShuffleNative loadBitShuffleApi() {
        if (bitshuffleApi != null) {
            return bitshuffleApi;
        }
        SnappyLoader.loadNativeLibrary();
        bitshuffleApi = new BitShuffleNative();
        return bitshuffleApi;
    }

    private static synchronized void loadNativeLibrary() {
        if (!isLoaded) {
            try {
                nativeLibFile = SnappyLoader.findNativeLibrary();
                if (nativeLibFile != null) {
                    System.load(nativeLibFile.getAbsolutePath());
                } else {
                    System.loadLibrary("snappyjava");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new SnappyError(SnappyErrorCode.FAILED_TO_LOAD_NATIVE_LIBRARY, exception.getMessage());
            }
            isLoaded = true;
        }
    }

    private static boolean contentsEquals(InputStream inputStream, InputStream inputStream2) throws IOException {
        int n;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!(inputStream2 instanceof BufferedInputStream)) {
            inputStream2 = new BufferedInputStream(inputStream2);
        }
        int n2 = inputStream.read();
        while (n2 != -1) {
            n = inputStream2.read();
            if (n2 != n) {
                return false;
            }
            n2 = inputStream.read();
        }
        n = inputStream2.read();
        return n == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extractLibraryFile(String string2, String string3, String string4) {
        String string5 = string2 + "/" + string3;
        String string6 = UUID.randomUUID().toString();
        String string7 = String.format("snappy-%s-%s-%s", SnappyLoader.getVersion(), string6, string3);
        File file = new File(string4, string7);
        try {
            boolean bl;
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                inputStream = SnappyLoader.class.getResourceAsStream(string5);
                try {
                    fileOutputStream = new FileOutputStream(file);
                    byte[] byArray = new byte[8192];
                    int n = 0;
                    while ((n = inputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                }
                finally {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                file.deleteOnExit();
            }
            boolean bl2 = bl = file.setReadable(true) && file.setWritable(true, true) && file.setExecutable(true);
            if (!bl) {
                // empty if block
            }
            InputStream inputStream2 = null;
            InputStream inputStream3 = null;
            try {
                inputStream2 = SnappyLoader.class.getResourceAsStream(string5);
                inputStream3 = new FileInputStream(file);
                if (!SnappyLoader.contentsEquals(inputStream2, inputStream3)) {
                    throw new SnappyError(SnappyErrorCode.FAILED_TO_LOAD_NATIVE_LIBRARY, String.format("Failed to write a native library file at %s", file));
                }
            }
            finally {
                if (inputStream2 != null) {
                    inputStream2.close();
                }
                if (inputStream3 != null) {
                    inputStream3.close();
                }
            }
            return new File(string4, string7);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            return null;
        }
    }

    static File findNativeLibrary() {
        boolean bl;
        Object object;
        File file;
        boolean bl2 = Boolean.parseBoolean(System.getProperty(KEY_SNAPPY_USE_SYSTEMLIB, "false"));
        boolean bl3 = Boolean.parseBoolean(System.getProperty(KEY_SNAPPY_DISABLE_BUNDLED_LIBS, "false"));
        if (bl2 || bl3) {
            return null;
        }
        String string2 = System.getProperty(KEY_SNAPPY_LIB_PATH);
        Object object2 = System.getProperty(KEY_SNAPPY_LIB_NAME);
        if (object2 == null) {
            object2 = System.mapLibraryName("snappyjava");
        }
        if (string2 != null && (file = new File(string2, (String)object2)).exists()) {
            return file;
        }
        string2 = "/org/xerial/snappy/native/" + OSInfo.getNativeLibFolderPathForCurrentOS();
        boolean bl4 = SnappyLoader.hasResource(string2 + "/" + (String)object2);
        if (!bl4 && OSInfo.getOSName().equals("Mac")) {
            object = "libsnappyjava.jnilib";
            if (SnappyLoader.hasResource(string2 + "/" + (String)object)) {
                object2 = object;
                bl4 = true;
            }
        }
        if (!bl4) {
            object = String.format("no native library is found for os.name=%s and os.arch=%s", OSInfo.getOSName(), OSInfo.getArchName());
            throw new SnappyError(SnappyErrorCode.FAILED_TO_LOAD_NATIVE_LIBRARY, (String)object);
        }
        object = new File(System.getProperty(KEY_SNAPPY_TEMPDIR, System.getProperty("java.io.tmpdir")));
        if (((File)object).exists() || !(bl = ((File)object).mkdirs())) {
            // empty if block
        }
        return SnappyLoader.extractLibraryFile(string2, (String)object2, ((File)object).getAbsolutePath());
    }

    private static boolean hasResource(String string2) {
        return SnappyLoader.class.getResource(string2) != null;
    }

    public static String getVersion() {
        URL uRL = SnappyLoader.class.getResource("/META-INF/maven/org.xerial.snappy/snappy-java/pom.properties");
        if (uRL == null) {
            uRL = SnappyLoader.class.getResource("/org/xerial/snappy/VERSION");
        }
        String string2 = "unknown";
        try {
            if (uRL != null) {
                Properties properties2 = new Properties();
                properties2.load(uRL.openStream());
                string2 = properties2.getProperty("version", string2);
                if (string2.equals("unknown")) {
                    string2 = properties2.getProperty("SNAPPY_VERSION", string2);
                }
                string2 = string2.trim().replaceAll("[^0-9M\\.]", "");
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        return string2;
    }

    static {
        SnappyLoader.loadSnappySystemProperties();
    }
}

