/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream.quantile;

import com.clearspring.analytics.stream.quantile.IQuantileEstimator;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class QDigest
implements IQuantileEstimator {
    private static final Comparator<long[]> RANGES_COMPARATOR = new Comparator<long[]>(){

        @Override
        public int compare(long[] ra, long[] rb) {
            long rightA = ra[1];
            long rightB = rb[1];
            long sizeA = ra[1] - ra[0];
            long sizeB = rb[1] - rb[0];
            if (rightA < rightB) {
                return -1;
            }
            if (rightA > rightB) {
                return 1;
            }
            if (sizeA < sizeB) {
                return -1;
            }
            if (sizeA > sizeB) {
                return 1;
            }
            return 0;
        }
    };
    private static final int MAP_INITIAL_SIZE = 16;
    private static final float MAP_LOAD_FACTOR = 0.25f;
    private long size;
    private long capacity = 1L;
    private double compressionFactor;
    private Long2LongOpenHashMap node2count = new Long2LongOpenHashMap(16, 0.25f);

    public QDigest(double compressionFactor) {
        this.compressionFactor = compressionFactor;
    }

    private long value2leaf(long x) {
        return this.capacity + x;
    }

    private long leaf2value(long id2) {
        return id2 - this.capacity;
    }

    private boolean isRoot(long id2) {
        return id2 == 1L;
    }

    private boolean isLeaf(long id2) {
        return id2 >= this.capacity;
    }

    private long sibling(long id2) {
        return id2 % 2L == 0L ? id2 + 1L : id2 - 1L;
    }

    private long parent(long id2) {
        return id2 / 2L;
    }

    private long leftChild(long id2) {
        return 2L * id2;
    }

    private long rightChild(long id2) {
        return 2L * id2 + 1L;
    }

    private long rangeLeft(long id2) {
        while (!this.isLeaf(id2)) {
            id2 = this.leftChild(id2);
        }
        return this.leaf2value(id2);
    }

    private long rangeRight(long id2) {
        while (!this.isLeaf(id2)) {
            id2 = this.rightChild(id2);
        }
        return this.leaf2value(id2);
    }

    @Override
    public void offer(long value2) {
        if (value2 < 0L || value2 > 0x3FFFFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("Can only accept values in the range 0..4611686018427387903, got " + value2);
        }
        if (value2 >= this.capacity) {
            this.rebuildToCapacity(Long.highestOneBit(value2) << 1);
        }
        long leaf = this.value2leaf(value2);
        this.node2count.addTo(leaf, 1L);
        ++this.size;
        this.compressUpward(leaf);
        if ((double)this.node2count.size() > 3.0 * this.compressionFactor) {
            this.compressFully();
        }
    }

    public static QDigest unionOf(QDigest a, QDigest b) {
        long k;
        if (a.compressionFactor != b.compressionFactor) {
            throw new IllegalArgumentException("Compression factors must be the same: left is " + a.compressionFactor + ", right is " + b.compressionFactor);
        }
        if (a.capacity > b.capacity) {
            return QDigest.unionOf(b, a);
        }
        QDigest res = new QDigest(a.compressionFactor);
        res.capacity = a.capacity;
        res.size = a.size + b.size;
        LongIterator longIterator = a.node2count.keySet().iterator();
        while (longIterator.hasNext()) {
            k = (Long)longIterator.next();
            res.node2count.put(k, a.node2count.get(k));
        }
        if (b.capacity > res.capacity) {
            res.rebuildToCapacity(b.capacity);
        }
        longIterator = b.node2count.keySet().iterator();
        while (longIterator.hasNext()) {
            k = (Long)longIterator.next();
            res.node2count.put(k, b.get(k) + res.get(k));
        }
        res.compressFully();
        return res;
    }

    private void rebuildToCapacity(long newCapacity) {
        Long2LongOpenHashMap newNode2count = new Long2LongOpenHashMap(16, 0.25f);
        long scaleR = newCapacity / this.capacity - 1L;
        Object[] keys = (Long[])this.node2count.keySet().toArray((Object[])new Long[this.node2count.size()]);
        Arrays.sort(keys);
        long scaleL = 1L;
        Object[] objectArray = keys;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            long k = (Long)objectArray[i];
            while (scaleL <= k / 2L) {
                scaleL <<= 1;
            }
            newNode2count.put(k + scaleL * scaleR, this.node2count.get(k));
        }
        this.node2count = newNode2count;
        this.capacity = newCapacity;
        this.compressFully();
    }

    private void compressFully() {
        Long[] allNodes;
        Long[] longArray = allNodes = (Long[])this.node2count.keySet().toArray((Object[])new Long[this.node2count.size()]);
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long node2 = longArray[i];
            if (this.isRoot(node2)) continue;
            this.compressDownward(node2);
        }
    }

    private void compressUpward(long node2) {
        long atParent;
        long atSibling;
        double threshold = Math.floor((double)this.size / this.compressionFactor);
        long atNode = this.get(node2);
        while (!(this.isRoot(node2) || (double)atNode > threshold || (double)(atNode + (atSibling = this.get(this.sibling(node2)))) > threshold || (double)(atNode + atSibling + (atParent = this.get(this.parent(node2)))) > threshold)) {
            this.node2count.addTo(this.parent(node2), atNode + atSibling);
            this.node2count.remove(node2);
            if (atSibling > 0L) {
                this.node2count.remove(this.sibling(node2));
            }
            node2 = this.parent(node2);
            atNode = atParent + atNode + atSibling;
        }
    }

    private void compressDownward(long seedNode) {
        double threshold = Math.floor((double)this.size / this.compressionFactor);
        LongArrayFIFOQueue q = new LongArrayFIFOQueue();
        q.enqueue(seedNode);
        while (!q.isEmpty()) {
            long atParent;
            long node2 = q.dequeueLong();
            long atNode = this.get(node2);
            long atSibling = this.get(this.sibling(node2));
            if (atNode == 0L && atSibling == 0L || (double)((atParent = this.get(this.parent(node2))) + atNode + atSibling) > threshold) continue;
            this.node2count.addTo(this.parent(node2), atNode + atSibling);
            this.node2count.remove(node2);
            this.node2count.remove(this.sibling(node2));
            if (this.isLeaf(node2)) continue;
            q.enqueue(this.leftChild(node2));
            q.enqueue(this.leftChild(this.sibling(node2)));
        }
    }

    private long get(long node2) {
        return this.node2count.get(node2);
    }

    @Override
    public long getQuantile(double q) {
        List<long[]> ranges = this.toAscRanges();
        long s2 = 0L;
        for (long[] r2 : ranges) {
            if (!((double)(s2 += r2[2]) > q * (double)this.size)) continue;
            return r2[1];
        }
        return ranges.get(ranges.size() - 1)[1];
    }

    public List<long[]> toAscRanges() {
        ArrayList<long[]> ranges = new ArrayList<long[]>();
        LongIterator longIterator = this.node2count.keySet().iterator();
        while (longIterator.hasNext()) {
            long key = (Long)longIterator.next();
            ranges.add(new long[]{this.rangeLeft(key), this.rangeRight(key), this.node2count.get(key)});
        }
        Collections.sort(ranges, RANGES_COMPARATOR);
        return ranges;
    }

    public String toString() {
        List<long[]> ranges = this.toAscRanges();
        StringBuilder res = new StringBuilder();
        for (long[] range : ranges) {
            if (res.length() > 0) {
                res.append(", ");
            }
            res.append(range[0]).append(" .. ").append(range[1]).append(": ").append(range[2]);
        }
        return res.toString();
    }

    public static byte[] serialize(QDigest d) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream s2 = new DataOutputStream(bos);
        try {
            s2.writeLong(d.size);
            s2.writeDouble(d.compressionFactor);
            s2.writeLong(d.capacity);
            s2.writeInt(d.node2count.size());
            LongIterator longIterator = d.node2count.keySet().iterator();
            while (longIterator.hasNext()) {
                long k = (Long)longIterator.next();
                s2.writeLong(k);
                s2.writeLong(d.node2count.get(k));
            }
            s2.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static QDigest deserialize(byte[] b) {
        ByteArrayInputStream bis = new ByteArrayInputStream(b);
        DataInputStream s2 = new DataInputStream(bis);
        try {
            long size2 = s2.readLong();
            double compressionFactor = s2.readDouble();
            long capacity = s2.readLong();
            int count2 = s2.readInt();
            QDigest d = new QDigest(compressionFactor);
            d.size = size2;
            d.capacity = capacity;
            for (int i = 0; i < count2; ++i) {
                long k = s2.readLong();
                long n = s2.readLong();
                d.node2count.put(k, n);
            }
            return d;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long computeActualSize() {
        long res = 0L;
        LongIterator longIterator = this.node2count.values().iterator();
        while (longIterator.hasNext()) {
            long x = (Long)longIterator.next();
            res += x;
        }
        return res;
    }
}

