/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.CharSet;
import org.apache.commons.lang3.StringUtils;

public class CharSetUtils {
    public static String squeeze(String str, String ... set2) {
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set2)) {
            return str;
        }
        CharSet chars = CharSet.getInstance(set2);
        StringBuilder buffer = new StringBuilder(str.length());
        char[] chrs = str.toCharArray();
        int sz = chrs.length;
        int lastChar = 32;
        int ch = 32;
        for (int i = 0; i < sz; ++i) {
            ch = chrs[i];
            if (ch == lastChar && i != 0 && chars.contains((char)ch)) continue;
            buffer.append((char)ch);
            lastChar = ch;
        }
        return buffer.toString();
    }

    public static boolean containsAny(String str, String ... set2) {
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set2)) {
            return false;
        }
        CharSet chars = CharSet.getInstance(set2);
        for (char c : str.toCharArray()) {
            if (!chars.contains(c)) continue;
            return true;
        }
        return false;
    }

    public static int count(String str, String ... set2) {
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set2)) {
            return 0;
        }
        CharSet chars = CharSet.getInstance(set2);
        int count2 = 0;
        for (char c : str.toCharArray()) {
            if (!chars.contains(c)) continue;
            ++count2;
        }
        return count2;
    }

    public static String keep(String str, String ... set2) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty() || CharSetUtils.deepEmpty(set2)) {
            return "";
        }
        return CharSetUtils.modify(str, set2, true);
    }

    public static String delete(String str, String ... set2) {
        if (StringUtils.isEmpty(str) || CharSetUtils.deepEmpty(set2)) {
            return str;
        }
        return CharSetUtils.modify(str, set2, false);
    }

    private static String modify(String str, String[] set2, boolean expect) {
        CharSet chars = CharSet.getInstance(set2);
        StringBuilder buffer = new StringBuilder(str.length());
        char[] chrs = str.toCharArray();
        int sz = chrs.length;
        for (int i = 0; i < sz; ++i) {
            if (chars.contains(chrs[i]) != expect) continue;
            buffer.append(chrs[i]);
        }
        return buffer.toString();
    }

    private static boolean deepEmpty(String[] strings) {
        if (strings != null) {
            for (String s2 : strings) {
                if (!StringUtils.isNotEmpty(s2)) continue;
                return false;
            }
        }
        return true;
    }
}

