/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.HashSet;
import org.apache.commons.text.similarity.SimilarityScore;

public class JaccardSimilarity
implements SimilarityScore<Double> {
    @Override
    public Double apply(CharSequence left2, CharSequence right2) {
        if (left2 == null || right2 == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        return this.calculateJaccardSimilarity(left2, right2);
    }

    private Double calculateJaccardSimilarity(CharSequence left2, CharSequence right2) {
        int leftLength = left2.length();
        int rightLength = right2.length();
        if (leftLength == 0 || rightLength == 0) {
            return 0.0;
        }
        HashSet<Character> leftSet = new HashSet<Character>();
        for (int i = 0; i < leftLength; ++i) {
            leftSet.add(Character.valueOf(left2.charAt(i)));
        }
        HashSet<Character> rightSet = new HashSet<Character>();
        for (int i = 0; i < rightLength; ++i) {
            rightSet.add(Character.valueOf(right2.charAt(i)));
        }
        HashSet<Character> unionSet = new HashSet<Character>(leftSet);
        unionSet.addAll(rightSet);
        int intersectionSize = leftSet.size() + rightSet.size() - unionSet.size();
        return 1.0 * (double)intersectionSize / (double)unionSet.size();
    }
}

