/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.streaming.connectors.kafka.KafkaTableSink;
import org.apache.flink.streaming.connectors.kafka.KafkaTableSinkBase;
import org.apache.flink.streaming.connectors.kafka.KafkaTableSource;
import org.apache.flink.streaming.connectors.kafka.KafkaTableSourceBase;
import org.apache.flink.streaming.connectors.kafka.KafkaTableSourceSinkFactoryBase;
import org.apache.flink.streaming.connectors.kafka.config.StartupMode;
import org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.types.Row;

public class KafkaTableSourceSinkFactory
extends KafkaTableSourceSinkFactoryBase {
    @Override
    protected String kafkaVersion() {
        return "universal";
    }

    @Override
    protected boolean supportsKafkaTimestamps() {
        return true;
    }

    @Override
    protected KafkaTableSourceBase createKafkaTableSource(TableSchema schema, Optional<String> proctimeAttribute, List<RowtimeAttributeDescriptor> rowtimeAttributeDescriptors, Map<String, String> fieldMapping, String topic, Properties properties2, DeserializationSchema<Row> deserializationSchema, StartupMode startupMode, Map<KafkaTopicPartition, Long> specificStartupOffsets, long startupTimestampMillis) {
        return new KafkaTableSource(schema, proctimeAttribute, rowtimeAttributeDescriptors, Optional.of(fieldMapping), topic, properties2, deserializationSchema, startupMode, specificStartupOffsets, startupTimestampMillis);
    }

    @Override
    protected KafkaTableSinkBase createKafkaTableSink(TableSchema schema, String topic, Properties properties2, Optional<FlinkKafkaPartitioner<Row>> partitioner, SerializationSchema<Row> serializationSchema) {
        return new KafkaTableSink(schema, topic, properties2, partitioner, serializationSchema);
    }
}

