/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.connectors.kafka.config.StartupMode;
import org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;
import org.apache.flink.table.descriptors.ConnectorDescriptor;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.KafkaValidator;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class Kafka
extends ConnectorDescriptor {
    private String version;
    private String topic;
    private StartupMode startupMode;
    private Map<Integer, Long> specificOffsets;
    private long startTimestampMillis;
    private Map<String, String> kafkaProperties;
    private String sinkPartitionerType;
    private Class<? extends FlinkKafkaPartitioner> sinkPartitionerClass;

    public Kafka() {
        super("kafka", 1, true);
    }

    public Kafka version(String version) {
        Preconditions.checkNotNull((Object)version);
        this.version = version;
        return this;
    }

    public Kafka topic(String topic) {
        Preconditions.checkNotNull((Object)topic);
        this.topic = topic;
        return this;
    }

    public Kafka properties(Properties properties2) {
        Preconditions.checkNotNull((Object)properties2);
        if (this.kafkaProperties == null) {
            this.kafkaProperties = new HashMap<String, String>();
        }
        this.kafkaProperties.clear();
        properties2.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.kafkaProperties.put((String)k, (String)v)));
        return this;
    }

    public Kafka property(String key, String value2) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)value2);
        if (this.kafkaProperties == null) {
            this.kafkaProperties = new HashMap<String, String>();
        }
        this.kafkaProperties.put(key, value2);
        return this;
    }

    public Kafka startFromEarliest() {
        this.startupMode = StartupMode.EARLIEST;
        this.specificOffsets = null;
        return this;
    }

    public Kafka startFromLatest() {
        this.startupMode = StartupMode.LATEST;
        this.specificOffsets = null;
        return this;
    }

    public Kafka startFromGroupOffsets() {
        this.startupMode = StartupMode.GROUP_OFFSETS;
        this.specificOffsets = null;
        return this;
    }

    public Kafka startFromSpecificOffsets(Map<Integer, Long> specificOffsets) {
        this.startupMode = StartupMode.SPECIFIC_OFFSETS;
        this.specificOffsets = (Map)Preconditions.checkNotNull(specificOffsets);
        return this;
    }

    public Kafka startFromSpecificOffset(int partition, long specificOffset) {
        this.startupMode = StartupMode.SPECIFIC_OFFSETS;
        if (this.specificOffsets == null) {
            this.specificOffsets = new HashMap<Integer, Long>();
        }
        this.specificOffsets.put(partition, specificOffset);
        return this;
    }

    public Kafka startFromTimestamp(long startTimestampMillis) {
        this.startupMode = StartupMode.TIMESTAMP;
        this.specificOffsets = null;
        this.startTimestampMillis = startTimestampMillis;
        return this;
    }

    public Kafka sinkPartitionerFixed() {
        this.sinkPartitionerType = "fixed";
        this.sinkPartitionerClass = null;
        return this;
    }

    public Kafka sinkPartitionerRoundRobin() {
        this.sinkPartitionerType = "round-robin";
        this.sinkPartitionerClass = null;
        return this;
    }

    public Kafka sinkPartitionerCustom(Class<? extends FlinkKafkaPartitioner> partitionerClass) {
        this.sinkPartitionerType = "custom";
        this.sinkPartitionerClass = (Class)Preconditions.checkNotNull(partitionerClass);
        return this;
    }

    protected Map<String, String> toConnectorProperties() {
        DescriptorProperties properties2 = new DescriptorProperties();
        if (this.version != null) {
            properties2.putString("connector.version", this.version);
        }
        if (this.topic != null) {
            properties2.putString("connector.topic", this.topic);
        }
        if (this.startupMode != null) {
            properties2.putString("connector.startup-mode", KafkaValidator.normalizeStartupMode(this.startupMode));
        }
        if (this.specificOffsets != null) {
            StringBuilder stringBuilder = new StringBuilder();
            int i = 0;
            for (Map.Entry<Integer, Long> specificOffset : this.specificOffsets.entrySet()) {
                if (i != 0) {
                    stringBuilder.append(';');
                }
                stringBuilder.append("partition").append(':').append(specificOffset.getKey()).append(',').append("offset").append(':').append(specificOffset.getValue());
                ++i;
            }
            properties2.putString("connector.specific-offsets", stringBuilder.toString());
        }
        if (this.startTimestampMillis > 0L) {
            properties2.putString("connector.startup-timestamp-millis", String.valueOf(this.startTimestampMillis));
        }
        if (this.kafkaProperties != null) {
            this.kafkaProperties.forEach((key, value2) -> properties2.putString("connector.properties." + key, value2));
        }
        if (this.sinkPartitionerType != null) {
            properties2.putString("connector.sink-partitioner", this.sinkPartitionerType);
            if (this.sinkPartitionerClass != null) {
                properties2.putClass("connector.sink-partitioner-class", this.sinkPartitionerClass);
            }
        }
        return properties2.asMap();
    }
}

