/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.MemberToRemove;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.protocol.Errors;

public class RemoveMembersFromConsumerGroupResult {
    private final KafkaFuture<Map<LeaveGroupRequestData.MemberIdentity, Errors>> future;
    private final Set<MemberToRemove> memberInfos;

    RemoveMembersFromConsumerGroupResult(KafkaFuture<Map<LeaveGroupRequestData.MemberIdentity, Errors>> future, Set<MemberToRemove> memberInfos) {
        this.future = future;
        this.memberInfos = memberInfos;
    }

    public KafkaFuture<Void> all() {
        KafkaFutureImpl<Void> result2 = new KafkaFutureImpl<Void>();
        this.future.whenComplete((memberErrors, throwable) -> {
            if (throwable != null) {
                result2.completeExceptionally((Throwable)throwable);
            } else {
                for (MemberToRemove memberToRemove : this.memberInfos) {
                    if (!this.maybeCompleteExceptionally((Map<LeaveGroupRequestData.MemberIdentity, Errors>)memberErrors, memberToRemove.toMemberIdentity(), result2)) continue;
                    return;
                }
                result2.complete(null);
            }
        });
        return result2;
    }

    public KafkaFuture<Void> memberResult(MemberToRemove member) {
        if (!this.memberInfos.contains(member)) {
            throw new IllegalArgumentException("Member " + member + " was not included in the original request");
        }
        KafkaFutureImpl<Void> result2 = new KafkaFutureImpl<Void>();
        this.future.whenComplete((memberErrors, throwable) -> {
            if (throwable != null) {
                result2.completeExceptionally((Throwable)throwable);
            } else if (!this.maybeCompleteExceptionally((Map<LeaveGroupRequestData.MemberIdentity, Errors>)memberErrors, member.toMemberIdentity(), result2)) {
                result2.complete(null);
            }
        });
        return result2;
    }

    private boolean maybeCompleteExceptionally(Map<LeaveGroupRequestData.MemberIdentity, Errors> memberErrors, LeaveGroupRequestData.MemberIdentity member, KafkaFutureImpl<Void> result2) {
        Throwable exception = KafkaAdminClient.getSubLevelError(memberErrors, member, "Member \"" + member + "\" was not included in the removal response");
        if (exception != null) {
            result2.completeExceptionally(exception);
            return true;
        }
        return false;
    }
}

