/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.CollectionUtils;

public class ConsumerProtocol {
    public static final String PROTOCOL_TYPE = "consumer";
    public static final String VERSION_KEY_NAME = "version";
    public static final String TOPICS_KEY_NAME = "topics";
    public static final String TOPIC_KEY_NAME = "topic";
    public static final String PARTITIONS_KEY_NAME = "partitions";
    public static final String OWNED_PARTITIONS_KEY_NAME = "owned_partitions";
    public static final String TOPIC_PARTITIONS_KEY_NAME = "topic_partitions";
    public static final String USER_DATA_KEY_NAME = "user_data";
    public static final short CONSUMER_PROTOCOL_V0 = 0;
    public static final short CONSUMER_PROTOCOL_V1 = 1;
    public static final short CONSUMER_PROTOCOL_LATEST_VERSION = 1;
    public static final Schema CONSUMER_PROTOCOL_HEADER_SCHEMA = new Schema(new Field("version", Type.INT16));
    private static final Struct CONSUMER_PROTOCOL_HEADER_V0 = new Struct(CONSUMER_PROTOCOL_HEADER_SCHEMA).set("version", (Object)0);
    private static final Struct CONSUMER_PROTOCOL_HEADER_V1 = new Struct(CONSUMER_PROTOCOL_HEADER_SCHEMA).set("version", (Object)1);
    public static final Schema TOPIC_ASSIGNMENT_V0 = new Schema(new Field("topic", Type.STRING), new Field("partitions", new ArrayOf(Type.INT32)));
    public static final Schema SUBSCRIPTION_V0 = new Schema(new Field("topics", new ArrayOf(Type.STRING)), new Field("user_data", Type.NULLABLE_BYTES));
    public static final Schema SUBSCRIPTION_V1 = new Schema(new Field("topics", new ArrayOf(Type.STRING)), new Field("user_data", Type.NULLABLE_BYTES), new Field("owned_partitions", new ArrayOf(TOPIC_ASSIGNMENT_V0)));
    public static final Schema ASSIGNMENT_V0 = new Schema(new Field("topic_partitions", new ArrayOf(TOPIC_ASSIGNMENT_V0)), new Field("user_data", Type.NULLABLE_BYTES));
    public static final Schema ASSIGNMENT_V1 = new Schema(new Field("topic_partitions", new ArrayOf(TOPIC_ASSIGNMENT_V0)), new Field("user_data", Type.NULLABLE_BYTES));

    public static Short deserializeVersion(ByteBuffer buffer) {
        Struct header = CONSUMER_PROTOCOL_HEADER_SCHEMA.read(buffer);
        return header.getShort(VERSION_KEY_NAME);
    }

    public static ByteBuffer serializeSubscriptionV0(ConsumerPartitionAssignor.Subscription subscription) {
        Struct struct = new Struct(SUBSCRIPTION_V0);
        struct.set(USER_DATA_KEY_NAME, (Object)subscription.userData());
        struct.set(TOPICS_KEY_NAME, (Object)subscription.topics().toArray());
        ByteBuffer buffer = ByteBuffer.allocate(CONSUMER_PROTOCOL_HEADER_V0.sizeOf() + SUBSCRIPTION_V0.sizeOf(struct));
        CONSUMER_PROTOCOL_HEADER_V0.writeTo(buffer);
        SUBSCRIPTION_V0.write(buffer, struct);
        buffer.flip();
        return buffer;
    }

    public static ByteBuffer serializeSubscriptionV1(ConsumerPartitionAssignor.Subscription subscription) {
        Struct struct = new Struct(SUBSCRIPTION_V1);
        struct.set(USER_DATA_KEY_NAME, (Object)subscription.userData());
        struct.set(TOPICS_KEY_NAME, (Object)subscription.topics().toArray());
        ArrayList<Struct> topicAssignments = new ArrayList<Struct>();
        Map<String, List<Integer>> partitionsByTopic = CollectionUtils.groupPartitionsByTopic(subscription.ownedPartitions());
        for (Map.Entry<String, List<Integer>> topicEntry : partitionsByTopic.entrySet()) {
            Struct topicAssignment = new Struct(TOPIC_ASSIGNMENT_V0);
            topicAssignment.set(TOPIC_KEY_NAME, (Object)topicEntry.getKey());
            topicAssignment.set(PARTITIONS_KEY_NAME, (Object)topicEntry.getValue().toArray());
            topicAssignments.add(topicAssignment);
        }
        struct.set(OWNED_PARTITIONS_KEY_NAME, (Object)topicAssignments.toArray());
        ByteBuffer buffer = ByteBuffer.allocate(CONSUMER_PROTOCOL_HEADER_V1.sizeOf() + SUBSCRIPTION_V1.sizeOf(struct));
        CONSUMER_PROTOCOL_HEADER_V1.writeTo(buffer);
        SUBSCRIPTION_V1.write(buffer, struct);
        buffer.flip();
        return buffer;
    }

    public static ByteBuffer serializeSubscription(ConsumerPartitionAssignor.Subscription subscription) {
        return ConsumerProtocol.serializeSubscription(subscription, (short)1);
    }

    public static ByteBuffer serializeSubscription(ConsumerPartitionAssignor.Subscription subscription, short version) {
        switch (version) {
            case 0: {
                return ConsumerProtocol.serializeSubscriptionV0(subscription);
            }
            case 1: {
                return ConsumerProtocol.serializeSubscriptionV1(subscription);
            }
        }
        return ConsumerProtocol.serializeSubscriptionV1(subscription);
    }

    public static ConsumerPartitionAssignor.Subscription deserializeSubscriptionV0(ByteBuffer buffer) {
        Struct struct = SUBSCRIPTION_V0.read(buffer);
        ByteBuffer userData = struct.getBytes(USER_DATA_KEY_NAME);
        ArrayList<String> topics2 = new ArrayList<String>();
        for (Object topicObj : struct.getArray(TOPICS_KEY_NAME)) {
            topics2.add((String)topicObj);
        }
        return new ConsumerPartitionAssignor.Subscription(topics2, userData, Collections.emptyList());
    }

    public static ConsumerPartitionAssignor.Subscription deserializeSubscriptionV1(ByteBuffer buffer) {
        Struct struct = SUBSCRIPTION_V1.read(buffer);
        ByteBuffer userData = struct.getBytes(USER_DATA_KEY_NAME);
        ArrayList<String> topics2 = new ArrayList<String>();
        for (Object topicObj : struct.getArray(TOPICS_KEY_NAME)) {
            topics2.add((String)topicObj);
        }
        ArrayList<TopicPartition> ownedPartitions = new ArrayList<TopicPartition>();
        for (Object structObj : struct.getArray(OWNED_PARTITIONS_KEY_NAME)) {
            Struct assignment = (Struct)structObj;
            String topic = assignment.getString(TOPIC_KEY_NAME);
            for (Object partitionObj : assignment.getArray(PARTITIONS_KEY_NAME)) {
                ownedPartitions.add(new TopicPartition(topic, (Integer)partitionObj));
            }
        }
        return new ConsumerPartitionAssignor.Subscription(topics2, userData, ownedPartitions);
    }

    public static ConsumerPartitionAssignor.Subscription deserializeSubscription(ByteBuffer buffer) {
        Short version = ConsumerProtocol.deserializeVersion(buffer);
        if (version < 0) {
            throw new SchemaException("Unsupported subscription version: " + version);
        }
        switch (version) {
            case 0: {
                return ConsumerProtocol.deserializeSubscriptionV0(buffer);
            }
            case 1: {
                return ConsumerProtocol.deserializeSubscriptionV1(buffer);
            }
        }
        return ConsumerProtocol.deserializeSubscriptionV1(buffer);
    }

    public static ByteBuffer serializeAssignmentV0(ConsumerPartitionAssignor.Assignment assignment) {
        Struct struct = new Struct(ASSIGNMENT_V0);
        struct.set(USER_DATA_KEY_NAME, (Object)assignment.userData());
        ArrayList<Struct> topicAssignments = new ArrayList<Struct>();
        Map<String, List<Integer>> partitionsByTopic = CollectionUtils.groupPartitionsByTopic(assignment.partitions());
        for (Map.Entry<String, List<Integer>> topicEntry : partitionsByTopic.entrySet()) {
            Struct topicAssignment = new Struct(TOPIC_ASSIGNMENT_V0);
            topicAssignment.set(TOPIC_KEY_NAME, (Object)topicEntry.getKey());
            topicAssignment.set(PARTITIONS_KEY_NAME, (Object)topicEntry.getValue().toArray());
            topicAssignments.add(topicAssignment);
        }
        struct.set(TOPIC_PARTITIONS_KEY_NAME, (Object)topicAssignments.toArray());
        ByteBuffer buffer = ByteBuffer.allocate(CONSUMER_PROTOCOL_HEADER_V0.sizeOf() + ASSIGNMENT_V0.sizeOf(struct));
        CONSUMER_PROTOCOL_HEADER_V0.writeTo(buffer);
        ASSIGNMENT_V0.write(buffer, struct);
        buffer.flip();
        return buffer;
    }

    public static ByteBuffer serializeAssignmentV1(ConsumerPartitionAssignor.Assignment assignment) {
        Struct struct = new Struct(ASSIGNMENT_V1);
        struct.set(USER_DATA_KEY_NAME, (Object)assignment.userData());
        ArrayList<Struct> topicAssignments = new ArrayList<Struct>();
        Map<String, List<Integer>> partitionsByTopic = CollectionUtils.groupPartitionsByTopic(assignment.partitions());
        for (Map.Entry<String, List<Integer>> topicEntry : partitionsByTopic.entrySet()) {
            Struct topicAssignment = new Struct(TOPIC_ASSIGNMENT_V0);
            topicAssignment.set(TOPIC_KEY_NAME, (Object)topicEntry.getKey());
            topicAssignment.set(PARTITIONS_KEY_NAME, (Object)topicEntry.getValue().toArray());
            topicAssignments.add(topicAssignment);
        }
        struct.set(TOPIC_PARTITIONS_KEY_NAME, (Object)topicAssignments.toArray());
        ByteBuffer buffer = ByteBuffer.allocate(CONSUMER_PROTOCOL_HEADER_V1.sizeOf() + ASSIGNMENT_V1.sizeOf(struct));
        CONSUMER_PROTOCOL_HEADER_V1.writeTo(buffer);
        ASSIGNMENT_V1.write(buffer, struct);
        buffer.flip();
        return buffer;
    }

    public static ByteBuffer serializeAssignment(ConsumerPartitionAssignor.Assignment assignment) {
        return ConsumerProtocol.serializeAssignment(assignment, (short)1);
    }

    public static ByteBuffer serializeAssignment(ConsumerPartitionAssignor.Assignment assignment, short version) {
        switch (version) {
            case 0: {
                return ConsumerProtocol.serializeAssignmentV0(assignment);
            }
            case 1: {
                return ConsumerProtocol.serializeAssignmentV1(assignment);
            }
        }
        return ConsumerProtocol.serializeAssignmentV1(assignment);
    }

    public static ConsumerPartitionAssignor.Assignment deserializeAssignmentV0(ByteBuffer buffer) {
        Struct struct = ASSIGNMENT_V0.read(buffer);
        ByteBuffer userData = struct.getBytes(USER_DATA_KEY_NAME);
        ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
        for (Object structObj : struct.getArray(TOPIC_PARTITIONS_KEY_NAME)) {
            Struct assignment = (Struct)structObj;
            String topic = assignment.getString(TOPIC_KEY_NAME);
            for (Object partitionObj : assignment.getArray(PARTITIONS_KEY_NAME)) {
                partitions.add(new TopicPartition(topic, (Integer)partitionObj));
            }
        }
        return new ConsumerPartitionAssignor.Assignment(partitions, userData);
    }

    public static ConsumerPartitionAssignor.Assignment deserializeAssignmentV1(ByteBuffer buffer) {
        return ConsumerProtocol.deserializeAssignmentV0(buffer);
    }

    public static ConsumerPartitionAssignor.Assignment deserializeAssignment(ByteBuffer buffer) {
        Short version = ConsumerProtocol.deserializeVersion(buffer);
        if (version < 0) {
            throw new SchemaException("Unsupported assignment version: " + version);
        }
        switch (version) {
            case 0: {
                return ConsumerProtocol.deserializeAssignmentV0(buffer);
            }
            case 1: {
                return ConsumerProtocol.deserializeAssignmentV1(buffer);
            }
        }
        return ConsumerProtocol.deserializeAssignmentV1(buffer);
    }
}

