/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Objects;

public class Node {
    private static final Node NO_NODE = new Node(-1, "", -1);
    private final int id;
    private final String idString;
    private final String host;
    private final int port;
    private final String rack;
    private Integer hash;

    public Node(int id2, String host, int port) {
        this(id2, host, port, null);
    }

    public Node(int id2, String host, int port, String rack) {
        this.id = id2;
        this.idString = Integer.toString(id2);
        this.host = host;
        this.port = port;
        this.rack = rack;
    }

    public static Node noNode() {
        return NO_NODE;
    }

    public boolean isEmpty() {
        return this.host == null || this.host.isEmpty() || this.port < 0;
    }

    public int id() {
        return this.id;
    }

    public String idString() {
        return this.idString;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean hasRack() {
        return this.rack != null;
    }

    public String rack() {
        return this.rack;
    }

    public int hashCode() {
        Integer h2 = this.hash;
        if (h2 == null) {
            int result2 = 31 + (this.host == null ? 0 : this.host.hashCode());
            result2 = 31 * result2 + this.id;
            result2 = 31 * result2 + this.port;
            result2 = 31 * result2 + (this.rack == null ? 0 : this.rack.hashCode());
            this.hash = result2;
            return result2;
        }
        return h2;
    }

    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (obj2 == null || this.getClass() != obj2.getClass()) {
            return false;
        }
        Node other = (Node)obj2;
        return this.id == other.id && this.port == other.port && Objects.equals(this.host, other.host) && Objects.equals(this.rack, other.rack);
    }

    public String toString() {
        return this.host + ":" + this.port + " (id: " + this.idString + " rack: " + this.rack + ")";
    }
}

