/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class AlterConfigsRequestData
implements ApiMessage {
    private AlterConfigsResourceCollection resources;
    private boolean validateOnly;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public AlterConfigsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public AlterConfigsRequestData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public AlterConfigsRequestData() {
        this.resources = new AlterConfigsResourceCollection(0);
        this.validateOnly = false;
    }

    @Override
    public short apiKey() {
        return 33;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field resources was serialized as null");
        }
        AlterConfigsResourceCollection newCollection = new AlterConfigsResourceCollection(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new AlterConfigsResource(_readable, _version));
        }
        this.resources = newCollection;
        this.validateOnly = _readable.readByte() != 0;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.resources.size());
        for (AlterConfigsResource resourcesElement : this.resources) {
            resourcesElement.write(_writable, _cache, _version);
        }
        _writable.writeByte(this.validateOnly ? (byte)1 : 0);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        this._unknownTaggedFields = null;
        Object[] _nestedObjects = struct.getArray("resources");
        this.resources = new AlterConfigsResourceCollection(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.resources.add(new AlterConfigsResource((Struct)nestedObject, _version));
        }
        this.validateOnly = struct.getBoolean("validate_only");
    }

    @Override
    public Struct toStruct(short _version) {
        Object _taggedFields = null;
        Struct struct = new Struct(SCHEMAS[_version]);
        Struct[] _nestedObjects = new Struct[this.resources.size()];
        int i = 0;
        for (AlterConfigsResource element : this.resources) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("resources", (Object)_nestedObjects);
        struct.set("validate_only", (Object)this.validateOnly);
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        int _arraySize = 0;
        _arraySize += 4;
        for (AlterConfigsResource resourcesElement : this.resources) {
            _arraySize += resourcesElement.size(_cache, _version);
        }
        _size += _arraySize;
        ++_size;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof AlterConfigsRequestData)) {
            return false;
        }
        AlterConfigsRequestData other = (AlterConfigsRequestData)obj2;
        if (this.resources == null ? other.resources != null : !this.resources.equals(other.resources)) {
            return false;
        }
        return this.validateOnly == other.validateOnly;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.resources == null ? 0 : this.resources.hashCode());
        hashCode = 31 * hashCode + (this.validateOnly ? 1231 : 1237);
        return hashCode;
    }

    public String toString() {
        return "AlterConfigsRequestData(resources=" + MessageUtil.deepToString(this.resources.iterator()) + ", validateOnly=" + (this.validateOnly ? "true" : "false") + ")";
    }

    public AlterConfigsResourceCollection resources() {
        return this.resources;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterConfigsRequestData setResources(AlterConfigsResourceCollection v) {
        this.resources = v;
        return this;
    }

    public AlterConfigsRequestData setValidateOnly(boolean v) {
        this.validateOnly = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("resources", new ArrayOf(AlterConfigsResource.SCHEMA_0), "The updates for each resource."), new Field("validate_only", Type.BOOLEAN, "True if we should validate the request, but not change the configurations."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class AlterConfigsResourceCollection
    extends ImplicitLinkedHashMultiCollection<AlterConfigsResource> {
        public AlterConfigsResourceCollection() {
        }

        public AlterConfigsResourceCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AlterConfigsResourceCollection(Iterator<AlterConfigsResource> iterator) {
            super(iterator);
        }

        public AlterConfigsResource find(byte resourceType, String resourceName) {
            AlterConfigsResource key = new AlterConfigsResource();
            key.setResourceType(resourceType);
            key.setResourceName(resourceName);
            return this.find(key);
        }

        public List<AlterConfigsResource> findAll(byte resourceType, String resourceName) {
            AlterConfigsResource key = new AlterConfigsResource();
            key.setResourceType(resourceType);
            key.setResourceName(resourceName);
            return this.findAll(key);
        }
    }

    public static class AlterableConfigCollection
    extends ImplicitLinkedHashMultiCollection<AlterableConfig> {
        public AlterableConfigCollection() {
        }

        public AlterableConfigCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AlterableConfigCollection(Iterator<AlterableConfig> iterator) {
            super(iterator);
        }

        @Override
        public AlterableConfig find(String name) {
            AlterableConfig key = new AlterableConfig();
            key.setName(name);
            return this.find(key);
        }

        @Override
        public List<AlterableConfig> findAll(String name) {
            AlterableConfig key = new AlterableConfig();
            key.setName(name);
            return this.findAll(key);
        }
    }

    public static class AlterableConfig
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private String name;
        private String value;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public AlterableConfig(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public AlterableConfig(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public AlterableConfig() {
            this.name = "";
            this.value = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AlterableConfig");
            }
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _readable.readShort();
            if (length < 0) {
                this.value = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field value had invalid length " + length);
                }
                this.value = _readable.readString(length);
            }
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of AlterableConfig");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
            if (this.value == null) {
                _writable.writeShort((short)-1);
            } else {
                _stringBytes = _cache.getSerializedValue(this.value);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AlterableConfig");
            }
            this._unknownTaggedFields = null;
            this.name = struct.getString("name");
            this.value = struct.getString("value");
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of AlterableConfig");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            struct.set("value", (Object)this.value);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AlterableConfig");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size += _stringBytes.length + 2;
            if (this.value == null) {
                _size += 2;
            } else {
                _stringBytes = this.value.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'value' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.value, _stringBytes);
                _size += _stringBytes.length + 2;
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj2) {
            if (!(obj2 instanceof AlterableConfig)) {
                return false;
            }
            AlterableConfig other = (AlterableConfig)obj2;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public String toString() {
            return "AlterableConfig(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", value=" + (this.value == null ? "null" : "'" + this.value.toString() + "'") + ")";
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AlterableConfig setName(String v) {
            this.name = v;
            return this;
        }

        public AlterableConfig setValue(String v) {
            this.value = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The configuration key name."), new Field("value", Type.NULLABLE_STRING, "The value to set for the configuration key."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class AlterConfigsResource
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private byte resourceType;
        private String resourceName;
        private AlterableConfigCollection configs;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public AlterConfigsResource(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public AlterConfigsResource(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public AlterConfigsResource() {
            this.resourceType = 0;
            this.resourceName = "";
            this.configs = new AlterableConfigCollection(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AlterConfigsResource");
            }
            this.resourceType = _readable.readByte();
            short length = _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field resourceName was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field resourceName had invalid length " + length);
            }
            this.resourceName = _readable.readString(length);
            int arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field configs was serialized as null");
            }
            AlterableConfigCollection newCollection = new AlterableConfigCollection(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new AlterableConfig(_readable, _version));
            }
            this.configs = newCollection;
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of AlterConfigsResource");
            }
            int _numTaggedFields = 0;
            _writable.writeByte(this.resourceType);
            Object _stringBytes = _cache.getSerializedValue(this.resourceName);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.configs.size());
            _stringBytes = this.configs.iterator();
            while (_stringBytes.hasNext()) {
                AlterableConfig configsElement = (AlterableConfig)_stringBytes.next();
                configsElement.write(_writable, _cache, _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AlterConfigsResource");
            }
            this._unknownTaggedFields = null;
            this.resourceType = struct.getByte("resource_type");
            this.resourceName = struct.getString("resource_name");
            Object[] _nestedObjects = struct.getArray("configs");
            this.configs = new AlterableConfigCollection(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.configs.add(new AlterableConfig((Struct)nestedObject, _version));
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of AlterConfigsResource");
            }
            Object _taggedFields = null;
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("resource_type", (Object)this.resourceType);
            struct.set("resource_name", (Object)this.resourceName);
            Struct[] _nestedObjects = new Struct[this.configs.size()];
            int i = 0;
            for (AlterableConfig element : this.configs) {
                _nestedObjects[i++] = element.toStruct(_version);
            }
            struct.set("configs", (Object)_nestedObjects);
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AlterConfigsResource");
            }
            ++_size;
            byte[] _stringBytes = this.resourceName.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'resourceName' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.resourceName, _stringBytes);
            _size += _stringBytes.length + 2;
            int _arraySize = 0;
            _arraySize += 4;
            for (AlterableConfig configsElement : this.configs) {
                _arraySize += configsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj2) {
            if (!(obj2 instanceof AlterConfigsResource)) {
                return false;
            }
            AlterConfigsResource other = (AlterConfigsResource)obj2;
            if (this.resourceType != other.resourceType) {
                return false;
            }
            return !(this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.resourceType;
            hashCode = 31 * hashCode + (this.resourceName == null ? 0 : this.resourceName.hashCode());
            return hashCode;
        }

        public String toString() {
            return "AlterConfigsResource(resourceType=" + this.resourceType + ", resourceName=" + (this.resourceName == null ? "null" : "'" + this.resourceName.toString() + "'") + ", configs=" + MessageUtil.deepToString(this.configs.iterator()) + ")";
        }

        public byte resourceType() {
            return this.resourceType;
        }

        public String resourceName() {
            return this.resourceName;
        }

        public AlterableConfigCollection configs() {
            return this.configs;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AlterConfigsResource setResourceType(byte v) {
            this.resourceType = v;
            return this;
        }

        public AlterConfigsResource setResourceName(String v) {
            this.resourceName = v;
            return this;
        }

        public AlterConfigsResource setConfigs(AlterableConfigCollection v) {
            this.configs = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("resource_type", Type.INT8, "The resource type."), new Field("resource_name", Type.STRING, "The resource name."), new Field("configs", new ArrayOf(AlterableConfig.SCHEMA_0), "The configurations."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

