/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol.types;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.protocol.types.Type;

public class ArrayOf
extends Type.DocumentedType {
    private static final String ARRAY_TYPE_NAME = "ARRAY";
    private final Type type;
    private final boolean nullable;

    public ArrayOf(Type type) {
        this(type, false);
    }

    public static ArrayOf nullable(Type type) {
        return new ArrayOf(type, true);
    }

    private ArrayOf(Type type, boolean nullable) {
        this.type = type;
        this.nullable = nullable;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    public void write(ByteBuffer buffer, Object o) {
        if (o == null) {
            buffer.putInt(-1);
            return;
        }
        Object[] objs = (Object[])o;
        int size2 = objs.length;
        buffer.putInt(size2);
        for (Object obj2 : objs) {
            this.type.write(buffer, obj2);
        }
    }

    @Override
    public Object read(ByteBuffer buffer) {
        int size2 = buffer.getInt();
        if (size2 < 0 && this.isNullable()) {
            return null;
        }
        if (size2 < 0) {
            throw new SchemaException("Array size " + size2 + " cannot be negative");
        }
        if (size2 > buffer.remaining()) {
            throw new SchemaException("Error reading array of size " + size2 + ", only " + buffer.remaining() + " bytes available");
        }
        Object[] objs = new Object[size2];
        for (int i = 0; i < size2; ++i) {
            objs[i] = this.type.read(buffer);
        }
        return objs;
    }

    @Override
    public int sizeOf(Object o) {
        Object[] objs;
        int size2 = 4;
        if (o == null) {
            return size2;
        }
        for (Object obj2 : objs = (Object[])o) {
            size2 += this.type.sizeOf(obj2);
        }
        return size2;
    }

    @Override
    public Optional<Type> arrayElementType() {
        return Optional.of(this.type);
    }

    @Override
    public String toString() {
        return "ARRAY(" + this.type + ")";
    }

    public Object[] validate(Object item) {
        try {
            Object[] array2;
            if (this.isNullable() && item == null) {
                return null;
            }
            for (Object obj2 : array2 = (Object[])item) {
                this.type.validate(obj2);
            }
            return array2;
        }
        catch (ClassCastException e) {
            throw new SchemaException("Not an Object[].");
        }
    }

    @Override
    public String typeName() {
        return ARRAY_TYPE_NAME;
    }

    @Override
    public String documentation() {
        return "Represents a sequence of objects of a given type T. Type T can be either a primitive type (e.g. " + STRING + ") or a structure. First, the length N is given as an " + INT32 + ". Then N instances of type T follow. A null array is represented with a length of -1. In protocol documentation an array of T instances is referred to as [T].";
    }
}

