/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol.types;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.RawTaggedField;

public class RawTaggedFieldWriter {
    private static final RawTaggedFieldWriter EMPTY_WRITER = new RawTaggedFieldWriter(new ArrayList<RawTaggedField>(0));
    private final List<RawTaggedField> fields;
    private final ListIterator<RawTaggedField> iter;
    private int prevTag;

    public static RawTaggedFieldWriter forFields(List<RawTaggedField> fields2) {
        if (fields2 == null) {
            return EMPTY_WRITER;
        }
        return new RawTaggedFieldWriter(fields2);
    }

    private RawTaggedFieldWriter(List<RawTaggedField> fields2) {
        this.fields = fields2;
        this.iter = this.fields.listIterator();
        this.prevTag = -1;
    }

    public int numFields() {
        return this.fields.size();
    }

    public void writeRawTags(Writable writable, int nextDefinedTag) {
        while (this.iter.hasNext()) {
            RawTaggedField field2 = this.iter.next();
            int tag2 = field2.tag();
            if (tag2 >= nextDefinedTag) {
                if (tag2 == nextDefinedTag) {
                    throw new RuntimeException("Attempted to use tag " + tag2 + " as an undefined tag.");
                }
                this.iter.previous();
                return;
            }
            if (tag2 <= this.prevTag) {
                throw new RuntimeException("Invalid raw tag field list: tag " + tag2 + " comes after tag " + this.prevTag + ", but is not higher than it.");
            }
            writable.writeUnsignedVarint(field2.tag());
            writable.writeUnsignedVarint(field2.data().length);
            writable.writeByteArray(field2.data());
            this.prevTag = tag2;
        }
    }
}

