/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Utils;

public class SimpleRecord {
    private final ByteBuffer key;
    private final ByteBuffer value;
    private final long timestamp;
    private final Header[] headers;

    public SimpleRecord(long timestamp, ByteBuffer key, ByteBuffer value2, Header[] headers) {
        Objects.requireNonNull(headers, "Headers must be non-null");
        this.key = key;
        this.value = value2;
        this.timestamp = timestamp;
        this.headers = headers;
    }

    public SimpleRecord(long timestamp, byte[] key, byte[] value2, Header[] headers) {
        this(timestamp, Utils.wrapNullable(key), Utils.wrapNullable(value2), headers);
    }

    public SimpleRecord(long timestamp, ByteBuffer key, ByteBuffer value2) {
        this(timestamp, key, value2, Record.EMPTY_HEADERS);
    }

    public SimpleRecord(long timestamp, byte[] key, byte[] value2) {
        this(timestamp, Utils.wrapNullable(key), Utils.wrapNullable(value2));
    }

    public SimpleRecord(long timestamp, byte[] value2) {
        this(timestamp, null, value2);
    }

    public SimpleRecord(byte[] value2) {
        this(-1L, null, value2);
    }

    public SimpleRecord(byte[] key, byte[] value2) {
        this(-1L, key, value2);
    }

    public SimpleRecord(Record record2) {
        this(record2.timestamp(), record2.key(), record2.value(), record2.headers());
    }

    public ByteBuffer key() {
        return this.key;
    }

    public ByteBuffer value() {
        return this.value;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Header[] headers() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleRecord that = (SimpleRecord)o;
        return this.timestamp == that.timestamp && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Arrays.equals(this.headers, that.headers);
    }

    public int hashCode() {
        int result2 = this.key != null ? this.key.hashCode() : 0;
        result2 = 31 * result2 + (this.value != null ? this.value.hashCode() : 0);
        result2 = 31 * result2 + Long.hashCode(this.timestamp);
        result2 = 31 * result2 + Arrays.hashCode(this.headers);
        return result2;
    }

    public String toString() {
        return String.format("SimpleRecord(timestamp=%d, key=%d bytes, value=%d bytes)", this.timestamp(), this.key == null ? 0 : this.key.limit(), this.value == null ? 0 : this.value.limit());
    }
}

