/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.concurrent.atomic.AtomicLong;
import org.hsqldb.Database;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rights.Grantee;

public final class HsqlNameManager {
    private static final HsqlNameManager staticManager = new HsqlNameManager();
    private static final HsqlName[] autoColumnNames;
    private static final String[] autoNoNameColumnNames;
    private AtomicLong serialNumber = new AtomicLong(1L);
    private AtomicLong sysNumber = new AtomicLong(10000L);
    private HsqlName catalogName;
    private boolean sqlRegularNames;
    HsqlName subqueryTableName;

    public HsqlNameManager() {
        this.sqlRegularNames = true;
    }

    public HsqlNameManager(Database database) {
        this.catalogName = new HsqlName(this, "PUBLIC", 1, false);
        this.sqlRegularNames = database.sqlRegularNames;
        this.subqueryTableName = new HsqlName(this, "SYSTEM_SUBQUERY", false, 3);
        this.subqueryTableName.schema = SqlInvariants.SYSTEM_SCHEMA_HSQLNAME;
    }

    public HsqlName getCatalogName() {
        return this.catalogName;
    }

    public void setSqlRegularNames(boolean bl) {
        this.sqlRegularNames = bl;
    }

    public static HsqlName newSystemObjectName(String string2, int n) {
        return new HsqlName(staticManager, string2, n, false);
    }

    public static HsqlName newInfoSchemaColumnName(String string2, HsqlName hsqlName) {
        HsqlName hsqlName2 = new HsqlName(staticManager, string2, false, 9);
        hsqlName2.schema = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        hsqlName2.parent = hsqlName;
        return hsqlName2;
    }

    public static HsqlName newInfoSchemaTableName(String string2) {
        HsqlName hsqlName = new HsqlName(staticManager, string2, 3, false);
        hsqlName.schema = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        return hsqlName;
    }

    public static HsqlName newInfoSchemaObjectName(String string2, boolean bl, int n) {
        HsqlName hsqlName = new HsqlName(staticManager, string2, n, bl);
        hsqlName.schema = SqlInvariants.INFORMATION_SCHEMA_HSQLNAME;
        return hsqlName;
    }

    public HsqlName newHsqlName(HsqlName hsqlName, String string2, int n) {
        HsqlName hsqlName2 = new HsqlName(this, string2, n, false);
        hsqlName2.schema = hsqlName;
        return hsqlName2;
    }

    public HsqlName newHsqlName(String string2, boolean bl, int n) {
        return new HsqlName(this, string2, bl, n);
    }

    public HsqlName newHsqlName(HsqlName hsqlName, String string2, boolean bl, int n) {
        HsqlName hsqlName2 = new HsqlName(this, string2, bl, n);
        hsqlName2.schema = hsqlName;
        return hsqlName2;
    }

    public HsqlName newHsqlName(HsqlName hsqlName, String string2, boolean bl, int n, HsqlName hsqlName2) {
        HsqlName hsqlName3 = new HsqlName(this, string2, bl, n);
        hsqlName3.schema = hsqlName;
        hsqlName3.parent = hsqlName2;
        return hsqlName3;
    }

    public HsqlName newColumnSchemaHsqlName(HsqlName hsqlName, SimpleName simpleName) {
        return this.newColumnHsqlName(hsqlName, simpleName.name, simpleName.isNameQuoted);
    }

    public HsqlName newColumnHsqlName(HsqlName hsqlName, String string2, boolean bl) {
        HsqlName hsqlName2 = new HsqlName(this, string2, bl, 9);
        hsqlName2.schema = hsqlName.schema;
        hsqlName2.parent = hsqlName;
        return hsqlName2;
    }

    public HsqlName getSubqueryTableName() {
        return this.subqueryTableName;
    }

    public HsqlName newAutoName(String string2, HsqlName hsqlName, HsqlName hsqlName2, int n) {
        HsqlName hsqlName3 = this.newAutoName(string2, null, hsqlName, hsqlName2, n);
        return hsqlName3;
    }

    public HsqlName newConstraintIndexName(HsqlName hsqlName, HsqlName hsqlName2, boolean bl) {
        if (hsqlName2 == null) {
            bl = false;
        }
        if (bl) {
            HsqlName hsqlName3 = new HsqlName(this, hsqlName2.name, 20, false);
            hsqlName3.schema = hsqlName.schema;
            hsqlName3.parent = hsqlName;
            return hsqlName3;
        }
        String string2 = hsqlName2 == null ? null : hsqlName2.name;
        return this.newAutoName("IDX", string2, hsqlName.schema, hsqlName, 20);
    }

    public HsqlName newSpecificRoutineName(HsqlName hsqlName) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(hsqlName.name).append('_').append(this.sysNumber.incrementAndGet());
        HsqlName hsqlName2 = new HsqlName(this, stringBuilder.toString(), 24, hsqlName.isNameQuoted);
        hsqlName2.parent = hsqlName;
        hsqlName2.schema = hsqlName.schema;
        return hsqlName2;
    }

    public static HsqlName getAutoColumnName(int n) {
        if (n < autoColumnNames.length) {
            return autoColumnNames[n];
        }
        return new HsqlName(staticManager, "C_" + (n + 1), 9, false);
    }

    public static String getAutoNoNameColumnString(int n) {
        if (n < autoColumnNames.length) {
            return autoNoNameColumnNames[n];
        }
        return String.valueOf(n);
    }

    public static String getAutoSavepointNameString(long l, int n) {
        StringBuilder stringBuilder = new StringBuilder("S");
        stringBuilder.append(l).append('_').append(n);
        return stringBuilder.toString();
    }

    public HsqlName newAutoName(String string2, String string3, HsqlName hsqlName, HsqlName hsqlName2, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null) {
            if (string2.length() != 0) {
                stringBuilder.append("SYS_");
                stringBuilder.append(string2);
                stringBuilder.append('_');
                if (string3 != null) {
                    stringBuilder.append(string3);
                    stringBuilder.append('_');
                }
                stringBuilder.append(this.sysNumber.incrementAndGet());
            }
        } else {
            stringBuilder.append(string3);
        }
        HsqlName hsqlName3 = new HsqlName(this, stringBuilder.toString(), n, false);
        hsqlName3.schema = hsqlName;
        hsqlName3.parent = hsqlName2;
        return hsqlName3;
    }

    public static SimpleName getSimpleName(String string2, boolean bl) {
        return new SimpleName(string2, bl);
    }

    static {
        HsqlNameManager.staticManager.serialNumber.set(Long.MIN_VALUE);
        autoColumnNames = new HsqlName[32];
        autoNoNameColumnNames = new String[32];
        for (int i = 0; i < autoColumnNames.length; ++i) {
            HsqlNameManager.autoColumnNames[i] = new HsqlName(staticManager, "C" + (i + 1), 0, false);
            HsqlNameManager.autoNoNameColumnNames[i] = String.valueOf(i);
        }
    }

    public static final class HsqlName
    extends SimpleName {
        static HsqlName[] emptyArray = new HsqlName[0];
        HsqlNameManager manager;
        public String statementName;
        public String comment;
        public HsqlName schema;
        public HsqlName parent;
        public Grantee owner;
        public final int type;
        private final long hashCode;
        static final String[] sysPrefixes = new String[]{"SYS_IDX_", "SYS_PK_", "SYS_REF_", "SYS_CT_", "SYS_FK_"};

        private HsqlName(HsqlNameManager hsqlNameManager, int n) {
            this.manager = hsqlNameManager;
            this.type = n;
            this.hashCode = this.manager.serialNumber.getAndIncrement();
        }

        private HsqlName(HsqlNameManager hsqlNameManager, String string2, boolean bl, int n) {
            this(hsqlNameManager, n);
            this.rename(string2, bl);
        }

        private HsqlName(HsqlNameManager hsqlNameManager, String string2, int n, boolean bl) {
            this(hsqlNameManager, n);
            this.name = string2;
            this.statementName = string2;
            this.isNameQuoted = bl;
            if (this.isNameQuoted) {
                this.statementName = StringConverter.toQuotedString(string2, '\"', true);
            }
        }

        @Override
        public String getStatementName() {
            return this.statementName;
        }

        public String getSchemaQualifiedStatementName() {
            switch (this.type) {
                case 22: 
                case 23: {
                    return this.statementName;
                }
                case 9: 
                case 30: {
                    if (this.parent == null || "SYSTEM_SUBQUERY".equals(this.parent.name)) {
                        return this.statementName;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    if (this.schema != null) {
                        stringBuilder.append(this.schema.getStatementName());
                        stringBuilder.append('.');
                    }
                    stringBuilder.append(this.parent.getStatementName());
                    stringBuilder.append('.');
                    stringBuilder.append(this.statementName);
                    return stringBuilder.toString();
                }
            }
            if (this.schema == null || "SYSTEM_SCHEMA".equals(this.schema.name)) {
                return this.statementName;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.schema.getStatementName());
            stringBuilder.append('.');
            stringBuilder.append(this.statementName);
            return stringBuilder.toString();
        }

        public void rename(HsqlName hsqlName) {
            this.rename(hsqlName.name, hsqlName.isNameQuoted);
        }

        public void rename(String string2, boolean bl) {
            if (this.manager.sqlRegularNames && string2.length() > 128) {
                throw Error.error(5501, string2);
            }
            this.statementName = this.name = string2;
            this.isNameQuoted = bl;
            if (this.isNameQuoted) {
                this.statementName = StringConverter.toQuotedString(string2, '\"', true);
            }
            if (string2.startsWith("SYS_")) {
                int n = string2.lastIndexOf(95) + 1;
                try {
                    int n2 = Integer.parseInt(string2.substring(n));
                    if ((long)n2 > this.manager.sysNumber.get()) {
                        this.manager.sysNumber.set(n2);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        void rename(String string2, String string3, boolean bl) {
            StringBuilder stringBuilder = new StringBuilder(string2);
            stringBuilder.append('_');
            stringBuilder.append(string3);
            this.rename(stringBuilder.toString(), bl);
        }

        public void setSchemaIfNull(HsqlName hsqlName) {
            if (this.schema == null) {
                this.schema = hsqlName;
            }
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof HsqlName) {
                return this.hashCode == ((HsqlName)object).hashCode;
            }
            if (object instanceof SimpleName) {
                return super.equals(object);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (int)(this.hashCode ^ this.hashCode >>> 32);
        }

        static int sysPrefixLength(String string2) {
            for (int i = 0; i < sysPrefixes.length; ++i) {
                if (!string2.startsWith(sysPrefixes[i])) continue;
                return sysPrefixes[i].length();
            }
            return 0;
        }

        static boolean isReservedName(String string2) {
            return HsqlName.sysPrefixLength(string2) > 0;
        }

        boolean isReservedName() {
            return HsqlName.isReservedName(this.name);
        }

        public String toString() {
            return this.getClass().getName() + super.hashCode() + "[this.hashCode()=" + this.hashCode + ", name=" + this.name + ", name.hashCode()=" + this.name.hashCode() + ", isNameQuoted=" + this.isNameQuoted + "]";
        }

        static boolean isRegularIdentifier(String string2) {
            int n = string2.length();
            for (int i = 0; i < n; ++i) {
                char c = string2.charAt(i);
                if (c >= 'A' && c <= 'Z' || c == '_' && i > 0 || c >= '0' && c <= '9') continue;
                return false;
            }
            return !Tokens.isKeyword(string2);
        }
    }

    public static class SimpleName {
        public String name;
        public boolean isNameQuoted;

        private SimpleName() {
        }

        private SimpleName(String string2, boolean bl) {
            this.name = string2;
            this.isNameQuoted = bl;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof SimpleName) {
                return ((SimpleName)object).name.equals(this.name);
            }
            return false;
        }

        public String getStatementName() {
            return this.isNameQuoted ? StringConverter.toQuotedString(this.name, '\"', true) : this.name;
        }

        public String getNameString() {
            return this.name;
        }
    }
}

