/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.sql.Clob;
import java.sql.SQLException;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.ClobInputStream;

public class JDBCClobClient
implements Clob {
    ClobDataID originalClob;
    ClobDataID clob;
    SessionInterface session;
    int colIndex;
    private boolean isClosed;
    private boolean isWritable;
    JDBCResultSet resultSet;

    @Override
    public synchronized InputStream getAsciiStream() throws SQLException {
        this.checkClosed();
        return new InputStream(){
            private final byte[] oneChar = new byte[1];
            private boolean m_closed;
            private CharBuffer m_charBuffer = (CharBuffer)CharBuffer.allocate(65536).flip();
            private ByteBuffer m_byteBuffer = ByteBuffer.allocate(1024);
            private Charset m_charset = JDBCClobClient.charsetForName("US-ASCII");
            private CharsetEncoder m_encoder = this.m_charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            private Reader m_reader;
            {
                this.m_reader = JDBCClobClient.this.clob.getCharacterStream(JDBCClobClient.this.session);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read() throws IOException {
                if (this.isEOF()) {
                    return -1;
                }
                byte[] byArray = this.oneChar;
                synchronized (this.oneChar) {
                    int n = this.read(this.oneChar, 0, 1);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return n == 1 ? this.oneChar[0] : -1;
                }
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                this.checkClosed();
                if (this.isEOF()) {
                    return -1;
                }
                CharBuffer charBuffer = this.m_charBuffer;
                if (charBuffer.remaining() == 0) {
                    charBuffer.clear();
                    int n3 = this.m_reader.read(charBuffer);
                    charBuffer.flip();
                    if (n3 < 0) {
                        this.setEOF();
                        return -1;
                    }
                    if (n3 == 0) {
                        return 0;
                    }
                }
                ByteBuffer byteBuffer = this.m_byteBuffer.capacity() < n2 ? ByteBuffer.allocate(n2) : this.m_byteBuffer;
                int n4 = charBuffer.limit();
                int n5 = charBuffer.position();
                charBuffer.limit(n5 + n2);
                byteBuffer.clear();
                int n6 = byteBuffer.position();
                CoderResult coderResult = this.m_encoder.encode(charBuffer, byteBuffer, false);
                if (n6 == byteBuffer.position() && coderResult.isUnderflow()) {
                    charBuffer.limit(charBuffer.limit() + 1);
                    this.m_encoder.encode(charBuffer, byteBuffer, false);
                }
                charBuffer.limit(n4);
                byteBuffer.flip();
                int n7 = byteBuffer.limit();
                if (n7 == 0) {
                    this.setEOF();
                    return -1;
                }
                this.m_byteBuffer = byteBuffer;
                byteBuffer.get(byArray, n, n7);
                return n7;
            }

            @Override
            public void close() throws IOException {
                boolean bl = this.m_closed;
                if (!bl) {
                    this.m_closed = true;
                    this.m_charBuffer = null;
                    this.m_charset = null;
                    this.m_encoder = null;
                    try {
                        this.m_reader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }

            private boolean isEOF() {
                Reader reader = this.m_reader;
                return reader == null;
            }

            private void setEOF() {
                Reader reader = this.m_reader;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.m_reader = null;
            }

            private void checkClosed() throws IOException {
                if (JDBCClobClient.this.isClosed()) {
                    try {
                        this.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.m_closed) {
                    throw new IOException("The stream is closed.");
                }
            }
        };
    }

    @Override
    public synchronized Reader getCharacterStream() throws SQLException {
        this.checkClosed();
        return new ClobInputStream(this.session, this.clob, 0L, this.length());
    }

    @Override
    public synchronized String getSubString(long l, int n) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, l - 1L, n)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            return this.clob.getSubString(this.session, l - 1L, n);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized long length() throws SQLException {
        this.checkClosed();
        try {
            return this.clob.length(this.session);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized long position(String string2, long l) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, l - 1L, 0L)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            return this.clob.position(this.session, string2, l - 1L);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized long position(Clob clob, long l) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, l - 1L, 0L)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (clob instanceof JDBCClobClient) {
            ClobDataID clobDataID = ((JDBCClobClient)clob).clob;
            try {
                return this.clob.position(this.session, clobDataID, l - 1L);
            }
            catch (HsqlException hsqlException) {
                throw JDBCUtil.sqlException(hsqlException);
            }
        }
        return this.position(clob.getSubString(1L, (int)clob.length()), l);
    }

    @Override
    public synchronized OutputStream setAsciiStream(final long l) throws SQLException {
        this.checkClosed();
        if (l < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        if (!this.isWritable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        this.startUpdate();
        return new OutputStream(){
            private long m_position;
            private Charset m_charset;
            private CharsetDecoder m_decoder;
            private CharBuffer m_charBuffer;
            private ByteBuffer m_byteBuffer;
            private final byte[] oneByte;
            private boolean m_closed;
            {
                this.m_position = l - 1L;
                this.m_charset = JDBCClobClient.charsetForName("US-ASCII");
                this.m_decoder = this.m_charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
                this.m_charBuffer = CharBuffer.allocate(65536);
                this.m_byteBuffer = ByteBuffer.allocate(1024);
                this.oneByte = new byte[1];
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(int n) throws IOException {
                byte[] byArray = this.oneByte;
                synchronized (this.oneByte) {
                    this.oneByte[0] = (byte)n;
                    this.write(this.oneByte, 0, 1);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                ByteBuffer byteBuffer;
                this.checkClosed();
                ByteBuffer byteBuffer2 = byteBuffer = this.m_byteBuffer.capacity() < n2 ? ByteBuffer.allocate(n2) : this.m_byteBuffer;
                if (this.m_charBuffer.remaining() < n2) {
                    this.flush0();
                }
                CharBuffer charBuffer = this.m_charBuffer.capacity() < n2 ? CharBuffer.allocate(n2) : this.m_charBuffer;
                byteBuffer.clear();
                byteBuffer.put(byArray, n, n2);
                byteBuffer.flip();
                this.m_decoder.decode(byteBuffer, charBuffer, false);
                if (charBuffer.remaining() == 0) {
                    this.flush();
                }
            }

            @Override
            public void flush() throws IOException {
                this.checkClosed();
                this.flush0();
            }

            @Override
            public void close() throws IOException {
                if (!this.m_closed) {
                    try {
                        this.flush0();
                    }
                    finally {
                        this.m_closed = true;
                        this.m_byteBuffer = null;
                        this.m_charBuffer = null;
                        this.m_charset = null;
                        this.m_decoder = null;
                    }
                }
            }

            private void checkClosed() throws IOException {
                if (JDBCClobClient.this.isClosed()) {
                    try {
                        this.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.m_closed) {
                    throw new IOException("The stream is closed.");
                }
            }

            private void flush0() throws IOException {
                CharBuffer charBuffer = this.m_charBuffer;
                charBuffer.flip();
                char[] cArray = new char[charBuffer.length()];
                charBuffer.get(cArray);
                charBuffer.clear();
                try {
                    JDBCClobClient.this.clob.setChars(JDBCClobClient.this.session, this.m_position, cArray, 0, cArray.length);
                }
                catch (Exception exception) {
                    throw new IOException(exception.toString());
                }
                this.m_position += (long)cArray.length;
            }
        };
    }

    @Override
    public synchronized Writer setCharacterStream(final long l) throws SQLException {
        this.checkClosed();
        if (l < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        if (!this.isWritable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        this.startUpdate();
        return new Writer(){
            private long m_clobPosition;
            private boolean m_closed;
            {
                this.m_clobPosition = l - 1L;
            }

            @Override
            public void write(char[] cArray, int n, int n2) throws IOException {
                this.checkClosed();
                JDBCClobClient.this.clob.setChars(JDBCClobClient.this.session, this.m_clobPosition, cArray, n, n2);
                this.m_clobPosition += (long)n2;
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
                this.m_closed = true;
            }

            private void checkClosed() throws IOException {
                if (this.m_closed || JDBCClobClient.this.isClosed()) {
                    throw new IOException("The stream is closed");
                }
            }
        };
    }

    @Override
    public synchronized int setString(long l, String string2) throws SQLException {
        return this.setString(l, string2, 0, string2.length());
    }

    @Override
    public synchronized int setString(long l, String string2, int n, int n2) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(string2.length(), n, n2)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (l < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        if (!this.isWritable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        this.startUpdate();
        string2 = string2.substring(n, n + n2);
        try {
            this.clob.setString(this.session, l - 1L, string2);
            return n2;
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void truncate(long l) throws SQLException {
        this.checkClosed();
        if (l < 0L) {
            throw JDBCUtil.outOfRangeArgument("len: " + l);
        }
        try {
            this.clob.truncate(this.session, l);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void free() throws SQLException {
        this.isClosed = true;
        this.clob = null;
        this.session = null;
    }

    @Override
    public synchronized Reader getCharacterStream(long l, long l2) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(this.length(), l - 1L, l2)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        return new ClobInputStream(this.session, this.clob, l - 1L, l2);
    }

    char[] getChars(long l, int n) throws SQLException {
        try {
            return this.clob.getChars(this.session, l - 1L, n);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    public JDBCClobClient(SessionInterface sessionInterface, ClobDataID clobDataID) {
        this.session = sessionInterface;
        this.clob = clobDataID;
    }

    public ClobDataID getClob() {
        return this.clob;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized void setWritable(JDBCResultSet jDBCResultSet, int n) {
        this.isWritable = true;
        this.resultSet = jDBCResultSet;
        this.colIndex = n;
    }

    public synchronized void clearUpdates() {
        if (this.originalClob != null) {
            this.clob = this.originalClob;
            this.originalClob = null;
        }
    }

    private void startUpdate() throws SQLException {
        if (this.originalClob != null) {
            return;
        }
        this.originalClob = this.clob;
        this.clob = (ClobDataID)this.clob.duplicate(this.session);
        this.resultSet.startUpdate(this.colIndex + 1);
        this.resultSet.preparedStatement.parameterValues[this.colIndex] = this.clob;
        this.resultSet.preparedStatement.parameterSet[this.colIndex] = Boolean.TRUE;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw JDBCUtil.sqlException(1852);
        }
    }

    static boolean isInLimits(long l, long l2, long l3) {
        return l >= 0L && l2 >= 0L && l3 >= 0L && l2 <= l - l3;
    }

    protected static Charset charsetForName(String string2) throws SQLException {
        String string3 = string2;
        if (string3 == null) {
            string3 = Charset.defaultCharset().name();
        }
        try {
            if (Charset.isSupported(string3)) {
                return Charset.forName(string3);
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        throw JDBCUtil.sqlException(new UnsupportedEncodingException(string3));
    }
}

