/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.hsqldb.ClientConnection;
import org.hsqldb.ClientConnectionHTTP;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.JDBCCallableStatement;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCConnectionEventListener;
import org.hsqldb.jdbc.JDBCDatabaseMetaData;
import org.hsqldb.jdbc.JDBCNClob;
import org.hsqldb.jdbc.JDBCPreparedStatement;
import org.hsqldb.jdbc.JDBCSQLXML;
import org.hsqldb.jdbc.JDBCSavepoint;
import org.hsqldb.jdbc.JDBCStatement;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.result.ResultProperties;
import org.hsqldb.types.Type;

public class JDBCConnection
implements Connection {
    int rsHoldability = 1;
    HsqlProperties connProperties;
    HsqlProperties clientProperties;
    SessionInterface sessionProxy;
    boolean isInternal;
    protected boolean isNetConn;
    boolean isClosed;
    private SQLWarning rootWarning;
    private final Object rootWarning_mutex = new Object();
    private int savepointIDSequence;
    int incarnation;
    boolean isPooled;
    JDBCConnectionEventListener poolEventListener;
    boolean isCloseResultSet;
    boolean isUseColumnName = true;
    boolean isTranslateTTIType = true;
    boolean isEmptyBatchAllowed = false;
    boolean isStoreLiveObject = false;

    @Override
    public synchronized Statement createStatement() throws SQLException {
        this.checkClosed();
        int n = ResultProperties.getValueForJDBC(1003, 1007, this.rsHoldability);
        JDBCStatement jDBCStatement = new JDBCStatement(this, n);
        return jDBCStatement;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string2) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string2, 1003, 1007, this.rsHoldability, 2, null, null);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String string2) throws SQLException {
        this.checkClosed();
        try {
            JDBCCallableStatement jDBCCallableStatement = new JDBCCallableStatement(this, string2, 1003, 1007, this.rsHoldability);
            return jDBCCallableStatement;
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized String nativeSQL(String string2) throws SQLException {
        this.checkClosed();
        if (string2 == null || string2.length() == 0 || string2.indexOf(123) == -1) {
            return string2;
        }
        boolean bl = false;
        int n = 0;
        int n2 = string2.length();
        int n3 = 0;
        StringBuilder stringBuilder = null;
        int n4 = 0;
        block6: for (int i = 0; i < n2; ++i) {
            char c = string2.charAt(i);
            switch (n) {
                case 0: {
                    if (c == '\'') {
                        n = 1;
                        continue block6;
                    }
                    if (c == '\"') {
                        n = 2;
                        continue block6;
                    }
                    if (c != '{') continue block6;
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(string2.length());
                    }
                    stringBuilder.append(string2, n4, i);
                    n4 = i = this.onStartEscapeSequence(string2, stringBuilder, i);
                    bl = true;
                    ++n3;
                    n = 3;
                    continue block6;
                }
                case 1: 
                case 4: {
                    if (c != '\'') continue block6;
                    --n;
                    continue block6;
                }
                case 2: 
                case 5: {
                    if (c != '\"') continue block6;
                    n -= 2;
                    continue block6;
                }
                case 3: {
                    if (c == '\'') {
                        n = 4;
                        continue block6;
                    }
                    if (c == '\"') {
                        n = 5;
                        continue block6;
                    }
                    if (c == '}') {
                        stringBuilder.append(string2, n4, i);
                        stringBuilder.append(' ');
                        n4 = ++i;
                        bl = true;
                        n = --n3 == 0 ? 0 : 3;
                        continue block6;
                    }
                    if (c != '{') continue block6;
                    stringBuilder.append(string2, n4, i);
                    n4 = i = this.onStartEscapeSequence(string2, stringBuilder, i);
                    bl = true;
                    ++n3;
                    n = 3;
                    continue block6;
                }
            }
        }
        if (!bl) {
            return string2;
        }
        stringBuilder.append(string2.substring(n4, string2.length()));
        return stringBuilder.toString();
    }

    @Override
    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setAutoCommit(bl);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.isAutoCommit();
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void commit() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.commit(false);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.rollback(false);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isInternal || this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.rootWarning = null;
        this.connProperties = null;
        if (this.isPooled) {
            if (this.poolEventListener != null) {
                this.poolEventListener.connectionClosed();
                this.poolEventListener = null;
            }
        } else if (this.sessionProxy != null) {
            this.sessionProxy.close();
            this.sessionProxy = null;
        }
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new JDBCDatabaseMetaData(this);
    }

    @Override
    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setReadOnlyDefault(bl);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.isReadOnlyDefault();
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void setCatalog(String string2) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setAttribute(3, string2);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized String getCatalog() throws SQLException {
        this.checkClosed();
        try {
            return (String)this.sessionProxy.getAttribute(3);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void setTransactionIsolation(int n) throws SQLException {
        this.checkClosed();
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw JDBCUtil.invalidArgument();
            }
        }
        try {
            this.sessionProxy.setIsolationDefault(n);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.getIsolation();
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.rootWarning;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
    }

    @Override
    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        this.checkClosed();
        int n3 = ResultProperties.getValueForJDBC(n, n2, this.rsHoldability);
        return new JDBCStatement(this, n3);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string2, int n, int n2) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string2, n, n2, this.rsHoldability, 2, null, null);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String string2, int n, int n2) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCCallableStatement(this, string2, n, n2, this.rsHoldability);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkClosed();
        return new HashMap();
    }

    @Override
    public synchronized void setTypeMap(Map<String, Class<?>> map23) throws SQLException {
        this.checkClosed();
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void setHoldability(int n) throws SQLException {
        this.checkClosed();
        switch (n) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw JDBCUtil.invalidArgument();
            }
        }
        this.rsHoldability = n;
    }

    @Override
    public synchronized int getHoldability() throws SQLException {
        this.checkClosed();
        return this.rsHoldability;
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw JDBCUtil.sqlException(4821);
        }
        JDBCSavepoint jDBCSavepoint = new JDBCSavepoint(this);
        try {
            this.sessionProxy.savepoint(jDBCSavepoint.name);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
        return jDBCSavepoint;
    }

    @Override
    public synchronized Savepoint setSavepoint(String string2) throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw JDBCUtil.sqlException(4821);
        }
        if (string2 == null) {
            throw JDBCUtil.nullArgument();
        }
        if (string2.startsWith("SYSTEM_SAVEPOINT_")) {
            throw JDBCUtil.invalidArgument();
        }
        try {
            this.sessionProxy.savepoint(string2);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
        return new JDBCSavepoint(string2, this);
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            throw JDBCUtil.nullArgument();
        }
        if (!(savepoint instanceof JDBCSavepoint)) {
            throw JDBCUtil.invalidArgument(4821);
        }
        JDBCSavepoint jDBCSavepoint = (JDBCSavepoint)savepoint;
        if (jDBCSavepoint.name == null) {
            throw JDBCUtil.invalidArgument(4821);
        }
        if (this != jDBCSavepoint.connection) {
            throw JDBCUtil.invalidArgument(4821);
        }
        if (this.getAutoCommit()) {
            jDBCSavepoint.name = null;
            jDBCSavepoint.connection = null;
            throw JDBCUtil.sqlException(4821);
        }
        try {
            this.sessionProxy.rollbackToSavepoint(jDBCSavepoint.name);
            jDBCSavepoint.connection = null;
            jDBCSavepoint.name = null;
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            throw JDBCUtil.nullArgument();
        }
        if (!(savepoint instanceof JDBCSavepoint)) {
            throw JDBCUtil.invalidArgument(4821);
        }
        JDBCSavepoint jDBCSavepoint = (JDBCSavepoint)savepoint;
        if (jDBCSavepoint.name == null) {
            throw JDBCUtil.invalidArgument(4821);
        }
        if (this != jDBCSavepoint.connection) {
            throw JDBCUtil.invalidArgument(4821);
        }
        if (this.getAutoCommit()) {
            jDBCSavepoint.name = null;
            jDBCSavepoint.connection = null;
            throw JDBCUtil.invalidArgument(4821);
        }
        try {
            this.sessionProxy.releaseSavepoint(jDBCSavepoint.name);
            jDBCSavepoint.connection = null;
            jDBCSavepoint.name = null;
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        int n4 = ResultProperties.getValueForJDBC(n, n2, n3);
        return new JDBCStatement(this, n4);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string2, int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string2, n, n2, n3, 2, null, null);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String string2, int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCCallableStatement(this, string2, n, n2, n3);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string2, int n) throws SQLException {
        this.checkClosed();
        try {
            if (n != 1 && n != 2) {
                throw JDBCUtil.invalidArgument("autoGeneratedKeys");
            }
            return new JDBCPreparedStatement(this, string2, 1003, 1007, this.rsHoldability, n, null, null);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string2, int[] nArray) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string2, 1003, 1007, this.rsHoldability, 21, nArray, null);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string2, String[] stringArray) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string2, 1003, 1007, this.rsHoldability, 11, null, stringArray);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        return new JDBCClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        return new JDBCBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        return new JDBCNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        return new JDBCSQLXML();
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        if (n < 0) {
            throw JDBCUtil.outOfRangeArgument("timeout: " + n);
        }
        if (this.isInternal) {
            return true;
        }
        if (!this.isNetConn) {
            return !this.isClosed();
        }
        if (this.isClosed()) {
            return false;
        }
        final boolean[] blArray = new boolean[]{true};
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    JDBCConnection.this.getMetaData().getDatabaseMajorVersion();
                }
                catch (Throwable throwable) {
                    blArray[0] = false;
                }
            }
        };
        if (n > 60) {
            n = 60;
        }
        n *= 1000;
        try {
            thread.start();
            long l = System.currentTimeMillis();
            thread.join(n);
            try {
                thread.setContextClassLoader(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (n == 0) {
                return blArray[0];
            }
            return blArray[0] && System.currentTimeMillis() - l < (long)n;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public void setClientInfo(String string2, String string3) throws SQLClientInfoException {
        SQLClientInfoException sQLClientInfoException = new SQLClientInfoException();
        sQLClientInfoException.initCause(JDBCUtil.notSupported());
        throw sQLClientInfoException;
    }

    @Override
    public void setClientInfo(Properties properties2) throws SQLClientInfoException {
        if (!this.isClosed && (properties2 == null || properties2.isEmpty())) {
            return;
        }
        SQLClientInfoException sQLClientInfoException = new SQLClientInfoException();
        if (this.isClosed) {
            sQLClientInfoException.initCause(JDBCUtil.connectionClosedException());
        } else {
            sQLClientInfoException.initCause(JDBCUtil.notSupported());
        }
        throw sQLClientInfoException;
    }

    @Override
    public String getClientInfo(String string2) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Array createArrayOf(String string2, Object[] objectArray) throws SQLException {
        this.checkClosed();
        if (string2 == null) {
            throw JDBCUtil.nullArgument();
        }
        int n = Type.getTypeNr(string2 = string2.toUpperCase());
        if (n == Integer.MIN_VALUE) {
            throw JDBCUtil.invalidArgument(string2);
        }
        Type type = Type.getDefaultType(n);
        if (type.isArrayType() || type.isLobType() || type.isRowType()) {
            throw JDBCUtil.invalidArgument(string2);
        }
        Object[] objectArray2 = new Object[objectArray.length];
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = type.convertJavaToSQL(this.sessionProxy, objectArray[i]);
                objectArray2[i] = type.convertToTypeLimits(this.sessionProxy, object);
            }
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
        return new JDBCArray(objectArray2, type, this);
    }

    @Override
    public Struct createStruct(String string2, Object[] objectArray) throws SQLException {
        this.checkClosed();
        throw JDBCUtil.notSupported();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        this.checkClosed();
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        this.checkClosed();
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public void setSchema(String string2) throws SQLException {
        this.checkClosed();
        if (string2 == null) {
            throw JDBCUtil.nullArgument("schema");
        }
        if (string2.length() == 0) {
            throw JDBCUtil.invalidArgument("Zero-length schema");
        }
        new JDBCDatabaseMetaData(this).setConnectionDefaultSchema(string2);
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return new JDBCDatabaseMetaData(this).getConnectionDefaultSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw JDBCUtil.nullArgument("executor");
        }
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        this.checkClosed();
        throw JDBCUtil.notSupported();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    public JDBCConnection(HsqlProperties hsqlProperties) throws SQLException {
        String string2 = hsqlProperties.getProperty("user");
        String string3 = hsqlProperties.getProperty("password");
        String string4 = hsqlProperties.getProperty("connection_type");
        String string5 = hsqlProperties.getProperty("host");
        int n = hsqlProperties.getIntegerProperty("port", 0);
        String string6 = hsqlProperties.getProperty("path");
        String string7 = hsqlProperties.getProperty("database");
        boolean bl = "hsqls://".equals(string4) || "https://".equals(string4);
        boolean bl2 = hsqlProperties.isPropertyTrue("tls_wrapper", false);
        bl2 &= bl;
        if (string2 == null) {
            string2 = "SA";
        }
        if (string3 == null) {
            string3 = "";
        }
        Calendar calendar = Calendar.getInstance();
        int n2 = HsqlDateTime.getZoneSeconds(calendar);
        try {
            if (DatabaseURL.isInProcessDatabaseType(string4)) {
                this.sessionProxy = DatabaseManager.newSession(string4, string7, string2, string3, hsqlProperties, null, n2);
            } else if ("hsql://".equals(string4) || "hsqls://".equals(string4)) {
                this.sessionProxy = new ClientConnection(string5, n, string6, string7, bl, bl2, string2, string3, n2);
                this.isNetConn = true;
            } else if ("http://".equals(string4) || "https://".equals(string4)) {
                this.sessionProxy = new ClientConnectionHTTP(string5, n, string6, string7, bl, bl2, string2, string3, n2);
                this.isNetConn = true;
            } else {
                throw JDBCUtil.invalidArgument(string4);
            }
            this.sessionProxy.setJDBCConnection(this);
            this.connProperties = hsqlProperties;
            this.clientProperties = this.sessionProxy.getClientProperties();
            this.setLocalVariables();
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    public JDBCConnection(SessionInterface sessionInterface) {
        this.isInternal = true;
        this.sessionProxy = sessionInterface;
    }

    public JDBCConnection(JDBCConnection jDBCConnection, JDBCConnectionEventListener jDBCConnectionEventListener) {
        this.sessionProxy = jDBCConnection.sessionProxy;
        this.connProperties = jDBCConnection.connProperties;
        this.clientProperties = jDBCConnection.clientProperties;
        this.isPooled = true;
        this.poolEventListener = jDBCConnectionEventListener;
        this.setLocalVariables();
    }

    private void setLocalVariables() {
        String string2;
        if (this.connProperties == null) {
            return;
        }
        this.isCloseResultSet = this.connProperties.isPropertyTrue("close_result", false);
        this.isUseColumnName = this.connProperties.isPropertyTrue("get_column_name", true);
        this.isEmptyBatchAllowed = this.connProperties.isPropertyTrue("allow_empty_batch", false);
        this.isTranslateTTIType = this.clientProperties.isPropertyTrue("jdbc.translate_tti_types", true);
        this.isStoreLiveObject = this.clientProperties.isPropertyTrue("sql.live_object", false);
        if (this.isStoreLiveObject && !"mem:".equals(string2 = this.connProperties.getProperty("connection_type"))) {
            this.isStoreLiveObject = false;
        }
    }

    synchronized int getSavepointID() {
        return this.savepointIDSequence++;
    }

    synchronized String getURL() throws SQLException {
        this.checkClosed();
        return this.isInternal ? this.sessionProxy.getInternalConnectionURL() : this.connProperties.getProperty("url");
    }

    synchronized void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw JDBCUtil.connectionClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWarning(SQLWarning sQLWarning) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            if (this.rootWarning == null) {
                this.rootWarning = sQLWarning;
            } else {
                this.rootWarning.setNextWarning(sQLWarning);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWarnings(SQLWarning sQLWarning) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            this.rootWarning = sQLWarning;
        }
    }

    public void reset() throws SQLException {
        try {
            ++this.incarnation;
            this.sessionProxy.resetSession();
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(1305, hsqlException.getMessage(), hsqlException);
        }
    }

    public void closeFully() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.sessionProxy != null) {
                this.sessionProxy.close();
                this.sessionProxy = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public SessionInterface getSession() {
        return this.sessionProxy;
    }

    private int onStartEscapeSequence(String string2, StringBuilder stringBuilder, int n) throws SQLException {
        stringBuilder.append(' ');
        ++n;
        n = StringUtil.skipSpaces(string2, n);
        if (string2.regionMatches(true, n, "fn ", 0, 3) || string2.regionMatches(true, n, "oj ", 0, 3)) {
            n += 2;
        } else if (string2.regionMatches(true, n, "ts ", 0, 3)) {
            stringBuilder.append("TIMESTAMP");
            n += 2;
        } else if (string2.regionMatches(true, n, "d ", 0, 2)) {
            stringBuilder.append("DATE");
            ++n;
        } else if (string2.regionMatches(true, n, "t ", 0, 2)) {
            stringBuilder.append("TIME");
            ++n;
        } else if (string2.regionMatches(true, n, "call ", 0, 5)) {
            stringBuilder.append("CALL");
            n += 4;
        } else if (string2.regionMatches(true, n, "?= call ", 0, 8)) {
            stringBuilder.append("CALL");
            n += 7;
        } else if (string2.regionMatches(true, n, "? = call ", 0, 8)) {
            stringBuilder.append("CALL");
            n += 8;
        } else if (string2.regionMatches(true, n, "escape ", 0, 7)) {
            n += 6;
        } else {
            throw JDBCUtil.sqlException(425, string2.substring(--n));
        }
        return n;
    }
}

