/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.map;

import org.hsqldb.map.BaseHashMap;
import org.hsqldb.types.TimestampData;

public class ValuePoolHashMap
extends BaseHashMap {
    long hits;

    public ValuePoolHashMap(int n, int n2, int n3) throws IllegalArgumentException {
        super(n, 3, 0, true);
        this.maxCapacity = n2;
        this.purgePolicy = n3;
    }

    protected Integer getOrAddInteger(int n) {
        Integer n2;
        int n3 = this.hashIndex.getHashIndex(n);
        int n4 = this.hashIndex.hashTable[n3];
        int n5 = -1;
        while (n4 >= 0) {
            n2 = (Integer)this.objectKeyTable[n4];
            int n6 = n2;
            if (n6 == n) {
                if (this.accessCount > 0x7FEFFFFF) {
                    this.resetAccessCount();
                }
                ++this.accessCount;
                ++this.hits;
                return n2;
            }
            if (n6 > n) break;
            n5 = n4;
            n4 = this.hashIndex.getNextLookup(n4);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddInteger(n);
        }
        n4 = this.hashIndex.linkNode(n3, n5);
        n2 = n;
        this.objectKeyTable[n4] = n2;
        if (this.accessCount > 0x7FEFFFFF) {
            this.resetAccessCount();
        }
        ++this.accessCount;
        return n2;
    }

    protected Long getOrAddLong(long l) {
        Long l2;
        int n = this.hashIndex.getHashIndex((int)(l ^ l >>> 32));
        int n2 = this.hashIndex.hashTable[n];
        int n3 = -1;
        while (n2 >= 0) {
            l2 = (Long)this.objectKeyTable[n2];
            long l3 = l2;
            if (l3 == l) {
                if (this.accessCount > 0x7FEFFFFF) {
                    this.resetAccessCount();
                }
                ++this.accessCount;
                return l2;
            }
            if (l3 > l) break;
            n3 = n2;
            n2 = this.hashIndex.getNextLookup(n2);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddLong(l);
        }
        n2 = this.hashIndex.linkNode(n, n3);
        l2 = l;
        this.objectKeyTable[n2] = l2;
        if (this.accessCount > 0x7FEFFFFF) {
            this.resetAccessCount();
        }
        ++this.accessCount;
        return l2;
    }

    protected String getOrAddString(Object object) {
        String string2;
        int n = this.hashIndex.getHashIndex(object.hashCode());
        int n2 = this.hashIndex.hashTable[n];
        int n3 = -1;
        while (n2 >= 0) {
            string2 = (String)this.objectKeyTable[n2];
            if (object.equals(string2)) {
                if (this.accessCount > 0x7FEFFFFF) {
                    this.resetAccessCount();
                }
                ++this.accessCount;
                return string2;
            }
            n3 = n2;
            n2 = this.hashIndex.getNextLookup(n2);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddString(object);
        }
        string2 = object.toString();
        n2 = this.hashIndex.linkNode(n, n3);
        this.objectKeyTable[n2] = string2;
        if (this.accessCount > 0x7FEFFFFF) {
            this.resetAccessCount();
        }
        ++this.accessCount;
        return string2;
    }

    protected String getOrAddSubString(String string2, int n, int n2) {
        String string3;
        string2 = string2.substring(n, n2);
        int n3 = this.hashIndex.getHashIndex(string2.hashCode());
        int n4 = this.hashIndex.hashTable[n3];
        int n5 = -1;
        while (n4 >= 0) {
            string3 = (String)this.objectKeyTable[n4];
            if (string2.equals(string3)) {
                if (this.accessCount > 0x7FEFFFFF) {
                    this.resetAccessCount();
                }
                ++this.accessCount;
                return string3;
            }
            n5 = n4;
            n4 = this.hashIndex.getNextLookup(n4);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddString(string2);
        }
        string3 = new String(string2.toCharArray());
        n4 = this.hashIndex.linkNode(n3, n5);
        this.objectKeyTable[n4] = string3;
        if (this.accessCount > 0x7FEFFFFF) {
            this.resetAccessCount();
        }
        ++this.accessCount;
        return string3;
    }

    protected TimestampData getOrAddDate(long l) {
        TimestampData timestampData;
        int n = (int)l ^ (int)(l >>> 32);
        int n2 = this.hashIndex.getHashIndex(n);
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        while (n3 >= 0) {
            timestampData = (TimestampData)this.objectKeyTable[n3];
            if (timestampData.getSeconds() == l) {
                if (this.accessCount > 0x7FEFFFFF) {
                    this.resetAccessCount();
                }
                ++this.accessCount;
                return timestampData;
            }
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddDate(l);
        }
        n3 = this.hashIndex.linkNode(n2, n4);
        timestampData = new TimestampData(l);
        this.objectKeyTable[n3] = timestampData;
        if (this.accessCount > 0x7FEFFFFF) {
            this.resetAccessCount();
        }
        ++this.accessCount;
        return timestampData;
    }

    protected Double getOrAddDouble(long l) {
        Double d;
        int n = this.hashIndex.getHashIndex((int)(l ^ l >>> 32));
        int n2 = this.hashIndex.hashTable[n];
        int n3 = -1;
        while (n2 >= 0) {
            d = (Double)this.objectKeyTable[n2];
            if (Double.doubleToLongBits(d) == l) {
                if (this.accessCount > 0x7FEFFFFF) {
                    this.resetAccessCount();
                }
                ++this.accessCount;
                return d;
            }
            n3 = n2;
            n2 = this.hashIndex.getNextLookup(n2);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddDouble(l);
        }
        n2 = this.hashIndex.linkNode(n, n3);
        d = Double.longBitsToDouble(l);
        this.objectKeyTable[n2] = d;
        if (this.accessCount > 0x7FEFFFFF) {
            this.resetAccessCount();
        }
        ++this.accessCount;
        return d;
    }

    protected Object getOrAddObject(Object object) {
        int n = this.hashIndex.getHashIndex(object.hashCode());
        int n2 = this.hashIndex.hashTable[n];
        int n3 = -1;
        while (n2 >= 0) {
            Object object2 = this.objectKeyTable[n2];
            if (object2.equals(object)) {
                if (this.accessCount > 0x7FEFFFFF) {
                    this.resetAccessCount();
                }
                ++this.accessCount;
                return object2;
            }
            n3 = n2;
            n2 = this.hashIndex.getNextLookup(n2);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddObject(object);
        }
        n2 = this.hashIndex.linkNode(n, n3);
        this.objectKeyTable[n2] = object;
        if (this.accessCount > 0x7FEFFFFF) {
            this.resetAccessCount();
        }
        ++this.accessCount;
        return object;
    }
}

