/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class DecoratingClassLoader
extends ClassLoader {
    private final Set<String> excludedPackages = Collections.newSetFromMap(new ConcurrentHashMap(8));
    private final Set<String> excludedClasses = Collections.newSetFromMap(new ConcurrentHashMap(8));

    public DecoratingClassLoader() {
    }

    public DecoratingClassLoader(@Nullable ClassLoader parent) {
        super(parent);
    }

    public void excludePackage(String packageName) {
        Assert.notNull((Object)packageName, "Package name must not be null");
        this.excludedPackages.add(packageName);
    }

    public void excludeClass(String className2) {
        Assert.notNull((Object)className2, "Class name must not be null");
        this.excludedClasses.add(className2);
    }

    protected boolean isExcluded(String className2) {
        if (this.excludedClasses.contains(className2)) {
            return true;
        }
        for (String packageName : this.excludedPackages) {
            if (!className2.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

