/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.codec;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractDataBufferDecoder;
import org.springframework.core.codec.Hints;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferLimitException;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.core.io.buffer.LimitedDataBufferList;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.core.log.LogFormatUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;

public final class StringDecoder
extends AbstractDataBufferDecoder<String> {
    private static final DataBuffer END_FRAME = new DefaultDataBufferFactory().wrap(new byte[0]);
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final List<String> DEFAULT_DELIMITERS = Arrays.asList("\r\n", "\n");
    private final List<String> delimiters;
    private final boolean stripDelimiter;
    private final ConcurrentMap<Charset, List<byte[]>> delimitersCache = new ConcurrentHashMap<Charset, List<byte[]>>();

    private StringDecoder(List<String> delimiters, boolean stripDelimiter, MimeType ... mimeTypes) {
        super(mimeTypes);
        Assert.notEmpty(delimiters, "'delimiters' must not be empty");
        this.delimiters = new ArrayList<String>(delimiters);
        this.stripDelimiter = stripDelimiter;
    }

    @Override
    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return elementType.resolve() == String.class && super.canDecode(elementType, mimeType);
    }

    @Override
    public Flux<String> decode(Publisher<DataBuffer> input, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        List<byte[]> delimiterBytes = this.getDelimiterBytes(mimeType);
        Flux inputFlux = Flux.defer(() -> {
            if (this.getMaxInMemorySize() != -1) {
                LimitedDataBufferList limiter = new LimitedDataBufferList(this.getMaxInMemorySize());
                return Flux.from((Publisher)input).concatMapIterable(buffer -> this.splitOnDelimiter((DataBuffer)buffer, delimiterBytes, limiter)).bufferUntil(buffer -> buffer == END_FRAME).map(StringDecoder::joinUntilEndFrame).doOnDiscard(PooledDataBuffer.class, DataBufferUtils::release);
            }
            ConcatMapIterableDiscardWorkaroundCache cache = new ConcatMapIterableDiscardWorkaroundCache();
            return Flux.from((Publisher)input).concatMapIterable(buffer -> cache.addAll(this.splitOnDelimiter((DataBuffer)buffer, delimiterBytes, null))).doOnNext((Consumer)cache).doOnCancel((Runnable)cache).bufferUntil(buffer -> buffer == END_FRAME).map(StringDecoder::joinUntilEndFrame).doOnDiscard(PooledDataBuffer.class, DataBufferUtils::release);
        });
        return super.decode((Publisher<DataBuffer>)inputFlux, elementType, mimeType, hints);
    }

    private List<byte[]> getDelimiterBytes(@Nullable MimeType mimeType) {
        return this.delimitersCache.computeIfAbsent(StringDecoder.getCharset(mimeType), charset -> {
            ArrayList<byte[]> list = new ArrayList<byte[]>();
            for (String delimiter : this.delimiters) {
                byte[] bytes = delimiter.getBytes((Charset)charset);
                list.add(bytes);
            }
            return list;
        });
    }

    private List<DataBuffer> splitOnDelimiter(DataBuffer buffer, List<byte[]> delimiterBytes, @Nullable LimitedDataBufferList limiter) {
        ArrayList<DataBuffer> frames = new ArrayList<DataBuffer>();
        try {
            do {
                DataBuffer frame;
                int length = Integer.MAX_VALUE;
                byte[] matchingDelimiter = null;
                for (byte[] delimiter : delimiterBytes) {
                    int index2 = StringDecoder.indexOf(buffer, delimiter);
                    if (index2 < 0 || index2 >= length) continue;
                    length = index2;
                    matchingDelimiter = delimiter;
                }
                int readPosition = buffer.readPosition();
                if (matchingDelimiter != null) {
                    frame = this.stripDelimiter ? buffer.slice(readPosition, length) : buffer.slice(readPosition, length + matchingDelimiter.length);
                    buffer.readPosition(readPosition + length + matchingDelimiter.length);
                    frames.add(DataBufferUtils.retain(frame));
                    frames.add(END_FRAME);
                    if (limiter == null) continue;
                    limiter.add(frame);
                    limiter.clear();
                    continue;
                }
                frame = buffer.slice(readPosition, buffer.readableByteCount());
                buffer.readPosition(readPosition + buffer.readableByteCount());
                frames.add(DataBufferUtils.retain(frame));
                if (limiter == null) continue;
                limiter.add(frame);
            } while (buffer.readableByteCount() > 0);
        }
        catch (DataBufferLimitException ex) {
            if (limiter != null) {
                limiter.releaseAndClear();
            }
            throw ex;
        }
        catch (Throwable ex) {
            for (DataBuffer frame : frames) {
                DataBufferUtils.release(frame);
            }
            throw ex;
        }
        finally {
            DataBufferUtils.release(buffer);
        }
        return frames;
    }

    private static int indexOf(DataBuffer buffer, byte[] delimiter) {
        for (int i = buffer.readPosition(); i < buffer.writePosition(); ++i) {
            int delimiterPos;
            int bufferPos = i;
            for (delimiterPos = 0; delimiterPos < delimiter.length && buffer.getByte(bufferPos) == delimiter[delimiterPos]; ++delimiterPos) {
                boolean endOfDelimiter;
                boolean endOfBuffer = ++bufferPos == buffer.writePosition();
                boolean bl = endOfDelimiter = delimiterPos == delimiter.length - 1;
                if (!endOfBuffer || endOfDelimiter) continue;
                return -1;
            }
            if (delimiterPos != delimiter.length) continue;
            return i - buffer.readPosition();
        }
        return -1;
    }

    private static DataBuffer joinUntilEndFrame(List<DataBuffer> dataBuffers) {
        int lastIdx;
        if (!dataBuffers.isEmpty() && dataBuffers.get(lastIdx = dataBuffers.size() - 1) == END_FRAME) {
            dataBuffers.remove(lastIdx);
        }
        return dataBuffers.get(0).factory().join(dataBuffers);
    }

    @Override
    protected String decodeDataBuffer(DataBuffer dataBuffer, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        Charset charset = StringDecoder.getCharset(mimeType);
        CharBuffer charBuffer = charset.decode(dataBuffer.asByteBuffer());
        DataBufferUtils.release(dataBuffer);
        String value2 = charBuffer.toString();
        LogFormatUtils.traceDebug(this.logger, traceOn -> {
            String formatted = LogFormatUtils.formatValue(value2, traceOn == false);
            return Hints.getLogPrefix(hints) + "Decoded " + formatted;
        });
        return value2;
    }

    private static Charset getCharset(@Nullable MimeType mimeType) {
        if (mimeType != null && mimeType.getCharset() != null) {
            return mimeType.getCharset();
        }
        return DEFAULT_CHARSET;
    }

    @Deprecated
    public static StringDecoder textPlainOnly(boolean ignored) {
        return StringDecoder.textPlainOnly();
    }

    public static StringDecoder textPlainOnly() {
        return StringDecoder.textPlainOnly(DEFAULT_DELIMITERS, true);
    }

    public static StringDecoder textPlainOnly(List<String> delimiters, boolean stripDelimiter) {
        return new StringDecoder(delimiters, stripDelimiter, new MimeType("text", "plain", DEFAULT_CHARSET));
    }

    @Deprecated
    public static StringDecoder allMimeTypes(boolean ignored) {
        return StringDecoder.allMimeTypes();
    }

    public static StringDecoder allMimeTypes() {
        return StringDecoder.allMimeTypes(DEFAULT_DELIMITERS, true);
    }

    public static StringDecoder allMimeTypes(List<String> delimiters, boolean stripDelimiter) {
        return new StringDecoder(delimiters, stripDelimiter, new MimeType("text", "plain", DEFAULT_CHARSET), MimeTypeUtils.ALL);
    }

    private class ConcatMapIterableDiscardWorkaroundCache
    implements Consumer<DataBuffer>,
    Runnable {
        private final List<DataBuffer> buffers = new ArrayList<DataBuffer>();

        private ConcatMapIterableDiscardWorkaroundCache() {
        }

        public List<DataBuffer> addAll(List<DataBuffer> buffersToAdd) {
            this.buffers.addAll(buffersToAdd);
            return buffersToAdd;
        }

        @Override
        public void accept(DataBuffer dataBuffer) {
            this.buffers.remove(dataBuffer);
        }

        @Override
        public void run() {
            this.buffers.forEach(buffer -> {
                try {
                    DataBufferUtils.release(buffer);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
    }
}

