/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.asm.Type;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.ObjectUtils;

abstract class AnnotationReadingVisitorUtils {
    AnnotationReadingVisitorUtils() {
    }

    public static AnnotationAttributes convertClassValues(Object annotatedElement, @Nullable ClassLoader classLoader, AnnotationAttributes original, boolean classValuesAsString) {
        AnnotationAttributes result2 = new AnnotationAttributes(original);
        AnnotationUtils.postProcessAnnotationAttributes(annotatedElement, result2, classValuesAsString);
        for (Map.Entry entry : result2.entrySet()) {
            try {
                int i;
                Object value2 = entry.getValue();
                if (value2 instanceof AnnotationAttributes) {
                    value2 = AnnotationReadingVisitorUtils.convertClassValues(annotatedElement, classLoader, (AnnotationAttributes)value2, classValuesAsString);
                } else if (value2 instanceof AnnotationAttributes[]) {
                    AnnotationAttributes[] values2 = (AnnotationAttributes[])value2;
                    for (int i2 = 0; i2 < values2.length; ++i2) {
                        values2[i2] = AnnotationReadingVisitorUtils.convertClassValues(annotatedElement, classLoader, values2[i2], classValuesAsString);
                    }
                    value2 = values2;
                } else if (value2 instanceof Type) {
                    value2 = classValuesAsString ? ((Type)value2).getClassName() : ClassUtils.forName(((Type)value2).getClassName(), classLoader);
                } else if (value2 instanceof Type[]) {
                    Type[] array2 = (Type[])value2;
                    Object[] convArray = classValuesAsString ? new String[array2.length] : new Class[array2.length];
                    for (i = 0; i < array2.length; ++i) {
                        convArray[i] = classValuesAsString ? array2[i].getClassName() : ClassUtils.forName(array2[i].getClassName(), classLoader);
                    }
                    value2 = convArray;
                } else if (classValuesAsString) {
                    if (value2 instanceof Class) {
                        value2 = ((Class)value2).getName();
                    } else if (value2 instanceof Class[]) {
                        Class[] clazzArray = (Class[])value2;
                        String[] newValue = new String[clazzArray.length];
                        for (i = 0; i < clazzArray.length; ++i) {
                            newValue[i] = clazzArray[i].getName();
                        }
                        value2 = newValue;
                    }
                }
                entry.setValue(value2);
            }
            catch (Throwable ex) {
                result2.put(entry.getKey(), ex);
            }
        }
        return result2;
    }

    @Nullable
    public static AnnotationAttributes getMergedAnnotationAttributes(LinkedMultiValueMap<String, AnnotationAttributes> attributesMap, Map<String, Set<String>> metaAnnotationMap, String annotationName) {
        Object attributesList = attributesMap.get(annotationName);
        if (CollectionUtils.isEmpty(attributesList)) {
            return null;
        }
        AnnotationAttributes result2 = new AnnotationAttributes((AnnotationAttributes)attributesList.get(0));
        HashSet overridableAttributeNames = new HashSet(result2.keySet());
        overridableAttributeNames.remove("value");
        ArrayList<String> annotationTypes = new ArrayList<String>(attributesMap.keySet());
        Collections.reverse(annotationTypes);
        annotationTypes.remove(annotationName);
        for (String currentAnnotationType : annotationTypes) {
            Set<String> metaAnns;
            Object currentAttributesList = attributesMap.get(currentAnnotationType);
            if (ObjectUtils.isEmpty(currentAttributesList) || (metaAnns = metaAnnotationMap.get(currentAnnotationType)) == null || !metaAnns.contains(annotationName)) continue;
            AnnotationAttributes currentAttributes = (AnnotationAttributes)currentAttributesList.get(0);
            for (String overridableAttributeName : overridableAttributeNames) {
                Object value2 = currentAttributes.get(overridableAttributeName);
                if (value2 == null) continue;
                result2.put(overridableAttributeName, value2);
            }
        }
        return result2;
    }
}

