/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.objenesis.instantiator.util;

import org.springframework.objenesis.ObjenesisException;

public final class ClassUtils {
    private ClassUtils() {
    }

    public static String classNameToInternalClassName(String className2) {
        return className2.replace('.', '/');
    }

    public static String classNameToResource(String className2) {
        return ClassUtils.classNameToInternalClassName(className2) + ".class";
    }

    public static <T> Class<T> getExistingClass(ClassLoader classLoader, String className2) {
        try {
            return Class.forName(className2, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ObjenesisException(e);
        }
    }
}

