/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class Assert {
    public static void state(boolean expression2, String message2) {
        if (!expression2) {
            throw new IllegalStateException(message2);
        }
    }

    public static void state(boolean expression2, Supplier<String> messageSupplier) {
        if (!expression2) {
            throw new IllegalStateException(Assert.nullSafeGet(messageSupplier));
        }
    }

    @Deprecated
    public static void state(boolean expression2) {
        Assert.state(expression2, "[Assertion failed] - this state invariant must be true");
    }

    public static void isTrue(boolean expression2, String message2) {
        if (!expression2) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void isTrue(boolean expression2, Supplier<String> messageSupplier) {
        if (!expression2) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    @Deprecated
    public static void isTrue(boolean expression2) {
        Assert.isTrue(expression2, "[Assertion failed] - this expression must be true");
    }

    public static void isNull(@Nullable Object object, String message2) {
        if (object != null) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void isNull(@Nullable Object object, Supplier<String> messageSupplier) {
        if (object != null) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    @Deprecated
    public static void isNull(@Nullable Object object) {
        Assert.isNull(object, "[Assertion failed] - the object argument must be null");
    }

    public static void notNull(@Nullable Object object, String message2) {
        if (object == null) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void notNull(@Nullable Object object, Supplier<String> messageSupplier) {
        if (object == null) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    @Deprecated
    public static void notNull(@Nullable Object object) {
        Assert.notNull(object, "[Assertion failed] - this argument is required; it must not be null");
    }

    public static void hasLength(@Nullable String text, String message2) {
        if (!StringUtils.hasLength(text)) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void hasLength(@Nullable String text, Supplier<String> messageSupplier) {
        if (!StringUtils.hasLength(text)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    @Deprecated
    public static void hasLength(@Nullable String text) {
        Assert.hasLength(text, "[Assertion failed] - this String argument must have length; it must not be null or empty");
    }

    public static void hasText(@Nullable String text, String message2) {
        if (!StringUtils.hasText(text)) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void hasText(@Nullable String text, Supplier<String> messageSupplier) {
        if (!StringUtils.hasText(text)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    @Deprecated
    public static void hasText(@Nullable String text) {
        Assert.hasText(text, "[Assertion failed] - this String argument must have text; it must not be null, empty, or blank");
    }

    public static void doesNotContain(@Nullable String textToSearch, String substring, String message2) {
        if (StringUtils.hasLength(textToSearch) && StringUtils.hasLength(substring) && textToSearch.contains(substring)) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void doesNotContain(@Nullable String textToSearch, String substring, Supplier<String> messageSupplier) {
        if (StringUtils.hasLength(textToSearch) && StringUtils.hasLength(substring) && textToSearch.contains(substring)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    @Deprecated
    public static void doesNotContain(@Nullable String textToSearch, String substring) {
        Assert.doesNotContain(textToSearch, substring, () -> "[Assertion failed] - this String argument must not contain the substring [" + substring + "]");
    }

    public static void notEmpty(@Nullable Object[] array2, String message2) {
        if (ObjectUtils.isEmpty(array2)) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void notEmpty(@Nullable Object[] array2, Supplier<String> messageSupplier) {
        if (ObjectUtils.isEmpty(array2)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    @Deprecated
    public static void notEmpty(@Nullable Object[] array2) {
        Assert.notEmpty(array2, "[Assertion failed] - this array must not be empty: it must contain at least 1 element");
    }

    public static void noNullElements(@Nullable Object[] array2, String message2) {
        if (array2 != null) {
            for (Object element : array2) {
                if (element != null) continue;
                throw new IllegalArgumentException(message2);
            }
        }
    }

    public static void noNullElements(@Nullable Object[] array2, Supplier<String> messageSupplier) {
        if (array2 != null) {
            for (Object element : array2) {
                if (element != null) continue;
                throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
            }
        }
    }

    @Deprecated
    public static void noNullElements(@Nullable Object[] array2) {
        Assert.noNullElements(array2, "[Assertion failed] - this array must not contain any null elements");
    }

    public static void notEmpty(@Nullable Collection<?> collection, String message2) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void notEmpty(@Nullable Collection<?> collection, Supplier<String> messageSupplier) {
        if (CollectionUtils.isEmpty(collection)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    @Deprecated
    public static void notEmpty(@Nullable Collection<?> collection) {
        Assert.notEmpty(collection, "[Assertion failed] - this collection must not be empty: it must contain at least 1 element");
    }

    public static void notEmpty(@Nullable Map<?, ?> map23, String message2) {
        if (CollectionUtils.isEmpty(map23)) {
            throw new IllegalArgumentException(message2);
        }
    }

    public static void notEmpty(@Nullable Map<?, ?> map23, Supplier<String> messageSupplier) {
        if (CollectionUtils.isEmpty(map23)) {
            throw new IllegalArgumentException(Assert.nullSafeGet(messageSupplier));
        }
    }

    @Deprecated
    public static void notEmpty(@Nullable Map<?, ?> map23) {
        Assert.notEmpty(map23, "[Assertion failed] - this map must not be empty; it must contain at least one entry");
    }

    public static void isInstanceOf(Class<?> type, @Nullable Object obj2, String message2) {
        Assert.notNull(type, "Type to check against must not be null");
        if (!type.isInstance(obj2)) {
            Assert.instanceCheckFailed(type, obj2, message2);
        }
    }

    public static void isInstanceOf(Class<?> type, @Nullable Object obj2, Supplier<String> messageSupplier) {
        Assert.notNull(type, "Type to check against must not be null");
        if (!type.isInstance(obj2)) {
            Assert.instanceCheckFailed(type, obj2, Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void isInstanceOf(Class<?> type, @Nullable Object obj2) {
        Assert.isInstanceOf(type, obj2, "");
    }

    public static void isAssignable(Class<?> superType, @Nullable Class<?> subType, String message2) {
        Assert.notNull(superType, "Super type to check against must not be null");
        if (subType == null || !superType.isAssignableFrom(subType)) {
            Assert.assignableCheckFailed(superType, subType, message2);
        }
    }

    public static void isAssignable(Class<?> superType, @Nullable Class<?> subType, Supplier<String> messageSupplier) {
        Assert.notNull(superType, "Super type to check against must not be null");
        if (subType == null || !superType.isAssignableFrom(subType)) {
            Assert.assignableCheckFailed(superType, subType, Assert.nullSafeGet(messageSupplier));
        }
    }

    public static void isAssignable(Class<?> superType, Class<?> subType) {
        Assert.isAssignable(superType, subType, "");
    }

    private static void instanceCheckFailed(Class<?> type, @Nullable Object obj2, @Nullable String msg) {
        String className2 = obj2 != null ? obj2.getClass().getName() : "null";
        String result2 = "";
        boolean defaultMessage = true;
        if (StringUtils.hasLength(msg)) {
            if (Assert.endsWithSeparator(msg)) {
                result2 = msg + " ";
            } else {
                result2 = Assert.messageWithTypeName(msg, className2);
                defaultMessage = false;
            }
        }
        if (defaultMessage) {
            result2 = result2 + "Object of class [" + className2 + "] must be an instance of " + type;
        }
        throw new IllegalArgumentException(result2);
    }

    private static void assignableCheckFailed(Class<?> superType, @Nullable Class<?> subType, @Nullable String msg) {
        String result2 = "";
        boolean defaultMessage = true;
        if (StringUtils.hasLength(msg)) {
            if (Assert.endsWithSeparator(msg)) {
                result2 = msg + " ";
            } else {
                result2 = Assert.messageWithTypeName(msg, subType);
                defaultMessage = false;
            }
        }
        if (defaultMessage) {
            result2 = result2 + subType + " is not assignable to " + superType;
        }
        throw new IllegalArgumentException(result2);
    }

    private static boolean endsWithSeparator(String msg) {
        return msg.endsWith(":") || msg.endsWith(";") || msg.endsWith(",") || msg.endsWith(".");
    }

    private static String messageWithTypeName(String msg, @Nullable Object typeName) {
        return msg + (msg.endsWith(" ") ? "" : ": ") + typeName;
    }

    @Nullable
    private static String nullSafeGet(@Nullable Supplier<String> messageSupplier) {
        return messageSupplier != null ? messageSupplier.get() : null;
    }
}

