/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public abstract class FileCopyUtils {
    public static final int BUFFER_SIZE = 4096;

    public static int copy(File in2, File out) throws IOException {
        Assert.notNull((Object)in2, "No input File specified");
        Assert.notNull((Object)out, "No output File specified");
        return FileCopyUtils.copy(Files.newInputStream(in2.toPath(), new OpenOption[0]), Files.newOutputStream(out.toPath(), new OpenOption[0]));
    }

    public static void copy(byte[] in2, File out) throws IOException {
        Assert.notNull((Object)in2, "No input byte array specified");
        Assert.notNull((Object)out, "No output File specified");
        FileCopyUtils.copy(new ByteArrayInputStream(in2), Files.newOutputStream(out.toPath(), new OpenOption[0]));
    }

    public static byte[] copyToByteArray(File in2) throws IOException {
        Assert.notNull((Object)in2, "No input File specified");
        return FileCopyUtils.copyToByteArray(Files.newInputStream(in2.toPath(), new OpenOption[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in2, OutputStream out) throws IOException {
        Assert.notNull((Object)in2, "No InputStream specified");
        Assert.notNull((Object)out, "No OutputStream specified");
        try {
            int n = StreamUtils.copy(in2, out);
            return n;
        }
        finally {
            try {
                in2.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void copy(byte[] in2, OutputStream out) throws IOException {
        Assert.notNull((Object)in2, "No input byte array specified");
        Assert.notNull((Object)out, "No OutputStream specified");
        try {
            out.write(in2);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] copyToByteArray(@Nullable InputStream in2) throws IOException {
        if (in2 == null) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        FileCopyUtils.copy(in2, (OutputStream)out);
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader in2, Writer out) throws IOException {
        Assert.notNull((Object)in2, "No Reader specified");
        Assert.notNull((Object)out, "No Writer specified");
        try {
            int charsRead;
            int charCount = 0;
            char[] buffer = new char[4096];
            while ((charsRead = in2.read(buffer)) != -1) {
                out.write(buffer, 0, charsRead);
                charCount += charsRead;
            }
            out.flush();
            int n = charCount;
            return n;
        }
        finally {
            try {
                in2.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void copy(String in2, Writer out) throws IOException {
        Assert.notNull((Object)in2, "No input String specified");
        Assert.notNull((Object)out, "No Writer specified");
        try {
            out.write(in2);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String copyToString(@Nullable Reader in2) throws IOException {
        if (in2 == null) {
            return "";
        }
        StringWriter out = new StringWriter(4096);
        FileCopyUtils.copy(in2, (Writer)out);
        return out.toString();
    }
}

