/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.flink.util.transformer.aggregate;

import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.streaming.api.TimerService;
import org.apache.flink.util.Collector;
import pl.touk.nussknacker.engine.api.Context;
import pl.touk.nussknacker.engine.api.ValueWithContext;
import pl.touk.nussknacker.engine.flink.api.state.StateHolder;
import pl.touk.nussknacker.engine.flink.util.keyed;
import pl.touk.nussknacker.engine.flink.util.transformer.aggregate.AggregatorFunctionMixin;
import scala.Function0;
import scala.Function2;
import scala.Option$;
import scala.Serializable;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public abstract class AggregatorFunctionMixin$class {
    public static long allowedOutOfOrderMs(AggregatorFunctionMixin $this) {
        return $this.timeWindowLengthMillis();
    }

    public static void handleNewElementAdded(AggregatorFunctionMixin $this, ValueWithContext value2, long timestamp, TimerService timeService, Collector out) {
        TreeMap<Object, Object> newState = $this.addElementToState(value2, timestamp, timeService, (Collector<ValueWithContext<Object>>)out);
        Object finalVal = $this.computeFinalValue(newState, timestamp);
        out.collect(new ValueWithContext<Object>(finalVal, value2.context()));
    }

    public static TreeMap addElementToState(AggregatorFunctionMixin $this, ValueWithContext value2, long timestamp, TimerService timeService, Collector out) {
        long newElementInStateTimestamp = AggregatorFunctionMixin$class.computeTimestampToStore($this, timestamp);
        Object newElement = ((keyed.KeyedValue)value2.value()).value();
        TreeMap newState = AggregatorFunctionMixin$class.computeNewState($this, newElementInStateTimestamp, newElement);
        ((StateHolder)((Object)$this)).updateState(newState, newElementInStateTimestamp + $this.timeWindowLengthMillis(), timeService);
        $this.handleElementAddedToState(newElementInStateTimestamp, newElement, value2.context(), timeService, (Collector<ValueWithContext<Object>>)out);
        return newState;
    }

    public static void handleElementAddedToState(AggregatorFunctionMixin $this, long newElementInStateTimestamp, Object newElement, Context nkCtx, TimerService timeService, Collector out) {
    }

    public static Object computeFinalValue(AggregatorFunctionMixin $this, TreeMap newState, long timestamp) {
        Object object;
        TreeMap newStateTruncatedToTimestamp = $this.stateForTimestampToRead(newState, timestamp);
        if (newStateTruncatedToTimestamp.isEmpty()) {
            object = $this.aggregator().getResult($this.aggregator().createAccumulator());
        } else {
            Object foldedState = newStateTruncatedToTimestamp.values().reduce((Function2)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AggregatorFunctionMixin $outer;

                public final Object apply(Object a, Object b) {
                    return this.$outer.aggregator().merge(a, b);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            object = $this.aggregator().getResult(foldedState);
        }
        return object;
    }

    private static TreeMap computeNewState(AggregatorFunctionMixin $this, long newElementInStateTimestamp, Object newValue) {
        TreeMap<Object, Object> current = $this.stateForTimestampToSave($this.readStateOrInitial(), newElementInStateTimestamp);
        Object currentAggregate = current.getOrElse((Object)BoxesRunTime.boxToLong((long)newElementInStateTimestamp), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AggregatorFunctionMixin $outer;

            public final Object apply() {
                return this.$outer.aggregator().createAccumulator();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Object newAggregate = $this.aggregator().add(newValue, currentAggregate);
        return current.updated((Object)BoxesRunTime.boxToLong((long)newElementInStateTimestamp), newAggregate);
    }

    private static long computeTimestampToStore(AggregatorFunctionMixin $this, long timestamp) {
        return timestamp / $this.minimalResolutionMs() * $this.minimalResolutionMs();
    }

    public static TreeMap stateForTimestampToSave(AggregatorFunctionMixin $this, TreeMap stateValue2, long timestamp) {
        return stateValue2.from((Object)BoxesRunTime.boxToLong((long)(timestamp - $this.timeWindowLengthMillis() + 1L - $this.allowedOutOfOrderMs())));
    }

    public static TreeMap stateForTimestampToRead(AggregatorFunctionMixin $this, TreeMap stateValue2, long timestamp) {
        return $this.stateForTimestampToReadUntilEnd(stateValue2, timestamp).to((Object)BoxesRunTime.boxToLong((long)timestamp));
    }

    public static TreeMap stateForTimestampToReadUntilEnd(AggregatorFunctionMixin $this, TreeMap stateValue2, long timestamp) {
        return stateValue2.from((Object)BoxesRunTime.boxToLong((long)(timestamp - $this.timeWindowLengthMillis() + 1L)));
    }

    public static TreeMap readStateOrInitial(AggregatorFunctionMixin $this) {
        return (TreeMap)Option$.MODULE$.apply((Object)((TreeMap)((StateHolder)((Object)$this)).readState())).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final TreeMap<Object, Nothing$> apply() {
                return TreeMap$.MODULE$.empty((Ordering)Ordering.Long$.MODULE$);
            }
        });
    }

    public static ValueStateDescriptor stateDescriptor(AggregatorFunctionMixin $this) {
        return new ValueStateDescriptor("state", TreeMap.class);
    }

    public static void $init$(AggregatorFunctionMixin $this) {
        $this.pl$touk$nussknacker$engine$flink$util$transformer$aggregate$AggregatorFunctionMixin$_setter_$minimalResolutionMs_$eq(60000L);
    }
}

