/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.kafka;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.LazyLogging$class;
import com.typesafe.scalalogging.Logger;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import pl.touk.nussknacker.engine.api.namespaces.KafkaUsageKey$;
import pl.touk.nussknacker.engine.api.namespaces.NamingContext;
import pl.touk.nussknacker.engine.api.process.ProcessObjectDependencies;
import pl.touk.nussknacker.engine.kafka.KafkaConfig;
import pl.touk.nussknacker.engine.kafka.KafkaUtils$;
import pl.touk.nussknacker.engine.kafka.PreparedKafkaTopic;
import pl.touk.nussknacker.engine.util.ThreadUtils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.IterableViewLike;
import scala.collection.JavaConverters$;
import scala.collection.SeqLike;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class KafkaUtils$
implements LazyLogging {
    public static final KafkaUtils$ MODULE$;
    private final int defaultTimeoutMillis;
    private final NamingContext KafkaTopicUsageKey;
    private final transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new KafkaUtils$();
    }

    private Logger logger$lzycompute() {
        KafkaUtils$ kafkaUtils$ = this;
        synchronized (kafkaUtils$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging$class.logger(this);
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    public int defaultTimeoutMillis() {
        return this.defaultTimeoutMillis;
    }

    public final NamingContext KafkaTopicUsageKey() {
        return this.KafkaTopicUsageKey;
    }

    public void setClientId(Properties props, String id2) {
        props.setProperty("client.id", this.sanitizeClientId(id2));
    }

    public PreparedKafkaTopic prepareKafkaTopic(String topic, ProcessObjectDependencies processObjectDependencies) {
        return new PreparedKafkaTopic(topic, processObjectDependencies.objectNaming().prepareName(topic, processObjectDependencies.config(), this.KafkaTopicUsageKey()));
    }

    public String sanitizeClientId(String originalId) {
        return originalId.replaceAll("[^a-zA-Z0-9\\._\\-]", "_");
    }

    public void setToLatestOffsetIfNeeded(KafkaConfig config, String topic, String consumerGroupId) {
        boolean setToLatestOffset = config.forceLatestRead().contains((Object)BoxesRunTime.boxToBoolean((boolean)true));
        if (setToLatestOffset) {
            this.setOffsetToLatest(topic, consumerGroupId, config);
        }
    }

    public void setOffsetToLatest(String topic, String groupId, KafkaConfig config) {
        BoxedUnit boxedUnit;
        long timeoutMillis = this.readTimeout(config);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Setting offset to latest for topic: {}, groupId: {}", new String[]{topic, groupId});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Future consumerAfterWork = Future$.MODULE$.apply((Function0)new Serializable(topic, groupId, config){
            public static final long serialVersionUID = 0L;
            public final String topic$1;
            private final String groupId$1;
            private final KafkaConfig config$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                KafkaUtils$.MODULE$.pl$touk$nussknacker$engine$kafka$KafkaUtils$$doWithTempKafkaConsumer(this.config$1, (Option<String>)new Some((Object)this.groupId$1), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.1 $outer;

                    public final void apply(KafkaConsumer<byte[], byte[]> consumer) {
                        KafkaUtils$.MODULE$.pl$touk$nussknacker$engine$kafka$KafkaUtils$$setOffsetToLatest(this.$outer.topic$1, consumer);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topic$1 = topic$1;
                this.groupId$1 = groupId$1;
                this.config$1 = config$1;
            }
        }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
        Await$.MODULE$.result((Awaitable)consumerAfterWork, (Duration)Duration$.MODULE$.apply(timeoutMillis, TimeUnit.MILLISECONDS));
    }

    public Properties toProperties(KafkaConfig config, Option<String> groupId) {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", config.kafkaAddress());
        props.setProperty("auto.offset.reset", "earliest");
        groupId.foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(String x$1) {
                return this.props$1.setProperty("group.id", x$1);
            }
            {
                this.props$1 = props$1;
            }
        });
        return this.withPropertiesFromConfig(props, config);
    }

    public Properties toProducerProperties(KafkaConfig config, String clientId) {
        Properties props = new Properties();
        props.setProperty("bootstrap.servers", config.kafkaAddress());
        props.setProperty("key.serializer", ByteArraySerializer.class.getCanonicalName());
        props.setProperty("value.serializer", ByteArraySerializer.class.getCanonicalName());
        props.setProperty("acks", "all");
        props.setProperty("retries", "0");
        props.setProperty("batch.size", "16384");
        props.setProperty("linger.ms", "1");
        props.setProperty("buffer.memory", "33554432");
        this.setClientId(props, clientId);
        return this.withPropertiesFromConfig(props, config);
    }

    public Properties withPropertiesFromConfig(Properties props, KafkaConfig kafkaConfig) {
        ((IterableLike)kafkaConfig.kafkaProperties().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, Nothing$> apply() {
                return Predef$.MODULE$.Map().empty();
            }
        })).foreach((Function1)new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$2;

            public final Object apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple23 = x0$1;
                if (tuple23 != null) {
                    String k = (String)tuple23._1();
                    String v = (String)tuple23._2();
                    Object object = this.props$2.setProperty(k, v);
                    return object;
                }
                throw new MatchError(tuple23);
            }
            {
                this.props$2 = props$2;
            }
        });
        return props;
    }

    /*
     * WARNING - void declaration
     */
    public Properties pl$touk$nussknacker$engine$kafka$KafkaUtils$$toPropertiesForTempConsumer(KafkaConfig config, Option<String> group) {
        void var3_3;
        Properties props = this.toProperties(config, group);
        props.put("value.deserializer", ByteArrayDeserializer.class);
        props.put("key.deserializer", ByteArrayDeserializer.class);
        props.setProperty("session.timeout.ms", ((Object)BoxesRunTime.boxToLong((long)this.readTimeout(config))).toString());
        return var3_3;
    }

    public List<ConsumerRecord<byte[], byte[]>> readLastMessages(String topic, int size2, KafkaConfig config) {
        return (List)this.pl$touk$nussknacker$engine$kafka$KafkaUtils$$doWithTempKafkaConsumer(config, (Option<String>)None$.MODULE$, (Function1)new Serializable(topic, size2){
            public static final long serialVersionUID = 0L;
            public final String topic$2;
            public final int size$1;

            public final List<ConsumerRecord<byte[], byte[]>> apply(KafkaConsumer<byte[], byte[]> consumer) {
                try {
                    return ((IterableViewLike)((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(consumer.partitionsFor(this.topic$2)).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.readLastMessages.1 $outer;

                        public final TopicPartition apply(PartitionInfo no) {
                            return new TopicPartition(this.$outer.topic$2, no.partition());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Buffer$.MODULE$.canBuildFrom())).view().flatMap((Function1)new Serializable(this, consumer){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.readLastMessages.1 $outer;
                        private final KafkaConsumer consumer$2;

                        public final ArrayBuffer<ConsumerRecord<byte[], byte[]>> apply(TopicPartition tp) {
                            java.util.List<TopicPartition> partitions = Collections.singletonList(tp);
                            this.consumer$2.assign(partitions);
                            this.consumer$2.seekToEnd(partitions);
                            long lastOffset = this.consumer$2.position(tp);
                            long offsetToSearch = Math.max(0L, lastOffset - (long)this.$outer.size$1);
                            this.consumer$2.seek(tp, offsetToSearch);
                            ArrayBuffer result2 = new ArrayBuffer(this.$outer.size$1);
                            result2.appendAll((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.consumer$2.poll(java.time.Duration.ofMillis(100L)).records(tp)).asScala());
                            if (result2.isEmpty()) {
                                this.consumer$2.seekToBeginning(partitions);
                            }
                            long currentOffset = this.consumer$2.position(tp);
                            while (result2.size() < this.$outer.size$1 && currentOffset < lastOffset) {
                                result2.appendAll((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.consumer$2.poll(java.time.Duration.ofMillis(100L)).records(tp)).asScala());
                                currentOffset = this.consumer$2.position(tp);
                            }
                            this.consumer$2.unsubscribe();
                            return (ArrayBuffer)result2.take(this.$outer.size$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.consumer$2 = consumer$2;
                        }
                    }, SeqView$.MODULE$.canBuildFrom())).take(this.size$1).toList();
                }
                finally {
                    consumer.unsubscribe();
                }
            }
            {
                this.topic$2 = topic$2;
                this.size$1 = size$1;
            }
        });
    }

    public <T> T pl$touk$nussknacker$engine$kafka$KafkaUtils$$doWithTempKafkaConsumer(KafkaConfig config, Option<String> groupId, Function1<KafkaConsumer<byte[], byte[]>, T> fun) {
        return ThreadUtils$.MODULE$.withThisAsContextClassLoader(KafkaClient.class.getClassLoader(), new Serializable(config, groupId, fun){
            public static final long serialVersionUID = 0L;
            private final KafkaConfig config$2;
            private final Option groupId$2;
            private final Function1 fun$1;

            /*
             * WARNING - void declaration
             */
            public final T apply() {
                Object object;
                KafkaConsumer<K, V> consumer = new KafkaConsumer<K, V>(KafkaUtils$.MODULE$.pl$touk$nussknacker$engine$kafka$KafkaUtils$$toPropertiesForTempConsumer(this.config$2, (Option<String>)this.groupId$2));
                try {
                    object = this.fun$1.apply(consumer);
                    consumer.close();
                }
                catch (Throwable throwable) {
                    void var1_1;
                    var1_1.close();
                    throw throwable;
                }
                return (T)object;
            }
            {
                this.config$2 = config$2;
                this.groupId$2 = groupId$2;
                this.fun$1 = fun$1;
            }
        });
    }

    private long readTimeout(KafkaConfig config) {
        return BoxesRunTime.unboxToLong((Object)config.kafkaProperties().flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Object> apply(Map<String, String> props) {
                return props.get((Object)"session.timeout.ms").map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(String x$2) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
                    }
                });
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return KafkaUtils$.MODULE$.defaultTimeoutMillis();
            }
        }));
    }

    public void pl$touk$nussknacker$engine$kafka$KafkaUtils$$setOffsetToLatest(String topic, KafkaConsumer<?, ?> consumer) {
        Buffer partitions = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(consumer.partitionsFor(topic)).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TopicPartition apply(PartitionInfo partition) {
                return new TopicPartition(partition.topic(), partition.partition());
            }
        }, Buffer$.MODULE$.canBuildFrom());
        consumer.assign((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(partitions).asJava());
        consumer.seekToEnd((Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(partitions).asJava());
        partitions.foreach((Function1)new Serializable(consumer){
            public static final long serialVersionUID = 0L;
            private final KafkaConsumer consumer$1;

            public final long apply(TopicPartition p) {
                return this.consumer$1.position(p);
            }
            {
                this.consumer$1 = consumer$1;
            }
        });
        consumer.commitSync();
    }

    public Future<RecordMetadata> sendToKafkaWithTempProducer(String topic, byte[] key, byte[] value2, KafkaConfig kafkaConfig) {
        try (KafkaProducer<byte[], byte[]> producer = null;){
            producer = this.createProducer(kafkaConfig, new StringBuilder().append((Object)"temp-").append((Object)topic).toString());
            return this.sendToKafka(topic, key, value2, producer);
        }
    }

    public <K, V> Future<RecordMetadata> sendToKafka(String topic, K key, V value2, KafkaProducer<K, V> producer) {
        Promise promise2 = Promise$.MODULE$.apply();
        producer.send(new ProducerRecord<K, V>(topic, key, value2), this.producerCallback((Promise<RecordMetadata>)promise2));
        return promise2.future();
    }

    public KafkaProducer<byte[], byte[]> createProducer(KafkaConfig kafkaConfig, String clientId) {
        return new KafkaProducer<byte[], byte[]>(this.toProducerProperties(kafkaConfig, clientId));
    }

    public Callback producerCallback(Promise<RecordMetadata> promise2) {
        return new Callback(promise2){
            private final Promise promise$1;

            public void onCompletion(RecordMetadata metadata, Exception exception) {
                Success result2 = exception == null ? new Success((Object)metadata) : new Failure((Throwable)exception);
                this.promise$1.complete((Try)result2);
            }
            {
                this.promise$1 = promise$1;
            }
        };
    }

    private KafkaUtils$() {
        MODULE$ = this;
        LazyLogging$class.$init$(this);
        this.defaultTimeoutMillis = 10000;
        this.KafkaTopicUsageKey = new NamingContext(KafkaUsageKey$.MODULE$);
    }
}

