/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.stream;

import com.clearspring.analytics.stream.ISampleSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class SampleSet<T>
implements ISampleSet<T> {
    private Map<T, Node<T>> sampleMap;
    private int size;
    private long count;
    private Random random;
    private Node<T> head;
    private Node<T> tail;

    public SampleSet() {
        this(7);
    }

    public SampleSet(int capacity) {
        this(capacity, new Random());
    }

    public SampleSet(int capacity, Random random) {
        this.sampleMap = new HashMap<T, Node<T>>(capacity);
        this.random = random;
    }

    @Override
    public T peek() {
        return (T)(this.head != null ? ((Node)this.head).element : null);
    }

    @Override
    public List<T> peek(int k) {
        ArrayList<Object> topK = new ArrayList<Object>(k);
        Node itr = this.head;
        while (itr != null && topK.size() < k) {
            topK.add(itr.element);
            itr = itr.next;
        }
        return topK;
    }

    @Override
    public long put(T element) {
        return this.put(element, 1);
    }

    @Override
    public long put(T element, int incrementCount) {
        Node<Object> node2 = this.sampleMap.get(element);
        if (node2 != null) {
            ((Node)node2).count = ((Node)node2).count + (long)incrementCount;
            this.promote(node2);
        } else {
            node2 = new Node();
            ((Node)node2).element = element;
            ((Node)node2).count = incrementCount;
            ((Node)node2).prev = (Node)this.tail;
            if (this.tail != null) {
                ((Node)this.tail).next = (Node)node2;
            }
            this.tail = node2;
            if (this.head == null) {
                this.head = node2;
            }
            this.sampleMap.put(element, node2);
            ++this.size;
        }
        ++this.count;
        return ((Node)node2).count;
    }

    @Override
    public T removeRandom() {
        double p = this.random.nextDouble();
        long weight = 0L;
        Node itr = this.head;
        while (itr != null) {
            if (p < (double)(weight += itr.count) / (double)this.count) {
                itr.count--;
                --this.count;
                this.demote(itr);
                if (itr.count == 0L) {
                    this.removeMin();
                }
                return (T)itr.element;
            }
            itr = itr.next;
        }
        return null;
    }

    protected T removeMin() {
        if (this.tail == null) {
            return null;
        }
        --this.size;
        this.count -= ((Node)this.tail).count;
        Object minElement = ((Node)this.tail).element;
        this.tail = ((Node)this.tail).prev;
        if (this.tail != null) {
            ((Node)this.tail).next = null;
        }
        this.sampleMap.remove(minElement);
        return (T)minElement;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public long count() {
        return this.count;
    }

    protected T peekMin() {
        return (T)((Node)this.tail).element;
    }

    protected void promote(Node<T> node2) {
        while (((Node)node2).prev != null && ((Node)node2).count > ((Node)node2).prev.count) {
            Node a;
            Node b = ((Node)node2).prev;
            Node<T> c = node2;
            Node d = ((Node)node2).next;
            Node node3 = a = b == null ? null : b.prev;
            if (a != null) {
                a.next = (Node)c;
            }
            ((Node)c).prev = a;
            ((Node)c).next = b;
            b.prev = (Node)c;
            b.next = d;
            if (d != null) {
                d.prev = b;
            }
            if (this.head == b) {
                this.head = c;
            }
            if (this.tail != c) continue;
            this.tail = b;
        }
    }

    protected void demote(Node<T> node2) {
        while (((Node)node2).next != null && ((Node)node2).count < ((Node)node2).next.count) {
            Node d;
            Node a = ((Node)node2).prev;
            Node<T> b = node2;
            Node c = ((Node)node2).next;
            Node node3 = d = c == null ? null : c.next;
            if (a != null) {
                a.next = c;
            }
            c.prev = a;
            c.next = (Node)b;
            ((Node)b).prev = c;
            if (d != null) {
                d.prev = (Node)b;
            }
            ((Node)b).next = d;
            if (this.head == b) {
                this.head = c;
            }
            if (this.tail != c) continue;
            this.tail = b;
        }
    }

    private class Node<E> {
        private Node<E> next;
        private Node<E> prev;
        private E element;
        private long count;

        private Node() {
        }
    }
}

