/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionPeriodOp;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.PeriodDefinition;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariableResolver;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.OrderedLongHashSet;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.types.Type;

public class RangeVariable {
    static final RangeVariable[] emptyArray = new RangeVariable[0];
    public static final int TABLE_RANGE = 1;
    public static final int TRANSITION_RANGE = 2;
    public static final int PARAMETER_RANGE = 3;
    public static final int VARIALBE_RANGE = 4;
    public static final int PLACEHOLDER_RANGE = 5;
    private static final RowIterator emptyIterator = new RangeIteratorEmpty();
    Table rangeTable;
    final HsqlNameManager.SimpleName tableAlias;
    private OrderedHashSet columnAliases;
    private HsqlNameManager.SimpleName[] columnAliasNames;
    private OrderedHashSet columnNames;
    OrderedHashSet namedJoinColumns;
    HashMap namedJoinColumnExpressions;
    boolean[] columnsInGroupBy;
    boolean hasKeyedColumnInGroupBy;
    boolean[] usedColumns;
    boolean[] updatedColumns;
    boolean[] namedJoinColumnCheck;
    RangeVariableConditions[] joinConditions;
    RangeVariableConditions[] whereConditions;
    int subRangeCount;
    Expression joinCondition;
    ExpressionPeriodOp periodCondition;
    ExpressionLogical filterCondition;
    boolean isLateral;
    boolean isLeftJoin;
    boolean isRightJoin;
    boolean isJoin;
    boolean hasLateral;
    boolean hasLeftJoin;
    boolean hasRightJoin;
    int level;
    int indexDistinctCount;
    int rangePositionInJoin;
    int rangePosition;
    boolean isViewSubquery;
    HashMappedList variables;
    int rangeType;
    boolean isGenerated;

    public RangeVariable(HashMappedList hashMappedList, HsqlNameManager.SimpleName simpleName, boolean bl, int n) {
        this.variables = hashMappedList;
        this.rangeType = n;
        this.rangeTable = null;
        this.tableAlias = simpleName;
        this.columnsInGroupBy = null;
        this.usedColumns = null;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
        switch (n) {
            case 2: {
                this.usedColumns = new boolean[hashMappedList.size()];
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw Error.runtimeError(201, "RangeVariable");
            }
        }
    }

    public RangeVariable(Table table, HsqlNameManager.SimpleName simpleName, OrderedHashSet orderedHashSet, HsqlNameManager.SimpleName[] simpleNameArray, ParserDQL.CompileContext compileContext) {
        this.rangeType = 1;
        this.rangeTable = table;
        this.tableAlias = simpleName;
        this.columnAliases = orderedHashSet;
        this.columnAliasNames = simpleNameArray;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
        compileContext.registerRangeVariable(this);
        if (this.rangeTable.getColumnCount() != 0) {
            this.setRangeTableVariables();
        }
    }

    public RangeVariable(Table table, int n) {
        this.rangeType = 1;
        this.rangeTable = table;
        this.tableAlias = null;
        this.columnsInGroupBy = this.rangeTable.getNewColumnCheckList();
        this.usedColumns = this.rangeTable.getNewColumnCheckList();
        this.rangePosition = n;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
    }

    public void setRangeTableVariables() {
        if (this.columnAliasNames != null && this.rangeTable.getColumnCount() != this.columnAliasNames.length) {
            throw Error.error(5593);
        }
        this.columnsInGroupBy = this.rangeTable.getNewColumnCheckList();
        this.usedColumns = this.rangeTable.getNewColumnCheckList();
        this.joinConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
        this.whereConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
    }

    public void setJoinType(boolean bl, boolean bl2) {
        this.isJoin = true;
        this.isLeftJoin = bl;
        this.isRightJoin = bl2;
        if (this.isRightJoin) {
            this.whereConditions[0].rangeIndex = this.rangeTable.getPrimaryIndex();
        }
    }

    public void setSystemPeriodCondition(ExpressionPeriodOp expressionPeriodOp) {
        this.periodCondition = expressionPeriodOp;
    }

    public void setFilterExpression(Session session, ExpressionLogical expressionLogical) {
        if (expressionLogical != null) {
            expressionLogical = (ExpressionLogical)expressionLogical.duplicate();
            RangeGroup.RangeGroupSimple rangeGroupSimple = new RangeGroup.RangeGroupSimple(new RangeVariable[]{this}, false);
            expressionLogical.resolveColumnReferences(session, rangeGroupSimple, RangeGroup.emptyArray, null);
            this.filterCondition = expressionLogical;
        }
    }

    public void addNamedJoinColumns(OrderedHashSet orderedHashSet) {
        this.namedJoinColumns = orderedHashSet;
    }

    public void addColumn(int n) {
        if (this.usedColumns != null) {
            this.usedColumns[n] = true;
        }
    }

    public void addAllColumns() {
        if (this.usedColumns != null) {
            ArrayUtil.fillArray(this.usedColumns, true);
        }
    }

    public void addNamedJoinColumnExpression(String string, Expression expression2, int n) {
        if (this.namedJoinColumnExpressions == null) {
            this.namedJoinColumnExpressions = new HashMap();
        }
        this.namedJoinColumnExpressions.put(string, expression2);
        if (this.namedJoinColumnCheck == null) {
            this.namedJoinColumnCheck = this.rangeTable.getNewColumnCheckList();
        }
        this.namedJoinColumnCheck[n] = true;
    }

    public ExpressionColumn getColumnExpression(String string) {
        return this.namedJoinColumnExpressions == null ? null : (ExpressionColumn)this.namedJoinColumnExpressions.get(string);
    }

    public Table getTable() {
        return this.rangeTable;
    }

    public boolean hasAnyTerminalCondition() {
        int n;
        for (n = 0; n < this.joinConditions.length; ++n) {
            if (this.joinConditions[0].terminalCondition == null) continue;
            return true;
        }
        for (n = 0; n < this.whereConditions.length; ++n) {
            if (this.whereConditions[0].terminalCondition == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyIndexCondition() {
        int n;
        for (n = 0; n < this.joinConditions.length; ++n) {
            if (this.joinConditions[0].indexedColumnCount <= 0) continue;
            return true;
        }
        for (n = 0; n < this.whereConditions.length; ++n) {
            if (this.whereConditions[0].indexedColumnCount <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasSingleIndexCondition() {
        return this.joinConditions.length == 1 && this.joinConditions[0].indexedColumnCount > 0;
    }

    public boolean setDistinctColumnsOnIndex(int[] nArray) {
        if (this.joinConditions.length != 1) {
            return false;
        }
        int[] nArray2 = this.joinConditions[0].rangeIndex.getColumns();
        if (nArray.length > nArray2.length) {
            return false;
        }
        if (nArray.length == nArray2.length && ArrayUtil.haveEqualSets(nArray, nArray2, nArray.length)) {
            this.indexDistinctCount = nArray.length;
            return true;
        }
        if (ArrayUtil.haveEqualArrays(nArray, nArray2, nArray.length)) {
            this.indexDistinctCount = nArray.length;
            return true;
        }
        return false;
    }

    public Index getSortIndex() {
        if (this.joinConditions.length == 1) {
            return this.joinConditions[0].rangeIndex;
        }
        return null;
    }

    public boolean setSortIndex(Index index, boolean bl) {
        if (this.joinConditions.length == 1 && this.joinConditions[0].indexedColumnCount == 0) {
            this.joinConditions[0].rangeIndex = index;
            this.joinConditions[0].reversed = bl;
            return true;
        }
        return false;
    }

    public boolean reverseOrder() {
        if (this.joinConditions.length == 1) {
            this.joinConditions[0].reverseIndexCondition();
            return true;
        }
        return false;
    }

    public OrderedHashSet getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = new OrderedHashSet();
            this.rangeTable.getColumnNames(this.usedColumns, this.columnNames);
        }
        return this.columnNames;
    }

    public OrderedHashSet getUniqueColumnNameSet() {
        OrderedHashSet orderedHashSet = new OrderedHashSet();
        if (this.columnAliases != null) {
            orderedHashSet.addAll(this.columnAliases);
            return orderedHashSet;
        }
        for (int i = 0; i < this.rangeTable.columnList.size(); ++i) {
            String string = this.rangeTable.getColumn((int)i).getName().name;
            boolean bl = orderedHashSet.add(string);
            if (bl) continue;
            throw Error.error(5578, string);
        }
        return orderedHashSet;
    }

    public int findColumn(String string, String string2, String string3) {
        if (this.namedJoinColumnExpressions != null && this.namedJoinColumnExpressions.containsKey(string3) && string2 != null && !this.resolvesTableName(string2)) {
            return -1;
        }
        if (this.resolvesSchemaAndTableName(string, string2)) {
            return this.findColumn(string3);
        }
        return -1;
    }

    public int findColumn(String string) {
        if (this.variables != null) {
            return this.variables.getIndex(string);
        }
        if (this.columnAliases != null) {
            return this.columnAliases.getIndex(string);
        }
        return this.rangeTable.findColumn(string);
    }

    public ColumnSchema getColumn(int n) {
        if (this.variables == null) {
            return this.rangeTable.getColumn(n);
        }
        return (ColumnSchema)this.variables.get(n);
    }

    public HsqlNameManager.SimpleName getColumnAlias(int n) {
        if (this.columnAliases == null) {
            return this.rangeTable.getColumn(n).getName();
        }
        return this.columnAliasNames[n];
    }

    public boolean hasColumnAlias() {
        return this.columnAliases != null;
    }

    public boolean hasTableAlias() {
        return this.tableAlias != null;
    }

    public boolean isVariable() {
        return this.variables != null;
    }

    public HsqlNameManager.SimpleName getTableAlias() {
        return this.tableAlias == null ? this.rangeTable.getName() : this.tableAlias;
    }

    public RangeVariable getRangeForTableName(String string) {
        if (this.resolvesTableName(string)) {
            return this;
        }
        return null;
    }

    private boolean resolvesSchemaAndTableName(String string, String string2) {
        return this.resolvesSchemaName(string) && this.resolvesTableName(string2);
    }

    private boolean resolvesTableName(String string) {
        if (string == null) {
            return true;
        }
        if (this.variables != null) {
            if (this.tableAlias != null) {
                return string.equals(this.tableAlias.name);
            }
            return false;
        }
        return this.tableAlias == null ? string.equals(this.rangeTable.getName().name) : string.equals(this.tableAlias.name);
    }

    private boolean resolvesSchemaName(String string) {
        if (string == null) {
            return true;
        }
        if (this.variables != null) {
            return false;
        }
        if (this.tableAlias != null) {
            return false;
        }
        return string.equals(this.rangeTable.getSchemaName().name);
    }

    public PeriodDefinition findPeriod(String string, String string2, String string3) {
        if (this.resolvesSchemaAndTableName(string, string2)) {
            PeriodDefinition periodDefinition = this.rangeTable.getApplicationPeriod();
            if (periodDefinition != null && periodDefinition.getName().name.equals(string3)) {
                return periodDefinition;
            }
            periodDefinition = this.rangeTable.getSystemPeriod();
            if (periodDefinition != null && periodDefinition.getName().name.equals(string3)) {
                return periodDefinition;
            }
        }
        return null;
    }

    public void addTableColumns(HsqlArrayList hsqlArrayList) {
        if (this.namedJoinColumns != null) {
            int n = hsqlArrayList.size();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Expression expression2 = (Expression)hsqlArrayList.get(i);
                String string = expression2.getColumnName();
                if (!this.namedJoinColumns.contains(string)) continue;
                if (n2 != i) {
                    hsqlArrayList.remove(i);
                    hsqlArrayList.add(n2, expression2);
                }
                expression2 = this.getColumnExpression(string);
                hsqlArrayList.set(n2, expression2);
                ++n2;
            }
        }
        this.addTableColumns(hsqlArrayList, hsqlArrayList.size(), (HashSet)this.namedJoinColumns);
    }

    public int addTableColumns(HsqlArrayList hsqlArrayList, int n, HashSet hashSet) {
        Table table = this.getTable();
        int n2 = table.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            String string;
            ColumnSchema columnSchema = table.getColumn(i);
            String string2 = string = this.columnAliases == null ? columnSchema.getName().name : (String)this.columnAliases.get(i);
            if (hashSet != null && hashSet.contains(string)) continue;
            ExpressionColumn expressionColumn = new ExpressionColumn(this, i);
            hsqlArrayList.add(n++, expressionColumn);
        }
        return n;
    }

    public void addTableColumns(RangeVariable rangeVariable, Expression expression2, HashSet hashSet) {
        if (rangeVariable == this) {
            Table table = this.getTable();
            int n = table.getColumnCount();
            this.addTableColumns(expression2, 0, n, hashSet);
        }
    }

    protected int getFirstColumnIndex(RangeVariable rangeVariable) {
        if (rangeVariable == this) {
            return 0;
        }
        return -1;
    }

    protected void addTableColumns(Expression expression2, int n, int n2, HashSet hashSet) {
        Table table = this.getTable();
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        for (int i = n; i < n + n2; ++i) {
            String string;
            ColumnSchema columnSchema = table.getColumn(i);
            String string2 = string = this.columnAliases == null ? columnSchema.getName().name : (String)this.columnAliases.get(i);
            if (hashSet != null && hashSet.contains(string)) continue;
            ExpressionColumn expressionColumn = new ExpressionColumn(this, i);
            hsqlArrayList.add(expressionColumn);
        }
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        expression2.nodes = expressionArray;
    }

    public void setForCheckConstraint() {
        this.joinConditions[0].rangeIndex = null;
        this.whereConditions[0].rangeIndex = null;
        this.rangePosition = 0;
    }

    public Expression getJoinCondition() {
        return this.joinCondition;
    }

    public void addJoinCondition(Expression expression2) {
        this.joinCondition = ExpressionLogical.andExpressions(this.joinCondition, expression2);
    }

    public void resetConditions() {
        Index index = this.joinConditions[0].rangeIndex;
        this.joinConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, true)};
        this.joinConditions[0].rangeIndex = index;
        index = this.whereConditions[0].rangeIndex;
        this.whereConditions = new RangeVariableConditions[]{new RangeVariableConditions(this, false)};
        this.whereConditions[0].rangeIndex = index;
    }

    public OrderedHashSet getSubqueries() {
        OrderedHashSet orderedHashSet = null;
        if (this.joinCondition != null) {
            orderedHashSet = this.joinCondition.collectAllSubqueries(orderedHashSet);
        }
        if (this.rangeTable instanceof TableDerived) {
            QueryExpression queryExpression = this.rangeTable.getQueryExpression();
            if (queryExpression == null) {
                Expression expression2 = this.rangeTable.getDataExpression();
                if (expression2 != null) {
                    if (orderedHashSet == null) {
                        orderedHashSet = new OrderedHashSet();
                    }
                    OrderedHashSet.addAll(orderedHashSet, expression2.getSubqueries());
                }
            } else {
                OrderedHashSet orderedHashSet2 = queryExpression.getSubqueries();
                orderedHashSet = OrderedHashSet.addAll(orderedHashSet, orderedHashSet2);
                orderedHashSet = OrderedHashSet.add(orderedHashSet, this.rangeTable);
            }
        }
        return orderedHashSet;
    }

    public OrderedHashSet collectAllExpressions(OrderedHashSet orderedHashSet, OrderedIntHashSet orderedIntHashSet, OrderedIntHashSet orderedIntHashSet2) {
        if (this.joinCondition != null) {
            orderedHashSet = this.joinCondition.collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        QueryExpression queryExpression = this.rangeTable.getQueryExpression();
        Expression expression2 = this.rangeTable.getDataExpression();
        if (queryExpression != null) {
            orderedHashSet = queryExpression.collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        if (expression2 != null) {
            orderedHashSet = expression2.collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        return orderedHashSet;
    }

    public void replaceColumnReferences(Session session, RangeVariable rangeVariable, Expression[] expressionArray) {
        int n;
        QueryExpression queryExpression = this.rangeTable.getQueryExpression();
        Expression expression2 = this.rangeTable.getDataExpression();
        if (expression2 != null) {
            expression2.replaceColumnReferences(session, rangeVariable, expressionArray);
        }
        if (queryExpression != null) {
            queryExpression.replaceColumnReferences(session, rangeVariable, expressionArray);
        }
        if (this.joinCondition != null) {
            this.joinCondition = this.joinCondition.replaceColumnReferences(session, rangeVariable, expressionArray);
        }
        for (n = 0; n < this.joinConditions.length; ++n) {
            this.joinConditions[n].replaceColumnReferences(session, rangeVariable, expressionArray);
        }
        for (n = 0; n < this.whereConditions.length; ++n) {
            this.whereConditions[n].replaceColumnReferences(session, rangeVariable, expressionArray);
        }
    }

    public void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
        if (this.joinCondition != null) {
            this.joinCondition.replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
    }

    public void replaceExpressions(OrderedHashSet orderedHashSet, int n) {
        int n2;
        QueryExpression queryExpression = this.rangeTable.getQueryExpression();
        Expression expression2 = this.rangeTable.getDataExpression();
        if (expression2 != null) {
            expression2.replaceExpressions(orderedHashSet, n);
        }
        if (queryExpression != null) {
            queryExpression.replaceExpressions(orderedHashSet, n);
        }
        if (this.joinCondition != null) {
            this.joinCondition = this.joinCondition.replaceExpressions(orderedHashSet, n);
        }
        for (n2 = 0; n2 < this.joinConditions.length; ++n2) {
            this.joinConditions[n2].replaceExpressions(orderedHashSet, n);
        }
        for (n2 = 0; n2 < this.whereConditions.length; ++n2) {
            this.whereConditions[n2].replaceExpressions(orderedHashSet, n);
        }
    }

    public void resolveRangeTable(Session session, RangeGroup rangeGroup, RangeGroup[] rangeGroupArray) {
        HsqlList hsqlList;
        QueryExpression queryExpression = this.rangeTable.getQueryExpression();
        Expression expression2 = this.rangeTable.getDataExpression();
        if (queryExpression == null && expression2 == null) {
            return;
        }
        rangeGroupArray = (RangeGroup[])ArrayUtil.toAdjustedArray(rangeGroupArray, rangeGroup, rangeGroupArray.length, 1);
        if (expression2 != null) {
            hsqlList = expression2.resolveColumnReferences(session, RangeGroup.emptyGroup, rangeGroupArray, null);
            hsqlList = Expression.resolveColumnSet(session, emptyArray, RangeGroup.emptyArray, hsqlList);
            ExpressionColumn.checkColumnsResolved(hsqlList);
            expression2.resolveTypes(session, null);
            this.setRangeTableVariables();
        }
        if (queryExpression != null) {
            queryExpression.resolveReferences(session, rangeGroupArray);
            hsqlList = queryExpression.getUnresolvedExpressions();
            hsqlList = Expression.resolveColumnSet(session, emptyArray, RangeGroup.emptyArray, hsqlList);
            ExpressionColumn.checkColumnsResolved(hsqlList);
            queryExpression.resolveTypesPartOne(session);
            queryExpression.resolveTypesPartTwo(session);
            this.rangeTable.prepareTable(session);
            this.setRangeTableVariables();
        }
    }

    void resolveRangeTableTypes(Session session, RangeVariable[] rangeVariableArray) {
        QueryExpression queryExpression = this.rangeTable.getQueryExpression();
        if (queryExpression != null) {
            if (queryExpression instanceof QuerySpecification) {
                QuerySpecification querySpecification = (QuerySpecification)queryExpression;
                if (!(querySpecification.isGrouped || querySpecification.isAggregated || querySpecification.isOrderSensitive)) {
                    this.moveConditionsToInner(session, rangeVariableArray);
                }
            }
            queryExpression.resolveTypesPartThree(session);
        }
    }

    void moveConditionsToInner(Session session, RangeVariable[] rangeVariableArray) {
        int n;
        Expression expression2 = null;
        if (this.whereConditions.length > 1) {
            return;
        }
        if (this.joinConditions.length > 1) {
            return;
        }
        for (n = 0; n < rangeVariableArray.length; ++n) {
            if (!rangeVariableArray[n].isLeftJoin && !rangeVariableArray[n].isRightJoin) continue;
            return;
        }
        int n2 = ArrayUtil.find(rangeVariableArray, this);
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        RangeVariable.addConditionsToList(hsqlArrayList, this.joinConditions[0].indexCond);
        if (this.joinConditions[0].indexCond != null && this.joinConditions[0].indexCond[0] != this.joinConditions[0].indexEndCond[0]) {
            RangeVariable.addConditionsToList(hsqlArrayList, this.joinConditions[0].indexEndCond);
        }
        RangeVariable.addConditionsToList(hsqlArrayList, this.whereConditions[0].indexCond);
        RangeVariable.addConditionsToList(hsqlArrayList, this.whereConditions[0].indexEndCond);
        RangeVariableResolver.decomposeAndConditions(session, this.joinConditions[0].nonIndexCondition, hsqlArrayList);
        RangeVariableResolver.decomposeAndConditions(session, this.whereConditions[0].nonIndexCondition, hsqlArrayList);
        for (n = hsqlArrayList.size() - 1; n >= 0; --n) {
            Expression expression3 = (Expression)hsqlArrayList.get(n);
            if (expression3 != null && !expression3.isTrue() && !expression3.hasReference(rangeVariableArray, n2)) continue;
            hsqlArrayList.remove(n);
        }
        if (hsqlArrayList.size() == 0) {
            if (this.rangeTable.isView()) {
                ((TableDerived)this.rangeTable).resetToView();
            }
            return;
        }
        OrderedHashSet orderedHashSet = null;
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            Expression expression4 = (Expression)hsqlArrayList.get(i);
            orderedHashSet = expression4.collectAllSubqueries(orderedHashSet);
            if (orderedHashSet == null) continue;
            return;
        }
        QueryExpression queryExpression = this.rangeTable.getQueryExpression();
        Expression[] expressionArray = ((QuerySpecification)queryExpression).exprColumns;
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            Expression expression5 = (Expression)hsqlArrayList.get(i);
            expression5 = expression5.duplicate();
            OrderedHashSet orderedHashSet2 = (expression5 = expression5.replaceColumnReferences(session, this, expressionArray)).collectRangeVariables(null);
            if (orderedHashSet2 != null) {
                for (int j = 0; j < orderedHashSet2.size(); ++j) {
                    RangeVariable rangeVariable = (RangeVariable)orderedHashSet2.get(j);
                    if (this == rangeVariable || rangeVariable.rangeType != 1) continue;
                    queryExpression.setCorrelated();
                    break;
                }
            }
            expression2 = ExpressionLogical.andExpressions(expression2, expression5);
        }
        queryExpression.addExtraConditions(expression2);
    }

    private static void addConditionsToList(HsqlArrayList hsqlArrayList, Expression[] expressionArray) {
        if (expressionArray == null) {
            return;
        }
        for (int i = 0; i < expressionArray.length; ++i) {
            if (expressionArray[i] == null || !expressionArray[i].isSingleColumnCondition && !expressionArray[i].isSingleColumnNull && !expressionArray[i].isSingleColumnNotNull) continue;
            hsqlArrayList.add(expressionArray[i]);
        }
    }

    public String describe(Session session, int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        String string = "INNER";
        if (this.isLeftJoin) {
            string = "LEFT OUTER";
            if (this.isRightJoin) {
                string = "FULL";
            }
        } else if (this.isRightJoin) {
            string = "RIGHT OUTER";
        }
        stringBuilder2.append((CharSequence)stringBuilder).append("join type=").append(string).append("\n");
        stringBuilder2.append((CharSequence)stringBuilder).append("table=").append(this.rangeTable.getName().name).append("\n");
        if (this.tableAlias != null) {
            stringBuilder2.append((CharSequence)stringBuilder).append("alias=").append(this.tableAlias.name).append("\n");
        }
        RangeVariableConditions[] rangeVariableConditionsArray = this.joinConditions;
        if (this.whereConditions[0].hasIndexCondition()) {
            rangeVariableConditionsArray = this.whereConditions;
        }
        stringBuilder2.append((CharSequence)stringBuilder).append("cardinality=");
        stringBuilder2.append(this.rangeTable.getRowStore(session).elementCount()).append("\n");
        boolean bl = !rangeVariableConditionsArray[0].hasIndexCondition();
        stringBuilder2.append((CharSequence)stringBuilder);
        if (rangeVariableConditionsArray == this.whereConditions && this.joinConditions[0].nonIndexCondition != null) {
            stringBuilder2.append("join condition = [");
            stringBuilder2.append(this.joinConditions[0].nonIndexCondition.describe(session, n));
            stringBuilder2.append((CharSequence)stringBuilder).append("]\n");
            stringBuilder2.append((CharSequence)stringBuilder);
        }
        stringBuilder2.append("access=").append(bl ? "FULL SCAN" : "INDEX PRED").append("\n");
        for (int i = 0; i < rangeVariableConditionsArray.length; ++i) {
            if (i > 0) {
                stringBuilder2.append((CharSequence)stringBuilder).append("OR condition = [");
            } else {
                stringBuilder2.append((CharSequence)stringBuilder);
                if (rangeVariableConditionsArray == this.whereConditions) {
                    stringBuilder2.append("where condition = [");
                } else {
                    stringBuilder2.append("join condition = [");
                }
            }
            stringBuilder2.append(rangeVariableConditionsArray[i].describe(session, n + 2));
            stringBuilder2.append((CharSequence)stringBuilder).append("]\n");
        }
        if (rangeVariableConditionsArray == this.joinConditions) {
            stringBuilder2.append((CharSequence)stringBuilder);
            if (this.whereConditions[0].nonIndexCondition != null) {
                stringBuilder2.append("where condition = [");
                stringBuilder2.append(this.whereConditions[0].nonIndexCondition.describe(session, n));
                stringBuilder2.append((CharSequence)stringBuilder).append("]\n");
                stringBuilder2.append((CharSequence)stringBuilder);
            }
        }
        return stringBuilder2.toString();
    }

    public RangeIteratorMain getIterator(Session session) {
        RangeIteratorMain rangeIteratorMain = this.isRightJoin ? new RangeIteratorRight(session, this, null) : new RangeIteratorMain(session, this);
        session.sessionContext.setRangeIterator(rangeIteratorMain);
        return rangeIteratorMain;
    }

    public static RangeIterator getIterator(Session session, RangeVariable[] rangeVariableArray) {
        if (rangeVariableArray.length == 1) {
            return rangeVariableArray[0].getIterator(session);
        }
        RangeIteratorMain[] rangeIteratorMainArray = new RangeIteratorMain[rangeVariableArray.length];
        for (int i = 0; i < rangeVariableArray.length; ++i) {
            rangeIteratorMainArray[i] = rangeVariableArray[i].getIterator(session);
        }
        return new RangeIteratorJoined(rangeIteratorMainArray);
    }

    public static class RangeVariableConditions {
        final RangeVariable rangeVar;
        Expression[] indexCond;
        Expression[] indexEndCond;
        int[] opTypes;
        int[] opTypesEnd;
        Expression indexEndCondition;
        int indexedColumnCount;
        Index rangeIndex;
        final boolean isJoin;
        Expression excludeConditions;
        Expression nonIndexCondition;
        Expression terminalCondition;
        int opType;
        int opTypeEnd;
        boolean isFalse;
        boolean reversed;
        boolean hasIndex;

        RangeVariableConditions(RangeVariable rangeVariable, boolean bl) {
            this.rangeVar = rangeVariable;
            this.isJoin = bl;
        }

        RangeVariableConditions(RangeVariableConditions rangeVariableConditions) {
            this.rangeVar = rangeVariableConditions.rangeVar;
            this.isJoin = rangeVariableConditions.isJoin;
            this.nonIndexCondition = rangeVariableConditions.nonIndexCondition;
        }

        boolean hasIndexCondition() {
            return this.indexedColumnCount > 0;
        }

        boolean hasIndex() {
            return this.hasIndex;
        }

        void addCondition(Expression expression2) {
            if (expression2 == null) {
                return;
            }
            if (expression2 instanceof ExpressionLogical && ((ExpressionLogical)expression2).isTerminal) {
                this.terminalCondition = expression2;
            }
            this.nonIndexCondition = ExpressionLogical.andExpressions(this.nonIndexCondition, expression2);
            this.isFalse = Expression.EXPR_FALSE.equals(this.nonIndexCondition);
            if (this.rangeIndex == null || this.rangeIndex.getColumnCount() == 0) {
                return;
            }
            if (this.indexedColumnCount == 0) {
                return;
            }
            if (expression2.getIndexableExpression(this.rangeVar) == null) {
                return;
            }
            int n = expression2.getLeftNode().getColumnIndex();
            int[] nArray = this.rangeIndex.getColumns();
            switch (expression2.getType()) {
                case 41: 
                case 42: 
                case 43: {
                    if (this.opType == 48) {
                        if (nArray[this.indexedColumnCount - 1] != n) break;
                        this.nonIndexCondition = ExpressionLogical.andExpressions(this.nonIndexCondition, this.indexCond[this.indexedColumnCount - 1]);
                        this.indexCond[this.indexedColumnCount - 1] = expression2;
                        this.opType = expression2.opType;
                        this.opTypes[this.indexedColumnCount - 1] = expression2.opType;
                        if (expression2.getType() != 42 || this.indexedColumnCount != 1) break;
                        this.indexEndCond[this.indexedColumnCount - 1] = ExpressionLogical.andExpressions(this.indexEndCond[this.indexedColumnCount - 1], expression2.nodes[2]);
                        break;
                    }
                    this.addToIndexConditions(expression2);
                    break;
                }
                case 44: 
                case 45: {
                    if (this.opType == 43 || this.opType == 41 || this.opType == 42 || this.opType == 48) {
                        if (this.opTypeEnd != 77 || nArray[this.indexedColumnCount - 1] != n) break;
                        this.indexEndCond[this.indexedColumnCount - 1] = expression2;
                        this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, expression2);
                        this.opTypeEnd = expression2.opType;
                        this.opTypesEnd[this.indexedColumnCount - 1] = expression2.opType;
                        break;
                    }
                    this.addToIndexEndConditions(expression2);
                    break;
                }
            }
        }

        private boolean addToIndexConditions(Expression expression2) {
            if ((this.opType == 40 || this.opType == 47) && this.indexedColumnCount < this.rangeIndex.getColumnCount() && this.rangeIndex.getColumns()[this.indexedColumnCount] == expression2.getLeftNode().getColumnIndex()) {
                this.indexCond[this.indexedColumnCount] = expression2;
                this.opType = expression2.opType;
                this.opTypes[this.indexedColumnCount] = expression2.opType;
                this.opTypeEnd = 77;
                this.opTypesEnd[this.indexedColumnCount] = 77;
                ++this.indexedColumnCount;
                return true;
            }
            return false;
        }

        private boolean addToIndexEndConditions(Expression expression2) {
            if ((this.opType == 40 || this.opType == 47) && this.indexedColumnCount < this.rangeIndex.getColumnCount() && this.rangeIndex.getColumns()[this.indexedColumnCount] == expression2.getLeftNode().getColumnIndex()) {
                ExpressionLogical expressionLogical = ExpressionLogical.newNotNullCondition(expression2.getLeftNode());
                this.indexCond[this.indexedColumnCount] = expressionLogical;
                this.indexEndCond[this.indexedColumnCount] = expression2;
                this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, expression2);
                this.opType = 48;
                this.opTypes[this.indexedColumnCount] = 48;
                this.opTypeEnd = expression2.opType;
                this.opTypesEnd[this.indexedColumnCount] = expression2.opType;
                ++this.indexedColumnCount;
                return true;
            }
            return false;
        }

        void addIndexCondition(Expression[] expressionArray, Index index, int n) {
            int n2 = index.getColumnCount();
            this.rangeIndex = index;
            this.indexCond = new Expression[n2];
            this.indexEndCond = new Expression[n2];
            this.opTypes = new int[n2];
            this.opTypesEnd = new int[n2];
            this.opType = expressionArray[0].opType;
            this.opTypes[0] = expressionArray[0].opType;
            switch (this.opType) {
                case 48: {
                    this.indexCond = expressionArray;
                    this.opTypeEnd = 77;
                    this.opTypesEnd[0] = 77;
                    break;
                }
                case 41: 
                case 42: 
                case 43: {
                    this.indexCond = expressionArray;
                    if (expressionArray[0].getType() == 42) {
                        this.indexEndCond[0] = this.indexEndCondition = expressionArray[0].nodes[2];
                    }
                    this.opTypeEnd = 77;
                    this.opTypesEnd[0] = 77;
                    break;
                }
                case 44: 
                case 45: {
                    Expression expression2 = expressionArray[0].getLeftNode();
                    expression2 = new ExpressionLogical(47, expression2);
                    this.indexCond[0] = expression2 = new ExpressionLogical(48, expression2);
                    this.indexEndCond[0] = this.indexEndCondition = expressionArray[0];
                    this.opTypeEnd = this.opType;
                    this.opTypesEnd[0] = this.opType;
                    this.opType = 48;
                    this.opTypes[0] = 48;
                    break;
                }
                case 40: 
                case 47: {
                    this.indexCond = expressionArray;
                    for (int i = 0; i < n; ++i) {
                        Expression expression3;
                        this.indexEndCond[i] = expression3 = expressionArray[i];
                        this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, expression3);
                        this.opType = expression3.opType;
                        this.opTypes[i] = expression3.opType;
                        this.opTypesEnd[i] = expression3.opType;
                    }
                    this.opTypeEnd = this.opType;
                    break;
                }
                default: {
                    throw Error.runtimeError(201, "RangeVariable");
                }
            }
            this.indexedColumnCount = n;
            this.hasIndex = true;
        }

        private void reverseIndexCondition() {
            if (this.indexedColumnCount == 0) {
                this.reversed = true;
                return;
            }
            if (this.opType != 40 && this.opType != 47) {
                this.indexEndCondition = null;
                Expression[] expressionArray = this.indexCond;
                this.indexCond = this.indexEndCond;
                this.indexEndCond = expressionArray;
                int[] nArray = this.opTypes;
                this.opTypes = this.opTypesEnd;
                this.opTypesEnd = nArray;
                for (int i = 0; i < this.indexedColumnCount; ++i) {
                    Expression expression2 = this.indexEndCond[i];
                    this.indexEndCondition = ExpressionLogical.andExpressions(this.indexEndCondition, expression2);
                }
                if (this.indexedColumnCount > 1 && this.opTypes[this.indexedColumnCount - 1] == 77) {
                    --this.indexedColumnCount;
                    this.opTypes[this.indexedColumnCount] = 0;
                    this.opTypesEnd[this.indexedColumnCount] = 0;
                }
                this.opType = this.opTypes[this.indexedColumnCount - 1];
                this.opTypeEnd = this.opTypesEnd[this.indexedColumnCount - 1];
            }
            this.reversed = true;
        }

        String describe(Session session, int n) {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder(n);
            for (n2 = 0; n2 < n; ++n2) {
                stringBuilder2.append(' ');
            }
            stringBuilder.append("index=").append(this.rangeIndex.getName().name).append("\n");
            if (this.hasIndexCondition()) {
                if (this.indexedColumnCount > 0) {
                    stringBuilder.append((CharSequence)stringBuilder2).append("start conditions=[");
                    for (n2 = 0; n2 < this.indexedColumnCount; ++n2) {
                        if (this.indexCond == null || this.indexCond[n2] == null) continue;
                        stringBuilder.append(this.indexCond[n2].describe(session, n));
                    }
                    stringBuilder.append("]\n");
                }
                if (this.opTypeEnd != 40 && this.indexEndCondition != null) {
                    String string = this.indexEndCondition.describe(session, n);
                    stringBuilder.append((CharSequence)stringBuilder2).append("end condition=[").append(string).append("]\n");
                }
            }
            if (this.nonIndexCondition != null) {
                String string = this.nonIndexCondition.describe(session, n);
                stringBuilder.append((CharSequence)stringBuilder2).append("other condition=[").append(string).append("]\n");
            }
            return stringBuilder.toString();
        }

        private void replaceColumnReferences(Session session, RangeVariable rangeVariable, Expression[] expressionArray) {
            int n;
            if (this.indexCond != null) {
                for (n = 0; n < this.indexCond.length; ++n) {
                    if (this.indexCond[n] == null) continue;
                    this.indexCond[n] = this.indexCond[n].replaceColumnReferences(session, rangeVariable, expressionArray);
                }
            }
            if (this.indexEndCond != null) {
                for (n = 0; n < this.indexEndCond.length; ++n) {
                    if (this.indexEndCond[n] == null) continue;
                    this.indexEndCond[n] = this.indexEndCond[n].replaceColumnReferences(session, rangeVariable, expressionArray);
                }
            }
            if (this.indexEndCondition != null) {
                this.indexEndCondition = this.indexEndCondition.replaceColumnReferences(session, rangeVariable, expressionArray);
            }
            if (this.excludeConditions != null) {
                this.excludeConditions = this.excludeConditions.replaceColumnReferences(session, rangeVariable, expressionArray);
            }
            if (this.nonIndexCondition != null) {
                this.nonIndexCondition = this.nonIndexCondition.replaceColumnReferences(session, rangeVariable, expressionArray);
            }
            if (this.terminalCondition != null) {
                this.terminalCondition = this.terminalCondition.replaceColumnReferences(session, rangeVariable, expressionArray);
            }
        }

        private void replaceExpressions(OrderedHashSet orderedHashSet, int n) {
            int n2;
            if (this.indexCond != null) {
                for (n2 = 0; n2 < this.indexCond.length; ++n2) {
                    if (this.indexCond[n2] == null) continue;
                    this.indexCond[n2] = this.indexCond[n2].replaceExpressions(orderedHashSet, n);
                }
            }
            if (this.indexEndCond != null) {
                for (n2 = 0; n2 < this.indexEndCond.length; ++n2) {
                    if (this.indexEndCond[n2] == null) continue;
                    this.indexEndCond[n2] = this.indexEndCond[n2].replaceExpressions(orderedHashSet, n);
                }
            }
            if (this.indexEndCondition != null) {
                this.indexEndCondition = this.indexEndCondition.replaceExpressions(orderedHashSet, n);
            }
            if (this.excludeConditions != null) {
                this.excludeConditions = this.excludeConditions.replaceExpressions(orderedHashSet, n);
            }
            if (this.nonIndexCondition != null) {
                this.nonIndexCondition = this.nonIndexCondition.replaceExpressions(orderedHashSet, n);
            }
            if (this.terminalCondition != null) {
                this.terminalCondition = this.terminalCondition.replaceExpressions(orderedHashSet, n);
            }
        }
    }

    static final class RangeIteratorCheck
    implements RangeIterator {
        final int rangePosition;
        Object[] currentData;

        RangeIteratorCheck() {
            this.rangePosition = 0;
        }

        RangeIteratorCheck(int n) {
            this.rangePosition = n;
        }

        @Override
        public Object getField(int n) {
            return this.currentData[n];
        }

        @Override
        public boolean next() {
            return false;
        }

        @Override
        public Row getCurrentRow() {
            return null;
        }

        @Override
        public Object[] getCurrent() {
            return this.currentData;
        }

        public boolean hasNext() {
            return false;
        }

        public long getPos() {
            return -1L;
        }

        public int getStorageSize() {
            return 0;
        }

        @Override
        public void release() {
        }

        @Override
        public void removeCurrent() {
        }

        @Override
        public long getRowId() {
            return 0L;
        }

        @Override
        public boolean isBeforeFirst() {
            return false;
        }

        @Override
        public void setCurrent(Object[] objectArray) {
            this.currentData = objectArray;
        }

        @Override
        public void reset() {
        }

        @Override
        public int getRangePosition() {
            return this.rangePosition;
        }
    }

    static final class RangeIteratorEmpty
    implements RowIterator {
        RangeIteratorEmpty() {
        }

        @Override
        public Object getField(int n) {
            return null;
        }

        @Override
        public boolean next() {
            return false;
        }

        @Override
        public Row getCurrentRow() {
            return null;
        }

        @Override
        public Object[] getCurrent() {
            return null;
        }

        public boolean hasNext() {
            return false;
        }

        public long getPos() {
            return -1L;
        }

        public int getStorageSize() {
            return 0;
        }

        @Override
        public void release() {
        }

        @Override
        public void removeCurrent() {
        }

        @Override
        public long getRowId() {
            return 0L;
        }
    }

    public static class RangeIteratorJoined
    extends RangeIteratorBase {
        RangeIteratorMain[] rangeIterators;
        int currentIndex = 0;
        RangeIterator currentRange = null;

        public RangeIteratorJoined(RangeIteratorMain[] rangeIteratorMainArray) {
            this.rangeIterators = rangeIteratorMainArray;
            this.isBeforeFirst = true;
        }

        @Override
        public Row getCurrentRow() {
            return this.currentRange.getCurrentRow();
        }

        @Override
        public Object[] getCurrent() {
            return this.currentRange.getCurrent();
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            while (this.currentIndex >= 0) {
                this.currentRange = this.rangeIterators[this.currentIndex];
                if (this.currentRange.next()) {
                    if (this.currentIndex < this.rangeIterators.length - 1) {
                        ++this.currentIndex;
                        continue;
                    }
                    return true;
                }
                this.currentRange.reset();
                --this.currentIndex;
            }
            this.currentRange = null;
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
            return false;
        }

        @Override
        public void removeCurrent() {
        }

        @Override
        public void release() {
            this.it.release();
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
        }

        @Override
        public void reset() {
            super.reset();
            for (int i = 0; i < this.rangeIterators.length; ++i) {
                this.rangeIterators[i].reset();
            }
        }

        @Override
        public int getRangePosition() {
            return 0;
        }
    }

    public static class RangeIteratorRight
    extends RangeIteratorMain {
        boolean isOnRightOuterRows;

        private RangeIteratorRight(Session session, RangeVariable rangeVariable, RangeIteratorMain rangeIteratorMain) {
            super(session, rangeVariable);
            this.isFullIterator = true;
        }

        public void setOnOuterRows() {
            this.conditions = this.rangeVar.whereConditions;
            this.isOnRightOuterRows = true;
            this.hasLeftOuterRow = false;
            this.condIndex = 0;
            this.initialiseIterator();
        }

        @Override
        public boolean next() {
            if (this.isOnRightOuterRows) {
                if (this.it == emptyIterator) {
                    return false;
                }
                return this.findNextRight();
            }
            return super.next();
        }

        private boolean findNextRight() {
            boolean bl;
            block3: {
                bl = false;
                do {
                    if (!this.it.next()) {
                        this.it = emptyIterator;
                        break block3;
                    }
                    if (this.conditions[this.condIndex].indexEndCondition != null && !this.conditions[this.condIndex].indexEndCondition.testCondition(this.session)) break block3;
                } while (this.conditions[this.condIndex].nonIndexCondition != null && !this.conditions[this.condIndex].nonIndexCondition.testCondition(this.session) || !this.lookupAndTest());
                bl = true;
            }
            if (bl) {
                return true;
            }
            this.it.release();
            return bl;
        }

        private boolean lookupAndTest() {
            boolean bl;
            long l = this.it.getRowId();
            boolean bl2 = bl = !this.lookup.contains(l);
            if (bl && this.conditions[this.condIndex].nonIndexCondition != null) {
                bl = this.conditions[this.condIndex].nonIndexCondition.testCondition(this.session);
            }
            return bl;
        }
    }

    public static class RangeIteratorMain
    extends RangeIteratorBase {
        boolean hasLeftOuterRow;
        boolean isFullIterator;
        RangeVariableConditions[] conditions;
        RangeVariableConditions[] whereConditions;
        RangeVariableConditions[] joinConditions;
        ExpressionPeriodOp periodCondition;
        ExpressionLogical filterCondition;
        int condIndex = 0;
        OrderedLongHashSet lookup;
        Object[] currentJoinData = null;

        RangeIteratorMain() {
        }

        private RangeIteratorMain(Session session, RangeVariable rangeVariable) {
            this.rangePosition = rangeVariable.rangePosition;
            this.store = rangeVariable.rangeTable.getRowStore(session);
            this.session = session;
            this.rangeVar = rangeVariable;
            this.isBeforeFirst = true;
            this.whereConditions = rangeVariable.whereConditions;
            this.joinConditions = rangeVariable.joinConditions;
            this.periodCondition = rangeVariable.periodCondition;
            this.filterCondition = rangeVariable.filterCondition;
            if (rangeVariable.isRightJoin) {
                this.lookup = new OrderedLongHashSet();
            }
            this.conditions = rangeVariable.joinConditions;
            if (rangeVariable.whereConditions[0].hasIndexCondition()) {
                this.conditions = rangeVariable.whereConditions;
            }
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            if (this.session.abortTransaction) {
                throw Error.error(4860);
            }
            if (this.session.abortAction) {
                throw Error.error(4872);
            }
            while (this.condIndex < this.conditions.length) {
                boolean bl;
                if (this.isBeforeFirst) {
                    this.isBeforeFirst = false;
                    this.initialiseIterator();
                }
                if (bl = this.findNext()) {
                    return true;
                }
                this.it.release();
                this.it = emptyIterator;
                this.isBeforeFirst = true;
                ++this.condIndex;
            }
            this.condIndex = 0;
            return false;
        }

        @Override
        public void removeCurrent() {
        }

        @Override
        public void reset() {
            this.it.release();
            this.it = emptyIterator;
            this.isBeforeFirst = true;
            this.condIndex = 0;
        }

        @Override
        public int getRangePosition() {
            return this.rangeVar.rangePosition;
        }

        protected void initialiseIterator() {
            if (this.condIndex == 0) {
                this.hasLeftOuterRow = this.rangeVar.isLeftJoin;
            }
            if (this.conditions[this.condIndex].isFalse) {
                this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                return;
            }
            this.rangeVar.rangeTable.materialiseCorrelated(this.session);
            if (this.conditions[this.condIndex].indexCond == null) {
                this.it = this.conditions[this.condIndex].reversed ? this.conditions[this.condIndex].rangeIndex.lastRow(this.session, this.store, this.rangeVar.indexDistinctCount, null) : this.conditions[this.condIndex].rangeIndex.firstRow(this.session, this.store, null, this.rangeVar.indexDistinctCount, null);
            } else {
                this.getFirstRow();
                if (!this.conditions[this.condIndex].isJoin) {
                    this.hasLeftOuterRow = false;
                }
            }
        }

        private void getFirstRow() {
            if (this.currentJoinData == null || this.currentJoinData.length < this.conditions[this.condIndex].indexedColumnCount) {
                this.currentJoinData = new Object[this.conditions[this.condIndex].indexedColumnCount];
            }
            int n = this.conditions[this.condIndex].opType;
            for (int i = 0; i < this.conditions[this.condIndex].indexedColumnCount; ++i) {
                Object object;
                block14: {
                    int n2;
                    int n3;
                    block15: {
                        n3 = 0;
                        int n4 = this.conditions[this.condIndex].opTypes[i];
                        if (n4 == 47 || n4 == 48 || n4 == 77) {
                            this.currentJoinData[i] = null;
                            continue;
                        }
                        Type type = this.conditions[this.condIndex].indexCond[i].getRightNode().getDataType();
                        object = this.conditions[this.condIndex].indexCond[i].getRightNode().getValue(this.session);
                        Type type2 = this.conditions[this.condIndex].indexCond[i].getLeftNode().getDataType();
                        if (i == 0 && object == null) {
                            this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                            return;
                        }
                        if (type2 != type && (n3 = type2.compareToTypeRange(object)) == 0 && type2.typeComparisonGroup != type.typeComparisonGroup) {
                            object = type2.convertToType(this.session, object, type);
                        }
                        if (i != 0) break block14;
                        n2 = this.conditions[this.condIndex].indexCond[0].getType();
                        if (n3 >= 0) break block15;
                        switch (n2) {
                            case 41: 
                            case 42: 
                            case 43: {
                                n = 48;
                                object = null;
                                break block14;
                            }
                            default: {
                                this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                                return;
                            }
                        }
                    }
                    if (n3 > 0) {
                        switch (n2) {
                            case 48: {
                                object = null;
                                break;
                            }
                            case 44: 
                            case 45: {
                                if (this.conditions[this.condIndex].reversed) {
                                    n = 77;
                                    object = null;
                                    break;
                                }
                            }
                            default: {
                                this.it = this.conditions[this.condIndex].rangeIndex.emptyIterator();
                                return;
                            }
                        }
                    }
                }
                this.currentJoinData[i] = object;
            }
            this.it = this.conditions[this.condIndex].rangeIndex.findFirstRow(this.session, this.store, this.currentJoinData, this.conditions[this.condIndex].indexedColumnCount, this.rangeVar.indexDistinctCount, n, this.conditions[this.condIndex].reversed, null);
        }

        private boolean findNext() {
            boolean bl;
            block8: {
                bl = false;
                while (true) {
                    if (this.session.abortTransaction) {
                        throw Error.error(4860);
                    }
                    if (this.session.abortAction) {
                        throw Error.error(4872);
                    }
                    if (!this.it.next()) {
                        this.it.release();
                        this.it = emptyIterator;
                        break block8;
                    }
                    if (this.periodCondition != null && !this.periodCondition.testCondition(this.session) || this.filterCondition != null && !this.filterCondition.testCondition(this.session)) continue;
                    if (this.conditions[this.condIndex].terminalCondition != null && !this.conditions[this.condIndex].terminalCondition.testCondition(this.session)) break block8;
                    if (this.conditions[this.condIndex].indexEndCondition != null && !this.conditions[this.condIndex].indexEndCondition.testCondition(this.session)) {
                        if (!this.conditions[this.condIndex].isJoin) {
                            this.hasLeftOuterRow = false;
                        }
                        break block8;
                    }
                    if (this.joinConditions[this.condIndex].nonIndexCondition != null && !this.joinConditions[this.condIndex].nonIndexCondition.testCondition(this.session)) continue;
                    if (this.whereConditions[this.condIndex].nonIndexCondition != null && !this.whereConditions[this.condIndex].nonIndexCondition.testCondition(this.session)) {
                        this.hasLeftOuterRow = false;
                        this.addFoundRow();
                        continue;
                    }
                    Expression expression2 = this.conditions[this.condIndex].excludeConditions;
                    if (expression2 == null || !expression2.testCondition(this.session)) break;
                }
                this.addFoundRow();
                this.hasLeftOuterRow = false;
                return true;
            }
            this.it.release();
            this.it = emptyIterator;
            if (this.hasLeftOuterRow && this.condIndex == this.conditions.length - 1) {
                bl = this.whereConditions[this.condIndex].nonIndexCondition == null || this.whereConditions[this.condIndex].nonIndexCondition.testCondition(this.session);
                this.hasLeftOuterRow = false;
            }
            return bl;
        }

        private void addFoundRow() {
            if (this.rangeVar.isRightJoin) {
                long l = this.it.getRowId();
                this.lookup.add(l);
            }
        }
    }

    public static class RangeIteratorBase
    implements RangeIterator {
        Session session;
        int rangePosition;
        RowIterator it = RangeVariable.access$500();
        PersistentStore store;
        boolean isBeforeFirst;
        RangeVariable rangeVar;

        private RangeIteratorBase() {
        }

        @Override
        public boolean isBeforeFirst() {
            return this.isBeforeFirst;
        }

        @Override
        public boolean next() {
            if (this.isBeforeFirst) {
                this.isBeforeFirst = false;
            } else if (this.it == emptyIterator) {
                return false;
            }
            if (this.session.abortTransaction) {
                throw Error.error(4860);
            }
            if (this.session.abortAction) {
                throw Error.error(4872);
            }
            return this.it.next();
        }

        @Override
        public Row getCurrentRow() {
            return this.it.getCurrentRow();
        }

        @Override
        public Object[] getCurrent() {
            return this.it.getCurrent();
        }

        @Override
        public Object getField(int n) {
            return this.it.getField(n);
        }

        @Override
        public void setCurrent(Object[] objectArray) {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public long getRowId() {
            return ((long)this.rangeVar.rangeTable.getId() << 32) + this.it.getRowId();
        }

        @Override
        public void removeCurrent() {
        }

        @Override
        public void reset() {
            this.it.release();
            this.it = emptyIterator;
            this.isBeforeFirst = true;
        }

        @Override
        public int getRangePosition() {
            return this.rangePosition;
        }

        public boolean hasNext() {
            throw Error.runtimeError(201, "RangeVariable");
        }

        @Override
        public void release() {
            this.it.release();
        }
    }
}

