/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.flink.util.timestamp;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.streaming.api.functions.AssignerWithPeriodicWatermarks;
import org.apache.flink.streaming.api.functions.AssignerWithPunctuatedWatermarks;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.functions.TimestampAssigner;
import org.apache.flink.streaming.api.scala.DataStream;
import org.apache.flink.streaming.runtime.operators.windowing.TimestampedValue;
import org.apache.flink.util.Collector;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0002\u0004\u0001+!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005C\u0001\t\r\t\u0015a\u0003D\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0005e!\u0016.\\3ti\u0006l\u0007/Q:tS\u001etW.\u001a8u\u0011\u0016d\u0007/\u001a:\u000b\u0005\u001dA\u0011!\u0003;j[\u0016\u001cH/Y7q\u0015\tI!\"\u0001\u0003vi&d'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004f]\u001eLg.\u001a\u0006\u0003\u001fA\t1B\\;tg.t\u0017mY6fe*\u0011\u0011CE\u0001\u0005i>,8NC\u0001\u0014\u0003\t\u0001Hn\u0001\u0001\u0016\u0005YI4C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fM\u0006\tB/[7fgR\fW\u000e]!tg&<g.\u001a:\u0011\u0007}YS&D\u0001!\u0015\t\t#%A\u0005gk:\u001cG/[8og*\u00111\u0005J\u0001\u0004CBL'BA\u0013'\u0003%\u0019HO]3b[&twM\u0003\u0002\fO)\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0013\ta\u0003EA\tUS6,7\u000f^1na\u0006\u001b8/[4oKJ\u00042AL\u001b8\u001b\u0005y#B\u0001\u00192\u0003%9\u0018N\u001c3po&twM\u0003\u00023g\u0005Iq\u000e]3sCR|'o\u001d\u0006\u0003i\u0011\nqA];oi&lW-\u0003\u00027_\t\u0001B+[7fgR\fW\u000e]3e-\u0006dW/\u001a\t\u0003qeb\u0001\u0001B\u0003;\u0001\t\u00071HA\u0001U#\tat\b\u0005\u0002\u0019{%\u0011a(\u0007\u0002\b\u001d>$\b.\u001b8h!\tA\u0002)\u0003\u0002B3\t\u0019\u0011I\\=\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002E\u0015^j\u0011!\u0012\u0006\u0003\r\u001e\u000b\u0001\u0002^=qK&tgm\u001c\u0006\u0003\u0011&\u000baaY8n[>t'BA\u0012'\u0013\tYUIA\bUsB,\u0017J\u001c4pe6\fG/[8o\u0003\u0019a\u0014N\\5u}Q\u0011aJ\u0015\u000b\u0003\u001fF\u00032\u0001\u0015\u00018\u001b\u00051\u0001\"\u0002\"\u0004\u0001\b\u0019\u0005\"B\u000f\u0004\u0001\u0004q\u0012\u0001E1tg&<gnV1uKJl\u0017M]6t)\t)&\fE\u0002W1^j\u0011a\u0016\u0006\u00035\tJ!!W,\u0003\u0015\u0011\u000bG/Y*ue\u0016\fW\u000eC\u0003\\\t\u0001\u0007Q+\u0001\u0004tiJ,\u0017-\u001c")
public class TimestampAssignmentHelper<T> {
    private final TimestampAssigner<TimestampedValue<T>> timestampAssigner;
    private final TypeInformation<T> evidence$1;

    public DataStream<T> assignWatermarks(DataStream<T> stream) {
        DataStream dataStream;
        DataStream timestampedStream = stream.process(new ProcessFunction<T, TimestampedValue<T>>(null){

            public void processElement(T value, ProcessFunction.Context ctx, Collector<TimestampedValue<T>> out) {
                out.collect((Object)new TimestampedValue(value, Predef$.MODULE$.Long2long(ctx.timestamp())));
            }
        }, TypeExtractor.createTypeInfo(TimestampedValue.class));
        TimestampAssigner<TimestampedValue<T>> timestampAssigner = this.timestampAssigner;
        if (timestampAssigner instanceof AssignerWithPeriodicWatermarks) {
            AssignerWithPeriodicWatermarks assignerWithPeriodicWatermarks = (AssignerWithPeriodicWatermarks)timestampAssigner;
            dataStream = timestampedStream.assignTimestampsAndWatermarks(assignerWithPeriodicWatermarks);
        } else if (timestampAssigner instanceof AssignerWithPunctuatedWatermarks) {
            AssignerWithPunctuatedWatermarks assignerWithPunctuatedWatermarks = (AssignerWithPunctuatedWatermarks)timestampAssigner;
            dataStream = timestampedStream.assignTimestampsAndWatermarks(assignerWithPunctuatedWatermarks);
        } else {
            throw new MatchError(timestampAssigner);
        }
        DataStream withTimestampAssigner = dataStream;
        return withTimestampAssigner.map((Function1 & java.io.Serializable & Serializable)tv -> tv.getValue(), this.evidence$1);
    }

    public TimestampAssignmentHelper(TimestampAssigner<TimestampedValue<T>> timestampAssigner, TypeInformation<T> evidence$1) {
        this.timestampAssigner = timestampAssigner;
        this.evidence$1 = evidence$1;
    }
}

