/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.spel;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.support.ReflectionHelper;
import org.springframework.expression.spel.support.ReflectiveMethodExecutor;
import org.springframework.util.ReflectionUtils;
import pl.touk.nussknacker.engine.spel.SpelEspReflectionHelper;

public class OmitAnnotationsMethodExecutor
extends ReflectiveMethodExecutor {
    private final Method method;
    private final Integer varargsPosition;
    private boolean computedPublicDeclaringClass = false;
    private Class<?> publicDeclaringClass;
    private boolean argumentConversionOccurred = false;

    public OmitAnnotationsMethodExecutor(ReflectiveMethodExecutor reflectiveMethodExecutor) {
        super(reflectiveMethodExecutor.getMethod());
        this.method = reflectiveMethodExecutor.getMethod();
        if (this.method.isVarArgs()) {
            Class<?>[] classArray = this.method.getParameterTypes();
            this.varargsPosition = classArray.length - 1;
        } else {
            this.varargsPosition = null;
        }
    }

    @Override
    public Class<?> getPublicDeclaringClass() {
        if (!this.computedPublicDeclaringClass) {
            this.publicDeclaringClass = this.discoverPublicClass(this.method, this.method.getDeclaringClass());
            this.computedPublicDeclaringClass = true;
        }
        return this.publicDeclaringClass;
    }

    private Class<?> discoverPublicClass(Method method, Class<?> clazz) {
        Class<?>[] classArray;
        if (Modifier.isPublic(clazz.getModifiers())) {
            try {
                clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                return clazz;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            this.discoverPublicClass(method, clazz2);
        }
        if (clazz.getSuperclass() != null) {
            return this.discoverPublicClass(method, clazz.getSuperclass());
        }
        return null;
    }

    @Override
    public boolean didArgumentConversionOccur() {
        return this.argumentConversionOccurred;
    }

    @Override
    public TypedValue execute(EvaluationContext evaluationContext, Object object, Object ... objectArray) throws AccessException {
        try {
            if (objectArray != null) {
                this.argumentConversionOccurred = SpelEspReflectionHelper.convertArguments(evaluationContext.getTypeConverter(), objectArray, this.method, this.varargsPosition);
            }
            if (this.method.isVarArgs()) {
                objectArray = ReflectionHelper.setupArgumentsForVarargsInvocation(this.method.getParameterTypes(), objectArray);
            }
            ReflectionUtils.makeAccessible(this.method);
            Object object2 = this.method.invoke(object, objectArray);
            return new TypedValue(object2, new TypeDescriptor(new MethodParameter(this.method, -1)).narrow(object2));
        }
        catch (Exception exception) {
            throw new AccessException("Problem invoking method: " + this.method, exception);
        }
    }
}

