/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.chars.AbstractChar2ReferenceFunction;
import it.unimi.dsi.fastutil.chars.AbstractCharSet;
import it.unimi.dsi.fastutil.chars.Char2ReferenceMap;
import it.unimi.dsi.fastutil.chars.Char2ReferenceMaps;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.AbstractReferenceCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractChar2ReferenceMap<V>
extends AbstractChar2ReferenceFunction<V>
implements Char2ReferenceMap<V>,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractChar2ReferenceMap() {
    }

    @Override
    public boolean containsValue(Object v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(char k) {
        Iterator i = this.char2ReferenceEntrySet().iterator();
        while (i.hasNext()) {
            if (((Char2ReferenceMap.Entry)i.next()).getCharKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public CharSet keySet() {
        return new AbstractCharSet(){

            @Override
            public boolean contains(char k) {
                return AbstractChar2ReferenceMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractChar2ReferenceMap.this.size();
            }

            @Override
            public void clear() {
                AbstractChar2ReferenceMap.this.clear();
            }

            @Override
            public CharIterator iterator() {
                return new CharIterator(){
                    private final ObjectIterator<Char2ReferenceMap.Entry<V>> i;
                    {
                        this.i = Char2ReferenceMaps.fastIterator(AbstractChar2ReferenceMap.this);
                    }

                    @Override
                    public char nextChar() {
                        return ((Char2ReferenceMap.Entry)this.i.next()).getCharKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public ReferenceCollection<V> values() {
        return new AbstractReferenceCollection<V>(){

            @Override
            public boolean contains(Object k) {
                return AbstractChar2ReferenceMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractChar2ReferenceMap.this.size();
            }

            @Override
            public void clear() {
                AbstractChar2ReferenceMap.this.clear();
            }

            @Override
            public ObjectIterator<V> iterator() {
                return new ObjectIterator<V>(){
                    private final ObjectIterator<Char2ReferenceMap.Entry<V>> i;
                    {
                        this.i = Char2ReferenceMaps.fastIterator(AbstractChar2ReferenceMap.this);
                    }

                    @Override
                    public V next() {
                        return ((Char2ReferenceMap.Entry)this.i.next()).getValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public void putAll(Map<? extends Character, ? extends V> m3) {
        if (m3 instanceof Char2ReferenceMap) {
            ObjectIterator i = Char2ReferenceMaps.fastIterator((Char2ReferenceMap)m3);
            while (i.hasNext()) {
                Char2ReferenceMap.Entry e = (Char2ReferenceMap.Entry)i.next();
                this.put(e.getCharKey(), e.getValue());
            }
        } else {
            int n = m3.size();
            Iterator<Map.Entry<Character, V>> i = m3.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<Character, V> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int n = this.size();
        ObjectIterator i = Char2ReferenceMaps.fastIterator(this);
        while (n-- != 0) {
            h2 += ((Char2ReferenceMap.Entry)i.next()).hashCode();
        }
        return h2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m3 = (Map)o;
        if (m3.size() != this.size()) {
            return false;
        }
        return this.char2ReferenceEntrySet().containsAll(m3.entrySet());
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        ObjectIterator i = Char2ReferenceMaps.fastIterator(this);
        int n = this.size();
        boolean first = true;
        s2.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s2.append(", ");
            }
            Char2ReferenceMap.Entry e = (Char2ReferenceMap.Entry)i.next();
            s2.append(String.valueOf(e.getCharKey()));
            s2.append("=>");
            if (this == e.getValue()) {
                s2.append("(this map)");
                continue;
            }
            s2.append(String.valueOf(e.getValue()));
        }
        s2.append("}");
        return s2.toString();
    }

    public static abstract class BasicEntrySet<V>
    extends AbstractObjectSet<Char2ReferenceMap.Entry<V>> {
        protected final Char2ReferenceMap<V> map;

        public BasicEntrySet(Char2ReferenceMap<V> map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Char2ReferenceMap.Entry) {
                Char2ReferenceMap.Entry e = (Char2ReferenceMap.Entry)o;
                char k = e.getCharKey();
                return this.map.containsKey(k) && this.map.get(k) == e.getValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            char k = ((Character)key).charValue();
            Object value = e.getValue();
            return this.map.containsKey(k) && this.map.get(k) == value;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Char2ReferenceMap.Entry) {
                Char2ReferenceMap.Entry e = (Char2ReferenceMap.Entry)o;
                return this.map.remove(e.getCharKey(), e.getValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            char k = ((Character)key).charValue();
            Object v = e.getValue();
            return this.map.remove(k, v);
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    public static class BasicEntry<V>
    implements Char2ReferenceMap.Entry<V> {
        protected char key;
        protected V value;

        public BasicEntry() {
        }

        public BasicEntry(Character key, V value) {
            this.key = key.charValue();
            this.value = value;
        }

        public BasicEntry(char key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public char getCharKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Char2ReferenceMap.Entry) {
                Char2ReferenceMap.Entry e = (Char2ReferenceMap.Entry)o;
                return this.key == e.getCharKey() && this.value == e.getValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Character)) {
                return false;
            }
            Object value = e.getValue();
            return this.key == ((Character)key).charValue() && this.value == value;
        }

        @Override
        public int hashCode() {
            return this.key ^ (this.value == null ? 0 : System.identityHashCode(this.value));
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

