/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SslPrincipalMapper {
    private static final Pattern RULE_PARSER = Pattern.compile("((DEFAULT)|(RULE:(([^/]*)/([^/]*))/([LU])?))");
    private final List<Rule> rules;

    public SslPrincipalMapper(List<Rule> sslPrincipalMappingRules) {
        this.rules = sslPrincipalMappingRules;
    }

    public static SslPrincipalMapper fromRules(List<String> sslPrincipalMappingRules) {
        List<String> rules = sslPrincipalMappingRules == null ? Collections.singletonList("DEFAULT") : sslPrincipalMappingRules;
        return new SslPrincipalMapper(SslPrincipalMapper.parseRules(rules));
    }

    private static List<String> joinSplitRules(List<String> rules) {
        String rule = "RULE:";
        String defaultRule = "DEFAULT";
        ArrayList<String> retVal = new ArrayList<String>();
        StringBuilder currentRule = new StringBuilder();
        for (String r : rules) {
            if (currentRule.length() > 0) {
                if (r.startsWith(rule) || r.equals(defaultRule)) {
                    retVal.add(currentRule.toString());
                    currentRule.setLength(0);
                    currentRule.append(r);
                    continue;
                }
                currentRule.append(String.format(",%s", r));
                continue;
            }
            currentRule.append(r);
        }
        if (currentRule.length() > 0) {
            retVal.add(currentRule.toString());
        }
        return retVal;
    }

    private static List<Rule> parseRules(List<String> rules) {
        rules = SslPrincipalMapper.joinSplitRules(rules);
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (String rule : rules) {
            Matcher matcher = RULE_PARSER.matcher(rule);
            if (!matcher.lookingAt()) {
                throw new IllegalArgumentException("Invalid rule: " + rule);
            }
            if (rule.length() != matcher.end()) {
                throw new IllegalArgumentException("Invalid rule: `" + rule + "`, unmatched substring: `" + rule.substring(matcher.end()) + "`");
            }
            if (matcher.group(2) != null) {
                result.add(new Rule());
                continue;
            }
            result.add(new Rule(matcher.group(5), matcher.group(6), "L".equals(matcher.group(7)), "U".equals(matcher.group(7))));
        }
        return result;
    }

    public String getName(String distinguishedName) throws IOException {
        for (Rule r : this.rules) {
            String principalName = r.apply(distinguishedName);
            if (principalName == null) continue;
            return principalName;
        }
        throw new NoMatchingRule("No rules apply to " + distinguishedName + ", rules " + this.rules);
    }

    public String toString() {
        return "SslPrincipalMapper(rules = " + this.rules + ")";
    }

    private static class Rule {
        private static final Pattern BACK_REFERENCE_PATTERN = Pattern.compile("\\$(\\d+)");
        private final boolean isDefault;
        private final Pattern pattern;
        private final String replacement;
        private final boolean toLowerCase;
        private final boolean toUpperCase;

        Rule() {
            this.isDefault = true;
            this.pattern = null;
            this.replacement = null;
            this.toLowerCase = false;
            this.toUpperCase = false;
        }

        Rule(String pattern, String replacement, boolean toLowerCase, boolean toUpperCase) {
            this.isDefault = false;
            this.pattern = pattern == null ? null : Pattern.compile(pattern);
            this.replacement = replacement;
            this.toLowerCase = toLowerCase;
            this.toUpperCase = toUpperCase;
        }

        String apply(String distinguishedName) {
            if (this.isDefault) {
                return distinguishedName;
            }
            String result = null;
            Matcher m3 = this.pattern.matcher(distinguishedName);
            if (m3.matches()) {
                result = distinguishedName.replaceAll(this.pattern.pattern(), this.escapeLiteralBackReferences(this.replacement, m3.groupCount()));
            }
            if (this.toLowerCase && result != null) {
                result = result.toLowerCase(Locale.ENGLISH);
            } else if (this.toUpperCase & result != null) {
                result = result.toUpperCase(Locale.ENGLISH);
            }
            return result;
        }

        private String escapeLiteralBackReferences(String unescaped, int numCapturingGroups) {
            if (numCapturingGroups == 0) {
                return unescaped;
            }
            String value = unescaped;
            Matcher backRefMatcher = BACK_REFERENCE_PATTERN.matcher(value);
            while (backRefMatcher.find()) {
                int originalBackRefIndex;
                int backRefIndex;
                String backRefNum = backRefMatcher.group(1);
                if (backRefNum.startsWith("0")) continue;
                for (backRefIndex = originalBackRefIndex = Integer.parseInt(backRefNum); backRefIndex > numCapturingGroups && backRefIndex >= 10; backRefIndex /= 10) {
                }
                if (backRefIndex <= numCapturingGroups) continue;
                StringBuilder sb = new StringBuilder(value.length() + 1);
                int groupStart = backRefMatcher.start(1);
                sb.append(value.substring(0, groupStart - 1));
                sb.append("\\");
                sb.append(value.substring(groupStart - 1));
                value = sb.toString();
            }
            return value;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            if (this.isDefault) {
                buf.append("DEFAULT");
            } else {
                buf.append("RULE:");
                if (this.pattern != null) {
                    buf.append(this.pattern);
                }
                if (this.replacement != null) {
                    buf.append("/");
                    buf.append(this.replacement);
                }
                if (this.toLowerCase) {
                    buf.append("/L");
                } else if (this.toUpperCase) {
                    buf.append("/U");
                }
            }
            return buf.toString();
        }
    }

    public static class NoMatchingRule
    extends IOException {
        NoMatchingRule(String msg) {
            super(msg);
        }
    }
}

