/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionValue;
import org.hsqldb.Like;
import org.hsqldb.RangeGroup;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.Type;

public final class ExpressionLike
extends ExpressionLogical {
    private static final int ESCAPE = 2;
    private Like likeObject;

    ExpressionLike(Expression expression2, Expression expression3, Expression expression4, boolean bl) {
        super(53);
        this.nodes = new Expression[3];
        this.nodes[0] = expression2;
        this.nodes[1] = expression3;
        this.nodes[2] = expression4;
        this.likeObject = new Like();
        this.noOptimisation = bl;
    }

    private ExpressionLike(ExpressionLike expressionLike) {
        super(53);
        this.nodes = expressionLike.nodes;
        this.likeObject = expressionLike.likeObject;
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeGroup rangeGroup, int n, RangeGroup[] rangeGroupArray, HsqlList hsqlList, boolean bl) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            hsqlList = this.nodes[i].resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, hsqlList, bl);
        }
        return hsqlList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue(Session session) {
        Object object;
        if (this.opType != 53) {
            return super.getValue(session);
        }
        Object object2 = this.nodes[0].getValue(session);
        Object object3 = this.nodes[1].getValue(session);
        Object object4 = object = this.nodes[2] == null ? null : this.nodes[2].getValue(session);
        if (this.likeObject.isVariable) {
            Like like = this.likeObject;
            synchronized (like) {
                this.likeObject.setPattern(session, object3, object, this.nodes[2] != null);
                return this.likeObject.compare(session, object2);
            }
        }
        return this.likeObject.compare(session, object2);
    }

    @Override
    public void resolveTypes(Session session, Expression expression2) {
        boolean bl;
        boolean bl2;
        int n;
        if (this.opType != 53) {
            return;
        }
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n] == null) continue;
            this.nodes[n].resolveTypes(session, this);
        }
        if (this.nodes[0].isUnresolvedParam() && this.nodes[1].isUnresolvedParam()) {
            this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
        }
        if (this.nodes[0].dataType == null && this.nodes[1].dataType == null) {
            throw Error.error(5567);
        }
        if (this.nodes[0].isUnresolvedParam()) {
            this.nodes[0].dataType = this.nodes[1].dataType.isBinaryType() ? Type.SQL_VARBINARY_DEFAULT : Type.SQL_VARCHAR_DEFAULT;
        } else if (this.nodes[1].isUnresolvedParam()) {
            Type type = this.nodes[1].dataType = this.nodes[0].dataType.isBinaryType() ? Type.SQL_VARBINARY_DEFAULT : Type.SQL_VARCHAR_DEFAULT;
        }
        if (this.nodes[0].dataType == null || this.nodes[1].dataType == null) {
            throw Error.error(5567);
        }
        n = this.nodes[0].dataType.typeComparisonGroup;
        if (n != 12) {
            if (n == 61) {
                this.likeObject.isBinary = true;
            } else {
                if (session.database.sqlEnforceTypes) {
                    throw Error.error(5562);
                }
                if (n == 1111) {
                    throw Error.error(5563);
                }
                this.nodes[0] = ExpressionOp.getCastExpression(session, this.nodes[0], Type.SQL_VARCHAR_DEFAULT);
                n = 12;
            }
        }
        if (this.nodes[1].dataType.typeComparisonGroup != n) {
            throw Error.error(5563);
        }
        if (n == 12) {
            bl2 = !this.nodes[0].dataType.getCollation().isCaseSensitive() || !this.nodes[1].dataType.getCollation().isCaseSensitive();
            this.likeObject.setIgnoreCase(bl2);
        }
        this.likeObject.dataType = this.nodes[0].dataType;
        bl2 = true;
        if (this.nodes[2] != null) {
            if (this.nodes[2].isUnresolvedParam()) {
                Type type = this.nodes[2].dataType = this.likeObject.isBinary ? Type.SQL_VARBINARY : Type.SQL_VARCHAR;
            }
            if (this.nodes[2].dataType.typeComparisonGroup != n) {
                throw Error.error(5563);
            }
            this.nodes[2].resolveTypes(session, this);
            boolean bl3 = bl2 = this.nodes[2].opType == 1;
            if (bl2) {
                this.nodes[2].setAsConstantValue(session, expression2);
                if (this.nodes[2].dataType == null) {
                    throw Error.error(5567);
                }
                if (this.nodes[2].valueData != null) {
                    long l;
                    switch (this.nodes[2].dataType.typeCode) {
                        case 1: 
                        case 12: {
                            l = ((String)this.nodes[2].valueData).length();
                            break;
                        }
                        case 60: 
                        case 61: {
                            l = ((BinaryData)this.nodes[2].valueData).length(session);
                            break;
                        }
                        default: {
                            throw Error.error(5563);
                        }
                    }
                    if (l != 1L) {
                        throw Error.error(3439);
                    }
                }
            }
        }
        boolean bl4 = bl = this.nodes[1].opType == 1;
        if (bl && bl2) {
            if (this.nodes[0].opType == 1) {
                this.setAsConstantValue(session, expression2);
                this.likeObject = null;
                return;
            }
            this.likeObject.isVariable = false;
        }
        Object object = bl ? this.nodes[1].getValue(session) : null;
        boolean bl5 = bl2 && this.nodes[2] != null;
        Object object2 = bl5 ? this.nodes[2].getValue(session) : null;
        this.likeObject.setPattern(session, object, object2, this.nodes[2] != null);
        if (this.noOptimisation) {
            return;
        }
        if (this.likeObject.isEquivalentToUnknownPredicate()) {
            this.setAsConstantValue(session, expression2);
            this.likeObject = null;
            return;
        }
        if (this.likeObject.isEquivalentToEqualsPredicate()) {
            this.opType = 40;
            this.nodes[1] = new ExpressionValue(this.likeObject.getRangeLow(), Type.SQL_VARCHAR);
            this.likeObject = null;
            this.setEqualityMode();
            return;
        }
        if (this.likeObject.isEquivalentToNotNullPredicate()) {
            ExpressionLogical expressionLogical = new ExpressionLogical(47, this.nodes[0]);
            this.opType = 48;
            this.nodes = new Expression[1];
            this.nodes[0] = expressionLogical;
            this.likeObject = null;
            return;
        }
        if (this.nodes[0].opType == 2) {
            ExpressionLike expressionLike = new ExpressionLike(this);
            ExpressionOp expressionOp = new ExpressionOp(37, this.nodes[1], this.nodes[2]);
            ((Expression)expressionOp).resolveTypes(session, null);
            ExpressionOp expressionOp2 = new ExpressionOp(87, this.nodes[0], (Expression)expressionOp);
            ExpressionLogical expressionLogical = new ExpressionLogical(40, expressionOp2, expressionOp);
            expressionLogical = new ExpressionLogical(42, this.nodes[0], expressionOp, expressionLogical);
            this.nodes = new Expression[2];
            this.likeObject = null;
            this.nodes[0] = expressionLogical;
            this.nodes[1] = expressionLike;
            this.opType = 49;
        }
    }

    @Override
    public String getSQL() {
        if (this.likeObject == null) {
            return super.getSQL();
        }
        String string = ExpressionLike.getContextSQL(this.nodes[0]);
        String string2 = ExpressionLike.getContextSQL(this.nodes[1]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append(' ').append("LIKE").append(' ');
        stringBuilder.append(string2);
        if (this.nodes[2] != null) {
            stringBuilder.append(' ').append("ESCAPE").append(' ');
            stringBuilder.append(this.nodes[2].getSQL());
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    @Override
    protected String describe(Session session, int n) {
        if (this.likeObject == null) {
            return super.describe(session, n);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append("LIKE ");
        stringBuilder.append(this.likeObject.describe(session));
        return stringBuilder.toString();
    }

    @Override
    public Expression duplicate() {
        ExpressionLike expressionLike = (ExpressionLike)super.duplicate();
        if (this.likeObject != null) {
            expressionLike.likeObject = this.likeObject.duplicate();
        }
        return expressionLike;
    }
}

