/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.types;

import cats.data.IndexedStateT;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Optional;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import pl.touk.nussknacker.engine.api.Documentation;
import pl.touk.nussknacker.engine.api.ParamName;
import pl.touk.nussknacker.engine.api.process.ClassExtractionSettings;
import pl.touk.nussknacker.engine.api.process.PropertyFromGetterExtractionStrategy;
import pl.touk.nussknacker.engine.api.process.PropertyFromGetterExtractionStrategy$AddPropertyNextToGetter$;
import pl.touk.nussknacker.engine.api.process.PropertyFromGetterExtractionStrategy$DoNothing$;
import pl.touk.nussknacker.engine.api.process.PropertyFromGetterExtractionStrategy$ReplaceGetterWithProperty$;
import pl.touk.nussknacker.engine.api.process.VisibleMembersPredicate;
import pl.touk.nussknacker.engine.api.typed.typing;
import pl.touk.nussknacker.engine.api.typed.typing$Typed$;
import pl.touk.nussknacker.engine.api.typed.typing$Unknown$;
import pl.touk.nussknacker.engine.definition.TypeInfos;
import pl.touk.nussknacker.engine.util.Implicits$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public final class EspTypeUtils$ {
    public static EspTypeUtils$ MODULE$;

    static {
        new EspTypeUtils$();
    }

    public TypeInfos.ClazzDefinition clazzDefinition(Class<?> clazz, ClassExtractionSettings settings) {
        return new TypeInfos.ClazzDefinition(typing$Typed$.MODULE$.apply(clazz), this.extractPublicMethodAndFields(clazz, settings));
    }

    private Map<String, List<TypeInfos.MethodInfo>> extractPublicMethodAndFields(Class<?> clazz, ClassExtractionSettings settings) {
        VisibleMembersPredicate membersPredicate = settings.visibleMembersPredicate(clazz);
        Map<String, List<TypeInfos.MethodInfo>> methods = this.extractPublicMethods(clazz, membersPredicate, settings);
        Map fields = Implicits$.MODULE$.RichScalaMap(this.extractPublicFields(clazz, membersPredicate, settings)).mapValuesNow((Function1 & Serializable & scala.Serializable)x$1 -> new .colon.colon(x$1, (List)Nil$.MODULE$));
        return methods.$plus$plus(fields);
    }

    private Map<String, List<TypeInfos.MethodInfo>> extractPublicMethods(Class<?> clazz, VisibleMembersPredicate membersPredicate, ClassExtractionSettings settings) {
        List additionalMethods = clazz.isInterface() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Object.class.getMethods())).toList() : (clazz.isPrimitive() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ClassUtils.primitiveToWrapper(clazz).getMethods())).toList() : List$.MODULE$.empty());
        List publicMethods = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])clazz.getMethods())).toList().$plus$plus((GenTraversableOnce)additionalMethods, List$.MODULE$.canBuildFrom());
        List filteredMethods = (List)publicMethods.filter((Function1 & Serializable & scala.Serializable)member -> BoxesRunTime.boxToBoolean((boolean)membersPredicate.shouldBeVisible(member)));
        List methodNameAndInfoList = (List)filteredMethods.flatMap((Function1 & Serializable & scala.Serializable)method -> {
            TypeInfos.MethodInfo extractedMethod = MODULE$.extractMethod((Method)method);
            return (List)MODULE$.collectMethodNames((Method)method, settings).map((Function1 & Serializable & scala.Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$2), (Object)extractedMethod), List$.MODULE$.canBuildFrom());
        }, List$.MODULE$.canBuildFrom());
        return this.deduplicateMethodsWithGenericReturnType((List<Tuple2<String, TypeInfos.MethodInfo>>)methodNameAndInfoList);
    }

    private Map<String, List<TypeInfos.MethodInfo>> deduplicateMethodsWithGenericReturnType(List<Tuple2<String, TypeInfos.MethodInfo>> methodNameAndInfoList) {
        Map groupedByNameAndParameters = methodNameAndInfoList.groupBy((Function1 & Serializable & scala.Serializable)mi -> new Tuple2(mi._1(), ((TypeInfos.MethodInfo)mi._2()).parameters()));
        return Implicits$.MODULE$.RichTupleList((List)groupedByNameAndParameters.toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List methodsForParams = (List)tuple2._2();
            Tuple2 tuple22 = (Tuple2)methodsForParams.find((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)EspTypeUtils$.$anonfun$deduplicateMethodsWithGenericReturnType$3(methodsForParams, x0$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Tuple2)methodsForParams.minBy((Function1 & Serializable & scala.Serializable)x$3 -> ((TypeInfos.MethodInfo)x$3._2()).refClazz().display(), (Ordering)Ordering.String$.MODULE$));
            return tuple22;
        }, List$.MODULE$.canBuildFrom())).toGroupedMap();
    }

    private List<String> collectMethodNames(Method method, ClassExtractionSettings settings) {
        .colon.colon colon2;
        boolean isGetter;
        boolean bl = isGetter = method.getName().matches("^(get|is).+") && method.getParameterCount() == 0;
        if (isGetter) {
            .colon.colon colon3;
            String propertyMethod = StringUtils.uncapitalize(method.getName().replaceAll("^get|^is", ""));
            PropertyFromGetterExtractionStrategy propertyFromGetterExtractionStrategy = settings.propertyExtractionStrategy();
            if (PropertyFromGetterExtractionStrategy$AddPropertyNextToGetter$.MODULE$.equals(propertyFromGetterExtractionStrategy)) {
                colon3 = new .colon.colon((Object)method.getName(), (List)new .colon.colon((Object)propertyMethod, (List)Nil$.MODULE$));
            } else if (PropertyFromGetterExtractionStrategy$ReplaceGetterWithProperty$.MODULE$.equals(propertyFromGetterExtractionStrategy)) {
                colon3 = new .colon.colon((Object)propertyMethod, (List)Nil$.MODULE$);
            } else if (PropertyFromGetterExtractionStrategy$DoNothing$.MODULE$.equals(propertyFromGetterExtractionStrategy)) {
                colon3 = new .colon.colon((Object)method.getName(), (List)Nil$.MODULE$);
            } else {
                throw new MatchError((Object)propertyFromGetterExtractionStrategy);
            }
            colon2 = colon3;
        } else {
            colon2 = new .colon.colon((Object)method.getName(), (List)Nil$.MODULE$);
        }
        return colon2;
    }

    private TypeInfos.MethodInfo extractMethod(Method method) {
        return new TypeInfos.MethodInfo(this.extractParameters(method), this.extractMethodReturnType(method), this.extractNussknackerDocs(method), method.isVarArgs());
    }

    private Map<String, TypeInfos.MethodInfo> extractPublicFields(Class<?> clazz, VisibleMembersPredicate membersPredicate, ClassExtractionSettings settings) {
        Field[] interestingFields = (Field[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])clazz.getFields())).filter((Function1 & Serializable & scala.Serializable)member -> BoxesRunTime.boxToBoolean((boolean)membersPredicate.shouldBeVisible(member)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])interestingFields)).map((Function1 & Serializable & scala.Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), (Object)new TypeInfos.MethodInfo((List<TypeInfos.Parameter>)List$.MODULE$.empty(), MODULE$.extractFieldReturnType((Field)field), MODULE$.extractNussknackerDocs((AccessibleObject)field), false)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    private Option<String> extractNussknackerDocs(AccessibleObject accessibleObject) {
        return Option$.MODULE$.apply((Object)accessibleObject.getAnnotation(Documentation.class)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.description());
    }

    private List<TypeInfos.Parameter> extractParameters(Method method) {
        return (List)((List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])method.getParameters())).toList().map((Function1 & Serializable & scala.Serializable)param -> {
            Option annotationOption = Option$.MODULE$.apply((Object)param.getAnnotation(ParamName.class));
            String name = (String)annotationOption.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.value()).getOrElse((Function0 & Serializable & scala.Serializable)() -> param.getName());
            typing.TypingResult paramType = MODULE$.extractParameterType((Parameter)param);
            return new Tuple4(param, (Object)annotationOption, (Object)name, (Object)paramType);
        }, List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$6 -> {
            Tuple4 tuple4 = x$6;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            String name = (String)tuple4._3();
            typing.TypingResult paramType = (typing.TypingResult)tuple4._4();
            TypeInfos.Parameter parameter = new TypeInfos.Parameter(name, paramType);
            return parameter;
        }, List$.MODULE$.canBuildFrom());
    }

    public typing.TypingResult extractParameterType(Parameter javaParam) {
        return (typing.TypingResult)this.extractClass(javaParam.getParameterizedType()).getOrElse((Function0 & Serializable & scala.Serializable)() -> typing$Typed$.MODULE$.apply(javaParam.getType()));
    }

    private typing.TypingResult extractFieldReturnType(Field field) {
        return (typing.TypingResult)this.extractGenericReturnType(field.getGenericType()).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.extractClass(field.getGenericType())).getOrElse((Function0 & Serializable & scala.Serializable)() -> typing$Typed$.MODULE$.apply(field.getType()));
    }

    public typing.TypingResult extractMethodReturnType(Method method) {
        return (typing.TypingResult)this.extractGenericReturnType(method.getGenericReturnType()).orElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.extractClass(method.getGenericReturnType())).getOrElse((Function0 & Serializable & scala.Serializable)() -> typing$Typed$.MODULE$.apply(method.getReturnType()));
    }

    private Option<typing.TypingResult> extractGenericReturnType(Type typ) {
        Option<typing.TypingResult> option;
        Type type = typ;
        if (type instanceof ParameterizedTypeImpl) {
            ParameterizedTypeImpl parameterizedTypeImpl = (ParameterizedTypeImpl)type;
            option = this.extractGenericMonadReturnType(parameterizedTypeImpl);
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    private Option<typing.TypingResult> extractGenericMonadReturnType(ParameterizedTypeImpl genericReturnType) {
        Option<typing.TypingResult> option;
        Type rawType = genericReturnType.getRawType();
        if (IndexedStateT.class.isAssignableFrom((Class<?>)rawType)) {
            Type returnType = genericReturnType.getActualTypeArguments()[3];
            option = this.extractClass(returnType);
        } else if (Option.class.isAssignableFrom((Class<?>)rawType)) {
            Type optionGenericType = genericReturnType.getActualTypeArguments()[0];
            option = this.extractClass(optionGenericType);
        } else if (Optional.class.isAssignableFrom((Class<?>)rawType)) {
            Type optionalGenericType = genericReturnType.getActualTypeArguments()[0];
            option = this.extractClass(optionalGenericType);
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    private Option<typing.TypingResult> extractClass(Type typ) {
        None$ none$;
        Type type = typ;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            none$ = new Some((Object)typing$Typed$.MODULE$.apply(clazz));
        } else if (type instanceof ParameterizedTypeImpl) {
            ParameterizedTypeImpl parameterizedTypeImpl = (ParameterizedTypeImpl)type;
            none$ = new Some((Object)this.extractGenericParams(parameterizedTypeImpl));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private typing.TypingResult extractGenericParams(ParameterizedTypeImpl paramsType) {
        Type rawType = paramsType.getRawType();
        return typing$Typed$.MODULE$.genericTypeClass((Class<?>)rawType, (List<typing.TypingResult>)((List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paramsType.getActualTypeArguments())).toList().map((Function1 & Serializable & scala.Serializable)p -> (typing.TypingResult)MODULE$.extractClass((Type)p).getOrElse((Function0 & Serializable & scala.Serializable)() -> typing$Unknown$.MODULE$), List$.MODULE$.canBuildFrom())));
    }

    public <T> T companionObject(Class<T> klazz) {
        return (T)klazz.getField("MODULE$").get(null);
    }

    public static final /* synthetic */ boolean $anonfun$deduplicateMethodsWithGenericReturnType$3(List methodsForParams$1, Tuple2 x0$2) {
        TypeInfos.MethodInfo methodInfo;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null || (methodInfo = (TypeInfos.MethodInfo)tuple2._2()) == null) {
            throw new MatchError((Object)tuple2);
        }
        typing.TypingResult ret = methodInfo.refClazz();
        boolean bl = methodsForParams$1.forall((Function1 & Serializable & scala.Serializable)mi -> BoxesRunTime.boxToBoolean((boolean)ret.canBeSubclassOf(((TypeInfos.MethodInfo)mi._2()).refClazz())));
        return bl;
    }

    private EspTypeUtils$() {
        MODULE$ = this;
    }
}

