/*
 * Decompiled with CFR 0.152.
 */
package com.clearspring.analytics.util;

import com.clearspring.analytics.util.ListNode2;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class DoublyLinkedList<T>
implements Iterable<T> {
    protected int size;
    protected ListNode2<T> tail;
    protected ListNode2<T> head;

    public ListNode2<T> add(T value) {
        ListNode2<T> node2 = new ListNode2<T>(value);
        if (this.size++ == 0) {
            this.tail = node2;
        } else {
            node2.prev = this.head;
            this.head.next = node2;
        }
        this.head = node2;
        return node2;
    }

    public ListNode2<T> enqueue(T value) {
        ListNode2<T> node2 = new ListNode2<T>(value);
        if (this.size++ == 0) {
            this.head = node2;
        } else {
            node2.next = this.tail;
            this.tail.prev = node2;
        }
        this.tail = node2;
        return node2;
    }

    public void add(ListNode2<T> node2) {
        node2.prev = this.head;
        node2.next = null;
        if (this.size++ == 0) {
            this.tail = node2;
        } else {
            this.head.next = node2;
        }
        this.head = node2;
    }

    public ListNode2<T> addAfter(ListNode2<T> node2, T value) {
        ListNode2<T> newNode = new ListNode2<T>(value);
        this.addAfter(node2, newNode);
        return newNode;
    }

    public void addAfter(ListNode2<T> node2, ListNode2<T> newNode) {
        newNode.next = node2.next;
        newNode.prev = node2;
        node2.next = newNode;
        if (newNode.next == null) {
            this.head = newNode;
        } else {
            newNode.next.prev = newNode;
        }
        ++this.size;
    }

    public void remove(ListNode2<T> node2) {
        if (node2 == this.tail) {
            this.tail = node2.next;
        } else {
            node2.prev.next = node2.next;
        }
        if (node2 == this.head) {
            this.head = node2.prev;
        } else {
            node2.next.prev = node2.prev;
        }
        --this.size;
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<T> iterator() {
        return new DoublyLinkedListIterator(this);
    }

    public T first() {
        return this.tail == null ? null : (T)this.tail.getValue();
    }

    public T last() {
        return this.head == null ? null : (T)this.head.getValue();
    }

    public ListNode2<T> head() {
        return this.head;
    }

    public ListNode2<T> tail() {
        return this.tail;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public T[] toArray() {
        Object[] a = new Object[this.size];
        int i = 0;
        for (T v : this) {
            a[i++] = v;
        }
        return a;
    }

    protected class DoublyLinkedListIterator
    implements Iterator<T> {
        protected DoublyLinkedList<T> list;
        protected ListNode2<T> itr;
        protected int length;

        public DoublyLinkedListIterator(DoublyLinkedList<T> list) {
            this.length = list.size;
            this.list = list;
            this.itr = list.tail;
        }

        @Override
        public boolean hasNext() {
            return this.itr != null;
        }

        @Override
        public T next() {
            if (this.length != this.list.size) {
                throw new ConcurrentModificationException();
            }
            Object next = this.itr.value;
            this.itr = this.itr.next;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

