/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kafka.internals;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.connectors.kafka.KafkaDeserializationSchema;
import org.apache.flink.util.Collector;
import org.apache.kafka.clients.consumer.ConsumerRecord;

@Internal
public class KafkaDeserializationSchemaWrapper<T>
implements KafkaDeserializationSchema<T> {
    private static final long serialVersionUID = 2651665280744549932L;
    private final DeserializationSchema<T> deserializationSchema;

    public KafkaDeserializationSchemaWrapper(DeserializationSchema<T> deserializationSchema) {
        this.deserializationSchema = deserializationSchema;
    }

    @Override
    public void open(DeserializationSchema.InitializationContext context) throws Exception {
        this.deserializationSchema.open(context);
    }

    @Override
    public T deserialize(ConsumerRecord<byte[], byte[]> record2) throws Exception {
        throw new UnsupportedOperationException("Should never be called");
    }

    @Override
    public void deserialize(ConsumerRecord<byte[], byte[]> message, Collector<T> out) throws Exception {
        this.deserializationSchema.deserialize(message.value(), out);
    }

    @Override
    public boolean isEndOfStream(T nextElement) {
        return this.deserializationSchema.isEndOfStream(nextElement);
    }

    public TypeInformation<T> getProducedType() {
        return this.deserializationSchema.getProducedType();
    }
}

