/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class ConfigEntry {
    private final String name;
    private final String value;
    private final ConfigSource source;
    private final boolean isSensitive;
    private final boolean isReadOnly;
    private final List<ConfigSynonym> synonyms;

    public ConfigEntry(String name, String value) {
        this(name, value, false, false, false);
    }

    @Deprecated
    public ConfigEntry(String name, String value, boolean isDefault, boolean isSensitive, boolean isReadOnly) {
        this(name, value, isDefault ? ConfigSource.DEFAULT_CONFIG : ConfigSource.UNKNOWN, isSensitive, isReadOnly, Collections.emptyList());
    }

    ConfigEntry(String name, String value, ConfigSource source2, boolean isSensitive, boolean isReadOnly, List<ConfigSynonym> synonyms) {
        Objects.requireNonNull(name, "name should not be null");
        this.name = name;
        this.value = value;
        this.source = source2;
        this.isSensitive = isSensitive;
        this.isReadOnly = isReadOnly;
        this.synonyms = synonyms;
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public ConfigSource source() {
        return this.source;
    }

    public boolean isDefault() {
        return this.source == ConfigSource.DEFAULT_CONFIG;
    }

    public boolean isSensitive() {
        return this.isSensitive;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public List<ConfigSynonym> synonyms() {
        return this.synonyms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigEntry that = (ConfigEntry)o;
        return this.name.equals(that.name) && this.value != null ? this.value.equals(that.value) : that.value == null && this.isSensitive == that.isSensitive && this.isReadOnly == that.isReadOnly && this.source == that.source && Objects.equals(this.synonyms, that.synonyms);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.isSensitive ? 1 : 0);
        result = 31 * result + (this.isReadOnly ? 1 : 0);
        result = 31 * result + this.source.hashCode();
        result = 31 * result + this.synonyms.hashCode();
        return result;
    }

    public String toString() {
        return "ConfigEntry(name=" + this.name + ", value=" + this.value + ", source=" + (Object)((Object)this.source) + ", isSensitive=" + this.isSensitive + ", isReadOnly=" + this.isReadOnly + ", synonyms=" + this.synonyms + ")";
    }

    public static class ConfigSynonym {
        private final String name;
        private final String value;
        private final ConfigSource source;

        ConfigSynonym(String name, String value, ConfigSource source2) {
            this.name = name;
            this.value = value;
            this.source = source2;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public ConfigSource source() {
            return this.source;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigSynonym that = (ConfigSynonym)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && this.source == that.source;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.name, this.value, this.source});
        }

        public String toString() {
            return "ConfigSynonym(name=" + this.name + ", value=" + this.value + ", source=" + (Object)((Object)this.source) + ")";
        }
    }

    public static enum ConfigSource {
        DYNAMIC_TOPIC_CONFIG,
        DYNAMIC_BROKER_LOGGER_CONFIG,
        DYNAMIC_BROKER_CONFIG,
        DYNAMIC_DEFAULT_BROKER_CONFIG,
        STATIC_BROKER_CONFIG,
        DEFAULT_CONFIG,
        UNKNOWN;

    }
}

