/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.utils.Utils;

public class MetadataResponse
extends AbstractResponse {
    public static final int NO_CONTROLLER_ID = -1;
    public static final int AUTHORIZED_OPERATIONS_OMITTED = Integer.MIN_VALUE;
    private final MetadataResponseData data;
    private volatile Holder holder;
    private final boolean hasReliableLeaderEpochs;

    public MetadataResponse(MetadataResponseData data) {
        this(data, true);
    }

    public MetadataResponse(Struct struct, short version) {
        this(new MetadataResponseData(struct, version), version >= 9);
    }

    private MetadataResponse(MetadataResponseData data, boolean hasReliableLeaderEpochs) {
        this.data = data;
        this.hasReliableLeaderEpochs = hasReliableLeaderEpochs;
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public Map<String, Errors> errors() {
        HashMap<String, Errors> errors = new HashMap<String, Errors>();
        for (MetadataResponseData.MetadataResponseTopic metadata : this.data.topics()) {
            if (metadata.errorCode() == Errors.NONE.code()) continue;
            errors.put(metadata.name(), Errors.forCode(metadata.errorCode()));
        }
        return errors;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> errorCounts = new HashMap<Errors, Integer>();
        for (MetadataResponseData.MetadataResponseTopic metadata : this.data.topics()) {
            this.updateErrorCounts(errorCounts, Errors.forCode(metadata.errorCode()));
        }
        return errorCounts;
    }

    public Set<String> topicsByError(Errors error) {
        HashSet<String> errorTopics = new HashSet<String>();
        for (MetadataResponseData.MetadataResponseTopic metadata : this.data.topics()) {
            if (metadata.errorCode() != error.code()) continue;
            errorTopics.add(metadata.name());
        }
        return errorTopics;
    }

    public Cluster cluster() {
        HashSet<String> internalTopics = new HashSet<String>();
        ArrayList<PartitionInfo> partitions = new ArrayList<PartitionInfo>();
        for (TopicMetadata metadata : this.topicMetadata()) {
            if (metadata.error != Errors.NONE) continue;
            if (metadata.isInternal) {
                internalTopics.add(metadata.topic);
            }
            for (PartitionMetadata partitionMetadata : metadata.partitionMetadata) {
                partitions.add(MetadataResponse.partitionMetaToInfo(metadata.topic, partitionMetadata));
            }
        }
        return new Cluster(this.data.clusterId(), this.brokers(), partitions, this.topicsByError(Errors.TOPIC_AUTHORIZATION_FAILED), this.topicsByError(Errors.INVALID_TOPIC_EXCEPTION), internalTopics, this.controller());
    }

    public Optional<Integer> topicAuthorizedOperations(String topicName) {
        MetadataResponseData.MetadataResponseTopic topic = this.data.topics().find(topicName);
        if (topic == null) {
            return Optional.empty();
        }
        return Optional.of(topic.topicAuthorizedOperations());
    }

    public int clusterAuthorizedOperations() {
        return this.data.clusterAuthorizedOperations();
    }

    public static PartitionInfo partitionMetaToInfo(String topic, PartitionMetadata partitionMetadata) {
        return new PartitionInfo(topic, partitionMetadata.partition(), partitionMetadata.leader(), partitionMetadata.replicas().toArray(new Node[0]), partitionMetadata.isr().toArray(new Node[0]), partitionMetadata.offlineReplicas().toArray(new Node[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Holder holder() {
        if (this.holder == null) {
            MetadataResponseData metadataResponseData = this.data;
            synchronized (metadataResponseData) {
                if (this.holder == null) {
                    this.holder = new Holder(this.data);
                }
            }
        }
        return this.holder;
    }

    public Collection<Node> brokers() {
        return this.holder().brokers.values();
    }

    public Map<Integer, Node> brokersById() {
        return this.holder().brokers;
    }

    public Collection<TopicMetadata> topicMetadata() {
        return this.holder().topicMetadata;
    }

    public Node controller() {
        return this.holder().controller;
    }

    public String clusterId() {
        return this.data.clusterId();
    }

    public boolean hasReliableLeaderEpochs() {
        return this.hasReliableLeaderEpochs;
    }

    public static MetadataResponse parse(ByteBuffer buffer, short version) {
        return new MetadataResponse(ApiKeys.METADATA.responseSchema(version).read(buffer), version);
    }

    public static MetadataResponse prepareResponse(int throttleTimeMs, Collection<Node> brokers, String clusterId, int controllerId, List<TopicMetadata> topicMetadataList, int clusterAuthorizedOperations) {
        MetadataResponseData responseData = new MetadataResponseData();
        responseData.setThrottleTimeMs(throttleTimeMs);
        brokers.forEach(broker -> responseData.brokers().add(new MetadataResponseData.MetadataResponseBroker().setNodeId(broker.id()).setHost(broker.host()).setPort(broker.port()).setRack(broker.rack())));
        responseData.setClusterId(clusterId);
        responseData.setControllerId(controllerId);
        responseData.setClusterAuthorizedOperations(clusterAuthorizedOperations);
        topicMetadataList.forEach(topicMetadata -> {
            MetadataResponseData.MetadataResponseTopic metadataResponseTopic = new MetadataResponseData.MetadataResponseTopic();
            metadataResponseTopic.setErrorCode(((TopicMetadata)topicMetadata).error.code()).setName(((TopicMetadata)topicMetadata).topic).setIsInternal(((TopicMetadata)topicMetadata).isInternal).setTopicAuthorizedOperations(((TopicMetadata)topicMetadata).authorizedOperations);
            for (PartitionMetadata partitionMetadata : ((TopicMetadata)topicMetadata).partitionMetadata) {
                metadataResponseTopic.partitions().add(new MetadataResponseData.MetadataResponsePartition().setErrorCode(partitionMetadata.error.code()).setPartitionIndex(partitionMetadata.partition).setLeaderId(partitionMetadata.leader == null ? -1 : partitionMetadata.leader.id()).setLeaderEpoch(partitionMetadata.leaderEpoch().orElse(-1)).setReplicaNodes(partitionMetadata.replicas.stream().map(Node::id).collect(Collectors.toList())).setIsrNodes(partitionMetadata.isr.stream().map(Node::id).collect(Collectors.toList())).setOfflineReplicas(partitionMetadata.offlineReplicas.stream().map(Node::id).collect(Collectors.toList())));
            }
            responseData.topics().add(metadataResponseTopic);
        });
        return new MetadataResponse(responseData);
    }

    public static MetadataResponse prepareResponse(int throttleTimeMs, Collection<Node> brokers, String clusterId, int controllerId, List<TopicMetadata> topicMetadataList) {
        return MetadataResponse.prepareResponse(throttleTimeMs, brokers, clusterId, controllerId, topicMetadataList, Integer.MIN_VALUE);
    }

    public static MetadataResponse prepareResponse(Collection<Node> brokers, String clusterId, int controllerId, List<TopicMetadata> topicMetadata) {
        return MetadataResponse.prepareResponse(0, brokers, clusterId, controllerId, topicMetadata);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 6;
    }

    private static class Holder {
        private final Map<Integer, Node> brokers;
        private final Node controller;
        private final Collection<TopicMetadata> topicMetadata;

        Holder(MetadataResponseData data) {
            this.brokers = this.createBrokers(data);
            this.topicMetadata = this.createTopicMetadata(data);
            this.controller = this.brokers.get(data.controllerId());
        }

        private Map<Integer, Node> createBrokers(MetadataResponseData data) {
            return data.brokers().valuesList().stream().map(b -> new Node(b.nodeId(), b.host(), b.port(), b.rack())).collect(Collectors.toMap(Node::id, b -> b));
        }

        private Collection<TopicMetadata> createTopicMetadata(MetadataResponseData data) {
            ArrayList<TopicMetadata> topicMetadataList = new ArrayList<TopicMetadata>();
            for (MetadataResponseData.MetadataResponseTopic topicMetadata : data.topics()) {
                Errors topicError = Errors.forCode(topicMetadata.errorCode());
                String topic = topicMetadata.name();
                boolean isInternal = topicMetadata.isInternal();
                ArrayList<PartitionMetadata> partitionMetadataList = new ArrayList<PartitionMetadata>();
                for (MetadataResponseData.MetadataResponsePartition partitionMetadata : topicMetadata.partitions()) {
                    Errors partitionError = Errors.forCode(partitionMetadata.errorCode());
                    int partitionIndex = partitionMetadata.partitionIndex();
                    int leader = partitionMetadata.leaderId();
                    Optional<Integer> leaderEpoch = RequestUtils.getLeaderEpoch(partitionMetadata.leaderEpoch());
                    Node leaderNode = leader == -1 ? null : this.brokers.get(leader);
                    List<Node> replicaNodes = this.convertToNodes(partitionMetadata.replicaNodes());
                    List<Node> isrNodes = this.convertToNodes(partitionMetadata.isrNodes());
                    List<Node> offlineNodes = this.convertToNodes(partitionMetadata.offlineReplicas());
                    partitionMetadataList.add(new PartitionMetadata(partitionError, partitionIndex, leaderNode, leaderEpoch, replicaNodes, isrNodes, offlineNodes));
                }
                topicMetadataList.add(new TopicMetadata(topicError, topic, isInternal, partitionMetadataList, topicMetadata.topicAuthorizedOperations()));
            }
            return topicMetadataList;
        }

        private List<Node> convertToNodes(List<Integer> brokerIds) {
            ArrayList<Node> nodes = new ArrayList<Node>(brokerIds.size());
            for (Integer brokerId : brokerIds) {
                Node node2 = this.brokers.get(brokerId);
                if (node2 == null) {
                    nodes.add(new Node(brokerId, "", -1));
                    continue;
                }
                nodes.add(node2);
            }
            return nodes;
        }
    }

    public static class PartitionMetadata {
        private final Errors error;
        private final int partition;
        private final Node leader;
        private final Optional<Integer> leaderEpoch;
        private final List<Node> replicas;
        private final List<Node> isr;
        private final List<Node> offlineReplicas;

        public PartitionMetadata(Errors error, int partition, Node leader, Optional<Integer> leaderEpoch, List<Node> replicas, List<Node> isr, List<Node> offlineReplicas) {
            this.error = error;
            this.partition = partition;
            this.leader = leader;
            this.leaderEpoch = leaderEpoch;
            this.replicas = replicas;
            this.isr = isr;
            this.offlineReplicas = offlineReplicas;
        }

        public Errors error() {
            return this.error;
        }

        public int partition() {
            return this.partition;
        }

        public int leaderId() {
            return this.leader == null ? -1 : this.leader.id();
        }

        public Optional<Integer> leaderEpoch() {
            return this.leaderEpoch;
        }

        public Node leader() {
            return this.leader;
        }

        public List<Node> replicas() {
            return this.replicas;
        }

        public List<Node> isr() {
            return this.isr;
        }

        public List<Node> offlineReplicas() {
            return this.offlineReplicas;
        }

        public String toString() {
            return "(type=PartitionMetadata, error=" + (Object)((Object)this.error) + ", partition=" + this.partition + ", leader=" + this.leader + ", leaderEpoch=" + this.leaderEpoch + ", replicas=" + Utils.join(this.replicas, ",") + ", isr=" + Utils.join(this.isr, ",") + ", offlineReplicas=" + Utils.join(this.offlineReplicas, ",") + ')';
        }
    }

    public static class TopicMetadata {
        private final Errors error;
        private final String topic;
        private final boolean isInternal;
        private final List<PartitionMetadata> partitionMetadata;
        private int authorizedOperations;

        public TopicMetadata(Errors error, String topic, boolean isInternal, List<PartitionMetadata> partitionMetadata, int authorizedOperations) {
            this.error = error;
            this.topic = topic;
            this.isInternal = isInternal;
            this.partitionMetadata = partitionMetadata;
            this.authorizedOperations = authorizedOperations;
        }

        public TopicMetadata(Errors error, String topic, boolean isInternal, List<PartitionMetadata> partitionMetadata) {
            this(error, topic, isInternal, partitionMetadata, 0);
        }

        public Errors error() {
            return this.error;
        }

        public String topic() {
            return this.topic;
        }

        public boolean isInternal() {
            return this.isInternal;
        }

        public List<PartitionMetadata> partitionMetadata() {
            return this.partitionMetadata;
        }

        public void authorizedOperations(int authorizedOperations) {
            this.authorizedOperations = authorizedOperations;
        }

        public int authorizedOperations() {
            return this.authorizedOperations;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TopicMetadata that = (TopicMetadata)o;
            return this.isInternal == that.isInternal && this.error == that.error && Objects.equals(this.topic, that.topic) && Objects.equals(this.partitionMetadata, that.partitionMetadata) && Objects.equals(this.authorizedOperations, that.authorizedOperations);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.error, this.topic, this.isInternal, this.partitionMetadata, this.authorizedOperations});
        }

        public String toString() {
            return "TopicMetadata{error=" + (Object)((Object)this.error) + ", topic='" + this.topic + '\'' + ", isInternal=" + this.isInternal + ", partitionMetadata=" + this.partitionMetadata + ", authorizedOperations=" + this.authorizedOperations + '}';
        }
    }
}

